﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/license-manager/LicenseManagerRequest.h>
#include <aws/license-manager/LicenseManager_EXPORTS.h>
#include <aws/license-manager/model/LicenseAssetGroupConfiguration.h>
#include <aws/license-manager/model/LicenseAssetGroupProperty.h>
#include <aws/license-manager/model/Tag.h>

#include <utility>

namespace Aws {
namespace LicenseManager {
namespace Model {

/**
 */
class CreateLicenseAssetGroupRequest : public LicenseManagerRequest {
 public:
  AWS_LICENSEMANAGER_API CreateLicenseAssetGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateLicenseAssetGroup"; }

  AWS_LICENSEMANAGER_API Aws::String SerializePayload() const override;

  AWS_LICENSEMANAGER_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>License asset group name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateLicenseAssetGroupRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>License asset group description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateLicenseAssetGroupRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>License asset group configurations.</p>
   */
  inline const Aws::Vector<LicenseAssetGroupConfiguration>& GetLicenseAssetGroupConfigurations() const {
    return m_licenseAssetGroupConfigurations;
  }
  inline bool LicenseAssetGroupConfigurationsHasBeenSet() const { return m_licenseAssetGroupConfigurationsHasBeenSet; }
  template <typename LicenseAssetGroupConfigurationsT = Aws::Vector<LicenseAssetGroupConfiguration>>
  void SetLicenseAssetGroupConfigurations(LicenseAssetGroupConfigurationsT&& value) {
    m_licenseAssetGroupConfigurationsHasBeenSet = true;
    m_licenseAssetGroupConfigurations = std::forward<LicenseAssetGroupConfigurationsT>(value);
  }
  template <typename LicenseAssetGroupConfigurationsT = Aws::Vector<LicenseAssetGroupConfiguration>>
  CreateLicenseAssetGroupRequest& WithLicenseAssetGroupConfigurations(LicenseAssetGroupConfigurationsT&& value) {
    SetLicenseAssetGroupConfigurations(std::forward<LicenseAssetGroupConfigurationsT>(value));
    return *this;
  }
  template <typename LicenseAssetGroupConfigurationsT = LicenseAssetGroupConfiguration>
  CreateLicenseAssetGroupRequest& AddLicenseAssetGroupConfigurations(LicenseAssetGroupConfigurationsT&& value) {
    m_licenseAssetGroupConfigurationsHasBeenSet = true;
    m_licenseAssetGroupConfigurations.emplace_back(std::forward<LicenseAssetGroupConfigurationsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ARNs of associated license asset rulesets.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAssociatedLicenseAssetRulesetARNs() const { return m_associatedLicenseAssetRulesetARNs; }
  inline bool AssociatedLicenseAssetRulesetARNsHasBeenSet() const { return m_associatedLicenseAssetRulesetARNsHasBeenSet; }
  template <typename AssociatedLicenseAssetRulesetARNsT = Aws::Vector<Aws::String>>
  void SetAssociatedLicenseAssetRulesetARNs(AssociatedLicenseAssetRulesetARNsT&& value) {
    m_associatedLicenseAssetRulesetARNsHasBeenSet = true;
    m_associatedLicenseAssetRulesetARNs = std::forward<AssociatedLicenseAssetRulesetARNsT>(value);
  }
  template <typename AssociatedLicenseAssetRulesetARNsT = Aws::Vector<Aws::String>>
  CreateLicenseAssetGroupRequest& WithAssociatedLicenseAssetRulesetARNs(AssociatedLicenseAssetRulesetARNsT&& value) {
    SetAssociatedLicenseAssetRulesetARNs(std::forward<AssociatedLicenseAssetRulesetARNsT>(value));
    return *this;
  }
  template <typename AssociatedLicenseAssetRulesetARNsT = Aws::String>
  CreateLicenseAssetGroupRequest& AddAssociatedLicenseAssetRulesetARNs(AssociatedLicenseAssetRulesetARNsT&& value) {
    m_associatedLicenseAssetRulesetARNsHasBeenSet = true;
    m_associatedLicenseAssetRulesetARNs.emplace_back(std::forward<AssociatedLicenseAssetRulesetARNsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>License asset group properties.</p>
   */
  inline const Aws::Vector<LicenseAssetGroupProperty>& GetProperties() const { return m_properties; }
  inline bool PropertiesHasBeenSet() const { return m_propertiesHasBeenSet; }
  template <typename PropertiesT = Aws::Vector<LicenseAssetGroupProperty>>
  void SetProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties = std::forward<PropertiesT>(value);
  }
  template <typename PropertiesT = Aws::Vector<LicenseAssetGroupProperty>>
  CreateLicenseAssetGroupRequest& WithProperties(PropertiesT&& value) {
    SetProperties(std::forward<PropertiesT>(value));
    return *this;
  }
  template <typename PropertiesT = LicenseAssetGroupProperty>
  CreateLicenseAssetGroupRequest& AddProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties.emplace_back(std::forward<PropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags to add to the license asset group.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  CreateLicenseAssetGroupRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  CreateLicenseAssetGroupRequest& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency
   * of the request.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  CreateLicenseAssetGroupRequest& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Vector<LicenseAssetGroupConfiguration> m_licenseAssetGroupConfigurations;
  bool m_licenseAssetGroupConfigurationsHasBeenSet = false;

  Aws::Vector<Aws::String> m_associatedLicenseAssetRulesetARNs;
  bool m_associatedLicenseAssetRulesetARNsHasBeenSet = false;

  Aws::Vector<LicenseAssetGroupProperty> m_properties;
  bool m_propertiesHasBeenSet = false;

  Aws::Vector<Tag> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::String m_clientToken;
  bool m_clientTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace LicenseManager
}  // namespace Aws
