/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class ExasolForeignKeyManager
extends SQLForeignKeyManager<ExasolTableForeignKey, ExasolTable>
implements DBEObjectRenamer<ExasolTableForeignKey> {
    public DBSObjectCache<? extends DBSObject, ExasolTableForeignKey> getObjectsCache(ExasolTableForeignKey object) {
        ExasolTable parent = (ExasolTable)object.getParentObject();
        return ((ExasolSchema)parent.getContainer()).getAssociationCache();
    }

    protected ExasolTableForeignKey createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        ExasolTable table = (ExasolTable)container;
        ExasolTableForeignKey foreignKey = new ExasolTableForeignKey(table, null, true, "FK");
        foreignKey.setName(this.getNewConstraintName(monitor, (AbstractTableConstraint)foreignKey));
        return foreignKey;
    }

    protected String getDropForeignKeyPattern(ExasolTableForeignKey constraint) {
        return "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)constraint.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " DROP CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)constraint);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        ExasolTableForeignKey key = (ExasolTableForeignKey)command.getObject();
        try {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Foreign Key", ExasolUtils.getFKDdl(key, monitor)));
        }
        catch (DBException e) {
            log.error((Object)("Could not created DDL for Exasol FK: " + key.getFullyQualifiedName(DBPEvaluationContext.DDL)));
            log.error((Object)e.getMessage());
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        ExasolTableForeignKey key = (ExasolTableForeignKey)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename FK", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)key.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME CONSTRAINT " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        ExasolTableForeignKey constraint = (ExasolTableForeignKey)command.getObject();
        if (command.getProperties().containsKey("enabled")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter FK", "ALTER TABLE " + ((ExasolTable)constraint.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY CONSTRAINT " + constraint.getName() + " " + (constraint.getEnabled() != false ? "ENABLE" : "DISABLE")));
        }
    }

    protected void processObjectRename(DBECommandContext commandContext, ExasolTableForeignKey object, Map<String, Object> options, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, options, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolTableForeignKey object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }
}

