/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.slf4j.Logger;

public class FilesystemMetadataResolver
extends AbstractReloadingMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilesystemMetadataResolver.class);
    @NonnullAfterInit
    private File metadataFile;

    public FilesystemMetadataResolver(@Nonnull File file) throws ResolverException {
        this.metadataFile = Constraint.isNotNull(file, "Metadata file cannot be null");
    }

    public FilesystemMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull File file) throws ResolverException {
        super(backgroundTaskTimer);
        this.metadataFile = Constraint.isNotNull(file, "Metadata file cannot be null");
    }

    protected void setMetadataFile(@Nonnull File file) throws ResolverException {
        this.checkSetterPreconditions();
        this.metadataFile = Constraint.isNotNull(file, "Metadata file cannot be null");
    }

    @Override
    protected void doDestroy() {
        this.metadataFile = null;
        super.doDestroy();
    }

    @Override
    @Nonnull
    protected String getMetadataIdentifier() {
        return this.metadataFile.getAbsolutePath();
    }

    @Override
    @Nullable
    protected byte[] fetchMetadata() throws ResolverException {
        try {
            this.validateMetadataFile(this.metadataFile);
            Instant metadataUpdateTime = Instant.ofEpochMilli(this.metadataFile.lastModified());
            if (this.getLastRefresh() == null || this.getLastUpdate() == null || metadataUpdateTime.isAfter(this.getLastUpdate())) {
                return this.inputstreamToByteArray(new FileInputStream(this.metadataFile));
            }
            return null;
        }
        catch (IOException e) {
            String errMsg = "Unable to read metadata file " + this.metadataFile.getAbsolutePath();
            this.log.error("{} {}: {}", new Object[]{this.getLogPrefix(), errMsg, e.getMessage()});
            throw new ResolverException(errMsg, e);
        }
    }

    protected void validateMetadataFile(@Nonnull File file) throws ResolverException {
        if (!file.exists()) {
            throw new ResolverException("Metadata file '" + file.getAbsolutePath() + "' does not exist");
        }
        if (!file.isFile()) {
            throw new ResolverException("Metadata file '" + file.getAbsolutePath() + "' is not a file");
        }
        if (!file.canRead()) {
            throw new ResolverException("Metadata file '" + file.getAbsolutePath() + "' is not readable");
        }
    }
}

