/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Component;
import java.awt.Cursor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class CursorManager {
    private final LinkedHashMap<Object, Cursor> cursors = new LinkedHashMap();
    private final CopyOnWriteArrayList<Component> components = new CopyOnWriteArrayList();

    public CursorManager(Component forComponent) {
        this.addComponent(forComponent);
    }

    public synchronized void addComponent(Component forComponent) {
        this.components.addIfAbsent(forComponent);
        forComponent.setCursor(this.getCurrentCursor());
    }

    public synchronized void removeComponent(Component forComponent) {
        this.components.remove(forComponent);
    }

    public synchronized void setNewCursor(Cursor cursor, Object reference) {
        Objects.requireNonNull(reference, "Cannot register a cursor that can never be removed.");
        this.cursors.remove(reference);
        this.cursors.put(reference, cursor);
        this.updateCursor();
    }

    public synchronized void resetCursor(Object reference) {
        if (reference == null) {
            return;
        }
        this.cursors.remove(reference);
        this.updateCursor();
    }

    private void updateCursor() {
        Cursor cursor = this.getCurrentCursor();
        for (Component c : this.components) {
            c.setCursor(cursor);
        }
    }

    private Cursor getCurrentCursor() {
        Iterator<Cursor> it = this.cursors.values().iterator();
        Cursor cursor = null;
        while (it.hasNext()) {
            cursor = it.next();
        }
        return cursor;
    }
}

