/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.measurement;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class PDNumberFormatDictionary
implements COSObjectable {
    public static final String TYPE = "NumberFormat";
    public static final String LABEL_SUFFIX_TO_VALUE = "S";
    public static final String LABEL_PREFIX_TO_VALUE = "P";
    public static final String FRACTIONAL_DISPLAY_DECIMAL = "D";
    public static final String FRACTIONAL_DISPLAY_FRACTION = "F";
    public static final String FRACTIONAL_DISPLAY_ROUND = "R";
    public static final String FRACTIONAL_DISPLAY_TRUNCATE = "T";
    private COSDictionary numberFormatDictionary;

    public PDNumberFormatDictionary() {
        this.numberFormatDictionary = new COSDictionary();
        this.numberFormatDictionary.setName(COSName.TYPE, TYPE);
    }

    public PDNumberFormatDictionary(COSDictionary dictionary) {
        this.numberFormatDictionary = dictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.numberFormatDictionary;
    }

    public COSDictionary getDictionary() {
        return this.numberFormatDictionary;
    }

    public String getType() {
        return TYPE;
    }

    public String getUnits() {
        return this.getDictionary().getString("U");
    }

    public void setUnits(String units) {
        this.getDictionary().setString("U", units);
    }

    public float getConversionFactor() {
        return this.getDictionary().getFloat("C");
    }

    public void setConversionFactor(float conversionFactor) {
        this.getDictionary().setFloat("C", conversionFactor);
    }

    public String getFractionalDisplay() {
        return this.getDictionary().getString(FRACTIONAL_DISPLAY_FRACTION, FRACTIONAL_DISPLAY_DECIMAL);
    }

    public void setFractionalDisplay(String fractionalDisplay) {
        if (!(fractionalDisplay == null || FRACTIONAL_DISPLAY_DECIMAL.equals(fractionalDisplay) || FRACTIONAL_DISPLAY_FRACTION.equals(fractionalDisplay) || FRACTIONAL_DISPLAY_ROUND.equals(fractionalDisplay) || FRACTIONAL_DISPLAY_TRUNCATE.equals(fractionalDisplay))) {
            throw new IllegalArgumentException("Value must be \"D\", \"F\", \"R\", or \"T\", (or null).");
        }
        this.getDictionary().setString(FRACTIONAL_DISPLAY_FRACTION, fractionalDisplay);
    }

    public int getDenominator() {
        return this.getDictionary().getInt(FRACTIONAL_DISPLAY_DECIMAL);
    }

    public void setDenominator(int denominator) {
        this.getDictionary().setInt(FRACTIONAL_DISPLAY_DECIMAL, denominator);
    }

    public boolean isFD() {
        return this.getDictionary().getBoolean("FD", false);
    }

    public void setFD(boolean fd) {
        this.getDictionary().setBoolean("FD", fd);
    }

    public String getThousandsSeparator() {
        return this.getDictionary().getString("RT", ",");
    }

    public void setThousandsSeparator(String thousandsSeparator) {
        this.getDictionary().setString("RT", thousandsSeparator);
    }

    public String getDecimalSeparator() {
        return this.getDictionary().getString("RD", ".");
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.getDictionary().setString("RD", decimalSeparator);
    }

    public String getLabelPrefixString() {
        return this.getDictionary().getString("PS", " ");
    }

    public void setLabelPrefixString(String labelPrefixString) {
        this.getDictionary().setString("PS", labelPrefixString);
    }

    public String getLabelSuffixString() {
        return this.getDictionary().getString("SS", " ");
    }

    public void setLabelSuffixString(String labelSuffixString) {
        this.getDictionary().setString("SS", labelSuffixString);
    }

    public String getLabelPositionToValue() {
        return this.getDictionary().getString("O", LABEL_SUFFIX_TO_VALUE);
    }

    public void setLabelPositionToValue(String labelPositionToValue) {
        if (labelPositionToValue != null && !LABEL_PREFIX_TO_VALUE.equals(labelPositionToValue) && !LABEL_SUFFIX_TO_VALUE.equals(labelPositionToValue)) {
            throw new IllegalArgumentException("Value must be \"S\", or \"P\" (or null).");
        }
        this.getDictionary().setString("O", labelPositionToValue);
    }
}

