#!/usr/bin/env bats

load helpers

function setup() {
	teardown_hello
	setup_hello
}

function teardown() {
	teardown_hello
}

@test "runc run" {
	# run hello-world
	runc run test_hello
	[ "$status" -eq 0 ]

	# check expected output
	[[ "${output}" == *"Hello"* ]]
}

@test "runc run ({u,g}id != 0)" {
	# cannot start containers as another user in rootless setup without idmap
	[[ "$ROOTLESS" -ne 0 ]] && requires rootless_idmap

	# replace "uid": 0 with "uid": 1000
	# and do a similar thing for gid.
	update_config ' (.. | select(.uid? == 0)) .uid |= 1000
		| (.. | select(.gid? == 0)) .gid |= 100'

	# run hello-world
	runc run test_hello
	[ "$status" -eq 0 ]

	# check expected output
	[[ "${output}" == *"Hello"* ]]
}

@test "runc run with rootfs set to ." {
	cp config.json rootfs/.
	rm config.json
	cd rootfs
	update_config '(.. | select(. == "rootfs")) |= "."'

	# run hello-world
	runc run test_hello
	[ "$status" -eq 0 ]
	[[ "${output}" == *"Hello"* ]]
}

@test "runc run --pid-file" {
	# run hello-world
	runc run --pid-file pid.txt test_hello
	[ "$status" -eq 0 ]
	[[ "${output}" == *"Hello"* ]]

	# check pid.txt was generated
	[ -e pid.txt ]

	[[ "$(cat pid.txt)" =~ [0-9]+ ]]
}
