# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function


__metaclass__ = type

from unittest.mock import patch

from ansible_collections.junipernetworks.junos.plugins.modules import junos_logging_global
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import set_module_args

from .junos_module import TestJunosModule, load_fixture


class TestJunosLogging_globalModule(TestJunosModule):
    module = junos_logging_global

    def setUp(self):
        super(TestJunosLogging_globalModule, self).setUp()

        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration",
        )
        self.lock_configuration = self.mock_lock_configuration.start()

        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration",
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()

        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.logging_global.logging_global.load_config",
        )
        self.load_config = self.mock_load_config.start()

        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.logging_global.logging_global.commit_configuration",
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()

        self.mock_execute_show_command = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.logging_global.logging_global."
            "Logging_globalFacts.get_device_data",
        )
        self.execute_show_command = self.mock_execute_show_command.start()

    def tearDown(self):
        super(TestJunosLogging_globalModule, self).tearDown()
        self.mock_load_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()
        self.mock_execute_show_command.stop()

    def load_fixtures(
        self,
        commands=None,
        format="text",
        changed=False,
        filename=None,
    ):
        def load_from_file(*args, **kwargs):
            output = load_fixture("junos_logging_global_config.cfg")
            return output

        self.execute_show_command.side_effect = load_from_file

    def test_junos_logging_global_merged_archive_01(self):
        set_module_args(
            dict(
                config=dict(
                    archive=dict(
                        set=True,
                        files=10,
                        file_size=65578,
                        no_binary_data=True,
                        no_world_readable=True,
                    ),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:syslog><nc:archive><nc:files>10</nc:files>"
            "<nc:no-binary-data/><nc:size>65578</nc:size><nc:no-world-readable/>"
            "</nc:archive></nc:syslog></nc:system>",
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_logging_global_merged_console_02(self):
        set_module_args(
            dict(
                config=dict(
                    console=dict(
                        any=dict(level="info"),
                        authorization=dict(level="any"),
                        change_log=dict(level="critical"),
                        ftp=dict(level="none"),
                    ),
                ),
                state="merged",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertIn(
            "<nc:console><nc:name>any</nc:name><nc:info/>",
            str(result["commands"]),
        )
        self.assertIn(
            "<nc:console><nc:name>authorization</nc:name><nc:any/>",
            str(result["commands"]),
        )
        self.assertIn(
            "<nc:console><nc:name>change-log</nc:name><nc:critical/>",
            str(result["commands"]),
        )
        self.assertIn(
            "<nc:console><nc:name>ftp</nc:name><nc:none/>",
            str(result["commands"]),
        )

    def test_junos_logging_global_merged_files_03(self):
        set_module_args(
            dict(
                config=dict(
                    files=[dict(name="file101", allow_duplicates=True)],
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:syslog><nc:file><nc:name>file101</nc:name>"
            "<nc:allow-duplicates/></nc:file></nc:syslog></nc:system>",
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_logging_global_merged_files_04(self):
        set_module_args(
            dict(
                config=dict(
                    files=[
                        dict(
                            name="file102",
                            allow_duplicates=True,
                            any=dict(level="any"),
                            structured_data=dict(set=True),
                        ),
                        dict(
                            name="file103",
                            archive=dict(
                                set=True,
                                no_binary_data=True,
                                files=10,
                                file_size=65578,
                                no_world_readable=True,
                            ),
                            explicit_priority=True,
                            match="^set*",
                            match_strings=["^delete", "^prompt"],
                        ),
                    ],
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:syslog><nc:file><nc:name>file102</nc:name><nc:allow-duplicates/>"
            "<nc:contents><nc:name>any</nc:name><nc:any/></nc:contents>"
            "<nc:structured-data/></nc:file><nc:file><nc:name>file103</nc:name>"
            "<nc:archive><nc:files>10</nc:files><nc:no-binary-data/>"
            "<nc:size>65578</nc:size><nc:no-world-readable/>"
            "</nc:archive><nc:explicit-priority/><nc:match>^set*</nc:match>"
            "<nc:match-strings>^delete</nc:match-strings>"
            "<nc:match-strings>^prompt</nc:match-strings></nc:file></nc:syslog></nc:system>",
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_logging_global_merged_hosts_05(self):
        set_module_args(
            dict(
                config=dict(
                    hosts=[
                        dict(
                            name="host222",
                            exclude_hostname=True,
                            allow_duplicates=True,
                        ),
                    ],
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:syslog><nc:host><nc:name>host222</nc:name><nc:allow-duplicates/>"
            "<nc:exclude-hostname/></nc:host></nc:syslog></nc:system>",
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_logging_global_merged_hosts_idempotent_06(self):
        set_module_args(
            dict(
                config=dict(
                    hosts=[
                        dict(
                            name="host111",
                            exclude_hostname=True,
                            allow_duplicates=True,
                            any=dict(level="any"),
                            structured_data=dict(set=True, brief=True),
                            facility_override="ftp",
                            log_prefix="field",
                            match="^set*",
                            match_strings=["^delete", "^prompt"],
                            port=1231,
                            routing_instance="inst11",
                            source_address="11.11.11.11",
                        ),
                    ],
                ),
                state="merged",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertEqual(result["before"], result["after"])

    def test_junos_logging_global_merged_07(self):
        set_module_args(
            dict(
                config=dict(
                    allow_duplicates=True,
                    routing_instance="inst11",
                    log_rotate_frequency=45,
                    source_address="33.33.33.33",
                    time_format=dict(millisecond=True, year=True),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:syslog><nc:allow-duplicates/><nc:log-rotate-frequency>45</nc:log-rotate-frequency>"
            "<nc:routing-instance>inst11</nc:routing-instance><nc:source-address>33.33.33.33</nc:source-address>"
            "<nc:time-format><nc:millisecond/><nc:year/></nc:time-format></nc:syslog></nc:system>",
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_logging_global_merged_user_08(self):
        set_module_args(
            dict(
                config=dict(
                    users=[
                        dict(name="user1", allow_duplicates=True),
                        dict(
                            name="user2",
                            allow_duplicates=True,
                            any=dict(level="any"),
                            user=dict(level="info"),
                        ),
                    ],
                ),
                state="merged",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertIn(
            "<nc:user><nc:name>user1</nc:name><nc:allow-duplicates/>",
            str(result["commands"]),
        )
        self.assertIn(
            "<nc:user><nc:name>user2</nc:name><nc:allow-duplicates/>",
            str(result["commands"]),
        )
        self.assertIn(
            "<nc:contents><nc:name>any</nc:name><nc:any/></nc:contents>",
            str(result["commands"]),
        )

    def test_junos_logging_global_replaced_user_09(self):
        set_module_args(
            dict(
                config=dict(
                    users=[
                        dict(name="user1", allow_duplicates=True),
                        dict(
                            name="user2",
                            allow_duplicates=True,
                            any=dict(level="any"),
                            user=dict(level="info"),
                        ),
                    ],
                ),
                state="replaced",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertIn(
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">',
            str(result["commands"]),
        )
        self.assertIn(
            '<nc:syslog delete="delete"/><nc:syslog><nc:user><nc:name>user1</nc:name>',
            str(result["commands"]),
        )
        self.assertIn(
            "<nc:allow-duplicates/></nc:user><nc:user><nc:name>user2</nc:name>",
            str(result["commands"]),
        )
        self.assertIn(
            "</nc:contents></nc:user></nc:syslog></nc:system>",
            str(result["commands"]),
        )

    def test_junos_logging_global_overridden_user_10(self):
        set_module_args(
            dict(
                config=dict(
                    users=[
                        dict(name="user1", allow_duplicates=True),
                        dict(
                            name="user2",
                            allow_duplicates=True,
                            any=dict(level="any"),
                            user=dict(level="info"),
                        ),
                    ],
                ),
                state="overridden",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertIn(
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">',
            str(result["commands"]),
        )
        self.assertIn(
            '<nc:syslog delete="delete"/><nc:syslog><nc:user><nc:name>user1</nc:name>',
            str(result["commands"]),
        )
        self.assertIn(
            "<nc:allow-duplicates/></nc:user><nc:user><nc:name>user2</nc:name>",
            str(result["commands"]),
        )

    def test_junos_logging_global_deleted_user_11(self):
        set_module_args(dict(config=dict(), state="deleted"))
        commands = [
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            '<nc:syslog delete="delete"/></nc:system>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_logging_global_rendered_12(self):
        set_module_args(
            dict(
                config=dict(
                    archive=dict(
                        set=True,
                        files=10,
                        file_size=65578,
                        no_binary_data=True,
                        no_world_readable=True,
                    ),
                ),
                state="rendered",
            ),
        )
        rendered = (
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:syslog><nc:archive><nc:files>10</nc:files><nc:no-binary-data/>"
            "<nc:size>65578</nc:size><nc:no-world-readable/></nc:archive></nc:syslog></nc:system>"
        )
        result = self.execute_module(changed=False)

        self.assertEqual(sorted(result["rendered"]), sorted(rendered))

    def test_junos_logging_global_parsed_13(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <version>18.4R1-S2.4</version>
                    <system>
                        <syslog>
                            <archive>
                                <size>65578</size>
                                <files>10</files>
                                <no-world-readable/>
                                <no-binary-data/>
                            </archive>
                            <user>
                                <name>user1</name>
                                <allow-duplicates/>
                            </user>
                            <user>
                                <name>user2</name>
                                <contents>
                                    <name>any</name>
                                    <any/>
                                </contents>
                                <contents>
                                    <name>user</name>
                                    <info/>
                                </contents>
                                <allow-duplicates/>
                            </user>
                            <host>
                                <name>host111</name>
                                <contents>
                                    <name>any</name>
                                    <any/>
                                </contents>
                                <match>^set*</match>
                                <allow-duplicates/>
                                <port>1231</port>
                                <facility-override>ftp</facility-override>
                                <log-prefix>field</log-prefix>
                                <source-address>11.1.1.11</source-address>
                                <routing-instance>inst11</routing-instance>
                                <exclude-hostname/>
                                <match-strings>^delete</match-strings>
                                <match-strings>^prompt</match-strings>
                                <structured-data>
                                    <brief/>
                                </structured-data>
                            </host>
                            <allow-duplicates/>
                            <file>
                                <name>file101</name>
                                <allow-duplicates/>
                            </file>
                            <file>
                                <name>file102</name>
                                <contents>
                                    <name>any</name>
                                    <any/>
                                </contents>
                                <allow-duplicates/>
                                <structured-data>
                                </structured-data>
                            </file>
                            <file>
                                <name>file103</name>
                                <match>^set*</match>
                                <archive>
                                    <size>65578</size>
                                    <files>10</files>
                                    <no-world-readable/>
                                    <no-binary-data/>
                                </archive>
                                <explicit-priority/>
                                <match-strings>^delete</match-strings>
                                <match-strings>^prompt</match-strings>
                            </file>
                            <console>
                                <name>any</name>
                                <info/>
                            </console>
                            <console>
                                <name>authorization</name>
                                <any/>
                            </console>
                            <console>
                                <name>ftp</name>
                                <none/>
                            </console>
                            <console>
                                <name>change-log</name>
                                <critical/>
                            </console>
                            <time-format>
                                <year/>
                                <millisecond/>
                            </time-format>
                            <source-address>33.33.33.33</source-address>
                            <routing-instance>inst11</routing-instance>
                            <log-rotate-frequency>45</log-rotate-frequency>
                        </syslog>
                    </system>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_dict = {
            "allow_duplicates": True,
            "archive": {
                "file_size": 65578,
                "files": 10,
                "no_binary_data": True,
                "no_world_readable": True,
            },
            "console": {
                "any": {"level": "info"},
                "authorization": {"level": "any"},
                "change_log": {"level": "critical"},
                "ftp": {"level": "none"},
            },
            "files": [
                {"allow_duplicates": True, "name": "file101"},
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "name": "file102",
                    "structured_data": {"set": True},
                },
                {
                    "archive": {
                        "file_size": 65578,
                        "files": 10,
                        "no_binary_data": True,
                        "no_world_readable": True,
                    },
                    "explicit_priority": True,
                    "match": "^set*",
                    "match_strings": ["^delete", "^prompt"],
                    "name": "file103",
                },
            ],
            "hosts": [
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "exclude_hostname": True,
                    "facility_override": "ftp",
                    "log_prefix": "field",
                    "match": "^set*",
                    "match_strings": ["^delete", "^prompt"],
                    "name": "host111",
                    "port": 1231,
                    "routing_instance": "inst11",
                    "source_address": "11.1.1.11",
                    "structured_data": {"brief": True},
                },
            ],
            "log_rotate_frequency": 45,
            "routing_instance": "inst11",
            "source_address": "33.33.33.33",
            "time_format": {"millisecond": True, "year": True},
            "users": [
                {"allow_duplicates": True, "name": "user1"},
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "name": "user2",
                    "user": {"level": "info"},
                },
            ],
        }
        self.assertEqual(sorted(parsed_dict), sorted(result["parsed"]))

    def test_junos_logging_global_gathered_14(self):
        """
        :return:
        """
        set_module_args(dict(state="gathered"))
        result = self.execute_module(changed=False)
        gather_list = {
            "hosts": [
                {
                    "name": "host111",
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "exclude_hostname": True,
                    "facility_override": "ftp",
                    "log_prefix": "field",
                    "match": "^set*",
                    "match_strings": ["^delete", "^prompt"],
                    "port": 1231,
                    "routing_instance": "inst11",
                    "source_address": "11.1.1.11",
                    "structured_data": {"brief": True},
                },
            ],
        }
        self.assertEqual(sorted(gather_list), sorted(result["gathered"]))

    def test_junos_logging_global_parsed_15(self):
        parsed_str = """
               <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                   <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                       <version>18.4R1-S2.4</version>
                       <system>
                           <syslog>
                               <archive>
                                   <size>65578</size>
                                   <files>10</files>
                                   <world-readable/>
                                   <binary-data/>
                               </archive>
                               <user>
                                   <name>user1</name>
                                   <allow-duplicates/>
                               </user>
                               <user>
                                   <name>user2</name>
                                   <contents>
                                       <name>any</name>
                                       <any/>
                                   </contents>
                                   <contents>
                                       <name>user</name>
                                       <info/>
                                   </contents>
                                   <allow-duplicates/>
                               </user>
                               <host>
                                   <name>host111</name>
                                   <contents>
                                       <name>any</name>
                                       <any/>
                                   </contents>
                                   <match>^set*</match>
                                   <allow-duplicates/>
                                   <port>1231</port>
                                   <facility-override>ftp</facility-override>
                                   <log-prefix>field</log-prefix>
                                   <source-address>11.1.1.11</source-address>
                                   <routing-instance>inst11</routing-instance>
                                   <exclude-hostname/>
                                   <match-strings>^delete</match-strings>
                                   <match-strings>^prompt</match-strings>
                                   <structured-data>
                                       <brief/>
                                   </structured-data>
                               </host>
                               <allow-duplicates/>
                               <file>
                                   <name>file101</name>
                                   <allow-duplicates/>
                                   <archive-sites>
                                       <name>www.antsiblr.com</name>
                                   </archive-sites>
                               </file>
                               <file>
                                   <name>file102</name>
                                   <contents>
                                       <name>any</name>
                                       <any/>
                                   </contents>
                                   <allow-duplicates/>
                                   <structured-data>
                                   </structured-data>
                               </file>
                               <file>
                                   <name>file103</name>
                                   <match>^set*</match>
                                   <archive>
                                       <size>65578</size>
                                       <files>10</files>
                                       <no-world-readable/>
                                       <no-binary-data/>
                                   </archive>
                                   <explicit-priority/>
                                   <match-strings>^delete</match-strings>
                                   <match-strings>^prompt</match-strings>
                               </file>
                               <console>
                                   <name>any</name>
                                   <info/>
                               </console>
                               <console>
                                   <name>authorization</name>
                                   <any/>
                               </console>
                               <console>
                                   <name>ftp</name>
                                   <none/>
                               </console>
                               <console>
                                   <name>change-log</name>
                                   <critical/>
                               </console>
                               <time-format>
                               </time-format>
                               <source-address>33.33.33.33</source-address>
                               <routing-instance>inst11</routing-instance>
                               <log-rotate-frequency>45</log-rotate-frequency>
                           </syslog>
                       </system>
                   </configuration>
               </rpc-reply>
           """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_dict = {
            "allow_duplicates": True,
            "archive": {
                "file_size": 65578,
                "files": 10,
                "no_binary_data": True,
                "no_world_readable": True,
            },
            "console": {
                "any": {"level": "info"},
                "authorization": {"level": "any"},
                "change_log": {"level": "critical"},
                "ftp": {"level": "none"},
            },
            "files": [
                {
                    "allow_duplicates": True,
                    "name": "file101",
                    "archive_sites": ["www.antsiblr.com"],
                },
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "name": "file102",
                    "structured_data": {"set": True},
                },
                {
                    "archive": {
                        "file_size": 65578,
                        "files": 10,
                        "binary_data": True,
                        "world_readable": True,
                    },
                    "explicit_priority": True,
                    "match": "^set*",
                    "match_strings": ["^delete", "^prompt"],
                    "name": "file103",
                },
            ],
            "hosts": [
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "exclude_hostname": True,
                    "facility_override": "ftp",
                    "log_prefix": "field",
                    "match": "^set*",
                    "match_strings": ["^delete", "^prompt"],
                    "name": "host111",
                    "port": 1231,
                    "routing_instance": "inst11",
                    "source_address": "11.1.1.11",
                    "structured_data": {"brief": True},
                },
            ],
            "log_rotate_frequency": 45,
            "routing_instance": "inst11",
            "source_address": "33.33.33.33",
            "time_format": {"set": True},
            "users": [
                {"allow_duplicates": True, "name": "user1"},
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "name": "user2",
                    "user": {"level": "info"},
                },
            ],
        }
        self.assertEqual(sorted(parsed_dict), sorted(result["parsed"]))

    def test_junos_logging_global_parsed_16(self):
        parsed_str = """
               <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                   <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                       <version>18.4R1-S2.4</version>
                       <system>
                           <syslog>
                               <archive>
                                   <size>65578</size>
                                   <files>10</files>
                                   <world-readable/>
                                   <binary-data/>
                               </archive>
                               <user>
                                   <name>user1</name>
                                   <allow-duplicates/>
                                   <match-strings>^delete</match-strings>
                                   <match-strings>^prompt</match-strings>
                               </user>
                               <user>
                                   <name>user2</name>
                                   <contents>
                                       <name>any</name>
                                       <any/>
                                   </contents>
                                   <contents>
                                       <name>user</name>
                                       <info/>
                                   </contents>
                                   <allow-duplicates/>
                               </user>
                               <host>
                                   <name>host111</name>
                                   <contents>
                                       <name>any</name>
                                       <any/>
                                   </contents>
                                   <match>^set*</match>
                                   <allow-duplicates/>
                                   <port>1231</port>
                                   <facility-override>ftp</facility-override>
                                   <log-prefix>field</log-prefix>
                                   <source-address>11.1.1.11</source-address>
                                   <routing-instance>inst11</routing-instance>
                                   <exclude-hostname/>
                                   <match-strings>^delete</match-strings>
                                   <match-strings>^prompt</match-strings>
                                   <structured-data>
                                       <brief/>
                                   </structured-data>
                               </host>
                               <allow-duplicates/>
                               <file>
                                   <name>file101</name>
                                   <allow-duplicates/>
                                   <archive-sites>
                                       <name>www.antsiblr.com</name>
                                       <name>www.antsiblr2.com</name>
                                   </archive-sites>
                                   <contents>
                                       <name>any</name>
                                       <any/>
                                   </contents>
                                   <contents>
                                       <name>authorization</name>
                                       <any/>
                                   </contents>
                                   <structured-data>
                                       <brief/>
                                   </structured-data>
                               </file>
                               <console>
                                   <name>any</name>
                                   <info/>
                               </console>
                               <console>
                                   <name>authorization</name>
                                   <any/>
                               </console>
                               <console>
                                   <name>ftp</name>
                                   <none/>
                               </console>
                               <console>
                                   <name>change-log</name>
                                   <critical/>
                               </console>
                               <time-format>
                               </time-format>
                               <source-address>33.33.33.33</source-address>
                               <routing-instance>inst11</routing-instance>
                               <log-rotate-frequency>45</log-rotate-frequency>
                           </syslog>
                       </system>
                   </configuration>
               </rpc-reply>
           """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_dict = {
            "allow_duplicates": True,
            "archive": {
                "file_size": 65578,
                "files": 10,
                "no_binary_data": True,
                "no_world_readable": True,
            },
            "console": {
                "any": {"level": "info"},
                "authorization": {"level": "any"},
                "change_log": {"level": "critical"},
                "ftp": {"level": "none"},
            },
            "files": [
                {
                    "allow_duplicates": True,
                    "name": "file101",
                    "archive_sites": ["www.antsiblr.com", "www.antsiblr2.com"],
                    "any": {"level": "any"},
                    "authorization": {"level": "any"},
                    "structured_data": {"brief": True},
                },
            ],
            "hosts": [
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "exclude_hostname": True,
                    "facility_override": "ftp",
                    "log_prefix": "field",
                    "match": "^set*",
                    "match_strings": ["^delete", "^prompt"],
                    "name": "host111",
                    "port": 1231,
                    "routing_instance": "inst11",
                    "source_address": "11.1.1.11",
                    "structured_data": {"brief": True},
                },
            ],
            "log_rotate_frequency": 45,
            "routing_instance": "inst11",
            "source_address": "33.33.33.33",
            "time_format": {"set": True},
            "users": [
                {
                    "allow_duplicates": True,
                    "name": "user1",
                    "match_strings": ["^delete", "^prompt"],
                },
                {
                    "allow_duplicates": True,
                    "any": {"level": "any"},
                    "name": "user2",
                    "user": {"level": "info"},
                },
            ],
        }
        self.assertEqual(sorted(parsed_dict), sorted(result["parsed"]))

    def test_junos_logging_global_parsed_17(self):
        parsed_str = """
               <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                   <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                       <version>18.4R1-S2.4</version>
                       <system>
                           <syslog>
                               <user>
                                   <name>user1</name>
                                   <match>^set*</match>
                                   <match-strings>^delete</match-strings>
                                   <contents>
                                       <name>user</name>
                                       <info/>
                                   </contents>
                               </user>
                               <host>
                                   <name>host111</name>
                                   <contents>
                                       <name>any</name>
                                       <any/>
                                   </contents>
                                   <contents>
                                       <name>authorization</name>
                                       <any/>
                                   </contents>
                                   <match-strings>^delete</match-strings>
                                   <structured-data>
                                   </structured-data>
                               </host>
                               <file>
                                   <name>file101</name>
                                   <match-strings>^delete</match-strings>
                                   <archive>
                                       <archive-sites>
                                          <name>www.antsiblr.com</name>
                                       </archive-sites>
                                       <archive-sites>
                                          <name>www.antsiblr2.com</name>
                                       </archive-sites>
                                   </archive>
                               </file>
                           </syslog>
                       </system>
                   </configuration>
               </rpc-reply>
           """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_dict = {
            "files": [
                {
                    "allow_duplicates": True,
                    "name": "file101",
                    "archive": {
                        "archive_sites": [
                            "www.antsiblr.com",
                            "www.antsiblr2.com",
                        ],
                    },
                    "any": {"level": "any"},
                    "authorization": {"level": "any"},
                    "structured_data": {"brief": True},
                },
            ],
            "hosts": [
                {
                    "any": {"level": "any"},
                    "authorization": {"level": "any"},
                    "match_strings": ["^delete"],
                    "name": "host111",
                    "structured_data": {"set": True},
                },
            ],
            "users": [
                {
                    "name": "user1",
                    "user": {"level": "info"},
                    "match": "^set*",
                    "match_strings": ["^delete"],
                },
            ],
        }
        self.assertEqual(sorted(parsed_dict), sorted(result["parsed"]))
