# generated automatically by aclocal 1.16.5 -*- Autoconf -*-

# Copyright (C) 1996-2021 Free Software Foundation, Inc.

# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

m4_ifndef([AC_CONFIG_MACRO_DIRS], [m4_defun([_AM_CONFIG_MACRO_DIRS], [])m4_defun([AC_CONFIG_MACRO_DIRS], [_AM_CONFIG_MACRO_DIRS($@)])])
# pkg.m4 - Macros to locate and utilise pkg-config.   -*- Autoconf -*-
# serial 11 (pkg-config-0.29.1)

dnl Copyright © 2004 Scott James Remnant <scott@netsplit.com>.
dnl Copyright © 2012-2015 Dan Nicholson <dbn.lists@gmail.com>
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful, but
dnl WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
dnl General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a
dnl configuration script generated by Autoconf, you may include it under
dnl the same distribution terms that you use for the rest of that
dnl program.

dnl PKG_PREREQ(MIN-VERSION)
dnl -----------------------
dnl Since: 0.29
dnl
dnl Verify that the version of the pkg-config macros are at least
dnl MIN-VERSION. Unlike PKG_PROG_PKG_CONFIG, which checks the user's
dnl installed version of pkg-config, this checks the developer's version
dnl of pkg.m4 when generating configure.
dnl
dnl To ensure that this macro is defined, also add:
dnl m4_ifndef([PKG_PREREQ],
dnl     [m4_fatal([must install pkg-config 0.29 or later before running autoconf/autogen])])
dnl
dnl See the "Since" comment for each macro you use to see what version
dnl of the macros you require.
m4_defun([PKG_PREREQ],
[m4_define([PKG_MACROS_VERSION], [0.29.1])
m4_if(m4_version_compare(PKG_MACROS_VERSION, [$1]), -1,
    [m4_fatal([pkg.m4 version $1 or higher is required but ]PKG_MACROS_VERSION[ found])])
])dnl PKG_PREREQ

dnl PKG_PROG_PKG_CONFIG([MIN-VERSION])
dnl ----------------------------------
dnl Since: 0.16
dnl
dnl Search for the pkg-config tool and set the PKG_CONFIG variable to
dnl first found in the path. Checks that the version of pkg-config found
dnl is at least MIN-VERSION. If MIN-VERSION is not specified, 0.9.0 is
dnl used since that's the first version where most current features of
dnl pkg-config existed.
AC_DEFUN([PKG_PROG_PKG_CONFIG],
[m4_pattern_forbid([^_?PKG_[A-Z_]+$])
m4_pattern_allow([^PKG_CONFIG(_(PATH|LIBDIR|SYSROOT_DIR|ALLOW_SYSTEM_(CFLAGS|LIBS)))?$])
m4_pattern_allow([^PKG_CONFIG_(DISABLE_UNINSTALLED|TOP_BUILD_DIR|DEBUG_SPEW)$])
AC_ARG_VAR([PKG_CONFIG], [path to pkg-config utility])
AC_ARG_VAR([PKG_CONFIG_PATH], [directories to add to pkg-config's search path])
AC_ARG_VAR([PKG_CONFIG_LIBDIR], [path overriding pkg-config's built-in search path])

if test "x$ac_cv_env_PKG_CONFIG_set" != "xset"; then
	AC_PATH_TOOL([PKG_CONFIG], [pkg-config])
fi
if test -n "$PKG_CONFIG"; then
	_pkg_min_version=m4_default([$1], [0.9.0])
	AC_MSG_CHECKING([pkg-config is at least version $_pkg_min_version])
	if $PKG_CONFIG --atleast-pkgconfig-version $_pkg_min_version; then
		AC_MSG_RESULT([yes])
	else
		AC_MSG_RESULT([no])
		PKG_CONFIG=""
	fi
fi[]dnl
])dnl PKG_PROG_PKG_CONFIG

dnl PKG_CHECK_EXISTS(MODULES, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl -------------------------------------------------------------------
dnl Since: 0.18
dnl
dnl Check to see whether a particular set of modules exists. Similar to
dnl PKG_CHECK_MODULES(), but does not set variables or print errors.
dnl
dnl Please remember that m4 expands AC_REQUIRE([PKG_PROG_PKG_CONFIG])
dnl only at the first occurence in configure.ac, so if the first place
dnl it's called might be skipped (such as if it is within an "if", you
dnl have to call PKG_CHECK_EXISTS manually
AC_DEFUN([PKG_CHECK_EXISTS],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
if test -n "$PKG_CONFIG" && \
    AC_RUN_LOG([$PKG_CONFIG --exists --print-errors "$1"]); then
  m4_default([$2], [:])
m4_ifvaln([$3], [else
  $3])dnl
fi])

dnl _PKG_CONFIG([VARIABLE], [COMMAND], [MODULES])
dnl ---------------------------------------------
dnl Internal wrapper calling pkg-config via PKG_CONFIG and setting
dnl pkg_failed based on the result.
m4_define([_PKG_CONFIG],
[if test -n "$$1"; then
    pkg_cv_[]$1="$$1"
 elif test -n "$PKG_CONFIG"; then
    PKG_CHECK_EXISTS([$3],
                     [pkg_cv_[]$1=`$PKG_CONFIG --[]$2 "$3" 2>/dev/null`
		      test "x$?" != "x0" && pkg_failed=yes ],
		     [pkg_failed=yes])
 else
    pkg_failed=untried
fi[]dnl
])dnl _PKG_CONFIG

dnl _PKG_SHORT_ERRORS_SUPPORTED
dnl ---------------------------
dnl Internal check to see if pkg-config supports short errors.
AC_DEFUN([_PKG_SHORT_ERRORS_SUPPORTED],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])
if $PKG_CONFIG --atleast-pkgconfig-version 0.20; then
        _pkg_short_errors_supported=yes
else
        _pkg_short_errors_supported=no
fi[]dnl
])dnl _PKG_SHORT_ERRORS_SUPPORTED


dnl PKG_CHECK_MODULES(VARIABLE-PREFIX, MODULES, [ACTION-IF-FOUND],
dnl   [ACTION-IF-NOT-FOUND])
dnl --------------------------------------------------------------
dnl Since: 0.4.0
dnl
dnl Note that if there is a possibility the first call to
dnl PKG_CHECK_MODULES might not happen, you should be sure to include an
dnl explicit call to PKG_PROG_PKG_CONFIG in your configure.ac
AC_DEFUN([PKG_CHECK_MODULES],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
AC_ARG_VAR([$1][_CFLAGS], [C compiler flags for $1, overriding pkg-config])dnl
AC_ARG_VAR([$1][_LIBS], [linker flags for $1, overriding pkg-config])dnl

pkg_failed=no
AC_MSG_CHECKING([for $1])

_PKG_CONFIG([$1][_CFLAGS], [cflags], [$2])
_PKG_CONFIG([$1][_LIBS], [libs], [$2])

m4_define([_PKG_TEXT], [Alternatively, you may set the environment variables $1[]_CFLAGS
and $1[]_LIBS to avoid the need to call pkg-config.
See the pkg-config man page for more details.])

if test $pkg_failed = yes; then
   	AC_MSG_RESULT([no])
        _PKG_SHORT_ERRORS_SUPPORTED
        if test $_pkg_short_errors_supported = yes; then
	        $1[]_PKG_ERRORS=`$PKG_CONFIG --short-errors --print-errors --cflags --libs "$2" 2>&1`
        else 
	        $1[]_PKG_ERRORS=`$PKG_CONFIG --print-errors --cflags --libs "$2" 2>&1`
        fi
	# Put the nasty error message in config.log where it belongs
	echo "$$1[]_PKG_ERRORS" >&AS_MESSAGE_LOG_FD

	m4_default([$4], [AC_MSG_ERROR(
[Package requirements ($2) were not met:

$$1_PKG_ERRORS

Consider adjusting the PKG_CONFIG_PATH environment variable if you
installed software in a non-standard prefix.

_PKG_TEXT])[]dnl
        ])
elif test $pkg_failed = untried; then
     	AC_MSG_RESULT([no])
	m4_default([$4], [AC_MSG_FAILURE(
[The pkg-config script could not be found or is too old.  Make sure it
is in your PATH or set the PKG_CONFIG environment variable to the full
path to pkg-config.

_PKG_TEXT

To get pkg-config, see <http://pkg-config.freedesktop.org/>.])[]dnl
        ])
else
	$1[]_CFLAGS=$pkg_cv_[]$1[]_CFLAGS
	$1[]_LIBS=$pkg_cv_[]$1[]_LIBS
        AC_MSG_RESULT([yes])
	$3
fi[]dnl
])dnl PKG_CHECK_MODULES


dnl PKG_CHECK_MODULES_STATIC(VARIABLE-PREFIX, MODULES, [ACTION-IF-FOUND],
dnl   [ACTION-IF-NOT-FOUND])
dnl ---------------------------------------------------------------------
dnl Since: 0.29
dnl
dnl Checks for existence of MODULES and gathers its build flags with
dnl static libraries enabled. Sets VARIABLE-PREFIX_CFLAGS from --cflags
dnl and VARIABLE-PREFIX_LIBS from --libs.
dnl
dnl Note that if there is a possibility the first call to
dnl PKG_CHECK_MODULES_STATIC might not happen, you should be sure to
dnl include an explicit call to PKG_PROG_PKG_CONFIG in your
dnl configure.ac.
AC_DEFUN([PKG_CHECK_MODULES_STATIC],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
_save_PKG_CONFIG=$PKG_CONFIG
PKG_CONFIG="$PKG_CONFIG --static"
PKG_CHECK_MODULES($@)
PKG_CONFIG=$_save_PKG_CONFIG[]dnl
])dnl PKG_CHECK_MODULES_STATIC


dnl PKG_INSTALLDIR([DIRECTORY])
dnl -------------------------
dnl Since: 0.27
dnl
dnl Substitutes the variable pkgconfigdir as the location where a module
dnl should install pkg-config .pc files. By default the directory is
dnl $libdir/pkgconfig, but the default can be changed by passing
dnl DIRECTORY. The user can override through the --with-pkgconfigdir
dnl parameter.
AC_DEFUN([PKG_INSTALLDIR],
[m4_pushdef([pkg_default], [m4_default([$1], ['${libdir}/pkgconfig'])])
m4_pushdef([pkg_description],
    [pkg-config installation directory @<:@]pkg_default[@:>@])
AC_ARG_WITH([pkgconfigdir],
    [AS_HELP_STRING([--with-pkgconfigdir], pkg_description)],,
    [with_pkgconfigdir=]pkg_default)
AC_SUBST([pkgconfigdir], [$with_pkgconfigdir])
m4_popdef([pkg_default])
m4_popdef([pkg_description])
])dnl PKG_INSTALLDIR


dnl PKG_NOARCH_INSTALLDIR([DIRECTORY])
dnl --------------------------------
dnl Since: 0.27
dnl
dnl Substitutes the variable noarch_pkgconfigdir as the location where a
dnl module should install arch-independent pkg-config .pc files. By
dnl default the directory is $datadir/pkgconfig, but the default can be
dnl changed by passing DIRECTORY. The user can override through the
dnl --with-noarch-pkgconfigdir parameter.
AC_DEFUN([PKG_NOARCH_INSTALLDIR],
[m4_pushdef([pkg_default], [m4_default([$1], ['${datadir}/pkgconfig'])])
m4_pushdef([pkg_description],
    [pkg-config arch-independent installation directory @<:@]pkg_default[@:>@])
AC_ARG_WITH([noarch-pkgconfigdir],
    [AS_HELP_STRING([--with-noarch-pkgconfigdir], pkg_description)],,
    [with_noarch_pkgconfigdir=]pkg_default)
AC_SUBST([noarch_pkgconfigdir], [$with_noarch_pkgconfigdir])
m4_popdef([pkg_default])
m4_popdef([pkg_description])
])dnl PKG_NOARCH_INSTALLDIR


dnl PKG_CHECK_VAR(VARIABLE, MODULE, CONFIG-VARIABLE,
dnl [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl -------------------------------------------
dnl Since: 0.28
dnl
dnl Retrieves the value of the pkg-config variable for the given module.
AC_DEFUN([PKG_CHECK_VAR],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
AC_ARG_VAR([$1], [value of $3 for $2, overriding pkg-config])dnl

_PKG_CONFIG([$1], [variable="][$3]["], [$2])
AS_VAR_COPY([$1], [pkg_cv_][$1])

AS_VAR_IF([$1], [""], [$5], [$4])dnl
])dnl PKG_CHECK_VAR

dnl PKG_WITH_MODULES(VARIABLE-PREFIX, MODULES,
dnl   [ACTION-IF-FOUND],[ACTION-IF-NOT-FOUND],
dnl   [DESCRIPTION], [DEFAULT])
dnl ------------------------------------------
dnl
dnl Prepare a "--with-" configure option using the lowercase
dnl [VARIABLE-PREFIX] name, merging the behaviour of AC_ARG_WITH and
dnl PKG_CHECK_MODULES in a single macro.
AC_DEFUN([PKG_WITH_MODULES],
[
m4_pushdef([with_arg], m4_tolower([$1]))

m4_pushdef([description],
           [m4_default([$5], [build with ]with_arg[ support])])

m4_pushdef([def_arg], [m4_default([$6], [auto])])
m4_pushdef([def_action_if_found], [AS_TR_SH([with_]with_arg)=yes])
m4_pushdef([def_action_if_not_found], [AS_TR_SH([with_]with_arg)=no])

m4_case(def_arg,
            [yes],[m4_pushdef([with_without], [--without-]with_arg)],
            [m4_pushdef([with_without],[--with-]with_arg)])

AC_ARG_WITH(with_arg,
     AS_HELP_STRING(with_without, description[ @<:@default=]def_arg[@:>@]),,
    [AS_TR_SH([with_]with_arg)=def_arg])

AS_CASE([$AS_TR_SH([with_]with_arg)],
            [yes],[PKG_CHECK_MODULES([$1],[$2],$3,$4)],
            [auto],[PKG_CHECK_MODULES([$1],[$2],
                                        [m4_n([def_action_if_found]) $3],
                                        [m4_n([def_action_if_not_found]) $4])])

m4_popdef([with_arg])
m4_popdef([description])
m4_popdef([def_arg])

])dnl PKG_WITH_MODULES

dnl PKG_HAVE_WITH_MODULES(VARIABLE-PREFIX, MODULES,
dnl   [DESCRIPTION], [DEFAULT])
dnl -----------------------------------------------
dnl
dnl Convenience macro to trigger AM_CONDITIONAL after PKG_WITH_MODULES
dnl check._[VARIABLE-PREFIX] is exported as make variable.
AC_DEFUN([PKG_HAVE_WITH_MODULES],
[
PKG_WITH_MODULES([$1],[$2],,,[$3],[$4])

AM_CONDITIONAL([HAVE_][$1],
               [test "$AS_TR_SH([with_]m4_tolower([$1]))" = "yes"])
])dnl PKG_HAVE_WITH_MODULES

dnl PKG_HAVE_DEFINE_WITH_MODULES(VARIABLE-PREFIX, MODULES,
dnl   [DESCRIPTION], [DEFAULT])
dnl ------------------------------------------------------
dnl
dnl Convenience macro to run AM_CONDITIONAL and AC_DEFINE after
dnl PKG_WITH_MODULES check. HAVE_[VARIABLE-PREFIX] is exported as make
dnl and preprocessor variable.
AC_DEFUN([PKG_HAVE_DEFINE_WITH_MODULES],
[
PKG_HAVE_WITH_MODULES([$1],[$2],[$3],[$4])

AS_IF([test "$AS_TR_SH([with_]m4_tolower([$1]))" = "yes"],
        [AC_DEFINE([HAVE_][$1], 1, [Enable ]m4_tolower([$1])[ support])])
])dnl PKG_HAVE_DEFINE_WITH_MODULES

# ===========================================================================
#  https://www.gnu.org/software/autoconf-archive/ax_check_compile_flag.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_CHECK_COMPILE_FLAG(FLAG, [ACTION-SUCCESS], [ACTION-FAILURE], [EXTRA-FLAGS], [INPUT])
#
# DESCRIPTION
#
#   Check whether the given FLAG works with the current language's compiler
#   or gives an error.  (Warnings, however, are ignored)
#
#   ACTION-SUCCESS/ACTION-FAILURE are shell commands to execute on
#   success/failure.
#
#   If EXTRA-FLAGS is defined, it is added to the current language's default
#   flags (e.g. CFLAGS) when the check is done.  The check is thus made with
#   the flags: "CFLAGS EXTRA-FLAGS FLAG".  This can for example be used to
#   force the compiler to issue an error when a bad flag is given.
#
#   INPUT gives an alternative input source to AC_COMPILE_IFELSE.
#
#   NOTE: Implementation based on AX_CFLAGS_GCC_OPTION. Please keep this
#   macro in sync with AX_CHECK_{PREPROC,LINK}_FLAG.
#
# LICENSE
#
#   Copyright (c) 2008 Guido U. Draheim <guidod@gmx.de>
#   Copyright (c) 2011 Maarten Bosmans <mkbosmans@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved.  This file is offered as-is, without any
#   warranty.

#serial 6

AC_DEFUN([AX_CHECK_COMPILE_FLAG],
[AC_PREREQ(2.64)dnl for _AC_LANG_PREFIX and AS_VAR_IF
AS_VAR_PUSHDEF([CACHEVAR],[ax_cv_check_[]_AC_LANG_ABBREV[]flags_$4_$1])dnl
AC_CACHE_CHECK([whether _AC_LANG compiler accepts $1], CACHEVAR, [
  ax_check_save_flags=$[]_AC_LANG_PREFIX[]FLAGS
  _AC_LANG_PREFIX[]FLAGS="$[]_AC_LANG_PREFIX[]FLAGS $4 $1"
  AC_COMPILE_IFELSE([m4_default([$5],[AC_LANG_PROGRAM()])],
    [AS_VAR_SET(CACHEVAR,[yes])],
    [AS_VAR_SET(CACHEVAR,[no])])
  _AC_LANG_PREFIX[]FLAGS=$ax_check_save_flags])
AS_VAR_IF(CACHEVAR,yes,
  [m4_default([$2], :)],
  [m4_default([$3], :)])
AS_VAR_POPDEF([CACHEVAR])dnl
])dnl AX_CHECK_COMPILE_FLAGS

# ===========================================================================
#  https://www.gnu.org/software/autoconf-archive/ax_gcc_func_attribute.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_GCC_FUNC_ATTRIBUTE(ATTRIBUTE)
#
# DESCRIPTION
#
#   This macro checks if the compiler supports one of GCC's function
#   attributes; many other compilers also provide function attributes with
#   the same syntax. Compiler warnings are used to detect supported
#   attributes as unsupported ones are ignored by default so quieting
#   warnings when using this macro will yield false positives.
#
#   The ATTRIBUTE parameter holds the name of the attribute to be checked.
#
#   If ATTRIBUTE is supported define HAVE_FUNC_ATTRIBUTE_<ATTRIBUTE>.
#
#   The macro caches its result in the ax_cv_have_func_attribute_<attribute>
#   variable.
#
#   The macro currently supports the following function attributes:
#
#    alias
#    aligned
#    alloc_size
#    always_inline
#    artificial
#    cold
#    const
#    constructor
#    constructor_priority for constructor attribute with priority
#    deprecated
#    destructor
#    dllexport
#    dllimport
#    error
#    externally_visible
#    fallthrough
#    flatten
#    format
#    format_arg
#    gnu_format
#    gnu_inline
#    hot
#    ifunc
#    leaf
#    malloc
#    noclone
#    noinline
#    nonnull
#    noreturn
#    nothrow
#    optimize
#    pure
#    sentinel
#    sentinel_position
#    unused
#    used
#    visibility
#    warning
#    warn_unused_result
#    weak
#    weakref
#
#   Unsupported function attributes will be tested with a prototype
#   returning an int and not accepting any arguments and the result of the
#   check might be wrong or meaningless so use with care.
#
# LICENSE
#
#   Copyright (c) 2013 Gabriele Svelto <gabriele.svelto@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved.  This file is offered as-is, without any
#   warranty.

#serial 12

AC_DEFUN([AX_GCC_FUNC_ATTRIBUTE], [
    AS_VAR_PUSHDEF([ac_var], [ax_cv_have_func_attribute_$1])

    AC_CACHE_CHECK([for __attribute__(($1))], [ac_var], [
        AC_LINK_IFELSE([AC_LANG_PROGRAM([
            m4_case([$1],
                [alias], [
                    int foo( void ) { return 0; }
                    int bar( void ) __attribute__(($1("foo")));
                ],
                [aligned], [
                    int foo( void ) __attribute__(($1(32)));
                ],
                [alloc_size], [
                    void *foo(int a) __attribute__(($1(1)));
                ],
                [always_inline], [
                    inline __attribute__(($1)) int foo( void ) { return 0; }
                ],
                [artificial], [
                    inline __attribute__(($1)) int foo( void ) { return 0; }
                ],
                [cold], [
                    int foo( void ) __attribute__(($1));
                ],
                [const], [
                    int foo( void ) __attribute__(($1));
                ],
                [constructor_priority], [
                    int foo( void ) __attribute__((__constructor__(65535/2)));
                ],
                [constructor], [
                    int foo( void ) __attribute__(($1));
                ],
                [deprecated], [
                    int foo( void ) __attribute__(($1("")));
                ],
                [destructor], [
                    int foo( void ) __attribute__(($1));
                ],
                [dllexport], [
                    __attribute__(($1)) int foo( void ) { return 0; }
                ],
                [dllimport], [
                    int foo( void ) __attribute__(($1));
                ],
                [error], [
                    int foo( void ) __attribute__(($1("")));
                ],
                [externally_visible], [
                    int foo( void ) __attribute__(($1));
                ],
                [fallthrough], [
                    int foo( void ) {switch (0) { case 1: __attribute__(($1)); case 2: break ; }};
                ],
                [flatten], [
                    int foo( void ) __attribute__(($1));
                ],
                [format], [
                    int foo(const char *p, ...) __attribute__(($1(printf, 1, 2)));
                ],
                [gnu_format], [
                    int foo(const char *p, ...) __attribute__((format(gnu_printf, 1, 2)));
                ],
                [format_arg], [
                    char *foo(const char *p) __attribute__(($1(1)));
                ],
                [gnu_inline], [
                    inline __attribute__(($1)) int foo( void ) { return 0; }
                ],
                [hot], [
                    int foo( void ) __attribute__(($1));
                ],
                [ifunc], [
                    int my_foo( void ) { return 0; }
                    static int (*resolve_foo(void))(void) { return my_foo; }
                    int foo( void ) __attribute__(($1("resolve_foo")));
                ],
                [leaf], [
                    __attribute__(($1)) int foo( void ) { return 0; }
                ],
                [malloc], [
                    void *foo( void ) __attribute__(($1));
                ],
                [noclone], [
                    int foo( void ) __attribute__(($1));
                ],
                [noinline], [
                    __attribute__(($1)) int foo( void ) { return 0; }
                ],
                [nonnull], [
                    int foo(char *p) __attribute__(($1(1)));
                ],
                [noreturn], [
                    void foo( void ) __attribute__(($1));
                ],
                [nothrow], [
                    int foo( void ) __attribute__(($1));
                ],
                [optimize], [
                    __attribute__(($1(3))) int foo( void ) { return 0; }
                ],
                [pure], [
                    int foo( void ) __attribute__(($1));
                ],
                [sentinel], [
                    int foo(void *p, ...) __attribute__(($1));
                ],
                [sentinel_position], [
                    int foo(void *p, ...) __attribute__(($1(1)));
                ],
                [returns_nonnull], [
                    void *foo( void ) __attribute__(($1));
                ],
                [unused], [
                    int foo( void ) __attribute__(($1));
                ],
                [used], [
                    int foo( void ) __attribute__(($1));
                ],
                [visibility], [
                    int foo_def( void ) __attribute__(($1("default")));
                    int foo_hid( void ) __attribute__(($1("hidden")));
                    int foo_int( void ) __attribute__(($1("internal")));
                    int foo_pro( void ) __attribute__(($1("protected")));
                ],
                [warning], [
                    int foo( void ) __attribute__(($1("")));
                ],
                [warn_unused_result], [
                    int foo( void ) __attribute__(($1));
                ],
                [weak], [
                    int foo( void ) __attribute__(($1));
                ],
                [weakref], [
                    static int foo( void ) { return 0; }
                    static int bar( void ) __attribute__(($1("foo")));
                ],
                [
                 m4_warn([syntax], [Unsupported attribute $1, the test may fail])
                 int foo( void ) __attribute__(($1));
                ]
            )], [])
            ],
            dnl GCC doesn't exit with an error if an unknown attribute is
            dnl provided but only outputs a warning, so accept the attribute
            dnl only if no warning were issued.
            [AS_IF([grep -- -Wattributes conftest.err],
                [AS_VAR_SET([ac_var], [no])],
                [AS_VAR_SET([ac_var], [yes])])],
            [AS_VAR_SET([ac_var], [no])])
    ])

    AS_IF([test yes = AS_VAR_GET([ac_var])],
        [AC_DEFINE_UNQUOTED(AS_TR_CPP(HAVE_FUNC_ATTRIBUTE_$1), 1,
            [Define to 1 if the system has the `$1' function attribute])], [])

    AS_VAR_POPDEF([ac_var])
])

# ===========================================================================
#   https://www.gnu.org/software/autoconf-archive/ax_gcc_var_attribute.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_GCC_VAR_ATTRIBUTE(ATTRIBUTE)
#
# DESCRIPTION
#
#   This macro checks if the compiler supports one of GCC's variable
#   attributes; many other compilers also provide variable attributes with
#   the same syntax. Compiler warnings are used to detect supported
#   attributes as unsupported ones are ignored by default so quieting
#   warnings when using this macro will yield false positives.
#
#   The ATTRIBUTE parameter holds the name of the attribute to be checked.
#
#   If ATTRIBUTE is supported define HAVE_VAR_ATTRIBUTE_<ATTRIBUTE>.
#
#   The macro caches its result in the ax_cv_have_var_attribute_<attribute>
#   variable.
#
#   The macro currently supports the following variable attributes:
#
#    aligned
#    cleanup
#    common
#    nocommon
#    deprecated
#    mode
#    packed
#    tls_model
#    unused
#    used
#    vector_size
#    weak
#    dllimport
#    dllexport
#    init_priority
#
#   Unsupported variable attributes will be tested against a global integer
#   variable and without any arguments given to the attribute itself; the
#   result of this check might be wrong or meaningless so use with care.
#
# LICENSE
#
#   Copyright (c) 2013 Gabriele Svelto <gabriele.svelto@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved.  This file is offered as-is, without any
#   warranty.

#serial 5

AC_DEFUN([AX_GCC_VAR_ATTRIBUTE], [
    AS_VAR_PUSHDEF([ac_var], [ax_cv_have_var_attribute_$1])

    AC_CACHE_CHECK([for __attribute__(($1))], [ac_var], [
        AC_LINK_IFELSE([AC_LANG_PROGRAM([
            m4_case([$1],
                [aligned], [
                    int foo __attribute__(($1(32)));
                ],
                [cleanup], [
                    int bar(int *t) { return *t; };
                ],
                [common], [
                    int foo __attribute__(($1));
                ],
                [nocommon], [
                    int foo __attribute__(($1));
                ],
                [deprecated], [
                    int foo __attribute__(($1)) = 0;
                ],
                [mode], [
                    long foo __attribute__(($1(word)));
                ],
                [packed], [
                    struct bar {
                        int baz __attribute__(($1));
                    };
                ],
                [tls_model], [
                    __thread int bar1 __attribute__(($1("global-dynamic")));
                    __thread int bar2 __attribute__(($1("local-dynamic")));
                    __thread int bar3 __attribute__(($1("initial-exec")));
                    __thread int bar4 __attribute__(($1("local-exec")));
                ],
                [unused], [
                    int foo __attribute__(($1));
                ],
                [used], [
                    int foo __attribute__(($1));
                ],
                [vector_size], [
                    int foo __attribute__(($1(16)));
                ],
                [weak], [
                    int foo __attribute__(($1));
                ],
                [dllimport], [
                    int foo __attribute__(($1));
                ],
                [dllexport], [
                    int foo __attribute__(($1));
                ],
                [init_priority], [
                    struct bar { bar() {} ~bar() {} };
                    bar b __attribute__(($1(65535/2)));
                ],
                [
                 m4_warn([syntax], [Unsupported attribute $1, the test may fail])
                 int foo __attribute__(($1));
                ]
            )], [
            m4_case([$1],
                [cleanup], [
                    int foo __attribute__(($1(bar))) = 0;
                    foo = foo + 1;
                ],
                []
            )])
            ],
            dnl GCC doesn't exit with an error if an unknown attribute is
            dnl provided but only outputs a warning, so accept the attribute
            dnl only if no warning were issued.
            [AS_IF([test -s conftest.err],
                [AS_VAR_SET([ac_var], [no])],
                [AS_VAR_SET([ac_var], [yes])])],
            [AS_VAR_SET([ac_var], [no])])
    ])

    AS_IF([test yes = AS_VAR_GET([ac_var])],
        [AC_DEFINE_UNQUOTED(AS_TR_CPP(HAVE_VAR_ATTRIBUTE_$1), 1,
            [Define to 1 if the system has the `$1' variable attribute])], [])

    AS_VAR_POPDEF([ac_var])
])

# libbrlapi - A library providing access to braille terminals for applications.
#
# Copyright (C) 1995-2024 by Dave Mielke <dave@mielke.cc>
#
# libbrlapi comes with ABSOLUTELY NO WARRANTY.
#
# This is free software, placed under the terms of the
# GNU Lesser General Public License, as published by the Free Software
# Foundation; either version 2.1 of the License, or (at your option) any
# later version. Please see the file LICENSE-LGPL for details.
#
# Web Page: http://brltty.app/
#
# This software is maintained by Dave Mielke <dave@mielke.cc>.

AC_DEFUN([BRLTTY_UPPERCASE_TRANSLATE], [translit([$1], [a-z], [A-Z])])

AC_DEFUN([BRLTTY_TRANSLATE_ASSIGN], [$1=`echo "$2" | sed -e 'y%$3%$4%'`])
AC_DEFUN([BRLTTY_UPPERCASE_ASSIGN], BRLTTY_TRANSLATE_ASSIGN([$1], [$2], [abcdefghijklmnopqrstuvwxyz$3], [ABCDEFGHIJKLMNOPQRSTUVWXYZ$4]))
AC_DEFUN([BRLTTY_LOWERCASE_ASSIGN], [BRLTTY_TRANSLATE_ASSIGN([$1], [$2], [ABCDEFGHIJKLMNOPQRSTUVWXYZ$3], [abcdefghijklmnopqrstuvwxyz$4])])

AC_DEFUN([BRLTTY_INCLUDE_HEADERS], [dnl
ifelse(len([$1]), 0, [], [
[#]include <$1>
])ifelse($#, 1, [], [BRLTTY_INCLUDE_HEADERS(m4_shift($@))])])

AC_DEFUN([BRLTTY_CHECK_FUNCTION], [dnl
   AC_CHECK_DECL([$1], [dnl
      AC_SEARCH_LIBS([$1], [$3], [dnl
         BRLTTY_UPPERCASE_ASSIGN([brltty_define], [have_$1])
         AC_DEFINE_UNQUOTED(${brltty_define}, [1], [Define this if the function $1 is available.])
      ])
   ], [], [BRLTTY_INCLUDE_HEADERS(m4_translit([$2], [ ], [,]))])
])

AC_DEFUN([BRLTTY_SEARCH_LIBS], [dnl
BRLTTY_UPPERCASE_ASSIGN([brltty_uc], [$1])
AC_SEARCH_LIBS([$1], [$2], [AC_DEFINE_UNQUOTED(HAVE_${brltty_uc}, [1], [Define this if the function $1 is available.])])])

AC_DEFUN([BRLTTY_VAR_TRIM], [dnl
$1="`echo "${$1}" | sed -e 's/^ *//' -e 's/ *$//'`"
])

AC_DEFUN([BRLTTY_VAR_EXPAND], [dnl
$1='$2'
while test "${$1}" != "${$1%\$?*}"
do
   eval '$1="'"${$1}"'"'
done
])

AC_DEFUN([BRLTTY_SUBST_EXPANDED], [dnl
BRLTTY_VAR_EXPAND([brltty_expanded], [$2])
AC_SUBST([$1], ["${brltty_expanded}"])])

AC_DEFUN([BRLTTY_DEFINE_STRING], [dnl
   AC_SUBST([$1], [$2])
   AC_DEFINE([$1], ["$2"], [Define this to be a string containing $3.])
])

AC_DEFUN([BRLTTY_DEFINE_EXPANDED], [dnl
BRLTTY_VAR_EXPAND([brltty_expanded], [$2])
AC_DEFINE_UNQUOTED([$1], ["${brltty_expanded}"], [$3])])

AC_DEFUN([BRLTTY_RELATIVE_PATH], [dnl
AC_REQUIRE([AC_PROG_AWK])
eval '$1="`"${AWK}" -v path="'"$2"'" -v reference="'"$3"'" -f "${srcdir}/relpath.awk"`"'])

AC_DEFUN([BRLTTY_DEFINE_DIRECTORY], [dnl
BRLTTY_VAR_EXPAND([$1], [$2])
brltty_path="${$1}"

ifelse([$4], [public], [], [dnl
  test "${brltty_enabled_relocatable_install}" = "yes" && {
     test "${$1}" = "${$1#\\}" && {
        BRLTTY_RELATIVE_PATH([brltty_path], [${$1}], [${brltty_reference_directory}])
     }
  }
])

BRLTTY_DEFINE_EXPANDED([$1], [${brltty_path}], [$3])
# resolve escaped characters
eval '$1="'"${$1}"'"'
AC_SUBST([$1])
])

AC_DEFUN([BRLTTY_PUBLIC_DIRECTORY], [dnl
BRLTTY_DEFINE_DIRECTORY([$1], [$2], [$3], [public])
])

AC_DEFUN([BRLTTY_ARG_WITH], [dnl
AC_ARG_WITH([$1], BRLTTY_HELP_STRING([--with-$1=$2], [$3]), [$4="${withval}"], [$4=$5])])

AC_DEFUN([BRLTTY_ARG_REQUIRED], [dnl
BRLTTY_ARG_WITH([$1], [$2], [$3], [$4], ["yes"])
if test "${$4}" = "no"
then
   AC_MSG_ERROR([$1 not specified])
elif test "${$4}" = "yes"
then
   $4=$5
fi
AC_SUBST([$4])
BRLTTY_SUMMARY_ITEM([$1], [$4])])

AC_DEFUN([BRLTTY_ARG_TABLE], [dnl
brltty_default_table="$2"
BRLTTY_ARG_WITH(
   [$1-table], [NAME],
   [built-in $1 table],
   [$1_table], ["${brltty_default_table}"]
)
install_$1_tables=install-$1-tables
if test "${$1_table}" = "no"
then
   install_$1_tables=
   $1_table="${brltty_default_table}"
elif test "${$1_table}" = "yes"
then
   $1_table="${brltty_default_table}"
fi
AC_SUBST([install_$1_tables])
BRLTTY_SUMMARY_ITEM([$1-table], [$1_table])
AC_DEFINE_UNQUOTED(BRLTTY_UPPERCASE_TRANSLATE([$1_table]), ["${$1_table}"],
                   [Define this to be a string containing the path to the default $1 table.])
AC_SUBST([$1_table])])

AC_DEFUN([BRLTTY_ARG_PARAMETERS], [dnl
BRLTTY_ARG_WITH(
   [$1-parameters], [$3NAME=VALUE... (comma-separated)],
   [default parameters for the $2],
   [$1_parameters], ["yes"]
)
if test "${$1_parameters}" = "no"
then
   $1_parameters=""
elif test "${$1_parameters}" = "yes"
then
   $1_parameters="$4"
fi
AC_SUBST([$1_parameters])
AC_DEFINE_UNQUOTED(BRLTTY_UPPERCASE_TRANSLATE([$1_parameters]), ["${$1_parameters}"],
                   [Define this to be a string containing the default parameters for the $2.])
BRLTTY_SUMMARY_ITEM([$1-parameters], [$1_parameters])])

AC_DEFUN([BRLTTY_HAVE_HEADER], [
AC_PREPROC_IFELSE([AC_LANG_SOURCE([[@%:@include <$1>]])], [$2], [$3])
])

AC_DEFUN([BRLTTY_HAVE_LIBRARY], [AC_CHECK_LIB([$1], [main], [$2], [$3])])

AC_DEFUN([BRLTTY_ARG_PACKAGE], [dnl
$1_package=""
$1_includes=""
$1_libs=""

BRLTTY_ARG_WITH(
   [$1-package], [PACKAGE],
   [which $2 package to use],
   [packages], ["yes"]
)

if test "${packages}" = "no"
then
   $1_package="none"
elif test "${packages}" = "yes"
then
   packages="$3"
   ifelse(len([$4]), 0, [], [dnl
      case "${host_os}"
      in
         $4
         *);;
      esac
   ])
else
   packages=`echo "${packages}" | sed -e 'y/,/ /'`
fi

test -z "${$1_package}" && {
   test -n "${packages}" && {
      for package in ${packages}
      do
         BRLTTY_HAVE_PACKAGE([$1], [${package}], [], [:])
         test -n "${$1_package}" && break

         ifelse(len([$5]), 0, [], [dnl
            case "${package}"
            in
               $5
               *);;
            esac

            test -n "${$1_package}" && break
         ])

         AC_MSG_NOTICE([$2 package not available: ${package}])
      done
   }
}

test -z "${$1_package}" && {
   $1_package="none"
   AC_MSG_WARN([$2 support not available on this platform])
}

AC_SUBST([$1_package])
AC_SUBST([$1_includes])
AC_SUBST([$1_libs])
AC_DEFINE_UNQUOTED(BRLTTY_UPPERCASE_TRANSLATE([$1_package]), [${$1_package}], [Define this to the name of the selected $2 package.])
BRLTTY_UPPERCASE_ASSIGN([brltty_uc], [use_pkg_$1_${$1_package}], [-.], [__])
AC_DEFINE_UNQUOTED([${brltty_uc}])
BRLTTY_SUMMARY_ITEM([$1-package], [$1_package])])

AC_DEFUN([BRLTTY_ARG_ENABLE], [dnl
BRLTTY_ARG_FEATURE([$1], [$2], [enable], [no], [$3], [$4], [$5])])

AC_DEFUN([BRLTTY_ARG_DISABLE], [dnl
BRLTTY_ARG_FEATURE([$1], [$2], [disable], [yes], [$3], [$4], [$5])])

AC_DEFUN([BRLTTY_ARG_FEATURE], [dnl
AC_ARG_ENABLE([$1], BRLTTY_HELP_STRING([--$3-$1], [$2]), [], [enableval="$4"])

pushdef([var], brltty_enabled_[]translit([$1], [-], [_]))dnl
AC_SUBST(var, ["${enableval}"])
BRLTTY_SUMMARY_ITEM([$1], var)dnl
popdef([var])

if test "${enableval}" = "no"
then
   ifelse(len([$7]), 0, [:], [$7])
else
ifelse(len([$5]), 0, [], [dnl
   set -- [$5]
])dnl
   if test "${enableval}" = "yes"
   then
      brltty_ok=true
ifelse(len([$5]), 0, [], [dnl
      test "${#}" -gt 0 && enableval="${1}"
])dnl
   else
      brltty_ok=false
ifelse(len([$5]), 0, [], [dnl
      test "${#}" -gt 0 && {
         for brltty_selection
         do
            test "${brltty_selection}" = "${enableval}" && {
               brltty_ok=true
               break
            }
         done
      }
])dnl
   fi

   if "${brltty_ok}"
   then
ifelse(len([$5]), 0, [], [dnl
      test "${#}" -gt 0 && {
         BRLTTY_UPPERCASE_ASSIGN([brltty_uc], [use_$1_${enableval}], [-], [_])
         AC_DEFINE_UNQUOTED([${brltty_uc}])
      }
])dnl
      ifelse(len([$6]), 0, [:], [$6])
   else
      AC_MSG_ERROR([invalid selection: --enable-$1=${enableval}])
   fi
fi])

AC_DEFUN([BRLTTY_HELP_STRING], [dnl
AS_HELP_STRING([$1], patsubst([$2], [
.*$]), m4_defn([brltty_help_prefix]))dnl
patsubst(patsubst([$2], [\`[^
]*]), [
], [\&brltty_help_prefix])[]dnl
])
m4_define([brltty_help_indent], 32)
m4_define([brltty_help_prefix], m4_format([%]brltty_help_indent[s], []))
m4_define([brltty_help_width], m4_eval(79-brltty_help_indent))

AC_DEFUN([BRLTTY_ITEM], [dnl
define([brltty_item_list_$1], ifdef([brltty_item_list_$1], [brltty_item_list_$1])[
m4_text_wrap([$3], [      ], [- $2  ], brltty_help_width)])dnl
brltty_item_entries_$1="${brltty_item_entries_$1} $2-$3"
brltty_item_codes_$1="${brltty_item_codes_$1} $2"
brltty_item_names_$1="${brltty_item_names_$1} $3"
AC_SUBST([$1_libraries_$2], ['$4'])])

AC_DEFUN([BRLTTY_BRAILLE_DRIVER], [dnl
BRLTTY_ITEM([braille], [$1], [$2], [$3])])

AC_DEFUN([BRLTTY_SPEECH_DRIVER], [dnl
BRLTTY_ITEM([speech], [$1], [$2], [$3])])

AC_DEFUN([BRLTTY_SCREEN_DRIVER], [dnl
BRLTTY_ITEM([screen], [$1], [$2], [$3])])

AC_DEFUN([BRLTTY_ARG_ITEM], [dnl
BRLTTY_VAR_TRIM([brltty_item_codes_$1])
AC_SUBST([brltty_item_codes_$1])

BRLTTY_VAR_TRIM([brltty_item_names_$1])
AC_SUBST([brltty_item_names_$1])

case "${host_os}"
in
   cygwin*|mingw*)
      brltty_default="all"
      ;;
   *)
      brltty_default="yes"
      ;;
esac

BRLTTY_ARG_WITH(
   [$1-$2], BRLTTY_UPPERCASE_TRANSLATE([$2]),
   [$1 $2(s) to build in]brltty_item_list_$1,
   [brltty_items], ["${brltty_default}"]
)

if test "${brltty_items}" = "no"
then
   brltty_external_codes_$1=""
   brltty_external_names_$1=""
   brltty_internal_codes_$1=""
   brltty_internal_names_$1=""
else
   brltty_items_left_$1=" ${brltty_item_entries_$1} "
   brltty_external_codes_$1=" ${brltty_item_codes_$1} "
   brltty_external_names_$1=" ${brltty_item_names_$1} "
   brltty_internal_codes_$1=""
   brltty_internal_names_$1=""

   if test "${brltty_items}" != "yes"
   then
      while :
      do
         [brltty_delimiter="`expr "${brltty_items}" : '[^,]*,'`"]
         if test "${brltty_delimiter}" -eq 0
         then
            brltty_item="${brltty_items}"
            brltty_items=""
            if test "${brltty_item}" = "all"
            then
               brltty_item_all=true
               brltty_item_include=true
            elif test "${brltty_item}" = "-all"
            then
               brltty_item_all=true
               brltty_item_include=false
            else
               brltty_item_all=false
            fi
            if "${brltty_item_all}"
            then
               if "${brltty_item_include}"
               then
                  brltty_internal_codes_$1="${brltty_internal_codes_$1}${brltty_external_codes_$1}"
                  brltty_internal_names_$1="${brltty_internal_names_$1}${brltty_external_names_$1}"
               fi
               brltty_external_codes_$1=""
               brltty_external_names_$1=""
               break
            fi
         else
            [brltty_item="`expr "${brltty_items}" : '\([^,]*\)'`"]
            [brltty_items="`expr "${brltty_items}" : '[^,]*,\(.*\)'`"]
         fi
         brltty_item_suffix="${brltty_item#-}"
         if test "${brltty_item}" = "${brltty_item_suffix}"
         then
            brltty_item_include=true
         else
            brltty_item_include=false
            brltty_item="${brltty_item_suffix}"
         fi

         BRLTTY_ITEM_RESOLVE([$1])
         "${brltty_item_unknown}" && {
            AC_MSG_ERROR([unknown $1 $2: ${brltty_item}])
         }

         brltty_item_found="`expr "${brltty_external_codes_$1}" : ".* ${brltty_item_code} "`"
         test "${brltty_item_found}" -eq 0 && {
            AC_MSG_ERROR([duplicate $1 $2: ${brltty_item}])
         }

         brltty_items_left_$1="`echo "${brltty_items_left_$1}" | sed -e "s% ${brltty_item_entry} % %"`"
         brltty_external_codes_$1="`echo "${brltty_external_codes_$1}" | sed -e "s% ${brltty_item_code} % %"`"
         brltty_external_names_$1="`echo "${brltty_external_names_$1}" | sed -e "s% ${brltty_item_name} % %"`"

         "${brltty_item_include}" && {
            brltty_internal_codes_$1="${brltty_internal_codes_$1} ${brltty_item_code}"
            brltty_internal_names_$1="${brltty_internal_names_$1} ${brltty_item_name}"
         }

         BRLTTY_ITEM_RESOLVE([$1])
         "${brltty_item_unknown}" || {
            AC_MSG_ERROR([ambiguous $1 $2: ${brltty_item}])
         }

         test "${brltty_delimiter}" -eq 0 && break
      done
   fi

   BRLTTY_VAR_TRIM([brltty_external_codes_$1])
   BRLTTY_VAR_TRIM([brltty_external_names_$1])
   BRLTTY_VAR_TRIM([brltty_internal_codes_$1])
   BRLTTY_VAR_TRIM([brltty_internal_names_$1])
fi

AC_SUBST([brltty_external_codes_$1])
AC_SUBST([brltty_external_names_$1])
AC_SUBST([brltty_internal_codes_$1])
AC_SUBST([brltty_internal_names_$1])

set -- ${brltty_internal_codes_$1} ${brltty_external_codes_$1}
AC_DEFINE_UNQUOTED(BRLTTY_UPPERCASE_TRANSLATE([$1_$2_codes]), ["${*}"], 
                   [Define this to be a string containing a list of the $1 $2 codes.])

AC_SUBST([default_$1_$2], ["${1}"])
AC_DEFINE_UNQUOTED(BRLTTY_UPPERCASE_TRANSLATE([default_$1_$2]), ["${1}"], 
                   [Define this to be a string containing the default $1 $2 code.])

$1_driver_libraries=""
if test -n "${brltty_internal_codes_$1}"
then
   for brltty_driver in ${brltty_internal_codes_$1}
   do
      eval 'brltty_libraries="${$1_libraries_'"${brltty_driver}"'}"'
      if test -n "${brltty_libraries}"
      then
         $1_driver_libraries="${$1_driver_libraries} ${brltty_libraries}"
      fi
   done
fi
BRLTTY_VAR_TRIM([$1_driver_libraries])
AC_SUBST([$1_driver_libraries])
])

AC_DEFUN([BRLTTY_ITEM_RESOLVE], [dnl
brltty_item_unknown=true
brltty_item_length=`expr length "${brltty_item}"`

if test "${brltty_item_length}" -eq 2
then
   [brltty_item_entry=`expr "${brltty_items_left_$1}" : '.* \('"${brltty_item}"'-[^ ]*\)'`]
   if test -n "${brltty_item_entry}"
   then
      brltty_item_code="${brltty_item}"
      [brltty_item_name=`expr "${brltty_item_entry}" : '[^[.-.]]*-\(.*\)$'`]
      brltty_item_unknown=false
   fi
elif test "${brltty_item_length}" -gt 2
then
   [brltty_item_entry=`expr "${brltty_items_left_$1}" : '.* \([^- ]*-'"${brltty_item}"'[^ ]*\)'`]
   if test -z "${brltty_item_entry}"
   then
      BRLTTY_LOWERCASE_ASSIGN([brltty_lowercase], [${brltty_items_left_$1}])
      [brltty_item_code=`expr "${brltty_lowercase}" : '.* \([^- ]*\)-'"${brltty_item}"`]
      if test -n "${brltty_item_code}"
      then
         [brltty_item_entry=`expr "${brltty_items_left_$1}" : '.* \('"${brltty_item_code}"'-[^ ]*\)'`]
      fi
   fi

   if test -n "${brltty_item_entry}"
   then
      [brltty_item_code=`expr "${brltty_item_entry}" : '\([^[.-.]]*\)'`]
      [brltty_item_name=`expr "${brltty_item_entry}" : '[^[.-.]]*-\(.*\)$'`]
      brltty_item_unknown=false
   fi
fi
])

AC_DEFUN([BRLTTY_ARG_DRIVER], [dnl
BRLTTY_ARG_ITEM([$1], [driver])
if test "${brltty_enabled_$1_support}" != "no"
then
   if test -n "${brltty_internal_codes_$1}"
   then
      [$1_driver_objects="`echo "${brltty_internal_names_$1}" | sed -e 's%\([^ ][^ ]*\)%$(BLD_TOP)Drivers/$2/\1/$1.$O%g'`"]
      $1_help="$1-help"
   fi

   if test "${brltty_standalone_programs}" != "yes"
   then
      if test -n "${brltty_external_codes_$1}"
      then
         $1_drivers="$1-drivers"
         install_drivers="install-drivers"
      fi
      BRLTTY_SUMMARY_ITEM([external-$1-drivers], [brltty_external_codes_$1])
   fi

   BRLTTY_SUMMARY_ITEM([internal-$1-drivers], [brltty_internal_codes_$1])
   BRLTTY_ARG_PARAMETERS([$1], [$1 driver(s)], [DRIVER:])
fi

for brltty_driver in ${brltty_item_names_$1}
do
   brltty_build_directories="${brltty_build_directories} Drivers/$2/${brltty_driver}"
done

AC_SUBST([$1_driver_objects])
AC_SUBST([$1_drivers])
AC_SUBST([$1_help])
])

AC_DEFUN([BRLTTY_SUMMARY_BEGIN], [dnl
brltty_summary_lines="Options Summary:"
])

AC_DEFUN([BRLTTY_SUMMARY_END], [dnl
AC_CONFIG_COMMANDS([item-summary],
   [AC_MSG_NOTICE([${brltty_summary_lines}])],
   [brltty_summary_lines='${brltty_summary_lines}']
)])

AC_DEFUN([BRLTTY_SUMMARY_ITEM], [dnl
brltty_summary_lines="${brltty_summary_lines}
   $1: ${$2}"])

AC_DEFUN([BRLTTY_PORTABLE_DIRECTORY], [dnl
   BRLTTY_TOPLEVEL_DIRECTORY([$1], [$2], [prefix])])

AC_DEFUN([BRLTTY_ARCHITECTURE_DIRECTORY], [dnl
if test "${exec_prefix}" = "NONE"
then
   BRLTTY_TOPLEVEL_DIRECTORY([$1], [$2], [exec_prefix])
fi])

AC_DEFUN([BRLTTY_TOPLEVEL_DIRECTORY], [dnl
if test "${prefix}" = "NONE"
then
   if test -z "${execute_root}"
   then
      [if test `expr "${$1} " : '\${$3}/[^/]*$'` -gt 0]
      then
         $1="`echo ${$1} | sed -e 's%/%$2/%'`"
      fi
   fi
fi])

AC_DEFUN([BRLTTY_EXECUTABLE_PATH], [dnl
[if test `expr "${$1} " : '[^/ ][^/ ]*/'` -gt 0]
then
   $1="`pwd`/${$1}"
fi])

AC_DEFUN([BRLTTY_IF_PACKAGE], [dnl
BRLTTY_ARG_WITH(
   [$2], [DIRECTORY],
   [where the $1 package is installed],
   [$2_root], ["yes"]
)

$2_found=false
m4_define([$2_find], ifelse(m4_eval($# > 4), 1, [true], [false]))
ifelse($2_find, [true], [BRLTTY_HAVE_PACKAGE([$2], [$1], [$2_found=true], [:])])

if test "${$2_root}" = "no"
then
   $2_root=""
elif test "${$2_root}" = "yes"
then
   "${$2_found}" || {
      $2_root=""
      roots="/usr /usr/local /usr/local/$1 /usr/local/$2 /opt/$1 /opt/$2 /mingw /mingw/$1 /mingw/$2"

      for root in ${roots}
      do
         test -f "${root}/$3" && {
            $2_root="${root}"
            AC_MSG_NOTICE([$1 root: ${$2_root}])
            break
         }
      done

      if test -z "${$2_root}"
      then
         AC_MSG_WARN([$1 package not found: ${roots}])
      fi
   }
fi

AC_SUBST([$2_root])
BRLTTY_SUMMARY_ITEM([$2-root], [$2_root])

test -n "${$2_root}" && {
   ifelse($2_find, [true], [dnl
      if test "${$2_root}" = "yes"
      then
         $2_root="/usr"
      else
         $2_includes="BRLTTY_WORDS_PREPEND([$5], [-I${$2_root}/])"
         $2_libs="BRLTTY_WORDS_PREPEND([$6], [-L${$2_root}/]) BRLTTY_WORDS_PREPEND([$7], [-l])"
      fi
   ])

   AC_DEFINE_UNQUOTED(BRLTTY_UPPERCASE_TRANSLATE([$2_root]), ["${$2_root}"],
                      [Define this to be a string containing the path to the root of the $1 package.])

   $4
}
])

AC_DEFUN([BRLTTY_WORDS_PREPEND], [dnl
patsubst([$1], [\(\S+\)], [$2\1])])

AC_DEFUN([BRLTTY_HAVE_PACKAGE], [dnl
$1_package=""
$1_includes=""
$1_libs=""

for package_specification in $2
do
   ${PKG_CONFIG} --exists "${package_specification}" && {
      AC_DEFINE(BRLTTY_UPPERCASE_TRANSLATE([HAVE_PKG_$1]))

      $1_package="${package_specification%% *}"
      AC_MSG_NOTICE([$1 package: ${$1_package}])

      $1_includes=`${PKG_CONFIG} --cflags-only-I "${$1_package}"`
      AC_MSG_NOTICE([$1 includes: ${$1_includes}])

      $1_libs=`${PKG_CONFIG} ${pkgconfig_flags_libs} "${$1_package}"`
      AC_MSG_NOTICE([$1 libs: ${$1_libs}])

      $3
      break
   }
done

test -n "${$1_package}" || {
   ifelse(len([$4]), 0, [AC_MSG_WARN([$1 support not available])], [$4])
}

AC_SUBST([$1_package])
AC_SUBST([$1_includes])
AC_SUBST([$1_libs])
])

AC_DEFUN([BRLTTY_HAVE_DBUS], [dnl
   AC_CACHE_CHECK([if D-Bus is available], [brltty_cv_have_dbus], [dnl
      BRLTTY_HAVE_PACKAGE([dbus], ["dbus-1 >= 1.0"], [dnl
         brltty_cv_have_dbus=yes
      ], [dnl
         brltty_cv_have_dbus=no
      ])
   ])
])

AC_DEFUN([BRLTTY_IF_DBUS], [dnl
AC_REQUIRE([BRLTTY_HAVE_DBUS])
test "${brltty_cv_have_dbus}" = "yes" && {
   $1
}])

AC_DEFUN([BRLTTY_HAVE_PTHREADS], [dnl
   AC_CACHE_CHECK([if pthreads are available], [brltty_cv_have_pthreads], [dnl
      SYSCFLAGS="${SYSCFLAGS} -D_REENTRANT"
      case "${host_os}"
      in
         mingw32*)
            brltty_cv_have_pthreads=yes
            ;;
         *)
            brltty_cv_have_pthreads=no
            AC_CHECK_HEADER([pthread.h], [dnl
               case "${host_os}"
               in
                  solaris*) AC_SEARCH_LIBS([_getfp], [pthread], [brltty_cv_have_pthreads=yes]);;
                  hpux*) AC_SEARCH_LIBS([__pthread_cancel_stack], [pthread], [brltty_cv_have_pthreads=yes]);;
                  *) AC_SEARCH_LIBS([pthread_create], [pthread c_r], [brltty_cv_have_pthreads=yes]);;
               esac
            ])
            ;;
      esac
   ])
])

AC_DEFUN([BRLTTY_IF_PTHREADS], [dnl
AC_REQUIRE([BRLTTY_HAVE_PTHREADS])
test "${brltty_cv_have_pthreads}" = "yes" && {
   $1
}])

AC_DEFUN([BRLTTY_PACKAGE_CHOOSE], [dnl
BRLTTY_ARG_WITH(
   [translit([$1], [_], [-])], [PACKAGE],
   [which translit([$1], [_], [ ]) package to use (BRLTTY_PACKAGE_LIST(m4_shift($@)))],
   [$1_package], ["yes"]
)
if test "${$1_package}" = "no"
then
   $1_package=""
elif test "${$1_package}" = "yes"
then
AC_CACHE_CHECK([which translit([$1], [_], [ ]) package to use], [brltty_cv_package_$1], [dnl
   brltty_cv_package_$1=""
   brltty_packages=""
   BRLTTY_PACKAGE_DEFINE(m4_shift($@))

   for brltty_package in ${brltty_packages}
   do
      eval 'brltty_headers="${brltty_headers_'"${brltty_package}"'}"'
      test -n "${brltty_headers}" && {
         brltty_found=true
         for brltty_header in ${brltty_headers}
         do
            BRLTTY_HAVE_HEADER([${brltty_header}], [], [brltty_found=false])
            "${brltty_found}" || break
         done
         "${brltty_found}" || continue
      }

      AC_CHECK_LIB([${brltty_package}], [main], [], [continue])
      brltty_cv_package_$1="${brltty_package}"
      break
   done
])
   $1_package="${brltty_cv_package_$1}"
else
   BRLTTY_HAVE_LIBRARY([${$1_package}], [], [$1_package=""])
fi
AC_SUBST([$1_package])
test -n "${$1_package}" && {
   BRLTTY_UPPERCASE_ASSIGN([brltty_uc], [${$1_package}])
   AC_DEFINE_UNQUOTED([HAVE_PKG_${brltty_uc}])
   BRLTTY_SUMMARY_ITEM([translit([$1], [_], [-])-package], [$1_package])
}])
AC_DEFUN([BRLTTY_PACKAGE_DEFINE], [dnl
ifelse($#, 0, [], [dnl

set -- [$1]
brltty_package="${1}"
shift 1
eval "brltty_headers_${brltty_package}"'="${*}"'
brltty_packages="${brltty_packages} ${brltty_package}"
ifelse($#, 1, [], [BRLTTY_PACKAGE_DEFINE(m4_shift($@))])])])
AC_DEFUN([BRLTTY_PACKAGE_LIST], [dnl
ifelse($#, 0, [], $#, 1, [BRLTTY_PACKAGE_NAME([$1])], [BRLTTY_PACKAGE_NAME([$1]) BRLTTY_PACKAGE_LIST(m4_shift($@))])])
AC_DEFUN([BRLTTY_PACKAGE_NAME], [patsubst([$1], [^ *\(\w+\).*], [\1])])

AC_DEFUN([BRLTTY_OPTIONS_LD2CC], [dnl
`echo "$1" | sed -e '
/^$/d
s/^ */-Wl /
s/ *$//
s/  */,/g
'`])

AC_DEFUN([BRLTTY_HAVE_WINDOWS_LIBRARY], [dnl
AC_CACHE_CHECK(
   [if DLL $1 can be loaded],
   [brltty_cv_dll_$1],
   [
      AC_RUN_IFELSE(
         [
            AC_LANG_SOURCE([[
               #include <windows.h>
               int main () {
                  return !LoadLibrary("$1.DLL");
               }
            ]])
         ],
         [brltty_cv_dll_$1=yes],
         [brltty_cv_dll_$1=no]
      )
   ]
)
if test "${brltty_cv_dll_$1}" = "yes"
then
   BRLTTY_HAVE_LIBRARY([$1])
   $2
else
   :
   $3
fi])

AC_DEFUN([BRLTTY_HAVE_WINDOWS_FUNCTION], [dnl
AC_CACHE_CHECK(
   [if function $1 in DLL $2 exists],
   [brltty_cv_function_$1],
   [
      AC_RUN_IFELSE([
         AC_LANG_SOURCE([[
            #include <windows.h>
            #include <stdio.h>
            #include <errno.h>

            int
            main (void) {
              HMODULE module;
              HINSTANCE instance;
              if (!(instance = LoadLibrary("$2.dll"))) return 1;
              if (!(module = GetModuleHandle("$2.dll"))) return 2;
              if (!(GetProcAddress(module, "$1"))) return 3;
              return 0;
            }
         ]]),
         [brltty_cv_function_$1=yes],
         [brltty_cv_function_$1=no]
      ])
   ]
)
if test "${brltty_cv_function_$1}" = "yes"
then
   AC_DEFINE(BRLTTY_UPPERCASE_TRANSLATE([HAVE_$1]), [1],
             [Define this if the function $1 is available.])
   $3
else
   :
   $4
fi
])

AC_DEFUN([BRLTTY_BINDINGS], [dnl
ifelse($#, 1, [dnl
BRLTTY_BINDINGS([$1], m4_tolower([$1]), m4_toupper([$1]))dnl
], [dnl
BRLTTY_ARG_DISABLE(
   [$2-bindings],
   [$1 bindings for BrlAPI],
   [],
   [
      BRLTTY_$3_BINDINGS
      if "${$3_OK}"
      then
         api_bindings="${api_bindings} $1"
      else
         AC_MSG_WARN([$1 BrlAPI bindings not included])
      fi
   ]
)dnl
])])

AC_DEFUN([BRLTTY_PKGCONFIG_VARIABLE], [dnl
$1=$($PKG_CONFIG --silence-errors --variable="$3" -- "$2")
test -n "${$1}" || $1="$4"
AC_SUBST([$1])
])


