/* A Bison parser, made by GNU Bison 3.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2019 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "matcher_parser_parse.y"

/*
 * Sylpheed -- a GTK+ based, lightweight, and fast e-mail client
 * Copyright (c) 2001-2014 by Hiroyuki Yamamoto & The Claws Mail Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "defs.h"

#include <glib.h>
#include <glib/gi18n.h>

#include "utils.h"
#include "filtering.h"
#include "procheader.h"
#include "matcher.h"
#include "matcher_parser.h"
#include "matcher_parser_lex.h"
#include "colorlabel.h"
#include "folder_item_prefs.h"

static gint error = 0;
static gint bool_op = 0;
static gint match_type = 0;
static gchar *header = NULL;

static MatcherProp *prop;

static GSList *matchers_list = NULL;

static gboolean enabled = TRUE;
static gchar *name = NULL;
static gint account_id = 0;
static MatcherList *cond;
static GSList *action_list = NULL;
static FilteringAction *action = NULL;
static gboolean matcher_is_fast = TRUE;
static gboolean disable_warnings = FALSE;

static FilteringProp *filtering;
static gboolean filtering_ptr_externally_managed = FALSE;

static GSList **prefs_filtering = NULL;
static int enable_compatibility = 0;

enum {
        MATCHER_PARSE_FILE,
        MATCHER_PARSE_NO_EOL,
	MATCHER_PARSE_ENABLED,
	MATCHER_PARSE_NAME,
	MATCHER_PARSE_ACCOUNT,
        MATCHER_PARSE_CONDITION,
        MATCHER_PARSE_FILTERING_ACTION,
};

static int matcher_parse_op = MATCHER_PARSE_FILE;


/* ******************************************************************** */
/* redeclarations to avoid warnings */
void matcher_parserrestart(FILE *input_file);
void matcher_parser_init(void);
void matcher_parser_switch_to_buffer(void * new_buffer);
void matcher_parser_delete_buffer(void * b);
void matcher_parserpop_buffer_state(void);
int matcher_parserlex(void);

void matcher_parser_disable_warnings(const gboolean disable)
{
	disable_warnings = disable;
}

void matcher_parser_start_parsing(FILE *f)
{
	matcher_parserlineno = 1;
	matcher_parserrestart(f);
	account_id = 0;
	matcher_parserparse();
}

 
void * matcher_parser_scan_string(const char * str);
 
FilteringProp *matcher_parser_get_filtering(gchar *str)
{
	void *bufstate;
	void *tmp_str = NULL;
	
	/* little hack to allow passing rules with no names */
	if (!strncmp(str, "rulename ", 9))
		tmp_str = g_strdup(str);
	else 
		tmp_str = g_strconcat("rulename \"\" ", str, NULL);

	/* bad coding to enable the sub-grammar matching
	   in yacc */
	matcher_parserlineno = 1;
	matcher_parse_op = MATCHER_PARSE_NO_EOL;
	matcher_parserrestart(NULL);
	matcher_parserpop_buffer_state();
        matcher_parser_init();
	bufstate = matcher_parser_scan_string((const char *) tmp_str);
        matcher_parser_switch_to_buffer(bufstate);
	/* Indicate that we will be using the global "filtering" pointer,
	 * so that yyparse does not free it in "filtering_action_list"
	 * section. */
	filtering_ptr_externally_managed = TRUE;
	if (matcher_parserparse() != 0)
		filtering = NULL;
	matcher_parse_op = MATCHER_PARSE_FILE;
	matcher_parser_delete_buffer(bufstate);
	g_free(tmp_str);
	filtering_ptr_externally_managed = FALSE; /* Return to normal. */
	return filtering;
}

static gboolean check_quote_symetry(gchar *str)
{
	const gchar *walk;
	int ret = 0;
	
	if (str == NULL)
		return TRUE; /* heh, that's symetric */
	if (*str == '\0')
		return TRUE;
	for (walk = str; *walk; walk++) {
		if (*walk == '\"') {
			if (walk == str 	/* first char */
			|| *(walk - 1) != '\\') /* not escaped */
				ret ++;
		}
	}
	return !(ret % 2);
}

MatcherList *matcher_parser_get_name(gchar *str)
{
	void *bufstate;

	if (!check_quote_symetry(str)) {
		cond = NULL;
		return cond;
	}
	
	/* bad coding to enable the sub-grammar matching
	   in yacc */
	matcher_parserlineno = 1;
	matcher_parse_op = MATCHER_PARSE_NAME;
	matcher_parserrestart(NULL);
	matcher_parserpop_buffer_state();
        matcher_parser_init();
	bufstate = matcher_parser_scan_string(str);
	matcher_parserparse();
	matcher_parse_op = MATCHER_PARSE_FILE;
	matcher_parser_delete_buffer(bufstate);
	return cond;
}

MatcherList *matcher_parser_get_enabled(gchar *str)
{
	void *bufstate;

	if (!check_quote_symetry(str)) {
		cond = NULL;
		return cond;
	}
	
	/* bad coding to enable the sub-grammar matching
	   in yacc */
	matcher_parserlineno = 1;
	matcher_parse_op = MATCHER_PARSE_ENABLED;
	matcher_parserrestart(NULL);
	matcher_parserpop_buffer_state();
	matcher_parser_init();
	bufstate = matcher_parser_scan_string(str);
	matcher_parserparse();
	matcher_parse_op = MATCHER_PARSE_FILE;
	matcher_parser_delete_buffer(bufstate);
	return cond;
}

MatcherList *matcher_parser_get_account(gchar *str)
{
	void *bufstate;

	if (!check_quote_symetry(str)) {
		cond = NULL;
		return cond;
	}
	
	/* bad coding to enable the sub-grammar matching
	   in yacc */
	matcher_parserlineno = 1;
	matcher_parse_op = MATCHER_PARSE_ACCOUNT;
	matcher_parserrestart(NULL);
	matcher_parserpop_buffer_state();
	matcher_parser_init();
	bufstate = matcher_parser_scan_string(str);
	matcher_parserparse();
	matcher_parse_op = MATCHER_PARSE_FILE;
	matcher_parser_delete_buffer(bufstate);
	return cond;
}

MatcherList *matcher_parser_get_cond(gchar *str, gboolean *is_fast)
{
	void *bufstate;

	if (!check_quote_symetry(str)) {
		cond = NULL;
		return cond;
	}
	
	matcher_is_fast = TRUE;
	/* bad coding to enable the sub-grammar matching
	   in yacc */
	matcher_parserlineno = 1;
	matcher_parse_op = MATCHER_PARSE_CONDITION;
	matcher_parserrestart(NULL);
	matcher_parserpop_buffer_state();
        matcher_parser_init();
	bufstate = matcher_parser_scan_string(str);
	matcher_parserparse();
	matcher_parse_op = MATCHER_PARSE_FILE;
	matcher_parser_delete_buffer(bufstate);
	if (is_fast)
		*is_fast = matcher_is_fast;
	return cond;
}

GSList *matcher_parser_get_action_list(gchar *str)
{
	void *bufstate;

	if (!check_quote_symetry(str)) {
		action_list = NULL;
		return action_list;
	}
	
	/* bad coding to enable the sub-grammar matching
	   in yacc */
	matcher_parserlineno = 1;
	matcher_parse_op = MATCHER_PARSE_FILTERING_ACTION;
	matcher_parserrestart(NULL);
	matcher_parserpop_buffer_state();
        matcher_parser_init();
	bufstate = matcher_parser_scan_string(str);
	matcher_parserparse();
	matcher_parse_op = MATCHER_PARSE_FILE;
	matcher_parser_delete_buffer(bufstate);
	return action_list;
}

MatcherProp *matcher_parser_get_prop(gchar *str)
{
	MatcherList *list;
	MatcherProp *prop;

	matcher_parserlineno = 1;
	list = matcher_parser_get_cond(str, NULL);
	if (list == NULL)
		return NULL;

	if (list->matchers == NULL)
		return NULL;

	if (list->matchers->next != NULL)
		return NULL;

	prop = list->matchers->data;

	g_slist_free(list->matchers);
	g_free(list);

	return prop;
}

void matcher_parsererror(char *str)
{
	GSList *l;

	if (matchers_list) {
		for (l = matchers_list; l != NULL; l = g_slist_next(l)) {
			matcherprop_free((MatcherProp *)
					 l->data);
			l->data = NULL;
		}
		g_slist_free(matchers_list);
		matchers_list = NULL;
	}
	cond = NULL;
	if (!disable_warnings)
		g_warning("filtering parsing: %i: %s",
		  	matcher_parserlineno, str);
	error = 1;
}

int matcher_parserwrap(void)
{
	return 1;
}

#line 386 "matcher_parser_parse.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_MATCHER_PARSER_PARSE_H_INCLUDED
# define YY_YY_MATCHER_PARSER_PARSE_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    MATCHER_ALL = 258,
    MATCHER_UNREAD = 259,
    MATCHER_NOT_UNREAD = 260,
    MATCHER_NEW = 261,
    MATCHER_NOT_NEW = 262,
    MATCHER_MARKED = 263,
    MATCHER_NOT_MARKED = 264,
    MATCHER_DELETED = 265,
    MATCHER_NOT_DELETED = 266,
    MATCHER_REPLIED = 267,
    MATCHER_NOT_REPLIED = 268,
    MATCHER_FORWARDED = 269,
    MATCHER_NOT_FORWARDED = 270,
    MATCHER_SUBJECT = 271,
    MATCHER_NOT_SUBJECT = 272,
    MATCHER_FROM = 273,
    MATCHER_NOT_FROM = 274,
    MATCHER_TO = 275,
    MATCHER_NOT_TO = 276,
    MATCHER_CC = 277,
    MATCHER_NOT_CC = 278,
    MATCHER_TO_OR_CC = 279,
    MATCHER_NOT_TO_AND_NOT_CC = 280,
    MATCHER_AGE_GREATER = 281,
    MATCHER_AGE_LOWER = 282,
    MATCHER_NEWSGROUPS = 283,
    MATCHER_AGE_GREATER_HOURS = 284,
    MATCHER_AGE_LOWER_HOURS = 285,
    MATCHER_DATE_AFTER = 286,
    MATCHER_DATE_BEFORE = 287,
    MATCHER_NOT_NEWSGROUPS = 288,
    MATCHER_INREPLYTO = 289,
    MATCHER_NOT_INREPLYTO = 290,
    MATCHER_MESSAGEID = 291,
    MATCHER_NOT_MESSAGEID = 292,
    MATCHER_REFERENCES = 293,
    MATCHER_NOT_REFERENCES = 294,
    MATCHER_SCORE_GREATER = 295,
    MATCHER_SCORE_LOWER = 296,
    MATCHER_HEADER = 297,
    MATCHER_NOT_HEADER = 298,
    MATCHER_HEADERS_PART = 299,
    MATCHER_NOT_HEADERS_PART = 300,
    MATCHER_MESSAGE = 301,
    MATCHER_HEADERS_CONT = 302,
    MATCHER_NOT_HEADERS_CONT = 303,
    MATCHER_NOT_MESSAGE = 304,
    MATCHER_BODY_PART = 305,
    MATCHER_NOT_BODY_PART = 306,
    MATCHER_TEST = 307,
    MATCHER_NOT_TEST = 308,
    MATCHER_MATCHCASE = 309,
    MATCHER_MATCH = 310,
    MATCHER_REGEXPCASE = 311,
    MATCHER_REGEXP = 312,
    MATCHER_SCORE = 313,
    MATCHER_MOVE = 314,
    MATCHER_FOUND_IN_ADDRESSBOOK = 315,
    MATCHER_NOT_FOUND_IN_ADDRESSBOOK = 316,
    MATCHER_IN = 317,
    MATCHER_COPY = 318,
    MATCHER_DELETE = 319,
    MATCHER_MARK = 320,
    MATCHER_UNMARK = 321,
    MATCHER_LOCK = 322,
    MATCHER_UNLOCK = 323,
    MATCHER_EXECUTE = 324,
    MATCHER_MARK_AS_READ = 325,
    MATCHER_MARK_AS_UNREAD = 326,
    MATCHER_FORWARD = 327,
    MATCHER_MARK_AS_SPAM = 328,
    MATCHER_MARK_AS_HAM = 329,
    MATCHER_FORWARD_AS_ATTACHMENT = 330,
    MATCHER_EOL = 331,
    MATCHER_OR = 332,
    MATCHER_AND = 333,
    MATCHER_COLOR = 334,
    MATCHER_SCORE_EQUAL = 335,
    MATCHER_REDIRECT = 336,
    MATCHER_SIZE_GREATER = 337,
    MATCHER_SIZE_SMALLER = 338,
    MATCHER_SIZE_EQUAL = 339,
    MATCHER_LOCKED = 340,
    MATCHER_NOT_LOCKED = 341,
    MATCHER_PARTIAL = 342,
    MATCHER_NOT_PARTIAL = 343,
    MATCHER_COLORLABEL = 344,
    MATCHER_NOT_COLORLABEL = 345,
    MATCHER_IGNORE_THREAD = 346,
    MATCHER_NOT_IGNORE_THREAD = 347,
    MATCHER_WATCH_THREAD = 348,
    MATCHER_NOT_WATCH_THREAD = 349,
    MATCHER_CHANGE_SCORE = 350,
    MATCHER_SET_SCORE = 351,
    MATCHER_ADD_TO_ADDRESSBOOK = 352,
    MATCHER_STOP = 353,
    MATCHER_HIDE = 354,
    MATCHER_IGNORE = 355,
    MATCHER_WATCH = 356,
    MATCHER_SPAM = 357,
    MATCHER_NOT_SPAM = 358,
    MATCHER_HAS_ATTACHMENT = 359,
    MATCHER_HAS_NO_ATTACHMENT = 360,
    MATCHER_SIGNED = 361,
    MATCHER_NOT_SIGNED = 362,
    MATCHER_TAG = 363,
    MATCHER_NOT_TAG = 364,
    MATCHER_SET_TAG = 365,
    MATCHER_UNSET_TAG = 366,
    MATCHER_TAGGED = 367,
    MATCHER_NOT_TAGGED = 368,
    MATCHER_CLEAR_TAGS = 369,
    MATCHER_ENABLED = 370,
    MATCHER_DISABLED = 371,
    MATCHER_RULENAME = 372,
    MATCHER_ACCOUNT = 373,
    MATCHER_STRING = 374,
    MATCHER_SECTION = 375,
    MATCHER_INTEGER = 376
  };
#endif
/* Tokens.  */
#define MATCHER_ALL 258
#define MATCHER_UNREAD 259
#define MATCHER_NOT_UNREAD 260
#define MATCHER_NEW 261
#define MATCHER_NOT_NEW 262
#define MATCHER_MARKED 263
#define MATCHER_NOT_MARKED 264
#define MATCHER_DELETED 265
#define MATCHER_NOT_DELETED 266
#define MATCHER_REPLIED 267
#define MATCHER_NOT_REPLIED 268
#define MATCHER_FORWARDED 269
#define MATCHER_NOT_FORWARDED 270
#define MATCHER_SUBJECT 271
#define MATCHER_NOT_SUBJECT 272
#define MATCHER_FROM 273
#define MATCHER_NOT_FROM 274
#define MATCHER_TO 275
#define MATCHER_NOT_TO 276
#define MATCHER_CC 277
#define MATCHER_NOT_CC 278
#define MATCHER_TO_OR_CC 279
#define MATCHER_NOT_TO_AND_NOT_CC 280
#define MATCHER_AGE_GREATER 281
#define MATCHER_AGE_LOWER 282
#define MATCHER_NEWSGROUPS 283
#define MATCHER_AGE_GREATER_HOURS 284
#define MATCHER_AGE_LOWER_HOURS 285
#define MATCHER_DATE_AFTER 286
#define MATCHER_DATE_BEFORE 287
#define MATCHER_NOT_NEWSGROUPS 288
#define MATCHER_INREPLYTO 289
#define MATCHER_NOT_INREPLYTO 290
#define MATCHER_MESSAGEID 291
#define MATCHER_NOT_MESSAGEID 292
#define MATCHER_REFERENCES 293
#define MATCHER_NOT_REFERENCES 294
#define MATCHER_SCORE_GREATER 295
#define MATCHER_SCORE_LOWER 296
#define MATCHER_HEADER 297
#define MATCHER_NOT_HEADER 298
#define MATCHER_HEADERS_PART 299
#define MATCHER_NOT_HEADERS_PART 300
#define MATCHER_MESSAGE 301
#define MATCHER_HEADERS_CONT 302
#define MATCHER_NOT_HEADERS_CONT 303
#define MATCHER_NOT_MESSAGE 304
#define MATCHER_BODY_PART 305
#define MATCHER_NOT_BODY_PART 306
#define MATCHER_TEST 307
#define MATCHER_NOT_TEST 308
#define MATCHER_MATCHCASE 309
#define MATCHER_MATCH 310
#define MATCHER_REGEXPCASE 311
#define MATCHER_REGEXP 312
#define MATCHER_SCORE 313
#define MATCHER_MOVE 314
#define MATCHER_FOUND_IN_ADDRESSBOOK 315
#define MATCHER_NOT_FOUND_IN_ADDRESSBOOK 316
#define MATCHER_IN 317
#define MATCHER_COPY 318
#define MATCHER_DELETE 319
#define MATCHER_MARK 320
#define MATCHER_UNMARK 321
#define MATCHER_LOCK 322
#define MATCHER_UNLOCK 323
#define MATCHER_EXECUTE 324
#define MATCHER_MARK_AS_READ 325
#define MATCHER_MARK_AS_UNREAD 326
#define MATCHER_FORWARD 327
#define MATCHER_MARK_AS_SPAM 328
#define MATCHER_MARK_AS_HAM 329
#define MATCHER_FORWARD_AS_ATTACHMENT 330
#define MATCHER_EOL 331
#define MATCHER_OR 332
#define MATCHER_AND 333
#define MATCHER_COLOR 334
#define MATCHER_SCORE_EQUAL 335
#define MATCHER_REDIRECT 336
#define MATCHER_SIZE_GREATER 337
#define MATCHER_SIZE_SMALLER 338
#define MATCHER_SIZE_EQUAL 339
#define MATCHER_LOCKED 340
#define MATCHER_NOT_LOCKED 341
#define MATCHER_PARTIAL 342
#define MATCHER_NOT_PARTIAL 343
#define MATCHER_COLORLABEL 344
#define MATCHER_NOT_COLORLABEL 345
#define MATCHER_IGNORE_THREAD 346
#define MATCHER_NOT_IGNORE_THREAD 347
#define MATCHER_WATCH_THREAD 348
#define MATCHER_NOT_WATCH_THREAD 349
#define MATCHER_CHANGE_SCORE 350
#define MATCHER_SET_SCORE 351
#define MATCHER_ADD_TO_ADDRESSBOOK 352
#define MATCHER_STOP 353
#define MATCHER_HIDE 354
#define MATCHER_IGNORE 355
#define MATCHER_WATCH 356
#define MATCHER_SPAM 357
#define MATCHER_NOT_SPAM 358
#define MATCHER_HAS_ATTACHMENT 359
#define MATCHER_HAS_NO_ATTACHMENT 360
#define MATCHER_SIGNED 361
#define MATCHER_NOT_SIGNED 362
#define MATCHER_TAG 363
#define MATCHER_NOT_TAG 364
#define MATCHER_SET_TAG 365
#define MATCHER_UNSET_TAG 366
#define MATCHER_TAGGED 367
#define MATCHER_NOT_TAGGED 368
#define MATCHER_CLEAR_TAGS 369
#define MATCHER_ENABLED 370
#define MATCHER_DISABLED 371
#define MATCHER_RULENAME 372
#define MATCHER_ACCOUNT 373
#define MATCHER_STRING 374
#define MATCHER_SECTION 375
#define MATCHER_INTEGER 376

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 317 "matcher_parser_parse.y"

	char *str;
	int value;

#line 685 "matcher_parser_parse.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_MATCHER_PARSER_PARSE_H_INCLUDED  */



#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))

/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   751

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  122
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  25
/* YYNRULES -- Number of rules.  */
#define YYNRULES  148
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  261

#define YYUNDEFTOK  2
#define YYMAXUTOK   376


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   376,   376,   376,   384,   386,   390,   392,   392,   394,
     400,   433,   434,   435,   436,   437,   438,   447,   456,   465,
     474,   483,   492,   496,   500,   507,   514,   521,   562,   563,
     567,   575,   579,   583,   587,   594,   602,   606,   614,   618,
     625,   632,   639,   646,   653,   660,   667,   674,   681,   688,
     695,   702,   709,   716,   723,   730,   737,   744,   751,   758,
     765,   772,   779,   786,   797,   808,   815,   822,   829,   836,
     845,   854,   863,   872,   881,   890,   899,   908,   917,   926,
     935,   944,   951,   958,   967,   976,   985,   994,  1005,  1016,
    1025,  1034,  1043,  1052,  1061,  1070,  1079,  1088,  1097,  1106,
    1115,  1123,  1131,  1140,  1139,  1153,  1152,  1165,  1174,  1183,
    1192,  1202,  1201,  1215,  1214,  1227,  1236,  1245,  1254,  1263,
    1272,  1284,  1293,  1302,  1311,  1320,  1327,  1336,  1343,  1350,
    1357,  1364,  1371,  1378,  1385,  1392,  1399,  1411,  1423,  1435,
    1444,  1453,  1461,  1469,  1473,  1477,  1482,  1481,  1494
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "MATCHER_ALL", "MATCHER_UNREAD",
  "MATCHER_NOT_UNREAD", "MATCHER_NEW", "MATCHER_NOT_NEW", "MATCHER_MARKED",
  "MATCHER_NOT_MARKED", "MATCHER_DELETED", "MATCHER_NOT_DELETED",
  "MATCHER_REPLIED", "MATCHER_NOT_REPLIED", "MATCHER_FORWARDED",
  "MATCHER_NOT_FORWARDED", "MATCHER_SUBJECT", "MATCHER_NOT_SUBJECT",
  "MATCHER_FROM", "MATCHER_NOT_FROM", "MATCHER_TO", "MATCHER_NOT_TO",
  "MATCHER_CC", "MATCHER_NOT_CC", "MATCHER_TO_OR_CC",
  "MATCHER_NOT_TO_AND_NOT_CC", "MATCHER_AGE_GREATER", "MATCHER_AGE_LOWER",
  "MATCHER_NEWSGROUPS", "MATCHER_AGE_GREATER_HOURS",
  "MATCHER_AGE_LOWER_HOURS", "MATCHER_DATE_AFTER", "MATCHER_DATE_BEFORE",
  "MATCHER_NOT_NEWSGROUPS", "MATCHER_INREPLYTO", "MATCHER_NOT_INREPLYTO",
  "MATCHER_MESSAGEID", "MATCHER_NOT_MESSAGEID", "MATCHER_REFERENCES",
  "MATCHER_NOT_REFERENCES", "MATCHER_SCORE_GREATER", "MATCHER_SCORE_LOWER",
  "MATCHER_HEADER", "MATCHER_NOT_HEADER", "MATCHER_HEADERS_PART",
  "MATCHER_NOT_HEADERS_PART", "MATCHER_MESSAGE", "MATCHER_HEADERS_CONT",
  "MATCHER_NOT_HEADERS_CONT", "MATCHER_NOT_MESSAGE", "MATCHER_BODY_PART",
  "MATCHER_NOT_BODY_PART", "MATCHER_TEST", "MATCHER_NOT_TEST",
  "MATCHER_MATCHCASE", "MATCHER_MATCH", "MATCHER_REGEXPCASE",
  "MATCHER_REGEXP", "MATCHER_SCORE", "MATCHER_MOVE",
  "MATCHER_FOUND_IN_ADDRESSBOOK", "MATCHER_NOT_FOUND_IN_ADDRESSBOOK",
  "MATCHER_IN", "MATCHER_COPY", "MATCHER_DELETE", "MATCHER_MARK",
  "MATCHER_UNMARK", "MATCHER_LOCK", "MATCHER_UNLOCK", "MATCHER_EXECUTE",
  "MATCHER_MARK_AS_READ", "MATCHER_MARK_AS_UNREAD", "MATCHER_FORWARD",
  "MATCHER_MARK_AS_SPAM", "MATCHER_MARK_AS_HAM",
  "MATCHER_FORWARD_AS_ATTACHMENT", "MATCHER_EOL", "MATCHER_OR",
  "MATCHER_AND", "MATCHER_COLOR", "MATCHER_SCORE_EQUAL",
  "MATCHER_REDIRECT", "MATCHER_SIZE_GREATER", "MATCHER_SIZE_SMALLER",
  "MATCHER_SIZE_EQUAL", "MATCHER_LOCKED", "MATCHER_NOT_LOCKED",
  "MATCHER_PARTIAL", "MATCHER_NOT_PARTIAL", "MATCHER_COLORLABEL",
  "MATCHER_NOT_COLORLABEL", "MATCHER_IGNORE_THREAD",
  "MATCHER_NOT_IGNORE_THREAD", "MATCHER_WATCH_THREAD",
  "MATCHER_NOT_WATCH_THREAD", "MATCHER_CHANGE_SCORE", "MATCHER_SET_SCORE",
  "MATCHER_ADD_TO_ADDRESSBOOK", "MATCHER_STOP", "MATCHER_HIDE",
  "MATCHER_IGNORE", "MATCHER_WATCH", "MATCHER_SPAM", "MATCHER_NOT_SPAM",
  "MATCHER_HAS_ATTACHMENT", "MATCHER_HAS_NO_ATTACHMENT", "MATCHER_SIGNED",
  "MATCHER_NOT_SIGNED", "MATCHER_TAG", "MATCHER_NOT_TAG",
  "MATCHER_SET_TAG", "MATCHER_UNSET_TAG", "MATCHER_TAGGED",
  "MATCHER_NOT_TAGGED", "MATCHER_CLEAR_TAGS", "MATCHER_ENABLED",
  "MATCHER_DISABLED", "MATCHER_RULENAME", "MATCHER_ACCOUNT",
  "MATCHER_STRING", "MATCHER_SECTION", "MATCHER_INTEGER", "$accept",
  "file", "$@1", "file_line_list", "file_line", "$@2",
  "section_notification", "instruction", "enabled", "name", "account",
  "filtering", "filtering_action_list", "filtering_action_b", "match_type",
  "condition", "condition_list", "bool_op", "one_condition", "$@3", "$@4",
  "$@5", "$@6", "filtering_action", "$@7", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376
};
# endif

#define YYPACT_NINF (-229)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-8)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -229,    12,   237,  -229,   -63,   -61,  -229,   119,   406,  -229,
    -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,
    -229,  -229,  -229,  -229,  -229,  -229,     5,     5,     5,     5,
       5,     5,     5,     5,     5,     5,   -97,   -96,     5,   -95,
     -84,   -81,   -80,     5,     5,     5,     5,     5,     5,     5,
     -66,   -64,   -56,   -55,     5,     5,     5,     5,     5,     5,
       5,     5,   -54,   -53,   -52,   -51,   -49,   -48,   -40,  -229,
    -229,  -229,  -229,  -229,   -39,  -229,  -229,   -38,  -229,  -229,
     -35,  -229,   -32,   -31,   -29,   -28,   -26,   -25,  -229,  -229,
    -229,  -229,   -24,   -22,  -229,  -229,  -229,  -229,   -21,   -20,
     -37,  -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,
    -229,     5,     5,   -17,   -16,  -229,  -229,  -229,  -229,  -229,
     -15,   -14,  -229,   -50,   638,  -229,  -229,   -23,  -229,   -68,
    -229,  -229,  -229,  -229,  -229,  -229,   -13,   -11,   -10,    -9,
      -8,    -7,    -6,    -5,    -4,    -3,  -229,  -229,    -2,  -229,
    -229,  -229,  -229,    -1,     2,    55,    56,    57,    62,   173,
    -229,  -229,  -229,  -229,   174,   175,   180,   195,   196,   239,
     240,   241,  -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,
     242,   243,  -229,  -229,   244,  -229,  -229,  -229,  -229,  -229,
    -229,  -229,  -229,   245,   246,  -229,  -229,  -229,  -229,   522,
     -23,  -229,  -229,  -229,   638,  -229,  -229,  -229,  -229,  -229,
    -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,  -229,
    -229,  -229,  -229,     5,     5,  -229,  -229,  -229,  -229,  -229,
    -229,  -229,  -229,    19,    32,  -229,  -229,  -229,   248,  -229,
    -229,   638,   -23,    22,  -229,  -229,   249,   250,   251,   252,
    -229,   -23,    29,  -229,  -229,  -229,  -229,  -229,   280,  -229,
    -229
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       2,     0,     0,     1,     0,     0,     3,     0,     0,     6,
       9,    10,     4,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   127,
     128,   129,   130,   131,     0,   132,   133,     0,   134,   135,
       0,    22,     0,     0,     0,     0,     0,     0,    53,    54,
      61,    62,     0,     0,    65,    66,    67,    68,     0,     0,
       0,   148,   143,   144,   145,    55,    56,    57,    58,    59,
      60,     0,     0,     0,     0,    81,    82,   125,    23,    24,
       0,     0,     8,    17,    19,    18,    21,    29,    20,    35,
      37,    30,    31,    32,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    83,    84,     0,    85,
      86,    87,    88,     0,     0,     0,     0,     0,     0,     0,
      97,    98,   103,   105,     0,     0,     0,     0,     0,     0,
       0,     0,   119,   120,   141,   122,   111,   113,   126,   121,
       0,     0,   139,    99,     0,   100,   101,   102,    63,    64,
     140,   142,   146,     0,     0,   123,   124,    25,    26,     0,
       0,    28,    39,    38,     0,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    89,    90,    93,    94,    91,
      92,    95,    96,     0,     0,   107,   108,   115,   109,   110,
     116,   117,   118,     0,     0,   136,   137,   138,     0,    79,
      80,     0,     0,    16,    27,    36,     0,     0,     0,     0,
     147,     0,    14,    15,   104,   106,   112,   114,    12,    13,
      11
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -229,  -229,  -229,   365,  -229,  -229,  -229,  -229,  -229,   -70,
     176,  -228,    46,  -229,   -27,   167,  -229,  -229,   169,  -229,
    -229,  -229,  -229,  -229,  -229
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,     6,     7,     8,     9,   122,   123,   124,
     125,   243,   244,   127,   136,   128,   129,   204,   130,   223,
     224,   233,   234,   131,   238
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     137,   138,   139,   140,   141,   142,   143,   144,   145,   202,
     203,   148,     3,    10,   252,    11,   153,   154,   155,   156,
     157,   158,   159,   258,   146,   147,   149,   164,   165,   166,
     167,   168,   169,   170,   171,    64,    65,   150,   151,   152,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,   199,   126,   160,    82,   161,    84,   132,
     133,   134,   135,   162,   163,   172,   173,   120,   175,   174,
     176,   177,    98,    99,   100,   101,   102,   103,   104,   178,
     179,   248,   192,   180,   193,   194,   181,   113,   114,   182,
     183,   117,   184,   185,   249,   186,   187,   188,   253,   189,
     190,   191,   195,   196,   197,   259,   205,   198,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,    -5,
       4,   217,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,   201,   218,   219,   220,    -7,    -7,    -7,
      -7,   221,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,   246,   247,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,     4,     5,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,   200,   222,   225,   226,    -7,    -7,    -7,    -7,   227,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,   228,   229,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,   260,     5,   230,   231,
     232,   235,   236,   237,   239,   240,   242,   250,   254,   255,
     256,   257,    12,   245,     0,   241,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   251,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
       0,     0,     0,     0,    64,    65,    66,    67,     0,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,     0,     0,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,     0,     0,     0,     0,
       0,     0,    66,    67,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    83,     0,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,     0,     0,     0,
       0,     0,     0,     0,   105,   106,   107,   108,   109,   110,
     111,   112,     0,     0,   115,   116,     0,     0,     0,     0,
     121,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,     0,     0,     0,     0,     0,     0,    66,    67,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    83,     0,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,     0,     0,     0,     0,     0,     0,     0,
     105,   106,   107,   108,   109,   110,   111,   112,     0,     0,
     115,   116
};

static const yytype_int16 yycheck[] =
{
      27,    28,    29,    30,    31,    32,    33,    34,    35,    77,
      78,    38,     0,    76,   242,    76,    43,    44,    45,    46,
      47,    48,    49,   251,   121,   121,   121,    54,    55,    56,
      57,    58,    59,    60,    61,    58,    59,   121,   119,   119,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,   123,     8,   121,    79,   121,    81,    54,
      55,    56,    57,   119,   119,   119,   119,   117,   119,   121,
     119,   119,    95,    96,    97,    98,    99,   100,   101,   119,
     119,    62,   119,   121,   111,   112,   121,   110,   111,   121,
     121,   114,   121,   121,    62,   121,   121,   121,    76,   121,
     121,   121,   119,   119,   119,    76,   119,   121,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,     0,
       1,   119,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,   127,   119,   119,   119,    58,    59,    60,
      61,   119,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,   223,   224,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,     1,   120,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,   124,   119,   119,   119,    58,    59,    60,    61,   119,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,   119,   119,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    76,   120,   119,   119,
     119,   119,   119,   119,   119,   119,   199,   119,   119,   119,
     119,   119,     7,   204,    -1,   199,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    61,    -1,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    60,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   102,   103,   104,   105,   106,   107,
     108,   109,    -1,    -1,   112,   113,    -1,    -1,    -1,    -1,
     118,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     102,   103,   104,   105,   106,   107,   108,   109,    -1,    -1,
     112,   113
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,   123,   124,     0,     1,   120,   125,   126,   127,   128,
      76,    76,   125,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    58,    59,    60,    61,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   129,   130,   131,   132,   134,   135,   137,   138,
     140,   145,    54,    55,    56,    57,   136,   136,   136,   136,
     136,   136,   136,   136,   136,   136,   121,   121,   136,   121,
     121,   119,   119,   136,   136,   136,   136,   136,   136,   136,
     121,   121,   119,   119,   136,   136,   136,   136,   136,   136,
     136,   136,   119,   119,   121,   119,   119,   119,   119,   119,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     121,   121,   119,   136,   136,   119,   119,   119,   121,   131,
     137,   134,    77,    78,   139,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   141,   142,   119,   119,   119,   119,   119,
     119,   119,   119,   143,   144,   119,   119,   119,   146,   119,
     119,   132,   137,   133,   134,   140,   136,   136,    62,    62,
     119,   137,   133,    76,   119,   119,   119,   119,   133,    76,
      76
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   122,   124,   123,   125,   125,   126,   127,   126,   126,
     128,   129,   129,   129,   129,   129,   129,   129,   129,   129,
     129,   129,   129,   130,   130,   131,   132,   133,   134,   134,
     135,   136,   136,   136,   136,   137,   138,   138,   139,   139,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   141,   140,   142,   140,   140,   140,   140,
     140,   143,   140,   144,   140,   140,   140,   140,   140,   140,
     140,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   146,   145,   145
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     2,     1,     1,     0,     2,     2,
       2,     6,     5,     5,     4,     4,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     1,     1,     2,     2,     2,     2,     2,     2,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     2,
       2,     2,     2,     0,     5,     0,     5,     3,     3,     3,
       3,     0,     5,     0,     5,     3,     3,     3,     3,     2,
       2,     2,     2,     2,     2,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     2,
       2,     2,     2,     1,     1,     1,     0,     4,     1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyo, yytype, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#  else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                yy_state_t *yyssp, int yytoken)
{
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Actual size of YYARG. */
  int yycount = 0;
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      YYPTRDIFF_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
      yysize = yysize0;
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYPTRDIFF_T yysize1
                    = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    /* Don't count the "%s"s in the final size, but reserve room for
       the terminator.  */
    YYPTRDIFF_T yysize1 = yysize + (yystrlen (yyformat) - 2 * yycount) + 1;
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYPTRDIFF_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2:
#line 376 "matcher_parser_parse.y"
{
	if (matcher_parse_op == MATCHER_PARSE_FILE) {
		prefs_filtering = &pre_global_processing;
	}
}
#line 2192 "matcher_parser_parse.c"
    break;

  case 7:
#line 392 "matcher_parser_parse.y"
{ action_list = NULL; }
#line 2198 "matcher_parser_parse.c"
    break;

  case 9:
#line 395 "matcher_parser_parse.y"
{
	yyerrok;
}
#line 2206 "matcher_parser_parse.c"
    break;

  case 10:
#line 401 "matcher_parser_parse.y"
{
	gchar *folder = (yyvsp[-1].str);
	FolderItem *item = NULL;

	if (matcher_parse_op == MATCHER_PARSE_FILE) {
                enable_compatibility = 0;
		if (!strcmp(folder, "global")) {
                        /* backward compatibility */
                        enable_compatibility = 1;
                }
		else if (!strcmp(folder, "preglobal")) {
			prefs_filtering = &pre_global_processing;
                }
		else if (!strcmp(folder, "postglobal")) {
			prefs_filtering = &post_global_processing;
                }
		else if (!strcmp(folder, "filtering")) {
                        prefs_filtering = &filtering_rules;
		}
                else {
			item = folder_find_item_from_identifier(folder);
			if (item != NULL) {
				prefs_filtering = &item->prefs->processing;
			} else {
				prefs_filtering = NULL;
			}
		}
	}
}
#line 2240 "matcher_parser_parse.c"
    break;

  case 16:
#line 439 "matcher_parser_parse.y"
{
	if (matcher_parse_op == MATCHER_PARSE_NO_EOL)
		YYACCEPT;
	else {
		matcher_parsererror("parse error [no eol]");
		YYERROR;
	}
}
#line 2253 "matcher_parser_parse.c"
    break;

  case 17:
#line 448 "matcher_parser_parse.y"
{
	if (matcher_parse_op == MATCHER_PARSE_ENABLED)
		YYACCEPT;
	else {
		matcher_parsererror("parse error [enabled]");
		YYERROR;
	}
}
#line 2266 "matcher_parser_parse.c"
    break;

  case 18:
#line 457 "matcher_parser_parse.y"
{
	if (matcher_parse_op == MATCHER_PARSE_ACCOUNT)
		YYACCEPT;
	else {
		matcher_parsererror("parse error [account]");
		YYERROR;
	}
}
#line 2279 "matcher_parser_parse.c"
    break;

  case 19:
#line 466 "matcher_parser_parse.y"
{
	if (matcher_parse_op == MATCHER_PARSE_NAME)
		YYACCEPT;
	else {
		matcher_parsererror("parse error [name]");
		YYERROR;
	}
}
#line 2292 "matcher_parser_parse.c"
    break;

  case 20:
#line 475 "matcher_parser_parse.y"
{
	if (matcher_parse_op == MATCHER_PARSE_CONDITION)
		YYACCEPT;
	else {
		matcher_parsererror("parse error [condition]");
		YYERROR;
	}
}
#line 2305 "matcher_parser_parse.c"
    break;

  case 21:
#line 484 "matcher_parser_parse.y"
{
	if (matcher_parse_op == MATCHER_PARSE_FILTERING_ACTION)
		YYACCEPT;
	else {
		matcher_parsererror("parse error [filtering action]");
		YYERROR;
	}
}
#line 2318 "matcher_parser_parse.c"
    break;

  case 23:
#line 497 "matcher_parser_parse.y"
{
	enabled = TRUE;
}
#line 2326 "matcher_parser_parse.c"
    break;

  case 24:
#line 501 "matcher_parser_parse.y"
{
	enabled = FALSE;
}
#line 2334 "matcher_parser_parse.c"
    break;

  case 25:
#line 508 "matcher_parser_parse.y"
{
	name = g_strdup((yyvsp[0].str));
}
#line 2342 "matcher_parser_parse.c"
    break;

  case 26:
#line 515 "matcher_parser_parse.y"
{
	account_id = strtol((yyvsp[0].str), NULL, 10);
}
#line 2350 "matcher_parser_parse.c"
    break;

  case 27:
#line 522 "matcher_parser_parse.y"
{
	filtering = filteringprop_new(enabled, name, account_id, cond, action_list);
	enabled = TRUE;
	account_id = 0;
	g_free(name);
	name = NULL;
        if (enable_compatibility) {
                prefs_filtering = &filtering_rules;
                if (action_list != NULL) {
                        FilteringAction * first_action;
                        
                        first_action = action_list->data;
                        
                        if (first_action->type == MATCHACTION_CHANGE_SCORE)
                                prefs_filtering = &pre_global_processing;
                }
        }
        
	cond = NULL;
	action_list = NULL;
        
	if ((matcher_parse_op == MATCHER_PARSE_FILE) &&
            (prefs_filtering != NULL)) {
		*prefs_filtering = g_slist_append(*prefs_filtering,
						  filtering);
		filtering = NULL;
	} else if (!filtering_ptr_externally_managed) {
		/* If filtering_ptr_externally_managed was TRUE, it
		 * would mean that some function higher in the stack is
		 * interested in the data "filtering" is pointing at, so
		 * we would not free it. That function has to free it itself.
		 * At the time of writing this, the only function that
		 * does this is matcher_parser_get_filtering(). */
		filteringprop_free(filtering);
		filtering = NULL;
	}
}
#line 2392 "matcher_parser_parse.c"
    break;

  case 30:
#line 568 "matcher_parser_parse.y"
{
        action_list = g_slist_append(action_list, action);
        action = NULL;
}
#line 2401 "matcher_parser_parse.c"
    break;

  case 31:
#line 576 "matcher_parser_parse.y"
{
	match_type = MATCHTYPE_MATCHCASE;
}
#line 2409 "matcher_parser_parse.c"
    break;

  case 32:
#line 580 "matcher_parser_parse.y"
{
	match_type = MATCHTYPE_MATCH;
}
#line 2417 "matcher_parser_parse.c"
    break;

  case 33:
#line 584 "matcher_parser_parse.y"
{
	match_type = MATCHTYPE_REGEXPCASE;
}
#line 2425 "matcher_parser_parse.c"
    break;

  case 34:
#line 588 "matcher_parser_parse.y"
{
	match_type = MATCHTYPE_REGEXP;
}
#line 2433 "matcher_parser_parse.c"
    break;

  case 35:
#line 595 "matcher_parser_parse.y"
{
	cond = matcherlist_new(matchers_list, (bool_op == MATCHERBOOL_AND));
	matchers_list = NULL;
}
#line 2442 "matcher_parser_parse.c"
    break;

  case 36:
#line 603 "matcher_parser_parse.y"
{
	matchers_list = g_slist_append(matchers_list, prop);
}
#line 2450 "matcher_parser_parse.c"
    break;

  case 37:
#line 607 "matcher_parser_parse.y"
{
	matchers_list = NULL;
	matchers_list = g_slist_append(matchers_list, prop);
}
#line 2459 "matcher_parser_parse.c"
    break;

  case 38:
#line 615 "matcher_parser_parse.y"
{
	bool_op = MATCHERBOOL_AND;
}
#line 2467 "matcher_parser_parse.c"
    break;

  case 39:
#line 619 "matcher_parser_parse.y"
{
	bool_op = MATCHERBOOL_OR;
}
#line 2475 "matcher_parser_parse.c"
    break;

  case 40:
#line 626 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_ALL;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2486 "matcher_parser_parse.c"
    break;

  case 41:
#line 633 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_UNREAD;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2497 "matcher_parser_parse.c"
    break;

  case 42:
#line 640 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_UNREAD;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2508 "matcher_parser_parse.c"
    break;

  case 43:
#line 647 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NEW;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2519 "matcher_parser_parse.c"
    break;

  case 44:
#line 654 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_NEW;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2530 "matcher_parser_parse.c"
    break;

  case 45:
#line 661 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_MARKED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2541 "matcher_parser_parse.c"
    break;

  case 46:
#line 668 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_MARKED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2552 "matcher_parser_parse.c"
    break;

  case 47:
#line 675 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_DELETED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2563 "matcher_parser_parse.c"
    break;

  case 48:
#line 682 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_DELETED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2574 "matcher_parser_parse.c"
    break;

  case 49:
#line 689 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_REPLIED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2585 "matcher_parser_parse.c"
    break;

  case 50:
#line 696 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_REPLIED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2596 "matcher_parser_parse.c"
    break;

  case 51:
#line 703 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_FORWARDED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2607 "matcher_parser_parse.c"
    break;

  case 52:
#line 710 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_FORWARDED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2618 "matcher_parser_parse.c"
    break;

  case 53:
#line 717 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_LOCKED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2629 "matcher_parser_parse.c"
    break;

  case 54:
#line 724 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_LOCKED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2640 "matcher_parser_parse.c"
    break;

  case 55:
#line 731 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_SPAM;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2651 "matcher_parser_parse.c"
    break;

  case 56:
#line 738 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_SPAM;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2662 "matcher_parser_parse.c"
    break;

  case 57:
#line 745 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_HAS_ATTACHMENT;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2673 "matcher_parser_parse.c"
    break;

  case 58:
#line 752 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_HAS_NO_ATTACHMENT;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2684 "matcher_parser_parse.c"
    break;

  case 59:
#line 759 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_SIGNED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2695 "matcher_parser_parse.c"
    break;

  case 60:
#line 766 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_SIGNED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2706 "matcher_parser_parse.c"
    break;

  case 61:
#line 773 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_PARTIAL;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2717 "matcher_parser_parse.c"
    break;

  case 62:
#line 780 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_PARTIAL;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2728 "matcher_parser_parse.c"
    break;

  case 63:
#line 787 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_COLORLABEL;
	value = strtol((yyvsp[0].str), NULL, 10);
	if (value < 0) value = 0;
	else if (value > COLORLABELS) value = COLORLABELS;
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 2743 "matcher_parser_parse.c"
    break;

  case 64:
#line 798 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_NOT_COLORLABEL;
	value = strtol((yyvsp[0].str), NULL, 0);
	if (value < 0) value = 0;
	else if (value > COLORLABELS) value = COLORLABELS;
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 2758 "matcher_parser_parse.c"
    break;

  case 65:
#line 809 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_IGNORE_THREAD;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2769 "matcher_parser_parse.c"
    break;

  case 66:
#line 816 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_IGNORE_THREAD;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2780 "matcher_parser_parse.c"
    break;

  case 67:
#line 823 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_WATCH_THREAD;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2791 "matcher_parser_parse.c"
    break;

  case 68:
#line 830 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_WATCH_THREAD;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2802 "matcher_parser_parse.c"
    break;

  case 69:
#line 837 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_SUBJECT;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2815 "matcher_parser_parse.c"
    break;

  case 70:
#line 846 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_SUBJECT;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2828 "matcher_parser_parse.c"
    break;

  case 71:
#line 855 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_FROM;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2841 "matcher_parser_parse.c"
    break;

  case 72:
#line 864 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_FROM;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2854 "matcher_parser_parse.c"
    break;

  case 73:
#line 873 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_TO;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2867 "matcher_parser_parse.c"
    break;

  case 74:
#line 882 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_TO;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2880 "matcher_parser_parse.c"
    break;

  case 75:
#line 891 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_CC;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2893 "matcher_parser_parse.c"
    break;

  case 76:
#line 900 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_CC;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2906 "matcher_parser_parse.c"
    break;

  case 77:
#line 909 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_TO_OR_CC;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2919 "matcher_parser_parse.c"
    break;

  case 78:
#line 918 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_TO_AND_NOT_CC;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2932 "matcher_parser_parse.c"
    break;

  case 79:
#line 927 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_TAG;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2945 "matcher_parser_parse.c"
    break;

  case 80:
#line 936 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_TAG;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 2958 "matcher_parser_parse.c"
    break;

  case 81:
#line 945 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_TAGGED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2969 "matcher_parser_parse.c"
    break;

  case 82:
#line 952 "matcher_parser_parse.y"
{
	gint criteria = 0;

	criteria = MATCHCRITERIA_NOT_TAGGED;
	prop = matcherprop_new(criteria, NULL, 0, NULL, 0);
}
#line 2980 "matcher_parser_parse.c"
    break;

  case 83:
#line 959 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_AGE_GREATER;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 2993 "matcher_parser_parse.c"
    break;

  case 84:
#line 968 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_AGE_LOWER;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3006 "matcher_parser_parse.c"
    break;

  case 85:
#line 977 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_AGE_GREATER_HOURS;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3019 "matcher_parser_parse.c"
    break;

  case 86:
#line 986 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_AGE_LOWER_HOURS;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3032 "matcher_parser_parse.c"
    break;

  case 87:
#line 995 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	time_t value;

	criteria = MATCHCRITERIA_DATE_AFTER;
	expr = (yyvsp[0].str);
	value = procheader_date_parse(NULL, expr, 0);
	prop = matcherprop_new(criteria, NULL, 0, expr, value);
}
#line 3047 "matcher_parser_parse.c"
    break;

  case 88:
#line 1006 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	time_t value;

	criteria = MATCHCRITERIA_DATE_BEFORE;
	expr = (yyvsp[0].str);
	value = procheader_date_parse(NULL, expr, 0);
	prop = matcherprop_new(criteria, NULL, 0, expr, value);
}
#line 3062 "matcher_parser_parse.c"
    break;

  case 89:
#line 1017 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NEWSGROUPS;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3075 "matcher_parser_parse.c"
    break;

  case 90:
#line 1026 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_NEWSGROUPS;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3088 "matcher_parser_parse.c"
    break;

  case 91:
#line 1035 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_MESSAGEID;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3101 "matcher_parser_parse.c"
    break;

  case 92:
#line 1044 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_MESSAGEID;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3114 "matcher_parser_parse.c"
    break;

  case 93:
#line 1053 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_INREPLYTO;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3127 "matcher_parser_parse.c"
    break;

  case 94:
#line 1062 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_INREPLYTO;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3140 "matcher_parser_parse.c"
    break;

  case 95:
#line 1071 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_REFERENCES;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3153 "matcher_parser_parse.c"
    break;

  case 96:
#line 1080 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_REFERENCES;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3166 "matcher_parser_parse.c"
    break;

  case 97:
#line 1089 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_SCORE_GREATER;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3179 "matcher_parser_parse.c"
    break;

  case 98:
#line 1098 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_SCORE_LOWER;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3192 "matcher_parser_parse.c"
    break;

  case 99:
#line 1107 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value = 0;

	criteria = MATCHCRITERIA_SCORE_EQUAL;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3205 "matcher_parser_parse.c"
    break;

  case 100:
#line 1116 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value    = 0;
	criteria = MATCHCRITERIA_SIZE_GREATER;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3217 "matcher_parser_parse.c"
    break;

  case 101:
#line 1124 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value    = 0;
	criteria = MATCHCRITERIA_SIZE_SMALLER;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3229 "matcher_parser_parse.c"
    break;

  case 102:
#line 1132 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gint value    = 0;
	criteria = MATCHCRITERIA_SIZE_EQUAL;
	value = strtol((yyvsp[0].str), NULL, 0);
	prop = matcherprop_new(criteria, NULL, 0, NULL, value);
}
#line 3241 "matcher_parser_parse.c"
    break;

  case 103:
#line 1140 "matcher_parser_parse.y"
{
	header = g_strdup((yyvsp[0].str));
}
#line 3249 "matcher_parser_parse.c"
    break;

  case 104:
#line 1143 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_HEADER;
	expr = (yyvsp[-3].str);
	prop = matcherprop_new(criteria, header, match_type, expr, 0);
	g_free(header);
}
#line 3263 "matcher_parser_parse.c"
    break;

  case 105:
#line 1153 "matcher_parser_parse.y"
{
	header = g_strdup((yyvsp[0].str));
}
#line 3271 "matcher_parser_parse.c"
    break;

  case 106:
#line 1156 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_NOT_HEADER;
	expr = (yyvsp[-3].str);
	prop = matcherprop_new(criteria, header, match_type, expr, 0);
	g_free(header);
}
#line 3285 "matcher_parser_parse.c"
    break;

  case 107:
#line 1166 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_HEADERS_PART;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3298 "matcher_parser_parse.c"
    break;

  case 108:
#line 1175 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_NOT_HEADERS_PART;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3311 "matcher_parser_parse.c"
    break;

  case 109:
#line 1184 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_HEADERS_CONT;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3324 "matcher_parser_parse.c"
    break;

  case 110:
#line 1193 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_NOT_HEADERS_CONT;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3337 "matcher_parser_parse.c"
    break;

  case 111:
#line 1202 "matcher_parser_parse.y"
{
	header = g_strdup((yyvsp[0].str));
}
#line 3345 "matcher_parser_parse.c"
    break;

  case 112:
#line 1205 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_FOUND_IN_ADDRESSBOOK;
	expr = (yyvsp[-3].str);
	prop = matcherprop_new(criteria, header, match_type, expr, 0);
	g_free(header);
}
#line 3359 "matcher_parser_parse.c"
    break;

  case 113:
#line 1215 "matcher_parser_parse.y"
{
	header = g_strdup((yyvsp[0].str));
}
#line 3367 "matcher_parser_parse.c"
    break;

  case 114:
#line 1218 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;

	criteria = MATCHCRITERIA_NOT_FOUND_IN_ADDRESSBOOK;
	expr = (yyvsp[-3].str);
	prop = matcherprop_new(criteria, header, match_type, expr, 0);
	g_free(header);
}
#line 3381 "matcher_parser_parse.c"
    break;

  case 115:
#line 1228 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_MESSAGE;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3394 "matcher_parser_parse.c"
    break;

  case 116:
#line 1237 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_NOT_MESSAGE;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3407 "matcher_parser_parse.c"
    break;

  case 117:
#line 1246 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_BODY_PART;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3420 "matcher_parser_parse.c"
    break;

  case 118:
#line 1255 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_NOT_BODY_PART;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, match_type, expr, 0);
}
#line 3433 "matcher_parser_parse.c"
    break;

  case 119:
#line 1264 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_TEST;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, MATCHTYPE_MATCH, expr, 0);
}
#line 3446 "matcher_parser_parse.c"
    break;

  case 120:
#line 1273 "matcher_parser_parse.y"
{
	gint criteria = 0;
	gchar *expr = NULL;
	matcher_is_fast = FALSE;
	criteria = MATCHCRITERIA_NOT_TEST;
	expr = (yyvsp[0].str);
	prop = matcherprop_new(criteria, NULL, MATCHTYPE_MATCH, expr, 0);
}
#line 3459 "matcher_parser_parse.c"
    break;

  case 121:
#line 1285 "matcher_parser_parse.y"
{
	gchar *cmd = NULL;
	gint action_type = 0;

	action_type = MATCHACTION_EXECUTE;
	cmd = (yyvsp[0].str);
	action = filteringaction_new(action_type, 0, cmd, 0, 0, NULL);
}
#line 3472 "matcher_parser_parse.c"
    break;

  case 122:
#line 1294 "matcher_parser_parse.y"
{
	gchar *destination = NULL;
	gint action_type = 0;

	action_type = MATCHACTION_MOVE;
	destination = (yyvsp[0].str);
	action = filteringaction_new(action_type, 0, destination, 0, 0, NULL);
}
#line 3485 "matcher_parser_parse.c"
    break;

  case 123:
#line 1303 "matcher_parser_parse.y"
{
	gchar *destination = NULL;
	gint action_type = 0;

	action_type = MATCHACTION_SET_TAG;
	destination = (yyvsp[0].str);
	action = filteringaction_new(action_type, 0, destination, 0, 0, NULL);
}
#line 3498 "matcher_parser_parse.c"
    break;

  case 124:
#line 1312 "matcher_parser_parse.y"
{
	gchar *destination = NULL;
	gint action_type = 0;

	action_type = MATCHACTION_UNSET_TAG;
	destination = (yyvsp[0].str);
	action = filteringaction_new(action_type, 0, destination, 0, 0, NULL);
}
#line 3511 "matcher_parser_parse.c"
    break;

  case 125:
#line 1321 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_CLEAR_TAGS;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3522 "matcher_parser_parse.c"
    break;

  case 126:
#line 1328 "matcher_parser_parse.y"
{
	gchar *destination = NULL;
	gint action_type = 0;

	action_type = MATCHACTION_COPY;
	destination = (yyvsp[0].str);
	action = filteringaction_new(action_type, 0, destination, 0, 0, NULL);
}
#line 3535 "matcher_parser_parse.c"
    break;

  case 127:
#line 1337 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_DELETE;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3546 "matcher_parser_parse.c"
    break;

  case 128:
#line 1344 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_MARK;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3557 "matcher_parser_parse.c"
    break;

  case 129:
#line 1351 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_UNMARK;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3568 "matcher_parser_parse.c"
    break;

  case 130:
#line 1358 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_LOCK;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3579 "matcher_parser_parse.c"
    break;

  case 131:
#line 1365 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_UNLOCK;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3590 "matcher_parser_parse.c"
    break;

  case 132:
#line 1372 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_MARK_AS_READ;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3601 "matcher_parser_parse.c"
    break;

  case 133:
#line 1379 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_MARK_AS_UNREAD;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3612 "matcher_parser_parse.c"
    break;

  case 134:
#line 1386 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_MARK_AS_SPAM;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3623 "matcher_parser_parse.c"
    break;

  case 135:
#line 1393 "matcher_parser_parse.y"
{
	gint action_type = 0;

	action_type = MATCHACTION_MARK_AS_HAM;
	action = filteringaction_new(action_type, 0, NULL, 0, 0, NULL);
}
#line 3634 "matcher_parser_parse.c"
    break;

  case 136:
#line 1400 "matcher_parser_parse.y"
{
	gchar *destination = NULL;
	gint action_type = 0;
	gint account_id = 0;

	action_type = MATCHACTION_FORWARD;
	account_id = strtol((yyvsp[-1].str), NULL, 10);
	destination = (yyvsp[0].str);
	action = filteringaction_new(action_type,
            account_id, destination, 0, 0, NULL);
}
#line 3650 "matcher_parser_parse.c"
    break;

  case 137:
#line 1412 "matcher_parser_parse.y"
{
	gchar *destination = NULL;
	gint action_type = 0;
	gint account_id = 0;

	action_type = MATCHACTION_FORWARD_AS_ATTACHMENT;
	account_id = strtol((yyvsp[-1].str), NULL, 10);
	destination = (yyvsp[0].str);
	action = filteringaction_new(action_type,
            account_id, destination, 0, 0, NULL);
}
#line 3666 "matcher_parser_parse.c"
    break;

  case 138:
#line 1424 "matcher_parser_parse.y"
{
	gchar *destination = NULL;
	gint action_type = 0;
	gint account_id = 0;

	action_type = MATCHACTION_REDIRECT;
	account_id = strtol((yyvsp[-1].str), NULL, 10);
	destination = (yyvsp[0].str);
	action = filteringaction_new(action_type,
            account_id, destination, 0, 0, NULL);
}
#line 3682 "matcher_parser_parse.c"
    break;

  case 139:
#line 1436 "matcher_parser_parse.y"
{
	gint action_type = 0;
	gint color = 0;

	action_type = MATCHACTION_COLOR;
	color = strtol((yyvsp[0].str), NULL, 10);
	action = filteringaction_new(action_type, 0, NULL, color, 0, NULL);
}
#line 3695 "matcher_parser_parse.c"
    break;

  case 140:
#line 1445 "matcher_parser_parse.y"
{
        gint score = 0;
        
        score = strtol((yyvsp[0].str), NULL, 10);
	action = filteringaction_new(MATCHACTION_CHANGE_SCORE, 0,
				     NULL, 0, score, NULL);
}
#line 3707 "matcher_parser_parse.c"
    break;

  case 141:
#line 1454 "matcher_parser_parse.y"
{
        gint score = 0;
        
        score = strtol((yyvsp[0].str), NULL, 10);
	action = filteringaction_new(MATCHACTION_CHANGE_SCORE, 0,
				     NULL, 0, score, NULL);
}
#line 3719 "matcher_parser_parse.c"
    break;

  case 142:
#line 1462 "matcher_parser_parse.y"
{
        gint score = 0;
        
        score = strtol((yyvsp[0].str), NULL, 10);
	action = filteringaction_new(MATCHACTION_SET_SCORE, 0,
				     NULL, 0, score, NULL);
}
#line 3731 "matcher_parser_parse.c"
    break;

  case 143:
#line 1470 "matcher_parser_parse.y"
{
	action = filteringaction_new(MATCHACTION_HIDE, 0, NULL, 0, 0, NULL);
}
#line 3739 "matcher_parser_parse.c"
    break;

  case 144:
#line 1474 "matcher_parser_parse.y"
{
	action = filteringaction_new(MATCHACTION_IGNORE, 0, NULL, 0, 0, NULL);
}
#line 3747 "matcher_parser_parse.c"
    break;

  case 145:
#line 1478 "matcher_parser_parse.y"
{
	action = filteringaction_new(MATCHACTION_WATCH, 0, NULL, 0, 0, NULL);
}
#line 3755 "matcher_parser_parse.c"
    break;

  case 146:
#line 1482 "matcher_parser_parse.y"
{
	header = g_strdup((yyvsp[0].str));
}
#line 3763 "matcher_parser_parse.c"
    break;

  case 147:
#line 1485 "matcher_parser_parse.y"
{
	gchar *addressbook = NULL;
	gint action_type = 0;

	action_type = MATCHACTION_ADD_TO_ADDRESSBOOK;
	addressbook = (yyvsp[-2].str);
	action = filteringaction_new(action_type, 0, addressbook, 0, 0, header);
	g_free(header);
}
#line 3777 "matcher_parser_parse.c"
    break;

  case 148:
#line 1495 "matcher_parser_parse.y"
{
	action = filteringaction_new(MATCHACTION_STOP, 0, NULL, 0, 0, NULL);
}
#line 3785 "matcher_parser_parse.c"
    break;


#line 3789 "matcher_parser_parse.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *, YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
