#!/bin/sh

set -e
set -x

unset tempd cleanup_err

cleanup() {
	local res="$?"
	local arg="$1"

	if [ -n "$tempd" ]; then
		rm -rf -- "$tempd"
		unset tempd
	fi

	if [ "$arg" -eq 0 ] && [ -n "$res" ]; then
		arg="$res"
	fi
	: "${cleanup_err:=$arg}"
	exit "$cleanup_err"
}

trap 'cleanup 0' EXIT
trap 'cleanup 2' QUIT TERM INT HUP

srcdir="$(pwd)"

tempd="$(mktemp -t -d plugins-test.XXXXXX)"
cd -- "$tempd"

ln -s /usr/lib/fenix/plugins .
cp -- "$srcdir/Makefile" .
make check

rm plugins
sed -i -e 's@plugins/@@' test_load.prg
cat test_load.prg
rm test_load.dcb
make test_load.dcb
