/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimplinklayer_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimplinklayer
 * @title: gimplinklayer
 * @short_description: Functions for querying and manipulating link layers.
 *
 * Functions for querying and manipulating link layers.
 **/


/**
 * gimp_link_layer_new:
 * @image: The image.
 * @file: The file this link layer will monitor.
 *
 * Create a new link layer.
 *
 * This procedure creates a link layer monitoring the specified @file.
 *
 * The new layer still needs to be added to the image as this is not
 * automatic. Add the new layer with the [method@Image.insert_layer]
 * method.
 *
 * The arguments are kept as simple as necessary for the basic case.
 * All link attributes, however, can be modified with the appropriate
 * `gimp_link_layer_set_*()` procedures.
 *
 * Returns: (transfer none):
 *          The new link layer. The object belongs to libgimp and you should not free it.
 *
 * Since: 3.2
 **/
GimpLinkLayer *
gimp_link_layer_new (GimpImage *image,
                     GFile     *file)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpLinkLayer *layer = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_FILE, file,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-link-layer-new",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    layer = GIMP_VALUES_GET_LINK_LAYER (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return layer;
}

/**
 * gimp_link_layer_get_file:
 * @layer: The link layer.
 *
 * Get the monitored file.
 *
 * This procedure returns the file which is being monitored.
 *
 * Returns: (transfer full): The monitored file.
 *
 * Since: 3.2
 **/
GFile *
gimp_link_layer_get_file (GimpLinkLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GFile *file = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LINK_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-link-layer-get-file",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    file = GIMP_VALUES_DUP_FILE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return file;
}

/**
 * gimp_link_layer_set_file:
 * @layer: The link layer.
 * @file: The file to monitor.
 *
 * Set the monitored file.
 *
 * This procedure sets the file to be monitored. It may change the
 * layer's render.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.2
 **/
gboolean
gimp_link_layer_set_file (GimpLinkLayer *layer,
                          GFile         *file)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LINK_LAYER, layer,
                                          G_TYPE_FILE, file,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-link-layer-set-file",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_link_layer_get_mime_type:
 * @layer: The link layer.
 *
 * Get the mime type of the monitored file.
 *
 * This procedure returns the mime type of the file which is being
 * monitored by @layer.
 *
 * Note that this will be the real mime type, corresponding to our
 * format support, as returned by the [class@Gimp.LoadProcedure] which
 * actually performs the external image file import.
 *
 * This function may also return %NULL in case of error (for instance
 * if the external file doesn't exist anymore).
 *
 * Returns: (transfer full): The mime type of the monitored file.
 *          The returned value must be freed with g_free().
 *
 * Since: 3.2
 **/
gchar *
gimp_link_layer_get_mime_type (GimpLinkLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *mimetype = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LINK_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-link-layer-get-mime-type",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    mimetype = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return mimetype;
}
