static char rcsid[] = "$Id: request.c 223511 2020-11-14 15:50:08Z twu $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "request.h"
#include "assert.h"
#include "mem.h"

#ifndef GSNAP
static Genome_T global_genome;
static Genome_T global_genomealt;
#endif


#define T Request_T
struct T {
  int id;
#ifdef GSNAP
  Shortread_T queryseq1;
  Shortread_T queryseq2;
#else
  Genome_T genome;
  Genome_T genomealt;
  Sequence_T queryseq;
#endif  
};


int
Request_id (T this) {
  return this->id;
}

#ifdef GSNAP

Shortread_T
Request_queryseq1 (T this) {
  return this->queryseq1;
}

Shortread_T
Request_queryseq2 (T this) {
  return this->queryseq2;
}


T
Request_new (int id, Shortread_T queryseq1, Shortread_T queryseq2) {
  T new = (T) MALLOC_IN(sizeof(*new));

  new->id = id;
  new->queryseq1 = queryseq1;
  new->queryseq2 = queryseq2;
  return new;
}

void
Request_free (T *old) {
  if (*old) {
    Shortread_free(&(*old)->queryseq1);
    if ((*old)->queryseq2) {
      Shortread_free(&(*old)->queryseq2);
    }
    FREE_IN(*old);
  }
  return;
}


#else  /* not GSNAP */

Genome_T
Request_genome (T this) {
  if (this->genome == NULL) {
    return global_genome;
  } else {
    return this->genome;
  }
}

Genome_T
Request_genomealt (T this) {
  if (this->genomealt == NULL) {
    return global_genomealt;
  } else {
    return this->genomealt;
  }
}

Sequence_T
Request_queryseq (T this) {
  return this->queryseq;
}

T
Request_new (int id, Genome_T genome, Genome_T genomealt, Sequence_T queryseq) {
  T new = (T) MALLOC_IN(sizeof(*new));

  new->id = id;
  new->genome = genome;
  new->genomealt = genomealt;
  new->queryseq = queryseq;
  
  return new;
}

void
Request_free (T *old) {
  if (*old) {
    if ((*old)->genomealt != (*old)->genome) {
      Genome_free(&(*old)->genomealt);
    }
    if ((*old)->genome != NULL) {
      Genome_free(&(*old)->genome);
    }
    Sequence_free(&(*old)->queryseq);
    FREE_IN(*old);
  }
  return;
}

void
Request_setup (Genome_T global_genome_in, Genome_T global_genomealt_in) {
  global_genome = global_genome_in;
  global_genomealt = global_genomealt_in;
  return;
}


#endif	/* not GSNAP */
