/*
 *  This file is part of Healpix Java.
 *
 *  This code is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This code is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this code; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  For more information about HEALPix, see http://healpix.sourceforge.net
 */

package healpix.essentials;

/** Some frequently used constants. */
public class Constants
  {
  /** The Constant halfpi */
  public static final double halfpi = Math.PI/2.;

  public static final double inv_halfpi = 2./Math.PI;

  /** The Constant twopi. */
  public static final double twopi = 2*Math.PI;
  public static final double inv_twopi = 1./(2*Math.PI);

  /** The Constant twothird. */
  public static final double twothird = 2./3.;
  }
