; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 < %s | FileCheck %s --check-prefixes=ALL,VSX
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 -mattr=-vsx < %s | FileCheck %s --check-prefixes=ALL,NOVSX

; Check VMX 128-bit integer operations

define <1 x i128> @out_of_bounds_insertelement(<1 x i128> %x, i128 %val) nounwind {
; ALL-LABEL: out_of_bounds_insertelement:
; ALL:       # %bb.0:
; ALL-NEXT:    blr
  %tmpvec = insertelement <1 x i128> <i128 0>, i128 %val, i32 1
  %result = add <1 x i128> %x, %tmpvec
  ret <1 x i128> %result
}

define <1 x i128> @test_add(<1 x i128> %x, <1 x i128> %y) nounwind {
; ALL-LABEL: test_add:
; ALL:       # %bb.0:
; ALL-NEXT:    vadduqm 2, 2, 3
; ALL-NEXT:    blr
  %result = add <1 x i128> %x, %y
  ret <1 x i128> %result
}

define <1 x i128> @increment_by_one(<1 x i128> %x) nounwind {
; VSX-LABEL: increment_by_one:
; VSX:       # %bb.0:
; VSX-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; VSX-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; VSX-NEXT:    lxvd2x 35, 0, 3
; VSX-NEXT:    vadduqm 2, 2, 3
; VSX-NEXT:    blr
;
; NOVSX-LABEL: increment_by_one:
; NOVSX:       # %bb.0:
; NOVSX-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; NOVSX-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; NOVSX-NEXT:    lvx 3, 0, 3
; NOVSX-NEXT:    vadduqm 2, 2, 3
; NOVSX-NEXT:    blr
  %result = add <1 x i128> %x, <i128 1>
  ret <1 x i128> %result
}

define <1 x i128> @increment_by_val(<1 x i128> %x, i128 %val) nounwind {
; VSX-LABEL: increment_by_val:
; VSX:       # %bb.0:
; VSX-NEXT:    mtvsrd 0, 6
; VSX-NEXT:    mtvsrd 1, 5
; VSX-NEXT:    xxmrghd 35, 1, 0
; VSX-NEXT:    vadduqm 2, 2, 3
; VSX-NEXT:    blr
;
; NOVSX-LABEL: increment_by_val:
; NOVSX:       # %bb.0:
; NOVSX-NEXT:    addi 3, 1, -16
; NOVSX-NEXT:    std 6, -8(1)
; NOVSX-NEXT:    std 5, -16(1)
; NOVSX-NEXT:    lvx 3, 0, 3
; NOVSX-NEXT:    vadduqm 2, 2, 3
; NOVSX-NEXT:    blr
  %tmpvec = insertelement <1 x i128> <i128 0>, i128 %val, i32 0
  %result = add <1 x i128> %x, %tmpvec
  ret <1 x i128> %result
}

define <1 x i128> @test_sub(<1 x i128> %x, <1 x i128> %y) nounwind {
; ALL-LABEL: test_sub:
; ALL:       # %bb.0:
; ALL-NEXT:    vsubuqm 2, 2, 3
; ALL-NEXT:    blr
  %result = sub <1 x i128> %x, %y
  ret <1 x i128> %result
}

define <1 x i128> @decrement_by_one(<1 x i128> %x) nounwind {
; VSX-LABEL: decrement_by_one:
; VSX:       # %bb.0:
; VSX-NEXT:    addis 3, 2, .LCPI5_0@toc@ha
; VSX-NEXT:    addi 3, 3, .LCPI5_0@toc@l
; VSX-NEXT:    lxvd2x 35, 0, 3
; VSX-NEXT:    vsubuqm 2, 2, 3
; VSX-NEXT:    blr
;
; NOVSX-LABEL: decrement_by_one:
; NOVSX:       # %bb.0:
; NOVSX-NEXT:    addis 3, 2, .LCPI5_0@toc@ha
; NOVSX-NEXT:    addi 3, 3, .LCPI5_0@toc@l
; NOVSX-NEXT:    lvx 3, 0, 3
; NOVSX-NEXT:    vsubuqm 2, 2, 3
; NOVSX-NEXT:    blr
  %result = sub <1 x i128> %x, <i128 1>
  ret <1 x i128> %result
}

define <1 x i128> @decrement_by_val(<1 x i128> %x, i128 %val) nounwind {
; VSX-LABEL: decrement_by_val:
; VSX:       # %bb.0:
; VSX-NEXT:    mtvsrd 0, 6
; VSX-NEXT:    mtvsrd 1, 5
; VSX-NEXT:    xxmrghd 35, 1, 0
; VSX-NEXT:    vsubuqm 2, 2, 3
; VSX-NEXT:    blr
;
; NOVSX-LABEL: decrement_by_val:
; NOVSX:       # %bb.0:
; NOVSX-NEXT:    addi 3, 1, -16
; NOVSX-NEXT:    std 6, -8(1)
; NOVSX-NEXT:    std 5, -16(1)
; NOVSX-NEXT:    lvx 3, 0, 3
; NOVSX-NEXT:    vsubuqm 2, 2, 3
; NOVSX-NEXT:    blr
  %tmpvec = insertelement <1 x i128> <i128 0>, i128 %val, i32 0
  %result = sub <1 x i128> %x, %tmpvec
  ret <1 x i128> %result
}

declare <1 x i128> @llvm.ppc.altivec.vaddeuqm(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind readnone
declare <1 x i128> @llvm.ppc.altivec.vaddcuq(<1 x i128> %x, <1 x i128> %y) nounwind readnone
declare <1 x i128> @llvm.ppc.altivec.vaddecuq(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind readnone
declare <1 x i128> @llvm.ppc.altivec.vsubeuqm(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind readnone
declare <1 x i128> @llvm.ppc.altivec.vsubcuq(<1 x i128> %x, <1 x i128> %y) nounwind readnone
declare <1 x i128> @llvm.ppc.altivec.vsubecuq(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind readnone

define <1 x i128> @test_vaddeuqm(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind {
; ALL-LABEL: test_vaddeuqm:
; ALL:       # %bb.0:
; ALL-NEXT:    vaddeuqm 2, 2, 3, 4
; ALL-NEXT:    blr
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vaddeuqm(<1 x i128> %x,
                 <1 x i128> %y,
                 <1 x i128> %z)
  ret <1 x i128> %tmp
}

define <1 x i128> @test_vaddcuq(<1 x i128> %x, <1 x i128> %y) nounwind {
; ALL-LABEL: test_vaddcuq:
; ALL:       # %bb.0:
; ALL-NEXT:    vaddcuq 2, 2, 3
; ALL-NEXT:    blr
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vaddcuq(<1 x i128> %x,
                <1 x i128> %y)
  ret <1 x i128> %tmp
}

define <1 x i128> @test_vaddecuq(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind {
; ALL-LABEL: test_vaddecuq:
; ALL:       # %bb.0:
; ALL-NEXT:    vaddecuq 2, 2, 3, 4
; ALL-NEXT:    blr
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vaddecuq(<1 x i128> %x,
                 <1 x i128> %y,
                 <1 x i128> %z)
  ret <1 x i128> %tmp
}

define <1 x i128> @test_vsubeuqm(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind {
; ALL-LABEL: test_vsubeuqm:
; ALL:       # %bb.0:
; ALL-NEXT:    vsubeuqm 2, 2, 3, 4
; ALL-NEXT:    blr
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vsubeuqm(<1 x i128> %x,
                 <1 x i128> %y,
                 <1 x i128> %z)
  ret <1 x i128> %tmp
}

define <1 x i128> @test_vsubcuq(<1 x i128> %x, <1 x i128> %y) nounwind {
; ALL-LABEL: test_vsubcuq:
; ALL:       # %bb.0:
; ALL-NEXT:    vsubcuq 2, 2, 3
; ALL-NEXT:    blr
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vsubcuq(<1 x i128> %x,
                <1 x i128> %y)
  ret <1 x i128> %tmp
}

define <1 x i128> @test_vsubecuq(<1 x i128> %x, <1 x i128> %y, <1 x i128> %z) nounwind {
; ALL-LABEL: test_vsubecuq:
; ALL:       # %bb.0:
; ALL-NEXT:    vsubecuq 2, 2, 3, 4
; ALL-NEXT:    blr
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vsubecuq(<1 x i128> %x,
                 <1 x i128> %y,
                 <1 x i128> %z)
  ret <1 x i128> %tmp
}
