/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import atan2 = require( './index' );


// TESTS //

// The function returns a number...
{
	atan2( 8, 2 ); // $ExpectType number
}

// The function does not compile if provided values other than two numbers...
{
	atan2( true, 3 ); // $ExpectError
	atan2( false, 2 ); // $ExpectError
	atan2( '5', 1 ); // $ExpectError
	atan2( [], 1 ); // $ExpectError
	atan2( {}, 2 ); // $ExpectError
	atan2( ( x: number ): number => x, 2 ); // $ExpectError

	atan2( 9, true ); // $ExpectError
	atan2( 9, false ); // $ExpectError
	atan2( 5, '5' ); // $ExpectError
	atan2( 8, [] ); // $ExpectError
	atan2( 9, {} ); // $ExpectError
	atan2( 8, ( x: number ): number => x ); // $ExpectError

	atan2( [], true ); // $ExpectError
	atan2( {}, false ); // $ExpectError
	atan2( false, '5' ); // $ExpectError
	atan2( {}, [] ); // $ExpectError
	atan2( '5', ( x: number ): number => x ); // $ExpectError
}

// The function does not compile if provided insufficient arguments...
{
	atan2(); // $ExpectError
	atan2( 3 ); // $ExpectError
}
