/* 
 */

/*

    Copyright (C) 2014 Ferrero Andrea

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.


 */

/*

    These files are distributed with PhotoFlow - http://aferrero2707.github.io/PhotoFlow/

 */

#ifndef CIMG_BLUR_BILATERAL_H
#define CIMG_BLUR_BILATERAL_H

#include <assert.h>
#include <string>

#include <sstream>
//#define SSTR( x ) dynamic_cast< std::ostringstream & >( \
//        ( std::ostringstream() << std::dec << x ) ).str()


#include "../base/processor.hh"


namespace PF 
{

  class GMicPar: public OpParBase
  {
    ProcessorBase* convert_format;
    ProcessorBase* convert_format2;

    Property<int> iterations;
    Property<std::string> command; 
    Property<std::string> post_command; 
    Property<int> padding;
    Property<float> x_scale;
    Property<float> y_scale; 

    bool cache_tiles;

  public:
    GMicPar();
    ~GMicPar() {
      delete convert_format;
      delete convert_format2;
    }

    bool has_intensity() { return false; }
    bool has_opacity() { return true; }

    void set_command( std::string cmd ) { command.set( cmd ); }
    void set_post_command( std::string cmd ) { post_command.set( cmd ); }
    void set_iterations( int it ) { iterations.set( it ); };
    void set_gmic_padding( int p ) { padding.set( p ); };
    int get_gmic_padding() { return padding.get(); };
    void set_x_scale(float xs ) { x_scale.set( xs ); }
    void set_y_scale(float ys ) { x_scale.set( ys ); }

    void set_cache_tiles( bool flag ) { cache_tiles = flag; }
      

    VipsImage* build(std::vector<VipsImage*>& in, int first, 
		     VipsImage* imap, VipsImage* omap, 
		     unsigned int& level);
  };

  

  template < OP_TEMPLATE_DEF > 
  class GMicProc
  {
  public: 
    void render(VipsRegion** ireg, int n, int in_first,
		VipsRegion* imap, VipsRegion* omap, 
		VipsRegion* oreg, OpParBase* par)
    {
			
    }
  };




  ProcessorBase* new_gmic();
}

#endif 


