# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AuthorizationRule(msrest.serialization.Model):
    """Authorization rule of an entity.

    :param type: The authorization type.
    :type type: str
    :param claim_type: The claim type.
    :type claim_type: str
    :param claim_value: The claim value.
    :type claim_value: str
    :param rights: Access rights of the entity. Values are 'Send', 'Listen', or 'Manage'.
    :type rights: list[str]
    :param created_time: The date and time when the authorization rule was created.
    :type created_time: ~datetime.datetime
    :param modified_time: The date and time when the authorization rule was modified.
    :type modified_time: ~datetime.datetime
    :param key_name: The authorization rule key name.
    :type key_name: str
    :param primary_key: The primary key of the authorization rule.
    :type primary_key: str
    :param secondary_key: The primary key of the authorization rule.
    :type secondary_key: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'i', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'claim_type': {'key': 'claimType', 'type': 'str', 'xml': {'name': 'ClaimType', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'claim_value': {'key': 'claimValue', 'type': 'str', 'xml': {'name': 'ClaimValue', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'rights': {'key': 'rights', 'type': '[str]', 'xml': {'name': 'Rights', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'AccessRights', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601', 'xml': {'name': 'CreatedTime', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601', 'xml': {'name': 'ModifiedTime', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'key_name': {'key': 'keyName', 'type': 'str', 'xml': {'name': 'KeyName', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'primary_key': {'key': 'primaryKey', 'type': 'str', 'xml': {'name': 'PrimaryKey', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str', 'xml': {'name': 'SecondaryKey', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'AuthorizationRule', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationRule, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.claim_type = kwargs.get('claim_type', None)
        self.claim_value = kwargs.get('claim_value', None)
        self.rights = kwargs.get('rights', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.key_name = kwargs.get('key_name', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)


class RuleFilter(msrest.serialization.Model):
    """RuleFilter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CorrelationFilter, SqlFilter.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
    }

    _subtype_map = {
        'type': {'CorrelationFilter': 'CorrelationFilter', 'SqlFilter': 'SqlFilter'}
    }
    _xml_map = {
        'name': 'Filter', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleFilter, self).__init__(**kwargs)
        self.type = None


class CorrelationFilter(RuleFilter):
    """CorrelationFilter.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param correlation_id:
    :type correlation_id: str
    :param message_id:
    :type message_id: str
    :param to:
    :type to: str
    :param reply_to:
    :type reply_to: str
    :param label:
    :type label: str
    :param session_id:
    :type session_id: str
    :param reply_to_session_id:
    :type reply_to_session_id: str
    :param content_type:
    :type content_type: str
    :param properties:
    :type properties: list[~azure.servicebus.management._generated.models.KeyValue]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'correlation_id': {'key': 'correlationId', 'type': 'str', 'xml': {'name': 'CorrelationId', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_id': {'key': 'messageId', 'type': 'str', 'xml': {'name': 'MessageId', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'to': {'key': 'to', 'type': 'str', 'xml': {'name': 'To', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'reply_to': {'key': 'replyTo', 'type': 'str', 'xml': {'name': 'ReplyTo', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'label': {'key': 'label', 'type': 'str', 'xml': {'name': 'Label', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'session_id': {'key': 'sessionId', 'type': 'str', 'xml': {'name': 'SessionId', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'reply_to_session_id': {'key': 'replyToSessionId', 'type': 'str', 'xml': {'name': 'ReplyToSessionId', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'content_type': {'key': 'contentType', 'type': 'str', 'xml': {'name': 'ContentType', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'properties': {'key': 'properties', 'type': '[KeyValue]', 'xml': {'name': 'Properties', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'KeyValueOfstringanyType', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorrelationFilter, self).__init__(**kwargs)
        self.type = 'CorrelationFilter'
        self.correlation_id = kwargs.get('correlation_id', None)
        self.message_id = kwargs.get('message_id', None)
        self.to = kwargs.get('to', None)
        self.reply_to = kwargs.get('reply_to', None)
        self.label = kwargs.get('label', None)
        self.session_id = kwargs.get('session_id', None)
        self.reply_to_session_id = kwargs.get('reply_to_session_id', None)
        self.content_type = kwargs.get('content_type', None)
        self.properties = kwargs.get('properties', None)


class CreateQueueBody(msrest.serialization.Model):
    """The request body for creating a queue.

    :param content: QueueDescription for the new queue.
    :type content: ~azure.servicebus.management._generated.models.CreateQueueBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateQueueBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateQueueBody, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class CreateQueueBodyContent(msrest.serialization.Model):
    """QueueDescription for the new queue.

    :param type: MIME type of content.
    :type type: str
    :param queue_description: Properties of the new queue.
    :type queue_description: ~azure.servicebus.management._generated.models.QueueDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'queue_description': {'key': 'queueDescription', 'type': 'QueueDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateQueueBodyContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', "application/xml")
        self.queue_description = kwargs.get('queue_description', None)


class CreateRuleBody(msrest.serialization.Model):
    """The request body for creating a rule.

    :param content: RuleDescription for the new Rule.
    :type content: ~azure.servicebus.management._generated.models.CreateRuleBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateRuleBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateRuleBody, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class CreateRuleBodyContent(msrest.serialization.Model):
    """RuleDescription for the new Rule.

    :param type: MIME type of content.
    :type type: str
    :param rule_description: Rule information to create.
    :type rule_description: ~azure.servicebus.management._generated.models.RuleDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'rule_description': {'key': 'ruleDescription', 'type': 'RuleDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateRuleBodyContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', "application/xml")
        self.rule_description = kwargs.get('rule_description', None)


class CreateSubscriptionBody(msrest.serialization.Model):
    """The request body for creating a subscription.

    :param content: SubscriptionDescription for the new subscription.
    :type content: ~azure.servicebus.management._generated.models.CreateSubscriptionBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateSubscriptionBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateSubscriptionBody, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class CreateSubscriptionBodyContent(msrest.serialization.Model):
    """SubscriptionDescription for the new subscription.

    :param type: MIME type of content.
    :type type: str
    :param subscription_description: Subscription information to create.
    :type subscription_description:
     ~azure.servicebus.management._generated.models.SubscriptionDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'subscription_description': {'key': 'subscriptionDescription', 'type': 'SubscriptionDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateSubscriptionBodyContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', "application/xml")
        self.subscription_description = kwargs.get('subscription_description', None)


class CreateTopicBody(msrest.serialization.Model):
    """The request body for creating a topic.

    :param content: TopicDescription for the new topic.
    :type content: ~azure.servicebus.management._generated.models.CreateTopicBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateTopicBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateTopicBody, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class CreateTopicBodyContent(msrest.serialization.Model):
    """TopicDescription for the new topic.

    :param type: MIME type of content.
    :type type: str
    :param topic_description: Topic information to create.
    :type topic_description: ~azure.servicebus.management._generated.models.TopicDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'topic_description': {'key': 'topicDescription', 'type': 'TopicDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateTopicBodyContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', "application/xml")
        self.topic_description = kwargs.get('topic_description', None)


class RuleAction(msrest.serialization.Model):
    """RuleAction.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EmptyRuleAction, SqlRuleAction.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
    }

    _subtype_map = {
        'type': {'EmptyRuleAction': 'EmptyRuleAction', 'SqlRuleAction': 'SqlRuleAction'}
    }
    _xml_map = {
        'name': 'Action', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleAction, self).__init__(**kwargs)
        self.type = None


class EmptyRuleAction(RuleAction):
    """EmptyRuleAction.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmptyRuleAction, self).__init__(**kwargs)
        self.type = 'EmptyRuleAction'


class SqlFilter(RuleFilter):
    """SqlFilter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FalseFilter, TrueFilter.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    :param compatibility_level:
    :type compatibility_level: str
    :param parameters:
    :type parameters: list[~azure.servicebus.management._generated.models.KeyValue]
    :param requires_preprocessing:
    :type requires_preprocessing: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'sqlExpression', 'type': 'str', 'xml': {'name': 'SqlExpression', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'str', 'xml': {'name': 'CompatibilityLevel', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'parameters': {'key': 'parameters', 'type': '[KeyValue]', 'xml': {'name': 'Parameters', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'KeyValueOfstringanyType', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool', 'xml': {'name': 'RequiresPreprocessing', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    _subtype_map = {
        'type': {'FalseFilter': 'FalseFilter', 'TrueFilter': 'TrueFilter'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlFilter, self).__init__(**kwargs)
        self.type = 'SqlFilter'
        self.sql_expression = kwargs.get('sql_expression', None)
        self.compatibility_level = kwargs.get('compatibility_level', "20")
        self.parameters = kwargs.get('parameters', None)
        self.requires_preprocessing = kwargs.get('requires_preprocessing', None)


class FalseFilter(SqlFilter):
    """FalseFilter.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    :param compatibility_level:
    :type compatibility_level: str
    :param parameters:
    :type parameters: list[~azure.servicebus.management._generated.models.KeyValue]
    :param requires_preprocessing:
    :type requires_preprocessing: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'sqlExpression', 'type': 'str', 'xml': {'name': 'SqlExpression', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'str', 'xml': {'name': 'CompatibilityLevel', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'parameters': {'key': 'parameters', 'type': '[KeyValue]', 'xml': {'name': 'Parameters', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'KeyValueOfstringanyType', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool', 'xml': {'name': 'RequiresPreprocessing', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FalseFilter, self).__init__(**kwargs)
        self.type = 'FalseFilter'


class KeyValue(msrest.serialization.Model):
    """Key Values of custom properties.

    :param key:
    :type key: str
    :param value:
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str', 'xml': {'name': 'Key', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'value': {'key': 'value', 'type': 'str', 'xml': {'name': 'Value', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'KeyValueOfstringanyType', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyValue, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class MessageCountDetails(msrest.serialization.Model):
    """Details about the message counts in entity.

    :param active_message_count: Number of active messages in the queue, topic, or subscription.
    :type active_message_count: int
    :param dead_letter_message_count: Number of messages that are dead lettered.
    :type dead_letter_message_count: int
    :param scheduled_message_count: Number of scheduled messages.
    :type scheduled_message_count: int
    :param transfer_dead_letter_message_count: Number of messages transferred into dead letters.
    :type transfer_dead_letter_message_count: int
    :param transfer_message_count: Number of messages transferred to another queue, topic, or
     subscription.
    :type transfer_message_count: int
    """

    _attribute_map = {
        'active_message_count': {'key': 'activeMessageCount', 'type': 'int', 'xml': {'name': 'ActiveMessageCount', 'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'dead_letter_message_count': {'key': 'deadLetterMessageCount', 'type': 'int', 'xml': {'name': 'DeadLetterMessageCount', 'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'scheduled_message_count': {'key': 'scheduledMessageCount', 'type': 'int', 'xml': {'name': 'ScheduledMessageCount', 'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'transfer_dead_letter_message_count': {'key': 'transferDeadLetterMessageCount', 'type': 'int', 'xml': {'name': 'TransferDeadLetterMessageCount', 'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'transfer_message_count': {'key': 'transferMessageCount', 'type': 'int', 'xml': {'name': 'TransferMessageCount', 'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
    }
    _xml_map = {
        'name': 'CountDetails', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MessageCountDetails, self).__init__(**kwargs)
        self.active_message_count = kwargs.get('active_message_count', None)
        self.dead_letter_message_count = kwargs.get('dead_letter_message_count', None)
        self.scheduled_message_count = kwargs.get('scheduled_message_count', None)
        self.transfer_dead_letter_message_count = kwargs.get('transfer_dead_letter_message_count', None)
        self.transfer_message_count = kwargs.get('transfer_message_count', None)


class NamespaceProperties(msrest.serialization.Model):
    """The metadata related to a Service Bus namespace.

    :param alias: Alias for the geo-disaster recovery Service Bus namespace.
    :type alias: str
    :param created_time: The exact time the namespace was created.
    :type created_time: ~datetime.datetime
    :param messaging_sku: The SKU for the messaging entity. Possible values include: "Basic",
     "Standard", "Premium".
    :type messaging_sku: str or ~azure.servicebus.management._generated.models.MessagingSku
    :param messaging_units: The number of messaging units allocated to the namespace.
    :type messaging_units: int
    :param modified_time: The exact time the namespace was last modified.
    :type modified_time: ~datetime.datetime
    :param name: Name of the namespace.
    :type name: str
    :param namespace_type: The type of entities the namespace can contain. Possible values include:
     "Messaging", "NotificationHub", "Mixed", "EventHub", "Relay".
    :type namespace_type: str or ~azure.servicebus.management._generated.models.NamespaceType
    """

    _attribute_map = {
        'alias': {'key': 'alias', 'type': 'str', 'xml': {'name': 'Alias', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601', 'xml': {'name': 'CreatedTime', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'messaging_sku': {'key': 'messagingSku', 'type': 'str', 'xml': {'name': 'MessagingSKU', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'messaging_units': {'key': 'messagingUnits', 'type': 'int', 'xml': {'name': 'MessagingUnits', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601', 'xml': {'name': 'ModifiedTime', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'name': {'key': 'name', 'type': 'str', 'xml': {'name': 'Name', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'namespace_type': {'key': 'namespaceType', 'type': 'str', 'xml': {'name': 'NamespaceType', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'NamespaceInfo', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamespaceProperties, self).__init__(**kwargs)
        self.alias = kwargs.get('alias', None)
        self.created_time = kwargs.get('created_time', None)
        self.messaging_sku = kwargs.get('messaging_sku', None)
        self.messaging_units = kwargs.get('messaging_units', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.name = kwargs.get('name', None)
        self.namespace_type = kwargs.get('namespace_type', None)


class NamespacePropertiesEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying namespace info.

    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the namespace.
    :type title: object
    :param updated: The timestamp for when this namespace was last updated.
    :type updated: ~datetime.datetime
    :param author: The author that created this resource.
    :type author: ~azure.servicebus.management._generated.models.ResponseAuthor
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: Information about the namespace.
    :type content: ~azure.servicebus.management._generated.models.NamespacePropertiesEntryContent
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'author': {'key': 'author', 'type': 'ResponseAuthor'},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'NamespacePropertiesEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamespacePropertiesEntry, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.updated = kwargs.get('updated', None)
        self.author = kwargs.get('author', None)
        self.link = kwargs.get('link', None)
        self.content = kwargs.get('content', None)


class NamespacePropertiesEntryContent(msrest.serialization.Model):
    """Information about the namespace.

    :param type: Type of content in namespace info response.
    :type type: str
    :param namespace_properties: The metadata related to a Service Bus namespace.
    :type namespace_properties: ~azure.servicebus.management._generated.models.NamespaceProperties
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'namespace_properties': {'key': 'NamespaceProperties', 'type': 'NamespaceProperties'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamespacePropertiesEntryContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.namespace_properties = kwargs.get('namespace_properties', None)


class QueueDescription(msrest.serialization.Model):
    """Description of a Service Bus queue resource.

    :param lock_duration: ISO 8601 timespan duration of a peek-lock; that is, the amount of time
     that the message is locked for other receivers. The maximum value for LockDuration is 5
     minutes; the default value is 1 minute.
    :type lock_duration: ~datetime.timedelta
    :param max_size_in_megabytes: The maximum size of the queue in megabytes, which is the size of
     memory allocated for the queue.
    :type max_size_in_megabytes: long
    :param requires_duplicate_detection: A value indicating if this queue requires duplicate
     detection.
    :type requires_duplicate_detection: bool
    :param requires_session: A value that indicates whether the queue supports the concept of
     sessions.
    :type requires_session: bool
    :param default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param dead_lettering_on_message_expiration: A value that indicates whether this queue has dead
     letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :type duplicate_detection_history_time_window: ~datetime.timedelta
    :param max_delivery_count: The maximum delivery count. A message is automatically deadlettered
     after this number of deliveries. Default value is 10.
    :type max_delivery_count: int
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param size_in_bytes: The size of the queue, in bytes.
    :type size_in_bytes: int
    :param message_count: The number of messages in the queue.
    :type message_count: int
    :param is_anonymous_accessible: A value indicating if the resource can be accessed without
     authorization.
    :type is_anonymous_accessible: bool
    :param authorization_rules: Authorization rules for resource.
    :type authorization_rules:
     list[~azure.servicebus.management._generated.models.AuthorizationRule]
    :param status: Status of a Service Bus resource. Possible values include: "Active", "Creating",
     "Deleting", "Disabled", "ReceiveDisabled", "Renaming", "Restoring", "SendDisabled", "Unknown".
    :type status: str or ~azure.servicebus.management._generated.models.EntityStatus
    :param forward_to: The name of the recipient entity to which all the messages sent to the queue
     are forwarded to.
    :type forward_to: str
    :param user_metadata: Custom metdata that user can associate with the description. Max length
     is 1024 chars.
    :type user_metadata: str
    :param created_at: The exact time the queue was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The exact time the entity description was last updated.
    :type updated_at: ~datetime.datetime
    :param accessed_at: Last time a message was sent, or the last time there was a receive request
     to this queue.
    :type accessed_at: ~datetime.datetime
    :param support_ordering: A value that indicates whether the queue supports ordering.
    :type support_ordering: bool
    :param message_count_details: Details about the message counts in entity.
    :type message_count_details: ~azure.servicebus.management._generated.models.MessageCountDetails
    :param auto_delete_on_idle: ISO 8601 timeSpan idle interval after which the queue is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param enable_partitioning: A value that indicates whether the queue is to be partitioned
     across multiple message brokers.
    :type enable_partitioning: bool
    :param entity_availability_status: Availability status of the entity. Possible values include:
     "Available", "Limited", "Renaming", "Restoring", "Unknown".
    :type entity_availability_status: str or
     ~azure.servicebus.management._generated.models.EntityAvailabilityStatus
    :param enable_express: A value that indicates whether Express Entities are enabled. An express
     queue holds a message in memory temporarily before writing it to persistent storage.
    :type enable_express: bool
    :param forward_dead_lettered_messages_to: The name of the recipient entity to which all the
     dead-lettered messages of this subscription are forwarded to.
    :type forward_dead_lettered_messages_to: str
    """

    _attribute_map = {
        'lock_duration': {'key': 'lockDuration', 'type': 'duration', 'xml': {'name': 'LockDuration', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_size_in_megabytes': {'key': 'maxSizeInMegabytes', 'type': 'long', 'xml': {'name': 'MaxSizeInMegabytes', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_duplicate_detection': {'key': 'requiresDuplicateDetection', 'type': 'bool', 'xml': {'name': 'RequiresDuplicateDetection', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_session': {'key': 'requiresSession', 'type': 'bool', 'xml': {'name': 'RequiresSession', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'default_message_time_to_live': {'key': 'defaultMessageTimeToLive', 'type': 'duration', 'xml': {'name': 'DefaultMessageTimeToLive', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'dead_lettering_on_message_expiration': {'key': 'deadLetteringOnMessageExpiration', 'type': 'bool', 'xml': {'name': 'DeadLetteringOnMessageExpiration', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'duplicate_detection_history_time_window': {'key': 'duplicateDetectionHistoryTimeWindow', 'type': 'duration', 'xml': {'name': 'DuplicateDetectionHistoryTimeWindow', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int', 'xml': {'name': 'MaxDeliveryCount', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_batched_operations': {'key': 'enableBatchedOperations', 'type': 'bool', 'xml': {'name': 'EnableBatchedOperations', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'size_in_bytes': {'key': 'sizeInBytes', 'type': 'int', 'xml': {'name': 'SizeInBytes', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count': {'key': 'messageCount', 'type': 'int', 'xml': {'name': 'MessageCount', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'is_anonymous_accessible': {'key': 'isAnonymousAccessible', 'type': 'bool', 'xml': {'name': 'IsAnonymousAccessible', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'authorization_rules': {'key': 'authorizationRules', 'type': '[AuthorizationRule]', 'xml': {'name': 'AuthorizationRules', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'AuthorizationRule', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'status': {'key': 'status', 'type': 'str', 'xml': {'name': 'Status', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_to': {'key': 'forwardTo', 'type': 'str', 'xml': {'name': 'ForwardTo', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'user_metadata': {'key': 'userMetadata', 'type': 'str', 'xml': {'name': 'UserMetadata', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601', 'xml': {'name': 'CreatedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'updated_at': {'key': 'updatedAt', 'type': 'iso-8601', 'xml': {'name': 'UpdatedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'accessed_at': {'key': 'accessedAt', 'type': 'iso-8601', 'xml': {'name': 'AccessedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'support_ordering': {'key': 'supportOrdering', 'type': 'bool', 'xml': {'name': 'SupportOrdering', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count_details': {'key': 'messageCountDetails', 'type': 'MessageCountDetails'},
        'auto_delete_on_idle': {'key': 'autoDeleteOnIdle', 'type': 'duration', 'xml': {'name': 'AutoDeleteOnIdle', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_partitioning': {'key': 'enablePartitioning', 'type': 'bool', 'xml': {'name': 'EnablePartitioning', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'entity_availability_status': {'key': 'entityAvailabilityStatus', 'type': 'str', 'xml': {'name': 'EntityAvailabilityStatus', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_express': {'key': 'enableExpress', 'type': 'bool', 'xml': {'name': 'EnableExpress', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_dead_lettered_messages_to': {'key': 'forwardDeadLetteredMessagesTo', 'type': 'str', 'xml': {'name': 'ForwardDeadLetteredMessagesTo', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'QueueDescription', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueDescription, self).__init__(**kwargs)
        self.lock_duration = kwargs.get('lock_duration', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.requires_session = kwargs.get('requires_session', None)
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.size_in_bytes = kwargs.get('size_in_bytes', None)
        self.message_count = kwargs.get('message_count', None)
        self.is_anonymous_accessible = kwargs.get('is_anonymous_accessible', None)
        self.authorization_rules = kwargs.get('authorization_rules', None)
        self.status = kwargs.get('status', None)
        self.forward_to = kwargs.get('forward_to', None)
        self.user_metadata = kwargs.get('user_metadata', None)
        self.created_at = kwargs.get('created_at', None)
        self.updated_at = kwargs.get('updated_at', None)
        self.accessed_at = kwargs.get('accessed_at', None)
        self.support_ordering = kwargs.get('support_ordering', None)
        self.message_count_details = kwargs.get('message_count_details', None)
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.enable_express = kwargs.get('enable_express', None)
        self.forward_dead_lettered_messages_to = kwargs.get('forward_dead_lettered_messages_to', None)


class QueueDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying queues.

    :param base: Base URL for the query.
    :type base: str
    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the queue.
    :type title: object
    :param published: The timestamp for when this queue was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this queue was last updated.
    :type updated: ~datetime.datetime
    :param author: The author that created this resource.
    :type author: ~azure.servicebus.management._generated.models.ResponseAuthor
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The QueueDescription.
    :type content: ~azure.servicebus.management._generated.models.QueueDescriptionEntryContent
    """

    _attribute_map = {
        'base': {'key': 'base', 'type': 'str', 'xml': {'name': 'base', 'attr': True, 'prefix': 'xml'}},
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'author': {'key': 'author', 'type': 'ResponseAuthor'},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'QueueDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueDescriptionEntry, self).__init__(**kwargs)
        self.base = kwargs.get('base', None)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.published = kwargs.get('published', None)
        self.updated = kwargs.get('updated', None)
        self.author = kwargs.get('author', None)
        self.link = kwargs.get('link', None)
        self.content = kwargs.get('content', None)


class QueueDescriptionEntryContent(msrest.serialization.Model):
    """The QueueDescription.

    :param type: Type of content in queue response.
    :type type: str
    :param queue_description: Description of a Service Bus queue resource.
    :type queue_description: ~azure.servicebus.management._generated.models.QueueDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'queue_description': {'key': 'QueueDescription', 'type': 'QueueDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueDescriptionEntryContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.queue_description = kwargs.get('queue_description', None)


class QueueDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus queues.

    :param id: URL of the list queues query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Queue entries.
    :type entry: list[~azure.servicebus.management._generated.models.QueueDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[QueueDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueDescriptionFeed, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.updated = kwargs.get('updated', None)
        self.link = kwargs.get('link', None)
        self.entry = kwargs.get('entry', None)


class ResponseAuthor(msrest.serialization.Model):
    """The author that created this resource.

    :param name: The Service Bus namespace.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
    }
    _xml_map = {
        'name': 'author', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseAuthor, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class ResponseLink(msrest.serialization.Model):
    """The URL for the HTTP request.

    :param href: The URL of the GET request.
    :type href: str
    :param rel: What the link href is relative to.
    :type rel: str
    """

    _attribute_map = {
        'href': {'key': 'href', 'type': 'str', 'xml': {'attr': True}},
        'rel': {'key': 'rel', 'type': 'str', 'xml': {'attr': True}},
    }
    _xml_map = {
        'name': 'link', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseLink, self).__init__(**kwargs)
        self.href = kwargs.get('href', None)
        self.rel = kwargs.get('rel', None)


class RuleDescription(msrest.serialization.Model):
    """RuleDescription.

    :param filter:
    :type filter: ~azure.servicebus.management._generated.models.RuleFilter
    :param action:
    :type action: ~azure.servicebus.management._generated.models.RuleAction
    :param created_at: The exact time the rule was created.
    :type created_at: ~datetime.datetime
    :param name:
    :type name: str
    """

    _attribute_map = {
        'filter': {'key': 'filter', 'type': 'RuleFilter'},
        'action': {'key': 'action', 'type': 'RuleAction'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601', 'xml': {'name': 'CreatedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'name': {'key': 'name', 'type': 'str', 'xml': {'name': 'Name', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'RuleDescription', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleDescription, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.action = kwargs.get('action', None)
        self.created_at = kwargs.get('created_at', None)
        self.name = kwargs.get('name', None)


class RuleDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying rules.

    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the rule.
    :type title: object
    :param published: The timestamp for when this rule was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this rule was last updated.
    :type updated: ~datetime.datetime
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The RuleDescription.
    :type content: ~azure.servicebus.management._generated.models.RuleDescriptionEntryContent
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'RuleDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleDescriptionEntry, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.published = kwargs.get('published', None)
        self.updated = kwargs.get('updated', None)
        self.link = kwargs.get('link', None)
        self.content = kwargs.get('content', None)


class RuleDescriptionEntryContent(msrest.serialization.Model):
    """The RuleDescription.

    :param type: Type of content in rule response.
    :type type: str
    :param rule_description:
    :type rule_description: ~azure.servicebus.management._generated.models.RuleDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'rule_description': {'key': 'RuleDescription', 'type': 'RuleDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleDescriptionEntryContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.rule_description = kwargs.get('rule_description', None)


class RuleDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus rules.

    :param id: URL of the list rules query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Rules entries.
    :type entry: list[~azure.servicebus.management._generated.models.RuleDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[RuleDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleDescriptionFeed, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.updated = kwargs.get('updated', None)
        self.link = kwargs.get('link', None)
        self.entry = kwargs.get('entry', None)


class ServiceBusManagementError(msrest.serialization.Model):
    """The error response from Service Bus.

    :param code: The service error code.
    :type code: int
    :param detail: The service error message.
    :type detail: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'int', 'xml': {'name': 'Code'}},
        'detail': {'key': 'detail', 'type': 'str', 'xml': {'name': 'Detail'}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceBusManagementError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.detail = kwargs.get('detail', None)


class SqlRuleAction(RuleAction):
    """SqlRuleAction.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    :param compatibility_level:
    :type compatibility_level: str
    :param parameters:
    :type parameters: list[~azure.servicebus.management._generated.models.KeyValue]
    :param requires_preprocessing:
    :type requires_preprocessing: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'sqlExpression', 'type': 'str', 'xml': {'name': 'SqlExpression', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'str', 'xml': {'name': 'CompatibilityLevel', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'parameters': {'key': 'parameters', 'type': '[KeyValue]', 'xml': {'name': 'Parameters', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'KeyValueOfstringanyType', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool', 'xml': {'name': 'RequiresPreprocessing', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlRuleAction, self).__init__(**kwargs)
        self.type = 'SqlRuleAction'
        self.sql_expression = kwargs.get('sql_expression', None)
        self.compatibility_level = kwargs.get('compatibility_level', "20")
        self.parameters = kwargs.get('parameters', None)
        self.requires_preprocessing = kwargs.get('requires_preprocessing', None)


class SubscriptionDescription(msrest.serialization.Model):
    """Description of a Service Bus subscription resource.

    :param lock_duration: ISO 8601 timespan duration of a peek-lock; that is, the amount of time
     that the message is locked for other receivers. The maximum value for LockDuration is 5
     minutes; the default value is 1 minute.
    :type lock_duration: ~datetime.timedelta
    :param requires_session: A value that indicates whether the subscription supports the concept
     of sessions.
    :type requires_session: bool
    :param default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param dead_lettering_on_message_expiration: A value that indicates whether this subscription
     has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param dead_lettering_on_filter_evaluation_exceptions: A value that indicates whether this
     subscription has dead letter support when a message expires.
    :type dead_lettering_on_filter_evaluation_exceptions: bool
    :param message_count: The number of messages in the subscription.
    :type message_count: int
    :param max_delivery_count: The maximum delivery count. A message is automatically deadlettered
     after this number of deliveries. Default value is 10.
    :type max_delivery_count: int
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param status: Status of a Service Bus resource. Possible values include: "Active", "Creating",
     "Deleting", "Disabled", "ReceiveDisabled", "Renaming", "Restoring", "SendDisabled", "Unknown".
    :type status: str or ~azure.servicebus.management._generated.models.EntityStatus
    :param forward_to: The name of the recipient entity to which all the messages sent to the
     subscription are forwarded to.
    :type forward_to: str
    :param created_at: The exact time the subscription was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The exact time a message was updated in the subscription.
    :type updated_at: ~datetime.datetime
    :param accessed_at: Last time a message was sent, or the last time there was a receive request
     to this subscription.
    :type accessed_at: ~datetime.datetime
    :param message_count_details: Details about the message counts in entity.
    :type message_count_details: ~azure.servicebus.management._generated.models.MessageCountDetails
    :param user_metadata: Metadata associated with the subscription. Maximum number of characters
     is 1024.
    :type user_metadata: str
    :param forward_dead_lettered_messages_to: The name of the recipient entity to which all the
     messages sent to the subscription are forwarded to.
    :type forward_dead_lettered_messages_to: str
    :param auto_delete_on_idle: ISO 8601 timeSpan idle interval after which the subscription is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param entity_availability_status: Availability status of the entity. Possible values include:
     "Available", "Limited", "Renaming", "Restoring", "Unknown".
    :type entity_availability_status: str or
     ~azure.servicebus.management._generated.models.EntityAvailabilityStatus
    """

    _attribute_map = {
        'lock_duration': {'key': 'lockDuration', 'type': 'duration', 'xml': {'name': 'LockDuration', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_session': {'key': 'requiresSession', 'type': 'bool', 'xml': {'name': 'RequiresSession', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'default_message_time_to_live': {'key': 'defaultMessageTimeToLive', 'type': 'duration', 'xml': {'name': 'DefaultMessageTimeToLive', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'dead_lettering_on_message_expiration': {'key': 'deadLetteringOnMessageExpiration', 'type': 'bool', 'xml': {'name': 'DeadLetteringOnMessageExpiration', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'dead_lettering_on_filter_evaluation_exceptions': {'key': 'deadLetteringOnFilterEvaluationExceptions', 'type': 'bool', 'xml': {'name': 'DeadLetteringOnFilterEvaluationExceptions', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count': {'key': 'messageCount', 'type': 'int', 'xml': {'name': 'MessageCount', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int', 'xml': {'name': 'MaxDeliveryCount', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_batched_operations': {'key': 'enableBatchedOperations', 'type': 'bool', 'xml': {'name': 'EnableBatchedOperations', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'status': {'key': 'status', 'type': 'str', 'xml': {'name': 'Status', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_to': {'key': 'forwardTo', 'type': 'str', 'xml': {'name': 'ForwardTo', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601', 'xml': {'name': 'CreatedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'updated_at': {'key': 'updatedAt', 'type': 'iso-8601', 'xml': {'name': 'UpdatedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'accessed_at': {'key': 'accessedAt', 'type': 'iso-8601', 'xml': {'name': 'AccessedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count_details': {'key': 'messageCountDetails', 'type': 'MessageCountDetails'},
        'user_metadata': {'key': 'userMetadata', 'type': 'str', 'xml': {'name': 'UserMetadata', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_dead_lettered_messages_to': {'key': 'forwardDeadLetteredMessagesTo', 'type': 'str', 'xml': {'name': 'ForwardDeadLetteredMessagesTo', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'auto_delete_on_idle': {'key': 'autoDeleteOnIdle', 'type': 'duration', 'xml': {'name': 'AutoDeleteOnIdle', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'entity_availability_status': {'key': 'entityAvailabilityStatus', 'type': 'str', 'xml': {'name': 'EntityAvailabilityStatus', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'SubscriptionDescription', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionDescription, self).__init__(**kwargs)
        self.lock_duration = kwargs.get('lock_duration', None)
        self.requires_session = kwargs.get('requires_session', None)
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.dead_lettering_on_filter_evaluation_exceptions = kwargs.get('dead_lettering_on_filter_evaluation_exceptions', None)
        self.message_count = kwargs.get('message_count', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.status = kwargs.get('status', None)
        self.forward_to = kwargs.get('forward_to', None)
        self.created_at = kwargs.get('created_at', None)
        self.updated_at = kwargs.get('updated_at', None)
        self.accessed_at = kwargs.get('accessed_at', None)
        self.message_count_details = kwargs.get('message_count_details', None)
        self.user_metadata = kwargs.get('user_metadata', None)
        self.forward_dead_lettered_messages_to = kwargs.get('forward_dead_lettered_messages_to', None)
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)


class SubscriptionDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying subscriptions.

    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the subscription.
    :type title: object
    :param published: The timestamp for when this subscription was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this subscription was last updated.
    :type updated: ~datetime.datetime
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The SubscriptionDescription.
    :type content:
     ~azure.servicebus.management._generated.models.SubscriptionDescriptionEntryContent
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'SubscriptionDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionDescriptionEntry, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.published = kwargs.get('published', None)
        self.updated = kwargs.get('updated', None)
        self.link = kwargs.get('link', None)
        self.content = kwargs.get('content', None)


class SubscriptionDescriptionEntryContent(msrest.serialization.Model):
    """The SubscriptionDescription.

    :param type: Type of content in subscription response.
    :type type: str
    :param subscription_description: Description of a Service Bus subscription resource.
    :type subscription_description:
     ~azure.servicebus.management._generated.models.SubscriptionDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'subscription_description': {'key': 'SubscriptionDescription', 'type': 'SubscriptionDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionDescriptionEntryContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.subscription_description = kwargs.get('subscription_description', None)


class SubscriptionDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus subscriptions.

    :param id: URL of the list subscriptions query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Subscription entries.
    :type entry: list[~azure.servicebus.management._generated.models.SubscriptionDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[SubscriptionDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionDescriptionFeed, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.updated = kwargs.get('updated', None)
        self.link = kwargs.get('link', None)
        self.entry = kwargs.get('entry', None)


class TopicDescription(msrest.serialization.Model):
    """Description of a Service Bus topic resource.

    :param default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param max_size_in_megabytes: The maximum size of the topic in megabytes, which is the size of
     memory allocated for the topic.
    :type max_size_in_megabytes: long
    :param requires_duplicate_detection: A value indicating if this topic requires duplicate
     detection.
    :type requires_duplicate_detection: bool
    :param duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :type duplicate_detection_history_time_window: ~datetime.timedelta
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param size_in_bytes: The size of the topic, in bytes.
    :type size_in_bytes: int
    :param filtering_messages_before_publishing: Filter messages before publishing.
    :type filtering_messages_before_publishing: bool
    :param is_anonymous_accessible: A value indicating if the resource can be accessed without
     authorization.
    :type is_anonymous_accessible: bool
    :param authorization_rules: Authorization rules for resource.
    :type authorization_rules:
     list[~azure.servicebus.management._generated.models.AuthorizationRule]
    :param status: Status of a Service Bus resource. Possible values include: "Active", "Creating",
     "Deleting", "Disabled", "ReceiveDisabled", "Renaming", "Restoring", "SendDisabled", "Unknown".
    :type status: str or ~azure.servicebus.management._generated.models.EntityStatus
    :param created_at: The exact time the topic was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The exact time a message was updated in the topic.
    :type updated_at: ~datetime.datetime
    :param accessed_at: Last time a message was sent, or the last time there was a receive request
     to this topic.
    :type accessed_at: ~datetime.datetime
    :param support_ordering: A value that indicates whether the topic supports ordering.
    :type support_ordering: bool
    :param message_count_details: Details about the message counts in entity.
    :type message_count_details: ~azure.servicebus.management._generated.models.MessageCountDetails
    :param subscription_count: The number of subscriptions in the topic.
    :type subscription_count: int
    :param auto_delete_on_idle: ISO 8601 timeSpan idle interval after which the topic is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param enable_partitioning: A value that indicates whether the topic is to be partitioned
     across multiple message brokers.
    :type enable_partitioning: bool
    :param entity_availability_status: Availability status of the entity. Possible values include:
     "Available", "Limited", "Renaming", "Restoring", "Unknown".
    :type entity_availability_status: str or
     ~azure.servicebus.management._generated.models.EntityAvailabilityStatus
    :param enable_subscription_partitioning: A value that indicates whether the topic's
     subscription is to be partitioned.
    :type enable_subscription_partitioning: bool
    :param enable_express: A value that indicates whether Express Entities are enabled. An express
     topic holds a message in memory temporarily before writing it to persistent storage.
    :type enable_express: bool
    :param user_metadata: Metadata associated with the topic.
    :type user_metadata: str
    """

    _attribute_map = {
        'default_message_time_to_live': {'key': 'defaultMessageTimeToLive', 'type': 'duration', 'xml': {'name': 'DefaultMessageTimeToLive', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_size_in_megabytes': {'key': 'maxSizeInMegabytes', 'type': 'long', 'xml': {'name': 'MaxSizeInMegabytes', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_duplicate_detection': {'key': 'requiresDuplicateDetection', 'type': 'bool', 'xml': {'name': 'RequiresDuplicateDetection', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'duplicate_detection_history_time_window': {'key': 'duplicateDetectionHistoryTimeWindow', 'type': 'duration', 'xml': {'name': 'DuplicateDetectionHistoryTimeWindow', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_batched_operations': {'key': 'enableBatchedOperations', 'type': 'bool', 'xml': {'name': 'EnableBatchedOperations', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'size_in_bytes': {'key': 'sizeInBytes', 'type': 'int', 'xml': {'name': 'SizeInBytes', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'filtering_messages_before_publishing': {'key': 'filteringMessagesBeforePublishing', 'type': 'bool', 'xml': {'name': 'FilteringMessagesBeforePublishing', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'is_anonymous_accessible': {'key': 'isAnonymousAccessible', 'type': 'bool', 'xml': {'name': 'IsAnonymousAccessible', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'authorization_rules': {'key': 'authorizationRules', 'type': '[AuthorizationRule]', 'xml': {'name': 'AuthorizationRules', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'AuthorizationRule', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'status': {'key': 'status', 'type': 'str', 'xml': {'name': 'Status', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601', 'xml': {'name': 'CreatedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'updated_at': {'key': 'updatedAt', 'type': 'iso-8601', 'xml': {'name': 'UpdatedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'accessed_at': {'key': 'accessedAt', 'type': 'iso-8601', 'xml': {'name': 'AccessedAt', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'support_ordering': {'key': 'supportOrdering', 'type': 'bool', 'xml': {'name': 'SupportOrdering', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count_details': {'key': 'messageCountDetails', 'type': 'MessageCountDetails'},
        'subscription_count': {'key': 'subscriptionCount', 'type': 'int', 'xml': {'name': 'SubscriptionCount', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'auto_delete_on_idle': {'key': 'autoDeleteOnIdle', 'type': 'duration', 'xml': {'name': 'AutoDeleteOnIdle', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_partitioning': {'key': 'enablePartitioning', 'type': 'bool', 'xml': {'name': 'EnablePartitioning', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'entity_availability_status': {'key': 'entityAvailabilityStatus', 'type': 'str', 'xml': {'name': 'EntityAvailabilityStatus', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_subscription_partitioning': {'key': 'enableSubscriptionPartitioning', 'type': 'bool', 'xml': {'name': 'EnableSubscriptionPartitioning', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_express': {'key': 'enableExpress', 'type': 'bool', 'xml': {'name': 'EnableExpress', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'user_metadata': {'key': 'userMetadata', 'type': 'str', 'xml': {'name': 'UserMetadata', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'TopicDescription', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicDescription, self).__init__(**kwargs)
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.size_in_bytes = kwargs.get('size_in_bytes', None)
        self.filtering_messages_before_publishing = kwargs.get('filtering_messages_before_publishing', None)
        self.is_anonymous_accessible = kwargs.get('is_anonymous_accessible', None)
        self.authorization_rules = kwargs.get('authorization_rules', None)
        self.status = kwargs.get('status', None)
        self.created_at = kwargs.get('created_at', None)
        self.updated_at = kwargs.get('updated_at', None)
        self.accessed_at = kwargs.get('accessed_at', None)
        self.support_ordering = kwargs.get('support_ordering', None)
        self.message_count_details = kwargs.get('message_count_details', None)
        self.subscription_count = kwargs.get('subscription_count', None)
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.enable_subscription_partitioning = kwargs.get('enable_subscription_partitioning', None)
        self.enable_express = kwargs.get('enable_express', None)
        self.user_metadata = kwargs.get('user_metadata', None)


class TopicDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying topics.

    :param base: Base URL for the query.
    :type base: str
    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the topic.
    :type title: object
    :param published: The timestamp for when this topic was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this topic was last updated.
    :type updated: ~datetime.datetime
    :param author: The author that created this resource.
    :type author: ~azure.servicebus.management._generated.models.ResponseAuthor
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The TopicDescription.
    :type content: ~azure.servicebus.management._generated.models.TopicDescriptionEntryContent
    """

    _attribute_map = {
        'base': {'key': 'base', 'type': 'str', 'xml': {'name': 'base', 'attr': True, 'prefix': 'xml'}},
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'author': {'key': 'author', 'type': 'ResponseAuthor'},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'TopicDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicDescriptionEntry, self).__init__(**kwargs)
        self.base = kwargs.get('base', None)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.published = kwargs.get('published', None)
        self.updated = kwargs.get('updated', None)
        self.author = kwargs.get('author', None)
        self.link = kwargs.get('link', None)
        self.content = kwargs.get('content', None)


class TopicDescriptionEntryContent(msrest.serialization.Model):
    """The TopicDescription.

    :param type: Type of content in topic response.
    :type type: str
    :param topic_description: Description of a Service Bus topic resource.
    :type topic_description: ~azure.servicebus.management._generated.models.TopicDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'topic_description': {'key': 'TopicDescription', 'type': 'TopicDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicDescriptionEntryContent, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.topic_description = kwargs.get('topic_description', None)


class TopicDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus topics.

    :param id: URL of the list topics query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Topic entries.
    :type entry: list[~azure.servicebus.management._generated.models.TopicDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[TopicDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopicDescriptionFeed, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.updated = kwargs.get('updated', None)
        self.link = kwargs.get('link', None)
        self.entry = kwargs.get('entry', None)


class TrueFilter(SqlFilter):
    """TrueFilter.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    :param compatibility_level:
    :type compatibility_level: str
    :param parameters:
    :type parameters: list[~azure.servicebus.management._generated.models.KeyValue]
    :param requires_preprocessing:
    :type requires_preprocessing: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'sqlExpression', 'type': 'str', 'xml': {'name': 'SqlExpression', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'str', 'xml': {'name': 'CompatibilityLevel', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'parameters': {'key': 'parameters', 'type': '[KeyValue]', 'xml': {'name': 'Parameters', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'KeyValueOfstringanyType', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool', 'xml': {'name': 'RequiresPreprocessing', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrueFilter, self).__init__(**kwargs)
        self.type = 'TrueFilter'
