% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exprfilter.R
\name{exprfilter}
\alias{exprfilter}
\title{subset ballgown objects using an expression filter}
\usage{
exprfilter(gown, cutoff, meas = "FPKM")
}
\arguments{
\item{gown}{a ballgown object}

\item{cutoff}{transcripts must have mean expression across samples above this
value to be included in the return}

\item{meas}{how should transcript expression be measured? Default FPKM, but 
can also be \code{'cov'}.}
}
\value{
A new ballgown object derived from \code{gown}, but only containing 
  transcripts (and associated exons/introns) with mean \code{meas} greater
  than \code{cutoff} across all samples.
}
\description{
Create a new ballgown object containing only transcripts passing
  a mean expression filter
}
\examples{
  data(bg)
  # make a ballgown object containing only transcripts with mean FPKM > 100:
  over100 = exprfilter(bg, cutoff=100)  

}
\seealso{
\code{\link{subset}}
}
