% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_kmers.R
\name{plotKmerFrequencyCorrelation}
\alias{plotKmerFrequencyCorrelation}
\title{Display correlation between pentemer proportions in two time windows}
\usage{
plotKmerFrequencyCorrelation(summaryData, kmerLength = 5,
  groupedMinutes = 10, only2D = TRUE)
}
\arguments{
\item{summaryData}{Object of class \linkS4class{Fast5Summary}.}

\item{kmerLength}{Specifies the length of kmers to compare. Defaults to 5 
given the current pentamer reading nature of the nanopores.}

\item{groupedMinutes}{Defines how many minutes each grouping of reads spans.}

\item{only2D}{Logical. If TRUE kmers are computed for only full 2D reads.
If FALSE 2D reads are ignored and all available template and complement 
strands are used.}
}
\value{
Returns an object of class \code{gg} representing the plot.
}
\description{
Plots
}
\examples{
if( require(minionSummaryData) ) {
   data(s.typhi.rep3, package = 'minionSummaryData')
   plotKmerFrequencyCorrelation( s.typhi.rep3, only2D = FALSE )
}
}
