% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSNNGraph.R
\name{clusterSNNGraph}
\alias{clusterSNNGraph}
\alias{clusterSNNGraph,ANY-method}
\alias{clusterSNNGraph,SummarizedExperiment-method}
\alias{clusterSNNGraph,SingleCellExperiment-method}
\alias{clusterKNNGraph}
\alias{clusterKNNGraph,ANY-method}
\alias{clusterKNNGraph,SummarizedExperiment-method}
\alias{clusterKNNGraph,SingleCellExperiment-method}
\title{Wrappers for graph-based clustering}
\usage{
clusterSNNGraph(x, ...)

\S4method{clusterSNNGraph}{ANY}(
  x,
  ...,
  clusterFUN = cluster_walktrap,
  subset.row = NULL,
  transposed = FALSE,
  use.kmeans = FALSE,
  kmeans.centers = NULL,
  kmeans.args = list(),
  full.stats = FALSE
)

\S4method{clusterSNNGraph}{SummarizedExperiment}(x, ..., assay.type = "logcounts")

\S4method{clusterSNNGraph}{SingleCellExperiment}(x, ..., use.dimred = NULL)

clusterKNNGraph(x, ...)

\S4method{clusterKNNGraph}{ANY}(
  x,
  ...,
  clusterFUN = cluster_walktrap,
  subset.row = NULL,
  transposed = FALSE,
  use.kmeans = FALSE,
  kmeans.centers = NULL,
  kmeans.args = list(),
  full.stats = FALSE
)

\S4method{clusterKNNGraph}{SummarizedExperiment}(x, ..., assay.type = "logcounts")

\S4method{clusterKNNGraph}{SingleCellExperiment}(x, ..., use.dimred = NULL)
}
\arguments{
\item{x}{A matrix-like object containing expression values for each gene (row) in each cell (column).
These dimensions can be transposed if \code{transposed=TRUE}.

Alternatively, a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} containing such an expression matrix.
If \code{x} is a SingleCellExperiment and \code{use.dimred} is set, its \code{\link{reducedDims}} will be used instead.}

\item{...}{For the generics, additional arguments to pass to the specific methods.

For the ANY methods, additional arguments to pass to \code{\link{buildSNNGraph}} or \code{\link{buildKNNGraph}}.

For the SummarizedExperiment method, additional arguments to pass to the corresponding ANY method.

For the SingleCellExperiment method, additional arguments to pass to the corresponding SummarizedExperiment method.}

\item{clusterFUN}{Function that can take a \link{graph} object and return a \link{communities} object,
see examples in the \pkg{igraph} package.}

\item{subset.row}{See \code{?"\link{scran-gene-selection}"}.
Only used when \code{transposed=FALSE}.}

\item{transposed}{A logical scalar indicating whether \code{x} is transposed (i.e., rows are cells).}

\item{use.kmeans}{Logical scalar indicating whether k-means clustering should be performed.}

\item{kmeans.centers}{Integer scalar specifying the number of clusters to use for k-means clustering.
Defaults to the square root of the number of cells in \code{x}.}

\item{kmeans.args}{List containing additional named arguments to pass to \code{\link{kmeans}}.}

\item{full.stats}{Logical scalar indicating whether to return more statistics regarding the k-means clustering.}

\item{assay.type}{A string specifying which assay values to use.}

\item{use.dimred}{A string specifying whether existing values in \code{reducedDims(x)} should be used.}
}
\value{
If \code{full.stats=FALSE}, a factor is returned containing the cluster assignment for each cell.

If \code{full.stats=TRUE} and \code{use.kmeans=TRUE}, a \linkS4class{DataFrame} is returned with one row per cell.
This contains the columns \code{kmeans}, specifying the assignment of each cell to a k-means cluster;
and \code{igraph}, specifying the assignment of each cell to a graph-based cluster operating on the k-means clusters.
In addition, the \code{\link{metadata}} contains \code{graph}, a \link{graph} object where each node is a k-means cluster;
and \code{membership}, the graph-based cluster to which each node is assigned.
}
\description{
Perform graph-based clustering using community detection methods on a nearest-neighbor graph,
where nodes represent cells or k-means centroids.
This has been deprecated in favor of directly using \code{\link{clusterRows}} from the \pkg{bluster} package,
with \code{BLUSPARAM} set to \code{\link{NNGraphParam}()} or \code{\link{TwoStepParam}()}.
}
\details{
We suggest using the \code{\link{clusterRows}} functionality instead as it provides a more general interface to clustering.
\itemize{
\item \code{clusterSNNGraph(x)} for a matrix-like object \code{x} is equivalent to 
\code{clusterRows(t(x), NNGraphParam())}.
\item \code{clusterKNNGraph(x)} for a matrix-like object \code{x} is equivalent to 
\code{clusterRows(t(x), NNGraphParam(shared=FALSE))}.
\item \code{clusterSNNGraph(x)} for a SummarizedExperiment object \code{x} is equivalent to 
\code{clusterRows(t(logcounts(x)), NNGraphParam())}.
\item \code{clusterSNNGraph(x, use.dimred="PCA")} for a SingleCellExperiment object \code{x} is equivalent to 
\code{clusterRows(reducedDim(x, "PCA"), NNGraphParam())}.
\item \code{clusterSNNGraph(x, use.kmeans=TRUE, use.dimred="PCA")} for a SingleCellExperiment object \code{x} is equivalent to 
\code{clusterRows(reducedDim(x, "PCA"), TwoStepParam())}.
}
}
\examples{
library(scuttle)
sce <- mockSCE(ncells=500)
sce <- logNormCounts(sce)

clusters <- clusterSNNGraph(sce)
table(clusters)

# Can pass usual arguments to buildSNNGraph:
clusters2 <- clusterSNNGraph(sce, k=5)
table(clusters2)

# Works with low-dimensional inputs:
sce <- scater::runPCA(sce, ncomponents=10)
clusters3 <- clusterSNNGraph(sce, use.dimred="PCA")
table(clusters3)

# Turn on k-means for larger datasets, e.g., 
# assuming we already have a PCA result:
set.seed(101010)
bigpc <- matrix(rnorm(2000000), ncol=20)
clusters4 <- clusterSNNGraph(bigpc, d=NA, use.kmeans=TRUE, transposed=TRUE)
table(clusters4)

# Extract the graph for more details:
clusters5 <- clusterSNNGraph(sce, use.dimred="PCA", 
    use.kmeans=TRUE, full.stats=TRUE)
head(clusters5)
metadata(clusters5)$graph

}
\seealso{
\code{\link{clusterRows}} with \code{BLUSPARAM} set to an instance of \linkS4class{NNGraphParam} or \linkS4class{TwoStepParam}.
}
\author{
Aaron Lun
}
