% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BhaduriOrganoidData.R
\name{BhaduriOrganoidData}
\alias{BhaduriOrganoidData}
\title{Obtain the Bhaduri cortical organoid data}
\usage{
BhaduriOrganoidData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of normalized expression values.
}
\description{
Obtain the human cortical organoid single-cell RNA-seq dataset from Bhaduri et al. (2020).
}
\details{
Column data contains sample-level information.
In theory, there is also cell-level metadata for this dataset but it could not be unambiguously mapped to the column names.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/bhaduri-organoid}.
}
\examples{
if (.Machine$sizeof.pointer > 4) { # too large for 32-bit machines!
    sce <- BhaduriOrganoidData()
}
}
\references{
Bhaduri A et al. (2020). 
Cell stress in cortical organoids impairs molecular subtype specification.
\emph{Nature} 578(7793), 142-148.
}
\author{
Aaron Lun
}
