% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-uncount.R
\name{dbplyr_uncount}
\alias{dbplyr_uncount}
\title{"Uncount" a database table}
\usage{
dbplyr_uncount(data, weights, .remove = TRUE, .id = NULL)
}
\arguments{
\item{data}{A lazy data frame backed by a database query.}

\item{weights}{A vector of weights. Evaluated in the context of \code{data};
supports quasiquotation.}

\item{.remove}{If \code{TRUE}, and \code{weights} is the name of a column in \code{data},
then this column is removed.}

\item{.id}{Supply a string to create a new variable which gives a unique
identifier for each created row.}
}
\description{
This is a method for the tidyr \code{uncount()} generic. It uses a temporary
table, so your database user needs permissions to create one.
}
\examples{
df <- memdb_frame(x = c("a", "b"), n = c(1, 2))
dbplyr_uncount(df, n)
dbplyr_uncount(df, n, .id = "id")

# You can also use constants
dbplyr_uncount(df, 2)

# Or expressions
dbplyr_uncount(df, 2 / n)
}
