% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_basis.R
\name{as_tibble.basis}
\alias{as_tibble.basis}
\title{Convert a spline basis to a tibble}
\usage{
\method{as_tibble}{basis}(x, ...)
}
\arguments{
\item{x}{object of class "basis"}

\item{...}{Ignored.}
}
\value{
A tibble constructed from the underlying matrix of the
    basis object. Each column will possess all the attributes from
    the source object, except that the "class" attribute will be
    renamed to "basis.class" to avoid interfering with dplyr
    operations.
}
\description{
Convert a spline basis to a tibble
}
\details{
This function is needed because the default method for
    converting a matrix object with an additional class attribute
    to a tibble causes issues because each column of the resulting
    tibble has the attributes, including the matrix class, copied
    from the source. Having matrices as columns in a tibble causes
    dplyr to throw errors, so a special method is needed to avoid
    copying the class attribute.
}
\examples{
\dontrun{
library(splines)
library(tibble)
x <- seq(0, 1, by=0.001)
spl <- bs(x, df=6)
as_tibble(spl)
}
}
