% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Objective_gaussian_weight.R
\docType{data}
\name{gaussian_weight}
\alias{gaussian_weight}
\alias{gaussian_weight.estimate.hook}
\alias{gaussian_weight_method.lvm}
\alias{gaussian_weight_logLik.lvm}
\alias{gaussian_weight_objective.lvm}
\alias{gaussian_weight_score.lvm}
\alias{gaussian_weight_gradient.lvm}
\alias{gaussian_weight_hessian.lvm}
\title{Estimate LVM With Weights}
\format{
An object of class \code{character} of length 1.
}
\usage{
gaussian_weight.estimate.hook(x, data, estimator, ...)

gaussian_weight_method.lvm

gaussian_weight_logLik.lvm(object, type = "cond", p, data, weights, ...)

gaussian_weight_objective.lvm(x, ...)

gaussian_weight_score.lvm(
  x,
  data,
  p,
  S,
  n,
  mu = NULL,
  weights = NULL,
  debug = FALSE,
  reindex = FALSE,
  mean = TRUE,
  constrain = TRUE,
  indiv = FALSE,
  ...
)

gaussian_weight_gradient.lvm(...)

gaussian_weight_hessian.lvm(x, p, n, weights = NULL, ...)
}
\arguments{
\item{x, object}{A latent variable model}

\item{data}{dataset}

\item{estimator}{name of the estimator to be used}

\item{...}{passed to lower level functions.}

\item{type}{must be "cond"}

\item{p}{parameter value}

\item{weights}{weight associated to each iid replicate.}

\item{S}{empirical variance-covariance matrix between variable}

\item{n}{number of iid replicates}

\item{mu}{empirical mean}

\item{debug, reindex, mean, constrain, indiv}{additional arguments not used}
}
\description{
Estimate LVM with weights.
}
\examples{
#### linear regression with weights ####

## data
df <- data.frame(Y = c(1,2,2,1,2),
                 X = c(1,1,2,2,2),
                 missing = c(0,0,0,0,1),
                 weights = c(1,1,2,1,NA))

## using lm
e.lm.GS <- lm(Y~X, data = df)
e.lm.test <- lm(Y~X, data = df[df$missing==0,], weights = df[df$missing==0,"weights"])

## using lvm
m <- lvm(Y~X)
e.GS <- estimate(m, df)
## e.lava.test <- estimate(m, df[df$missing==0,], weights = df[df$missing==0,"weights"])
## warnings!!
e.test <- estimate(m, data = df[df$missing==0,],
                   weights = df[df$missing==0,"weights"],
                   estimator = "gaussian_weight")

}
\keyword{datasets}
