% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_ring.R
\name{use_ring}
\alias{use_ring}
\title{Set Macaulay2 ring}
\usage{
use_ring(ring)
}
\arguments{
\item{ring}{a \code{m2_ring} (see \code{\link[=ring]{ring()}}),
\code{m2_ring_pointer} (see \code{\link[=ring.]{ring.()}}), or a character
string containing the name of a ring in Macaulay2}
}
\description{
\code{use_ring()} sets the default referent ring on the Macaulay2
side using the \code{use} function.
}
\examples{

\dontrun{ requires Macaulay2


##### basic usage
########################################

ring("x", coefring = "QQ")
factor_poly("x^4 + 1")

QQtxyz <- ring("t","x","y","z", coefring = "QQ")
gb("t^4 - x", "t^3 - y", "t^2 - z")

ring("x", "y", "z", "t", coefring = "QQ")
gb("t^4 - x", "t^3 - y", "t^2 - z")

use_ring(QQtxyz)
gb("t^4 - x", "t^3 - y", "t^2 - z")

}
}
