% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.R
\name{sim.cox}
\alias{sim.cox}
\alias{read.fit}
\alias{sim.base}
\alias{simulate.cox}
\title{Simulation of output from Cox model.}
\usage{
sim.cox(cox,n,data=NULL,cens=NULL,rrc=NULL,entry=NULL,...)
}
\arguments{
\item{cox}{output form coxph or cox.aalen model fitting cox model.}

\item{n}{number of simulations.}

\item{data}{to extract covariates for simulations (draws from observed
covariates).}

\item{cens}{specifies censoring model, if "is.matrix" then uses cumulative
hazard given, if "is.scalar" then uses rate for exponential, and if not
given then takes average rate of in simulated data from cox model.}

\item{rrc}{possible vector of relative risk for cox-type censoring.}

\item{entry}{delayed entry variable for simulation.}

\item{...}{arguments for rchaz, for example entry-time}
}
\description{
Simulates data that looks like fit from Cox model. Censor data automatically
for highest value of the event times by using cumulative hazard.
}
\examples{

data(sTRACE)
cox <-  coxph(Surv(time,status==9)~vf+chf+wmi,data=sTRACE)
sim1 <- sim.cox(cox,1000,data=sTRACE)
cc <- coxph(Surv(time,status)~vf+chf+wmi,data=sim1)
cbind(cox$coef,cc$coef)

cor(sim1[,c("vf","chf","wmi")])
cor(sTRACE[,c("vf","chf","wmi")])

cox <-  phreg(Surv(time, status==9)~vf+chf+wmi,data=sTRACE)
sim3 <- sim.cox(cox,1000,data=sTRACE)
cc <-  phreg(Surv(time, status)~vf+chf+wmi,data=sim3)
cbind(cox$coef,cc$coef)
plot(cox,se=TRUE)
plot(cc,add=TRUE,col=2)

cox <-  phreg(Surv(time,status==9)~strata(chf)+vf+wmi,data=sTRACE)
sim3 <- sim.cox(cox,100,data=sTRACE)
cc <-   phreg(Surv(time, status)~strata(chf)+vf+wmi,data=sim3)
cbind(cox$coef,cc$coef)
plot(cox)
plot(cc,add=TRUE,col=2)

}
\author{
Thomas Scheike
}
\keyword{survival}
