% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgbp.R
\name{sgbp}
\alias{sgbp}
\alias{print.sgbp}
\alias{t.sgbp}
\alias{as.matrix.sgbp}
\alias{dim.sgbp}
\alias{Ops.sgbp}
\alias{as.data.frame.sgbp}
\title{Methods for dealing with sparse geometry binary predicate lists}
\usage{
\method{print}{sgbp}(x, ..., n = 10, max_nb = 10)

\method{t}{sgbp}(x)

\method{as.matrix}{sgbp}(x, ...)

\method{dim}{sgbp}(x)

\method{Ops}{sgbp}(e1, e2)

\method{as.data.frame}{sgbp}(x, ...)
}
\arguments{
\item{x}{object of class \code{sgbp}}

\item{...}{ignored}

\item{n}{integer; maximum number of items to print}

\item{max_nb}{integer; maximum number of neighbours to print for each item}

\item{e1}{object of class \code{sgbp}}

\item{e2}{object of class \code{sgbp}}
}
\description{
Methods for dealing with sparse geometry binary predicate lists
}
\details{
\code{sgbp} are sparse matrices, stored as a list with integer vectors holding the ordered \code{TRUE} indices of each row. This means that for a dense, \eqn{m \times n}{m x n} matrix \code{Q} and a list \code{L}, if \code{Q[i,j]} is \code{TRUE} then \eqn{j} is an element of \code{L[[i]]}. Reversed: when \eqn{k} is the value of \code{L[[i]][j]}, then \code{Q[i,k]} is \code{TRUE}.

\code{==} compares only the dimension and index values, not the attributes of two \code{sgbp} object; use \code{identical} to check for equality of everything.
}
