#lang racket/base
(provide (all-defined-out))

(define WM_NULL                         #x0000)
(define WM_CREATE                       #x0001)
(define WM_DESTROY                      #x0002)
(define WM_MOVE                         #x0003)
(define WM_SIZE                         #x0005)

(define WM_ACTIVATE                     #x0006)


;; WM_ACTIVATE state values
(define     WA_INACTIVE     0)
(define     WA_ACTIVE       1)
(define     WA_CLICKACTIVE  2)

(define WM_SETFOCUS                     #x0007)
(define WM_KILLFOCUS                    #x0008)
(define WM_ENABLE                       #x000A)
(define WM_SETREDRAW                    #x000B)
(define WM_SETTEXT                      #x000C)
(define WM_GETTEXT                      #x000D)
(define WM_GETTEXTLENGTH                #x000E)
(define WM_PAINT                        #x000F)
(define WM_CLOSE                        #x0010)
(define WM_QUIT                         #x0012)
(define WM_ERASEBKGND                   #x0014)
(define WM_SYSCOLORCHANGE               #x0015)
(define WM_SHOWWINDOW                   #x0018)
(define WM_WININICHANGE                 #x001A)
(define WM_SETTINGCHANGE                WM_WININICHANGE)

(define WM_DEVMODECHANGE                #x001B)
(define WM_ACTIVATEAPP                  #x001C)
(define WM_FONTCHANGE                   #x001D)
(define WM_TIMECHANGE                   #x001E)
(define WM_CANCELMODE                   #x001F)
(define WM_SETCURSOR                    #x0020)
(define WM_MOUSEACTIVATE                #x0021)
(define WM_CHILDACTIVATE                #x0022)
(define WM_QUEUESYNC                    #x0023)

(define WM_GETMINMAXINFO                #x0024)

(define WM_PAINTICON                    #x0026)
(define WM_ICONERASEBKGND               #x0027)
(define WM_NEXTDLGCTL                   #x0028)
(define WM_SPOOLERSTATUS                #x002A)
(define WM_DRAWITEM                     #x002B)
(define WM_MEASUREITEM                  #x002C)
(define WM_DELETEITEM                   #x002D)
(define WM_VKEYTOITEM                   #x002E)
(define WM_CHARTOITEM                   #x002F)
(define WM_SETFONT                      #x0030)
(define WM_GETFONT                      #x0031)
(define WM_SETHOTKEY                    #x0032)
(define WM_GETHOTKEY                    #x0033)
(define WM_QUERYDRAGICON                #x0037)
(define WM_COMPAREITEM                  #x0039)
(define WM_GETOBJECT                    #x003D)
(define WM_COMPACTING                   #x0041)
(define WM_WINDOWPOSCHANGING            #x0046)
(define WM_WINDOWPOSCHANGED             #x0047)

(define WM_POWER                        #x0048)

(define WM_GESTURE                      #x0119)

;; wParam for WM_POWER window message and DRV_POWER driver notification
(define PWR_OK              1)
(define PWR_FAIL            -1)
(define PWR_SUSPENDREQUEST  1)
(define PWR_SUSPENDRESUME   2)
(define PWR_CRITICALRESUME  3)

(define WM_COPYDATA                     #x004A)
(define WM_CANCELJOURNAL                #x004B)

(define WM_NOTIFY                       #x004E)
(define WM_INPUTLANGCHANGEREQUEST       #x0050)
(define WM_INPUTLANGCHANGE              #x0051)
(define WM_TCARD                        #x0052)
(define WM_HELP                         #x0053)
(define WM_USERCHANGED                  #x0054)
(define WM_NOTIFYFORMAT                 #x0055)

(define NFR_ANSI                             1)
(define NFR_UNICODE                          2)
(define NF_QUERY                             3)
(define NF_REQUERY                           4)

(define WM_CONTEXTMENU                  #x007B)
(define WM_STYLECHANGING                #x007C)
(define WM_STYLECHANGED                 #x007D)
(define WM_DISPLAYCHANGE                #x007E)
(define WM_GETICON                      #x007F)
(define WM_SETICON                      #x0080)

(define WM_NCCREATE                     #x0081)
(define WM_NCDESTROY                    #x0082)
(define WM_NCCALCSIZE                   #x0083)
(define WM_NCHITTEST                    #x0084)
(define WM_NCPAINT                      #x0085)
(define WM_NCACTIVATE                   #x0086)
(define WM_GETDLGCODE                   #x0087)
(define WM_NCMOUSEMOVE                  #x00A0)
(define WM_NCLBUTTONDOWN                #x00A1)
(define WM_NCLBUTTONUP                  #x00A2)
(define WM_NCLBUTTONDBLCLK              #x00A3)
(define WM_NCRBUTTONDOWN                #x00A4)
(define WM_NCRBUTTONUP                  #x00A5)
(define WM_NCRBUTTONDBLCLK              #x00A6)
(define WM_NCMBUTTONDOWN                #x00A7)
(define WM_NCMBUTTONUP                  #x00A8)
(define WM_NCMBUTTONDBLCLK              #x00A9)

(define WM_NCXBUTTONDOWN                #x00AB)
(define WM_NCXBUTTONUP                  #x00AC)
(define WM_NCXBUTTONDBLCLK              #x00AD)

(define WM_INPUT                        #x00FF)

(define WM_KEYFIRST                     #x0100)
(define WM_KEYDOWN                      #x0100)
(define WM_KEYUP                        #x0101)
(define WM_CHAR                         #x0102)
(define WM_DEADCHAR                     #x0103)
(define WM_SYSKEYDOWN                   #x0104)
(define WM_SYSKEYUP                     #x0105)
(define WM_SYSCHAR                      #x0106)
(define WM_SYSDEADCHAR                  #x0107)
(define WM_UNICHAR                      #x0109)
(define WM_KEYLAST                      #x0109)
(define UNICODE_NOCHAR                  #xFFFF)

(define WM_IME_STARTCOMPOSITION         #x010D)
(define WM_IME_ENDCOMPOSITION           #x010E)
(define WM_IME_COMPOSITION              #x010F)
(define WM_IME_KEYLAST                  #x010F)

(define WM_INITDIALOG                   #x0110)
(define WM_COMMAND                      #x0111)
(define WM_SYSCOMMAND                   #x0112)
(define WM_TIMER                        #x0113)
(define WM_HSCROLL                      #x0114)
(define WM_VSCROLL                      #x0115)
(define WM_INITMENU                     #x0116)
(define WM_INITMENUPOPUP                #x0117)
(define WM_MENUSELECT                   #x011F)
(define WM_MENUCHAR                     #x0120)
(define WM_ENTERIDLE                    #x0121)
(define WM_MENURBUTTONUP                #x0122)
(define WM_MENUDRAG                     #x0123)
(define WM_MENUGETOBJECT                #x0124)
(define WM_UNINITMENUPOPUP              #x0125)
(define WM_MENUCOMMAND                  #x0126)

(define WM_CHANGEUISTATE                #x0127)
(define WM_UPDATEUISTATE                #x0128)
(define WM_QUERYUISTATE                 #x0129)

;; LOWORD(wParam) values in WM_*UISTATE*
(define UIS_SET                         1)
(define UIS_CLEAR                       2)
(define UIS_INITIALIZE                  3)

;; HIWORD(wParam) values in WM_*UISTATE*
(define UISF_HIDEFOCUS                  #x1)
(define UISF_HIDEACCEL                  #x2)
(define UISF_ACTIVE                     #x4)

(define WM_CTLCOLORMSGBOX               #x0132)
(define WM_CTLCOLOREDIT                 #x0133)
(define WM_CTLCOLORLISTBOX              #x0134)
(define WM_CTLCOLORBTN                  #x0135)
(define WM_CTLCOLORDLG                  #x0136)
(define WM_CTLCOLORSCROLLBAR            #x0137)
(define WM_CTLCOLORSTATIC               #x0138)
(define MN_GETHMENU                     #x01E1)

(define WM_MOUSEFIRST                   #x0200)
(define WM_MOUSEMOVE                    #x0200)
(define WM_LBUTTONDOWN                  #x0201)
(define WM_LBUTTONUP                    #x0202)
(define WM_LBUTTONDBLCLK                #x0203)
(define WM_RBUTTONDOWN                  #x0204)
(define WM_RBUTTONUP                    #x0205)
(define WM_RBUTTONDBLCLK                #x0206)
(define WM_MBUTTONDOWN                  #x0207)
(define WM_MBUTTONUP                    #x0208)
(define WM_MBUTTONDBLCLK                #x0209)
(define WM_MOUSEWHEEL                   #x020A)
(define WM_XBUTTONDOWN                  #x020B)
(define WM_XBUTTONUP                    #x020C)
(define WM_XBUTTONDBLCLK                #x020D)
(define WM_MOUSEHWHEEL                  #x020E)

;; Value for rolling one detent
(define WHEEL_DELTA                     120)
;; (define WHEEL_PAGESCROLL                UINT_MAX)

;; XButton values are WORD flags
(define XBUTTON1      #x0001)
(define XBUTTON2      #x0002)

(define WM_PARENTNOTIFY                 #x0210)
(define WM_ENTERMENULOOP                #x0211)
(define WM_EXITMENULOOP                 #x0212)

(define WM_NEXTMENU                     #x0213)
(define WM_SIZING                       #x0214)
(define WM_CAPTURECHANGED               #x0215)
(define WM_MOVING                       #x0216)

(define WM_DEVICECHANGE                 #x0219)

(define WM_MDICREATE                    #x0220)
(define WM_MDIDESTROY                   #x0221)
(define WM_MDIACTIVATE                  #x0222)
(define WM_MDIRESTORE                   #x0223)
(define WM_MDINEXT                      #x0224)
(define WM_MDIMAXIMIZE                  #x0225)
(define WM_MDITILE                      #x0226)
(define WM_MDICASCADE                   #x0227)
(define WM_MDIICONARRANGE               #x0228)
(define WM_MDIGETACTIVE                 #x0229)


(define WM_MDISETMENU                   #x0230)
(define WM_ENTERSIZEMOVE                #x0231)
(define WM_EXITSIZEMOVE                 #x0232)
(define WM_DROPFILES                    #x0233)
(define WM_MDIREFRESHMENU               #x0234)


(define WM_IME_SETCONTEXT               #x0281)
(define WM_IME_NOTIFY                   #x0282)
(define WM_IME_CONTROL                  #x0283)
(define WM_IME_COMPOSITIONFULL          #x0284)
(define WM_IME_SELECT                   #x0285)
(define WM_IME_CHAR                     #x0286)
(define WM_IME_REQUEST                  #x0288)
(define WM_IME_KEYDOWN                  #x0290)
(define WM_IME_KEYUP                    #x0291)

(define WM_MOUSEHOVER                   #x02A1)
(define WM_MOUSELEAVE                   #x02A3)
(define WM_NCMOUSEHOVER                 #x02A0)
(define WM_NCMOUSELEAVE                 #x02A2)

(define WM_WTSSESSION_CHANGE            #x02B1)

(define WM_TABLET_FIRST                 #x02c0)
(define WM_TABLET_LAST                  #x02df)

(define WM_CUT                          #x0300)
(define WM_COPY                         #x0301)
(define WM_PASTE                        #x0302)
(define WM_CLEAR                        #x0303)
(define WM_UNDO                         #x0304)
(define WM_RENDERFORMAT                 #x0305)
(define WM_RENDERALLFORMATS             #x0306)
(define WM_DESTROYCLIPBOARD             #x0307)
(define WM_DRAWCLIPBOARD                #x0308)
(define WM_PAINTCLIPBOARD               #x0309)
(define WM_VSCROLLCLIPBOARD             #x030A)
(define WM_SIZECLIPBOARD                #x030B)
(define WM_ASKCBFORMATNAME              #x030C)
(define WM_CHANGECBCHAIN                #x030D)
(define WM_HSCROLLCLIPBOARD             #x030E)
(define WM_QUERYNEWPALETTE              #x030F)
(define WM_PALETTEISCHANGING            #x0310)
(define WM_PALETTECHANGED               #x0311)
(define WM_HOTKEY                       #x0312)

(define WM_USER                         #x0400)

;; Class styles
(define CS_VREDRAW          #x0001)
(define CS_HREDRAW          #x0002)
(define CS_DBLCLKS          #x0008)
(define CS_OWNDC            #x0020)
(define CS_CLASSDC          #x0040)
(define CS_PARENTDC         #x0080)
(define CS_NOCLOSE          #x0200)
(define CS_SAVEBITS         #x0800)
(define CS_BYTEALIGNCLIENT  #x1000)
(define CS_BYTEALIGNWINDOW  #x2000)
(define CS_GLOBALCLASS      #x4000)

;; Window styles
(define WS_OVERLAPPED   #x00000000)
(define WS_POPUP        #x80000000)
(define WS_CHILD        #x40000000)
(define WS_CLIPSIBLINGS #x04000000)
(define WS_CLIPCHILDREN #x02000000)
(define WS_VISIBLE      #x10000000)
(define WS_DISABLED     #x08000000)
(define WS_MINIMIZE     #x20000000)
(define WS_MAXIMIZE     #x01000000)
(define WS_CAPTION      #x00C00000)
(define WS_BORDER       #x00800000)
(define WS_DLGFRAME     #x00400000)
(define WS_VSCROLL      #x00200000)
(define WS_HSCROLL      #x00100000)
(define WS_SYSMENU      #x00080000)
(define WS_THICKFRAME   #x00040000)
(define WS_MINIMIZEBOX  #x00020000)
(define WS_MAXIMIZEBOX  #x00010000)
(define WS_GROUP        #x00020000)
(define WS_TABSTOP      #x00010000)

(define WS_OVERLAPPEDWINDOW (bitwise-ior WS_OVERLAPPED  WS_CAPTION  WS_SYSMENU 
					 WS_THICKFRAME  WS_MINIMIZEBOX  WS_MAXIMIZEBOX))

(define PM_NOREMOVE         #x0000)
(define PM_REMOVE           #x0001)
(define PM_NOYIELD          #x0002)

(define QS_KEY              #x0001)
(define QS_MOUSEMOVE        #x0002)
(define QS_MOUSEBUTTON      #x0004)
(define QS_POSTMESSAGE      #x0008)
(define QS_TIMER            #x0010)
(define QS_PAINT            #x0020)
(define QS_SENDMESSAGE      #x0040)
(define QS_HOTKEY           #x0080)
(define QS_ALLPOSTMESSAGE   #x0100)
(define QS_RAWINPUT         #x0400)
(define QS_MOUSE           (bitwise-ior QS_MOUSEMOVE
                                        QS_MOUSEBUTTON))

(define QS_INPUT           (bitwise-ior QS_MOUSE
                                        QS_KEY
                                        QS_RAWINPUT))
(define QS_ALLEVENTS       (bitwise-ior QS_INPUT
                                        QS_POSTMESSAGE
                                        QS_TIMER
                                        QS_PAINT
                                        QS_HOTKEY))

(define QS_ALLINPUT        (bitwise-ior QS_INPUT
                                        QS_POSTMESSAGE
                                        QS_TIMER
                                        QS_PAINT
                                        QS_HOTKEY
                                        QS_SENDMESSAGE))

(define GWL_STYLE           -16)
(define GWLP_WNDPROC        -4)
(define GWLP_USERDATA       -21)


(define COLOR_SCROLLBAR         0)
(define COLOR_BACKGROUND        1)
(define COLOR_ACTIVECAPTION     2)
(define COLOR_INACTIVECAPTION   3)
(define COLOR_MENU              4)
(define COLOR_WINDOW            5)
(define COLOR_WINDOWFRAME       6)
(define COLOR_MENUTEXT          7)
(define COLOR_WINDOWTEXT        8)
(define COLOR_CAPTIONTEXT       9)
(define COLOR_ACTIVEBORDER      10)
(define COLOR_INACTIVEBORDER    11)
(define COLOR_APPWORKSPACE      12)
(define COLOR_HIGHLIGHT         13)
(define COLOR_HIGHLIGHTTEXT     14)
(define COLOR_BTNFACE           15)
(define COLOR_BTNSHADOW         16)
(define COLOR_GRAYTEXT          17)
(define COLOR_BTNTEXT           18)
(define COLOR_INACTIVECAPTIONTEXT 19)
(define COLOR_BTNHIGHLIGHT      20)

(define BS_PUSHBUTTON       #x00000000)
(define BS_DEFPUSHBUTTON    #x00000001)
(define BS_CHECKBOX         #x00000002)
(define BS_AUTOCHECKBOX     #x00000003)
(define BS_RADIOBUTTON      #x00000004)
(define BS_3STATE           #x00000005)
(define BS_AUTO3STATE       #x00000006)
(define BS_GROUPBOX         #x00000007)
(define BS_USERBUTTON       #x00000008)
(define BS_AUTORADIOBUTTON  #x00000009)
(define BS_PUSHBOX          #x0000000A)
(define BS_OWNERDRAW        #x0000000B)
(define BS_TYPEMASK         #x0000000F)
(define BS_LEFTTEXT         #x00000020)
(define BS_TEXT             #x00000000)
(define BS_ICON             #x00000040)
(define BS_BITMAP           #x00000080)
(define BS_LEFT             #x00000100)
(define BS_RIGHT            #x00000200)
(define BS_CENTER           #x00000300)
(define BS_TOP              #x00000400)
(define BS_BOTTOM           #x00000800)
(define BS_VCENTER          #x00000C00)
(define BS_PUSHLIKE         #x00001000)
(define BS_MULTILINE        #x00002000)
(define BS_NOTIFY           #x00004000)
(define BS_FLAT             #x00008000)
(define BS_RIGHTBUTTON      BS_LEFTTEXT)

(define CW_USEDEFAULT       (- #x80000000)) ; minus sign => int instead of uint

(define WS_EX_LAYERED       #x00080000)
(define WS_EX_TRANSPARENT   #x00000020)

(define LWA_ALPHA #x00000002)

(define MB_OK                       #x00000000)
(define MB_OKCANCEL                 #x00000001)
(define MB_ABORTRETRYIGNORE         #x00000002)
(define MB_YESNOCANCEL              #x00000003)
(define MB_YESNO                    #x00000004)
(define MB_RETRYCANCEL              #x00000005)

(define SIZE_RESTORED       0)
(define SIZE_MINIMIZED      1)
(define SIZE_MAXIMIZED      2)
(define SIZE_MAXSHOW        3)
(define SIZE_MAXHIDE        4)

(define SB_LINEUP           0)
(define SB_LINELEFT         0)
(define SB_LINEDOWN         1)
(define SB_LINERIGHT        1)
(define SB_PAGEUP           2)
(define SB_PAGELEFT         2)
(define SB_PAGEDOWN         3)
(define SB_PAGERIGHT        3)
(define SB_THUMBPOSITION    4)
(define SB_THUMBTRACK       5)
(define SB_TOP              6)
(define SB_LEFT             6)
(define SB_BOTTOM           7)
(define SB_RIGHT            7)
(define SB_ENDSCROLL        8)

(define SB_HORZ             0)
(define SB_VERT             1)
(define SB_CTL              2)
(define SB_BOTH             3)

(define SIF_RANGE           #x0001)
(define SIF_PAGE            #x0002)
(define SIF_POS             #x0004)
(define SIF_DISABLENOSCROLL #x0008)
(define SIF_TRACKPOS        #x0010)
(define SIF_ALL             (bitwise-ior SIF_RANGE SIF_PAGE SIF_POS SIF_TRACKPOS))

(define VK_LBUTTON        #x01)
(define VK_RBUTTON        #x02)
(define VK_CANCEL         #x03)
(define VK_MBUTTON        #x04)
(define VK_XBUTTON1       #x05)
(define VK_XBUTTON2       #x06)
(define VK_BACK           #x08)
(define VK_TAB            #x09)
(define VK_CLEAR          #x0C)
(define VK_RETURN         #x0D)
(define VK_SHIFT          #x10)
(define VK_CONTROL        #x11)
(define VK_MENU           #x12)
(define VK_PAUSE          #x13)
(define VK_CAPITAL        #x14)
(define VK_KANA           #x15)
(define VK_HANGUL         #x15)
(define VK_JUNJA          #x17)
(define VK_FINAL          #x18)
(define VK_HANJA          #x19)
(define VK_KANJI          #x19)
(define VK_ESCAPE         #x1B)
(define VK_CONVERT        #x1C)
(define VK_NONCONVERT     #x1D)
(define VK_ACCEPT         #x1E)
(define VK_MODECHANGE     #x1F)
(define VK_SPACE          #x20)
(define VK_PRIOR          #x21)
(define VK_NEXT           #x22)
(define VK_END            #x23)
(define VK_HOME           #x24)
(define VK_LEFT           #x25)
(define VK_UP             #x26)
(define VK_RIGHT          #x27)
(define VK_DOWN           #x28)
(define VK_SELECT         #x29)
(define VK_PRINT          #x2A)
(define VK_EXECUTE        #x2B)
(define VK_SNAPSHOT       #x2C)
(define VK_INSERT         #x2D)
(define VK_DELETE         #x2E)
(define VK_HELP           #x2F)
(define VK_LWIN           #x5B)
(define VK_RWIN           #x5C)
(define VK_APPS           #x5D)
(define VK_SLEEP          #x5F)
(define VK_NUMPAD0        #x60)
(define VK_NUMPAD1        #x61)
(define VK_NUMPAD2        #x62)
(define VK_NUMPAD3        #x63)
(define VK_NUMPAD4        #x64)
(define VK_NUMPAD5        #x65)
(define VK_NUMPAD6        #x66)
(define VK_NUMPAD7        #x67)
(define VK_NUMPAD8        #x68)
(define VK_NUMPAD9        #x69)
(define VK_MULTIPLY       #x6A)
(define VK_ADD            #x6B)
(define VK_SEPARATOR      #x6C)
(define VK_SUBTRACT       #x6D)
(define VK_DECIMAL        #x6E)
(define VK_DIVIDE         #x6F)
(define VK_F1             #x70)
(define VK_F2             #x71)
(define VK_F3             #x72)
(define VK_F4             #x73)
(define VK_F5             #x74)
(define VK_F6             #x75)
(define VK_F7             #x76)
(define VK_F8             #x77)
(define VK_F9             #x78)
(define VK_F10            #x79)
(define VK_F11            #x7A)
(define VK_F12            #x7B)
(define VK_F13            #x7C)
(define VK_F14            #x7D)
(define VK_F15            #x7E)
(define VK_F16            #x7F)
(define VK_F17            #x80)
(define VK_F18            #x81)
(define VK_F19            #x82)
(define VK_F20            #x83)
(define VK_F21            #x84)
(define VK_F22            #x85)
(define VK_F23            #x86)
(define VK_F24            #x87)
(define VK_NUMLOCK        #x90)
(define VK_SCROLL         #x91)
(define VK_LSHIFT         #xA0)
(define VK_RSHIFT         #xA1)
(define VK_LCONTROL       #xA2)
(define VK_RCONTROL       #xA3)
(define VK_LMENU          #xA4)
(define VK_RMENU          #xA5)
(define VK_OEM_1          #xBA)
(define VK_OEM_PLUS       #xBB)
(define VK_OEM_COMMA      #xBC)
(define VK_OEM_MINUS      #xBD)
(define VK_OEM_PERIOD     #xBE)
(define VK_OEM_2          #xBF)
(define VK_OEM_3          #xC0)
(define VK_OEM_4          #xDB)
(define VK_OEM_5          #xDC)
(define VK_OEM_6          #xDD)
(define VK_OEM_7          #xDE)
(define VK_OEM_8          #xDF)

(define KF_EXTENDED       #x0100)
(define KF_DLGMODE        #x0800)
(define KF_MENUMODE       #x1000)
(define KF_ALTDOWN        #x2000)
(define KF_REPEAT         #x4000)
(define KF_UP             #x8000)

(define GW_HWNDFIRST        0)
(define GW_HWNDLAST         1)
(define GW_HWNDNEXT         2)
(define GW_HWNDPREV         3)
(define GW_OWNER            4)
(define GW_CHILD            5)

(define MF_INSERT           #x00000000)
(define MF_CHANGE           #x00000080)
(define MF_APPEND           #x00000100)
(define MF_DELETE           #x00000200)
(define MF_REMOVE           #x00001000)
(define MF_BYCOMMAND        #x00000000)
(define MF_BYPOSITION       #x00000400)
(define MF_SEPARATOR        #x00000800)
(define MF_ENABLED          #x00000000)
(define MF_GRAYED           #x00000001)
(define MF_DISABLED         #x00000002)
(define MF_UNCHECKED        #x00000000)
(define MF_CHECKED          #x00000008)
(define MF_USECHECKBITMAPS  #x00000200)
(define MF_STRING           #x00000000)
(define MF_BITMAP           #x00000004)
(define MF_OWNERDRAW        #x00000100)
(define MF_POPUP            #x00000010)
(define MF_MENUBARBREAK     #x00000020)
(define MF_MENUBREAK        #x00000040)
(define MF_UNHILITE         #x00000000)
(define MF_HILITE           #x00000080)

(define BM_SETIMAGE        #x00F7)
(define IMAGE_BITMAP        0)
(define BN_CLICKED          0)

(define SW_SHOW 5)
(define SW_HIDE 0)
(define SW_SHOWNORMAL       1)
(define SW_SHOWMINIMIZED    2)
(define SW_SHOWMAXIMIZED    3)
(define SW_MAXIMIZE         3)
(define SW_SHOWNOACTIVATE   4)
(define SW_MINIMIZE         6)
(define SW_SHOWMINNOACTIVE  7)
(define SW_RESTORE          9)
(define SW_SHOWDEFAULT      10)
(define SW_FORCEMINIMIZE    11)

(define HORZRES       8)
(define VERTRES       10)
(define LOGPIXELSX    88)
(define LOGPIXELSY    90)

(define CBS_DROPDOWNLIST #x0003)
(define CB_INSERTSTRING #x014A)
(define CB_SETCURSEL #x014E)
(define CB_GETCURSEL #x0147)
(define CB_ADDSTRING #x0143)
(define CB_DELETESTRING #x0144)
(define CB_RESETCONTENT #x014B)

(define CBN_SELENDOK 9)
(define CBN_DROPDOWN        7)
(define CBN_CLOSEUP         8)
(define CBN_SELENDCANCEL    10)
