/*******************************************************************************
 * SAT4J: a SATisfiability library for Java Copyright (C) 2004, 2012 Artois University and CNRS
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU Lesser General Public License Version 2.1 or later (the
 * "LGPL"), in which case the provisions of the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of the LGPL, and not to allow others to use your version of
 * this file under the terms of the EPL, indicate your decision by deleting
 * the provisions above and replace them with the notice and other provisions
 * required by the LGPL. If you do not delete the provisions above, a recipient
 * may use your version of this file under the terms of the EPL or the LGPL.
 *
 * Based on the original MiniSat specification from:
 *
 * An extensible SAT solver. Niklas Een and Niklas Sorensson. Proceedings of the
 * Sixth International Conference on Theory and Applications of Satisfiability
 * Testing, LNCS 2919, pp 502-518, 2003.
 *
 * See www.minisat.se for the original solver in C++.
 *
 * Contributors:
 *   CRIL - initial API and implementation
 *******************************************************************************/

package org.sat4j.pb.constraints;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ISolver;

/**
 * @author leberre
 * 
 *         To change the template for this generated type comment go to
 *         Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class AbstractPigeonHoleWithCardinalityTest<T extends ISolver>
        extends AbstractAcceptanceTestCase {

    protected static final String PREFIX = System.getProperty("test.pbprefix");

    /**
     * Cr?ation d'un test
     * 
     * @param arg
     *            argument ?ventuel
     */
    public AbstractPigeonHoleWithCardinalityTest(String arg) {
        super(arg);
    }

    public void testPN34()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertTrue(solveInstance(PREFIX + "pigeons/PN-3-4.opb"));
    }

    public void testPN4()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertFalse(solveInstance(PREFIX + "pigeons/PN-4-3.opb"));
    }

    public void testPN45()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertTrue(solveInstance(PREFIX + "pigeons/PN-4-5.opb"));
    }

    public void testPN5()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertFalse(solveInstance(PREFIX + "pigeons/PN-5-4.opb"));
    }

    public void testPN56()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertTrue(solveInstance(PREFIX + "pigeons/PN-5-6.opb"));
    }

    public void testPN6()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertFalse(solveInstance(PREFIX + "pigeons/PN-6-5.opb"));
    }

    public void testPN67()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertTrue(solveInstance(PREFIX + "pigeons/PN-6-7.opb"));
    }

    public void testPN7()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertFalse(solveInstance(PREFIX + "pigeons/PN-7-6.opb"));
    }

    public void testPN78()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertTrue(solveInstance(PREFIX + "pigeons/PN-7-8.opb"));
    }

    public void testPN8()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertFalse(solveInstance(PREFIX + "pigeons/PN-8-7.opb"));
    }

    public void testPN89()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertTrue(solveInstance(PREFIX + "pigeons/PN-8-9.opb"));
    }

    public void testPN9()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertFalse(solveInstance(PREFIX + "pigeons/PN-9-8.opb"));
    }

    public void testPN910()
            throws FileNotFoundException, IOException, ParseFormatException {
        assertTrue(solveInstance(PREFIX + "pigeons/PN-9-10.opb"));
    }
}
