/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.ZipOutput;

public class JarWriter
implements DataEntryWriter {
    private final byte[] header;
    private final int modificationTime;
    private final DataEntryWriter dataEntryWriter;
    private DataEntry currentParentEntry;
    private ZipOutput currentZipOutput;

    public JarWriter(DataEntryWriter dataEntryWriter) {
        this(null, dataEntryWriter);
    }

    public JarWriter(byte[] byArray, DataEntryWriter dataEntryWriter) {
        this(byArray, JarWriter.currentTime(), dataEntryWriter);
    }

    public JarWriter(byte[] byArray, int n, DataEntryWriter dataEntryWriter) {
        this.header = byArray;
        this.modificationTime = n;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        this.setUp(dataEntry);
        if (this.currentZipOutput == null) {
            return false;
        }
        String string = dataEntry.getName() + '/';
        OutputStream outputStream = this.currentZipOutput.createOutputStream(string, false, this.modificationTime);
        outputStream.close();
        return true;
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        return dataEntry != null && dataEntry2 != null && dataEntry.getName().equals(dataEntry2.getName()) && this.dataEntryWriter.sameOutputStream(dataEntry.getParent(), dataEntry2.getParent());
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        this.setUp(dataEntry);
        if (this.currentZipOutput == null) {
            return null;
        }
        return this.currentZipOutput.createOutputStream(dataEntry.getName(), true, this.modificationTime);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        printWriter.println(string + "JarWriter");
        this.dataEntryWriter.println(printWriter, string + "  ");
    }

    protected void setUp(DataEntry dataEntry) throws IOException {
        if (this.currentZipOutput == null) {
            this.currentParentEntry = dataEntry.getParent();
            this.currentZipOutput = new ZipOutput(this.dataEntryWriter.createOutputStream(this.currentParentEntry), this.header, null, 1);
        }
    }

    private void finishIfNecessary(DataEntry dataEntry) throws IOException {
        if (this.currentParentEntry != null && !this.dataEntryWriter.sameOutputStream(this.currentParentEntry, dataEntry.getParent())) {
            this.finish();
        }
    }

    protected void finish() throws IOException {
        if (this.currentZipOutput != null) {
            this.currentZipOutput.close();
            this.currentParentEntry = null;
            this.currentZipOutput = null;
        }
    }

    private static int currentTime() {
        Date date = new Date();
        return date.getYear() - 80 << 25 | date.getMonth() + 1 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }
}

