/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.KeyValuePair;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.BufferObject;
import sleep.bridges.io.DataPattern;
import sleep.bridges.io.FileObject;
import sleep.bridges.io.IOObject;
import sleep.bridges.io.ProcessObject;
import sleep.bridges.io.SocketObject;
import sleep.engine.types.ObjectValue;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class BasicIO
implements Loadable,
Function {
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        hashtable.put("__EXEC__", TaintUtils.Tainter(TaintUtils.Sensitive(this)));
        hashtable.put("-eof", new iseof());
        hashtable.put("&openf", TaintUtils.Sensitive(new openf()));
        SocketFuncs socketFuncs = new SocketFuncs();
        hashtable.put("&connect", TaintUtils.Sensitive(socketFuncs));
        hashtable.put("&listen", socketFuncs);
        hashtable.put("&exec", TaintUtils.Sensitive(new exec()));
        hashtable.put("&fork", new fork());
        hashtable.put("&allocate", this);
        hashtable.put("&sleep", new sleep());
        hashtable.put("&closef", new closef());
        hashtable.put("&read", new read());
        hashtable.put("&readln", TaintUtils.Tainter(new readln()));
        hashtable.put("&readAll", TaintUtils.Tainter(new readAll()));
        hashtable.put("&readc", TaintUtils.Tainter(this));
        hashtable.put("&readb", TaintUtils.Tainter(new readb()));
        hashtable.put("&consume", new consume());
        hashtable.put("&writeb", new writeb());
        hashtable.put("&bread", TaintUtils.Tainter(new bread()));
        hashtable.put("&bwrite", new bwrite());
        hashtable.put("&readObject", TaintUtils.Tainter(this));
        hashtable.put("&writeObject", this);
        hashtable.put("&readAsObject", TaintUtils.Tainter(this));
        hashtable.put("&writeAsObject", this);
        hashtable.put("&sizeof", this);
        hashtable.put("&pack", new pack());
        hashtable.put("&unpack", new unpack());
        hashtable.put("&available", new available());
        hashtable.put("&mark", new mark());
        hashtable.put("&skip", hashtable.get("&consume"));
        hashtable.put("&reset", new reset());
        hashtable.put("&wait", this);
        hashtable.put("&print", new print());
        hashtable.put("&setEncoding", this);
        println println2 = new println();
        hashtable.put("&println", println2);
        hashtable.put("&printf", println2);
        hashtable.put("&printAll", new printArray());
        hashtable.put("&printEOF", new printEOF());
        hashtable.put("&getConsole", new getConsoleObject());
        hashtable.put("&checksum", this);
        hashtable.put("&digest", this);
    }

    private static Checksum getChecksum(String string) {
        if (string.equals("Adler32")) {
            return new Adler32();
        }
        if (string.equals("CRC32")) {
            return new CRC32();
        }
        return null;
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&wait")) {
            IOObject iOObject = (IOObject)BridgeUtilities.getObject(stack);
            long l = BridgeUtilities.getLong(stack, 0L);
            return iOObject.wait(scriptInstance.getScriptEnvironment(), l);
        }
        if (string.equals("__EXEC__")) {
            Scalar scalar = SleepUtils.getArrayScalar();
            try {
                Process process = Runtime.getRuntime().exec(BridgeUtilities.getString(stack, ""), null, scriptInstance.cwd());
                IOObject iOObject = SleepUtils.getIOHandle(process.getInputStream(), null);
                String string2 = null;
                while ((string2 = iOObject.readLine()) != null) {
                    scalar.getArray().push(SleepUtils.getScalar(string2));
                }
                if (process.waitFor() != 0) {
                    scriptInstance.getScriptEnvironment().flagError("abnormal termination: " + process.exitValue());
                }
            }
            catch (Exception exception) {
                scriptInstance.getScriptEnvironment().flagError(exception);
            }
            return scalar;
        }
        if (string.equals("&writeObject") || string.equals("&writeAsObject")) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            while (!stack.isEmpty()) {
                Scalar scalar = (Scalar)stack.pop();
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(iOObject.getWriter());
                    if (string.equals("&writeAsObject")) {
                        objectOutputStream.writeObject(scalar.objectValue());
                        continue;
                    }
                    objectOutputStream.writeObject(scalar);
                }
                catch (Exception exception) {
                    scriptInstance.getScriptEnvironment().flagError(exception);
                    iOObject.close();
                }
            }
        } else if (string.equals("&readObject") || string.equals("&readAsObject")) {
            IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(iOObject.getReader());
                if (string.equals("&readAsObject")) {
                    return SleepUtils.getScalar(objectInputStream.readObject());
                }
                Scalar scalar = (Scalar)objectInputStream.readObject();
                return scalar;
            }
            catch (EOFException eOFException) {
                iOObject.close();
            }
            catch (Exception exception) {
                scriptInstance.getScriptEnvironment().flagError(exception);
                iOObject.close();
            }
        } else {
            if (string.equals("&allocate")) {
                int n = BridgeUtilities.getInt(stack, 32768);
                BufferObject bufferObject = new BufferObject();
                bufferObject.allocate(n);
                return SleepUtils.getScalar(bufferObject);
            }
            if (string.equals("&digest")) {
                Scalar scalar = BridgeUtilities.getScalar(stack);
                if (scalar.objectValue() != null && scalar.objectValue() instanceof IOObject) {
                    boolean bl = true;
                    String string3 = BridgeUtilities.getString(stack, "MD5");
                    if (string3.charAt(0) == '>') {
                        bl = false;
                        string3 = string3.substring(1);
                    }
                    IOObject iOObject = (IOObject)scalar.objectValue();
                    try {
                        if (bl) {
                            DigestInputStream digestInputStream = new DigestInputStream(iOObject.getInputStream(), MessageDigest.getInstance(string3));
                            iOObject.openRead(digestInputStream);
                            return SleepUtils.getScalar(digestInputStream.getMessageDigest());
                        }
                        DigestOutputStream digestOutputStream = new DigestOutputStream(iOObject.getOutputStream(), MessageDigest.getInstance(string3));
                        iOObject.openWrite(digestOutputStream);
                        return SleepUtils.getScalar(digestOutputStream.getMessageDigest());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        scriptInstance.getScriptEnvironment().flagError(noSuchAlgorithmException);
                    }
                } else {
                    if (scalar.objectValue() != null && scalar.objectValue() instanceof MessageDigest) {
                        MessageDigest messageDigest = (MessageDigest)scalar.objectValue();
                        return SleepUtils.getScalar(messageDigest.digest());
                    }
                    String string4 = scalar.toString();
                    String string5 = BridgeUtilities.getString(stack, "MD5");
                    try {
                        MessageDigest messageDigest = MessageDigest.getInstance(string5);
                        messageDigest.update(BridgeUtilities.toByteArrayNoConversion(string4), 0, string4.length());
                        return SleepUtils.getScalar(messageDigest.digest());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        scriptInstance.getScriptEnvironment().flagError(noSuchAlgorithmException);
                    }
                }
                return SleepUtils.getEmptyScalar();
            }
            if (string.equals("&sizeof")) {
                return SleepUtils.getScalar(DataPattern.EstimateSize(BridgeUtilities.getString(stack, "")));
            }
            if (string.equals("&setEncoding")) {
                IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
                String string6 = BridgeUtilities.getString(stack, "");
                try {
                    iOObject.setEncoding(string6);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("&setEncoding: specified a non-existent encoding '" + string6 + "'");
                }
            } else {
                if (string.equals("&readc")) {
                    IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
                    return SleepUtils.getScalar(iOObject.readCharacter());
                }
                if (string.equals("&checksum")) {
                    Scalar scalar = BridgeUtilities.getScalar(stack);
                    if (scalar.objectValue() != null && scalar.objectValue() instanceof IOObject) {
                        boolean bl = true;
                        String string7 = BridgeUtilities.getString(stack, "CRC32");
                        if (string7.charAt(0) == '>') {
                            bl = false;
                            string7 = string7.substring(1);
                        }
                        IOObject iOObject = (IOObject)scalar.objectValue();
                        if (bl) {
                            CheckedInputStream checkedInputStream = new CheckedInputStream(iOObject.getInputStream(), BasicIO.getChecksum(string7));
                            iOObject.openRead(checkedInputStream);
                            return SleepUtils.getScalar(checkedInputStream.getChecksum());
                        }
                        CheckedOutputStream checkedOutputStream = new CheckedOutputStream(iOObject.getOutputStream(), BasicIO.getChecksum(string7));
                        iOObject.openWrite(checkedOutputStream);
                        return SleepUtils.getScalar(checkedOutputStream.getChecksum());
                    }
                    if (scalar.objectValue() != null && scalar.objectValue() instanceof Checksum) {
                        Checksum checksum = (Checksum)scalar.objectValue();
                        return SleepUtils.getScalar(checksum.getValue());
                    }
                    String string8 = scalar.toString();
                    String string9 = BridgeUtilities.getString(stack, "CRC32");
                    Checksum checksum = BasicIO.getChecksum(string9);
                    checksum.update(BridgeUtilities.toByteArrayNoConversion(string8), 0, string8.length());
                    return SleepUtils.getScalar(checksum.getValue());
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    private static IOObject chooseSource(Stack stack, int n, ScriptInstance scriptInstance) {
        if (stack.size() < n && !stack.isEmpty()) {
            Scalar scalar = (Scalar)stack.peek();
            if (scalar.getActualValue() != null && scalar.getActualValue().getType() == ObjectValue.class && scalar.objectValue() instanceof IOObject) {
                stack.pop();
                return (IOObject)scalar.objectValue();
            }
        } else if (stack.size() >= n) {
            Scalar scalar = (Scalar)stack.pop();
            if (!(scalar.objectValue() instanceof IOObject)) {
                throw new IllegalArgumentException("expected I/O handle argument, received: " + SleepUtils.describe(scalar));
            }
            return (IOObject)scalar.objectValue();
        }
        return IOObject.getConsole(scriptInstance.getScriptEnvironment());
    }

    private static Scalar ReadFormatted(String string, InputStream inputStream, ScriptEnvironment scriptEnvironment, IOObject iOObject) {
        Scalar scalar = SleepUtils.getArrayScalar();
        DataPattern dataPattern = DataPattern.Parse(string);
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = 0;
        while (dataPattern != null) {
            int n2;
            byteBuffer.order(dataPattern.order);
            if (dataPattern.value == 'M') {
                if (dataPattern.count == 1) {
                    dataPattern.count = 10240;
                }
                inputStream.mark(dataPattern.count);
            } else if (dataPattern.value == 'x') {
                try {
                    inputStream.skip(dataPattern.count);
                }
                catch (Exception exception) {}
            } else if (dataPattern.value == 'h' || dataPattern.value == 'H') {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    for (n2 = 0; n2 < dataPattern.count || dataPattern.count == -1; ++n2) {
                        n = inputStream.read(byArray, 0, 1);
                        if (n < 1) {
                            throw new EOFException();
                        }
                        int n3 = (byteBuffer.get(0) & 0xF0) >> 4;
                        int n4 = byteBuffer.get(0) & 0xF;
                        if (dataPattern.value == 'h') {
                            stringBuffer.append(Integer.toHexString(n4));
                            stringBuffer.append(Integer.toHexString(n3));
                            continue;
                        }
                        stringBuffer.append(Integer.toHexString(n3));
                        stringBuffer.append(Integer.toHexString(n4));
                    }
                }
                catch (Exception exception) {
                    if (iOObject != null) {
                        iOObject.close();
                    }
                    scalar.getArray().push(SleepUtils.getScalar(stringBuffer.toString()));
                    return scalar;
                }
                scalar.getArray().push(SleepUtils.getScalar(stringBuffer.toString()));
            } else if (dataPattern.value == 'z' || dataPattern.value == 'Z' || dataPattern.value == 'U' || dataPattern.value == 'u') {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    int n5;
                    if (dataPattern.value == 'u' || dataPattern.value == 'U') {
                        n = inputStream.read(byArray, 0, 2);
                        if (n < 2) {
                            throw new EOFException();
                        }
                        n2 = byteBuffer.getChar(0);
                    } else {
                        n2 = inputStream.read();
                        if (n2 == -1) {
                            throw new EOFException();
                        }
                    }
                    for (n5 = 1; n2 != 0 && n5 != dataPattern.count; ++n5) {
                        stringBuffer.append((char)n2);
                        if (dataPattern.value == 'u' || dataPattern.value == 'U') {
                            n = inputStream.read(byArray, 0, 2);
                            if (n < 2) {
                                throw new EOFException();
                            }
                            n2 = byteBuffer.getChar(0);
                            continue;
                        }
                        n2 = inputStream.read();
                        if (n2 != -1) continue;
                        throw new EOFException();
                    }
                    if (n2 != 0) {
                        stringBuffer.append((char)n2);
                    }
                    if ((dataPattern.value == 'Z' || dataPattern.value == 'U') && n5 < dataPattern.count) {
                        int n6 = (dataPattern.count - n5) * (dataPattern.value == 'U' ? 2 : 1);
                        inputStream.skip(n6);
                    }
                }
                catch (Exception exception) {
                    if (iOObject != null) {
                        iOObject.close();
                    }
                    scalar.getArray().push(SleepUtils.getScalar(stringBuffer.toString()));
                    return scalar;
                }
                scalar.getArray().push(SleepUtils.getScalar(stringBuffer.toString()));
            } else {
                for (int i = 0; i != dataPattern.count; ++i) {
                    Scalar scalar2 = null;
                    try {
                        switch (dataPattern.value) {
                            case 'R': {
                                inputStream.reset();
                                break;
                            }
                            case 'C': {
                                n = inputStream.read(byArray, 0, 1);
                                if (n < 1) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar((char)byArray[0] + "");
                                break;
                            }
                            case 'c': {
                                n = inputStream.read(byArray, 0, 2);
                                if (n < 2) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(byteBuffer.getChar(0) + "");
                                break;
                            }
                            case 'b': {
                                byArray[0] = (byte)inputStream.read();
                                if (byArray[0] == -1) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar((int)byArray[0]);
                                break;
                            }
                            case 'B': {
                                n = inputStream.read();
                                if (n == -1) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(n);
                                break;
                            }
                            case 's': {
                                n = inputStream.read(byArray, 0, 2);
                                if (n < 2) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(byteBuffer.getShort(0));
                                break;
                            }
                            case 'S': {
                                n = inputStream.read(byArray, 0, 2);
                                if (n < 2) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(byteBuffer.getShort(0) & 0xFFFF);
                                break;
                            }
                            case 'i': {
                                n = inputStream.read(byArray, 0, 4);
                                if (n < 4) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(byteBuffer.getInt(0));
                                break;
                            }
                            case 'I': {
                                n = inputStream.read(byArray, 0, 4);
                                if (n < 4) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar((long)byteBuffer.getInt(0) & 0xFFFFFFFFL);
                                break;
                            }
                            case 'f': {
                                n = inputStream.read(byArray, 0, 4);
                                if (n < 4) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(byteBuffer.getFloat(0));
                                break;
                            }
                            case 'd': {
                                n = inputStream.read(byArray, 0, 8);
                                if (n < 8) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(byteBuffer.getDouble(0));
                                break;
                            }
                            case 'l': {
                                n = inputStream.read(byArray, 0, 8);
                                if (n < 8) {
                                    throw new EOFException();
                                }
                                scalar2 = SleepUtils.getScalar(byteBuffer.getLong(0));
                                break;
                            }
                            case 'o': {
                                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                                scalar2 = (Scalar)objectInputStream.readObject();
                                break;
                            }
                            default: {
                                scriptEnvironment.showDebugMessage("unknown file pattern character: " + dataPattern.value);
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (iOObject != null) {
                            iOObject.close();
                        }
                        if (scalar2 != null) {
                            scalar.getArray().push(scalar2);
                        }
                        return scalar;
                    }
                    if (scalar2 == null) continue;
                    scalar.getArray().push(scalar2);
                }
            }
            dataPattern = dataPattern.next;
        }
        return scalar;
    }

    /*
     * Unable to fully structure code
     */
    private static void WriteFormatted(String var0, OutputStream var1_1, ScriptEnvironment var2_2, Stack var3_3, IOObject var4_4) {
        var5_5 = DataPattern.Parse(var0);
        if (var3_3.size() == 1 && ((Scalar)var3_3.peek()).getArray() != null) {
            var6_6 = new Stack<E>();
            var7_8 = ((Scalar)var3_3.peek()).getArray().scalarIterator();
            while (var7_8.hasNext()) {
                var6_6.push(var7_8.next());
            }
            BasicIO.WriteFormatted(var0, var1_1, var2_2, var6_6, var4_4);
            return;
        }
        var6_7 = new byte[8];
        var7_9 = ByteBuffer.wrap(var6_7);
        while (var5_5 != null) {
            var7_9.order(var5_5.order);
            if (var5_5.value == 'z' || var5_5.value == 'Z' || var5_5.value == 'u' || var5_5.value == 'U') {
                try {
                    var8_10 = BridgeUtilities.getString(var3_3, "").toCharArray();
                    for (var9_17 = 0; var9_17 < var8_10.length; ++var9_17) {
                        if (var5_5.value == 'u' || var5_5.value == 'U') {
                            var7_9.putChar(0, var8_10[var9_17]);
                            var1_1.write(var6_7, 0, 2);
                            continue;
                        }
                        var1_1.write(var8_10[var9_17]);
                    }
                    block31: for (var9_17 = var8_10.length; var9_17 < var5_5.count; ++var9_17) {
                        switch (var5_5.value) {
                            case 'U': {
                                var1_1.write(0);
                                var1_1.write(0);
                                continue block31;
                            }
                            case 'Z': {
                                var1_1.write(0);
                            }
                        }
                    }
                    if (var5_5.value == 'z' || var5_5.value == 'Z' && var5_5.count == -1) {
                        var1_1.write(0);
                    }
                    if (var5_5.value != 'u' && (var5_5.value != 'U' || var5_5.count != -1)) ** GOTO lbl140
                    var1_1.write(0);
                    var1_1.write(0);
                }
                catch (Exception var8_11) {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    return;
                }
            } else if (var5_5.value == 'h' || var5_5.value == 'H') {
                try {
                    var8_12 = new StringBuffer("FF");
                    var9_18 = BridgeUtilities.getString(var3_3, "");
                    if (var9_18.length() % 2 != 0) {
                        throw new IllegalArgumentException("can not pack '" + var9_18 + "' as hex string, number of characters must be even");
                    }
                    var10_20 = var9_18.toCharArray();
                    for (var11_23 = 0; var11_23 < ((char[])var10_20).length; var11_23 += 2) {
                        if (var5_5.value == 'H') {
                            var8_12.setCharAt(0, (char)var10_20[var11_23]);
                            var8_12.setCharAt(1, (char)var10_20[var11_23 + 1]);
                        } else {
                            var8_12.setCharAt(0, (char)var10_20[var11_23 + 1]);
                            var8_12.setCharAt(1, (char)var10_20[var11_23]);
                        }
                        var7_9.putInt(0, Integer.parseInt(var8_12.toString(), 16));
                        var1_1.write(var6_7, 3, 1);
                    }
                }
                catch (IllegalArgumentException var8_13) {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    throw var8_13;
                }
                catch (Exception var8_14) {
                    var8_14.printStackTrace();
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    return;
                }
            } else {
                for (var8_15 = 0; var8_15 != var5_5.count && !var3_3.isEmpty(); ++var8_15) {
                    var9_19 = null;
                    if (var5_5.value != 'x') {
                        var9_19 = BridgeUtilities.getScalar(var3_3);
                    }
                    try {
                        switch (var5_5.value) {
                            case 'x': {
                                var1_1.write(0);
                                break;
                            }
                            case 'c': {
                                var7_9.putChar(0, var9_19.toString().charAt(0));
                                var1_1.write(var6_7, 0, 2);
                                break;
                            }
                            case 'C': {
                                var1_1.write(var9_19.toString().charAt(0));
                                break;
                            }
                            case 'B': 
                            case 'b': {
                                var1_1.write(var9_19.intValue());
                                break;
                            }
                            case 'S': 
                            case 's': {
                                var7_9.putShort(0, (short)var9_19.intValue());
                                var1_1.write(var6_7, 0, 2);
                                break;
                            }
                            case 'i': {
                                var7_9.putInt(0, var9_19.intValue());
                                var1_1.write(var6_7, 0, 4);
                                break;
                            }
                            case 'I': {
                                var7_9.putInt(0, (int)var9_19.longValue());
                                var1_1.write(var6_7, 0, 4);
                                break;
                            }
                            case 'f': {
                                var7_9.putFloat(0, (float)var9_19.doubleValue());
                                var1_1.write(var6_7, 0, 4);
                                break;
                            }
                            case 'd': {
                                var7_9.putDouble(0, var9_19.doubleValue());
                                var1_1.write(var6_7, 0, 8);
                                break;
                            }
                            case 'l': {
                                var7_9.putLong(0, var9_19.longValue());
                                var1_1.write(var6_7, 0, 8);
                                break;
                            }
                            case 'o': {
                                try {
                                    var10_20 = new ObjectOutputStream(var1_1);
                                    var10_20.writeObject(var9_19);
                                    break;
                                }
                                catch (Exception var10_21) {
                                    var2_2.flagError(var10_21);
                                    if (var4_4 != null) {
                                        var4_4.close();
                                    }
                                    return;
                                }
                            }
                        }
                        continue;
                    }
                    catch (Exception var10_22) {
                        if (var4_4 != null) {
                            var4_4.close();
                        }
                        return;
                    }
                }
            }
lbl140:
            // 5 sources

            var5_5 = var5_5.next;
        }
        try {
            var1_1.flush();
        }
        catch (Exception var8_16) {
            // empty catch block
        }
    }

    private static class CallbackReader
    implements Runnable {
        protected IOObject source;
        protected ScriptInstance script;
        protected SleepClosure function;
        protected int bytes;

        public CallbackReader(IOObject iOObject, ScriptInstance scriptInstance, SleepClosure sleepClosure, int n) {
            this.source = iOObject;
            this.script = scriptInstance;
            this.function = sleepClosure;
            this.bytes = n;
        }

        public void run() {
            Stack<Scalar> stack = new Stack<Scalar>();
            if (this.bytes <= 0) {
                String string;
                while (this.script.isLoaded() && (string = this.source.readLine()) != null) {
                    stack.push(SleepUtils.getScalar(string));
                    stack.push(SleepUtils.getScalar(this.source));
                    this.function.callClosure("&read", this.script, stack);
                }
            } else {
                StringBuffer stringBuffer = null;
                try {
                    while (this.script.isLoaded() && !this.source.isEOF()) {
                        stringBuffer = new StringBuffer(this.bytes);
                        for (int i = 0; i < this.bytes; ++i) {
                            stringBuffer.append((char)this.source.getReader().readUnsignedByte());
                        }
                        stack.push(SleepUtils.getScalar(stringBuffer.toString()));
                        stack.push(SleepUtils.getScalar(this.source));
                        this.function.callClosure("&read", this.script, stack);
                    }
                }
                catch (Exception exception) {
                    if (stringBuffer.length() > 0) {
                        stack.push(SleepUtils.getScalar(stringBuffer.toString()));
                        stack.push(SleepUtils.getScalar(this.source));
                        this.function.callClosure("&read", this.script, stack);
                    }
                    this.source.close();
                    this.script.getScriptEnvironment().flagError(exception);
                }
            }
        }
    }

    private static class iseof
    implements Predicate {
        private iseof() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = (IOObject)BridgeUtilities.getObject(stack);
            return iOObject.isEOF();
        }
    }

    private static class read
    implements Function {
        private read() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
            Thread thread = new Thread(new CallbackReader(iOObject, scriptInstance, sleepClosure, BridgeUtilities.getInt(stack, 0)));
            iOObject.setThread(thread);
            thread.start();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class consume
    implements Function {
        private consume() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            int n = BridgeUtilities.getInt(stack, 1);
            int n2 = BridgeUtilities.getInt(stack, 32768);
            int n3 = 0;
            if (iOObject.getReader() != null) {
                int n4;
                byte[] byArray = new byte[n2];
                try {
                    for (n4 = 0; n4 < n && (n3 = n - n4 < n2 ? iOObject.getReader().read(byArray, 0, n - n4) : iOObject.getReader().read(byArray, 0, n2)) != -1; n4 += n3) {
                    }
                }
                catch (Exception exception) {
                    iOObject.close();
                    scriptInstance.getScriptEnvironment().flagError(exception);
                }
                if (n4 > 0) {
                    return SleepUtils.getScalar(n4);
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class readb
    implements Function {
        private readb() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            int n = BridgeUtilities.getInt(stack, 1);
            int n2 = 0;
            byte[] byArray = null;
            StringBuffer stringBuffer = null;
            if (iOObject.getReader() != null) {
                int n3;
                block10: {
                    try {
                        if (n == -1) {
                            stringBuffer = new StringBuffer(BridgeUtilities.getInt(stack, 2048));
                            while ((n2 = iOObject.getReader().read()) != -1) {
                                char c = (char)(n2 & 0xFF);
                                stringBuffer.append(c);
                                ++n3;
                            }
                        } else {
                            byArray = new byte[n];
                            for (n3 = 0; n3 < n && (n2 = iOObject.getReader().read(byArray, n3, n - n3)) != -1; n3 += n2) {
                            }
                        }
                    }
                    catch (Exception exception) {
                        iOObject.close();
                        if (n == -1) break block10;
                        scriptInstance.getScriptEnvironment().flagError(exception);
                    }
                }
                if (n3 > 0) {
                    if (byArray != null) {
                        return SleepUtils.getScalar(byArray, n3);
                    }
                    if (stringBuffer != null) {
                        return SleepUtils.getScalar(stringBuffer.toString());
                    }
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class writeb
    implements Function {
        private writeb() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            String string2 = BridgeUtilities.getString(stack, "");
            try {
                for (int i = 0; i < string2.length(); ++i) {
                    iOObject.getWriter().writeByte((byte)string2.charAt(i));
                }
                iOObject.getWriter().flush();
            }
            catch (Exception exception) {
                iOObject.close();
                scriptInstance.getScriptEnvironment().flagError(exception);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class pack
    implements Function {
        private pack() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(DataPattern.EstimateSize(string2) + 128);
            BasicIO.WriteFormatted(string2, new DataOutputStream(byteArrayOutputStream), scriptInstance.getScriptEnvironment(), stack, null);
            return SleepUtils.getScalar(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size());
        }
    }

    private static class unpack
    implements Function {
        private unpack() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            String string3 = BridgeUtilities.getString(stack, "");
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string3.length());
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeBytes(string3);
                return BasicIO.ReadFormatted(string2, new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), scriptInstance.getScriptEnvironment(), null);
            }
            catch (Exception exception) {
                return SleepUtils.getArrayScalar();
            }
        }
    }

    private static class reset
    implements Function {
        private reset() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            try {
                IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
                iOObject.getInputBuffer().reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class available
    implements Function {
        private available() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            try {
                IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
                if (stack.isEmpty()) {
                    return SleepUtils.getScalar(iOObject.getInputBuffer().available());
                }
                String string2 = BridgeUtilities.getString(stack, "\n");
                StringBuffer stringBuffer = new StringBuffer();
                int n = iOObject.getInputBuffer().available();
                iOObject.getInputBuffer().mark(n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append((char)iOObject.getReader().readUnsignedByte());
                }
                iOObject.getInputBuffer().reset();
                return SleepUtils.getScalar(stringBuffer.indexOf(string2) > -1);
            }
            catch (Exception exception) {
                return SleepUtils.getEmptyScalar();
            }
        }
    }

    private static class mark
    implements Function {
        private mark() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            if (iOObject.getInputBuffer() == null) {
                throw new RuntimeException("&mark: input buffer for " + SleepUtils.describe(SleepUtils.getScalar(iOObject)) + " is closed");
            }
            iOObject.getInputBuffer().mark(BridgeUtilities.getInt(stack, 102400));
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class bwrite
    implements Function {
        private bwrite() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 3, scriptInstance);
            String string2 = BridgeUtilities.getString(stack, "");
            BasicIO.WriteFormatted(string2, iOObject.getWriter(), scriptInstance.getScriptEnvironment(), stack, iOObject);
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class bread
    implements Function {
        private bread() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            String string2 = BridgeUtilities.getString(stack, "");
            return iOObject.getReader() != null ? BasicIO.ReadFormatted(string2, iOObject.getReader(), scriptInstance.getScriptEnvironment(), iOObject) : SleepUtils.getEmptyScalar();
        }
    }

    private static class getConsoleObject
    implements Function {
        private getConsoleObject() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(IOObject.getConsole(scriptInstance.getScriptEnvironment()));
        }
    }

    private static class printEOF
    implements Function {
        private printEOF() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
            iOObject.sendEOF();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class print
    implements Function {
        private print() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            String string2 = BridgeUtilities.getString(stack, "");
            iOObject.print(string2);
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class printArray
    implements Function {
        private printArray() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            Iterator iterator = BridgeUtilities.getIterator(stack, scriptInstance);
            while (iterator.hasNext()) {
                iOObject.printLine(iterator.next().toString());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class println
    implements Function {
        private println() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 2, scriptInstance);
            String string2 = BridgeUtilities.getString(stack, "");
            iOObject.printLine(string2);
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class readAll
    implements Function {
        private readAll() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2;
            IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
            Scalar scalar = SleepUtils.getArrayScalar();
            while ((string2 = iOObject.readLine()) != null) {
                scalar.getArray().push(SleepUtils.getScalar(string2));
            }
            return scalar;
        }
    }

    private static class readln
    implements Function {
        private readln() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            IOObject iOObject = BasicIO.chooseSource(stack, 1, scriptInstance);
            String string2 = iOObject.readLine();
            if (string2 == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(string2);
        }
    }

    private static class closef
    implements Function {
        private closef() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (!stack.isEmpty() && ((Scalar)stack.peek()).objectValue() instanceof IOObject) {
                IOObject iOObject = (IOObject)BridgeUtilities.getObject(stack);
                iOObject.close();
            } else {
                int n = BridgeUtilities.getInt(stack, 80);
                SocketObject.release(n);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class SocketFuncs
    implements Function {
        private SocketFuncs() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Map map2 = BridgeUtilities.extractNamedParameters(stack);
            SocketObject.SocketHandler socketHandler = new SocketObject.SocketHandler();
            socketHandler.socket = new SocketObject();
            socketHandler.script = scriptInstance;
            socketHandler.lport = map2.containsKey("lport") ? ((Scalar)map2.get("lport")).intValue() : 0;
            socketHandler.laddr = map2.containsKey("laddr") ? ((Scalar)map2.get("laddr")).toString() : null;
            socketHandler.linger = map2.containsKey("linger") ? ((Scalar)map2.get("linger")).intValue() : 5;
            int n = socketHandler.backlog = map2.containsKey("backlog") ? ((Scalar)map2.get("backlog")).intValue() : 0;
            if (string.equals("&listen")) {
                socketHandler.port = BridgeUtilities.getInt(stack, -1);
                socketHandler.timeout = BridgeUtilities.getInt(stack, 60000);
                socketHandler.callback = BridgeUtilities.getScalar(stack);
                socketHandler.type = 1;
            } else {
                socketHandler.host = BridgeUtilities.getString(stack, "127.0.0.1");
                socketHandler.port = BridgeUtilities.getInt(stack, 1);
                socketHandler.timeout = BridgeUtilities.getInt(stack, 60000);
                socketHandler.type = 2;
            }
            if (!stack.isEmpty()) {
                socketHandler.function = BridgeUtilities.getFunction(stack, scriptInstance);
            }
            socketHandler.start();
            return SleepUtils.getScalar(socketHandler.socket);
        }
    }

    private static class fork
    implements Function {
        private fork() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Object object;
            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
            ScriptInstance scriptInstance2 = scriptInstance.fork();
            scriptInstance2.installBlock(sleepClosure.getRunnableCode());
            ScriptVariables scriptVariables = scriptInstance2.getScriptVariables();
            while (!stack.isEmpty()) {
                object = BridgeUtilities.getKeyValuePair(stack);
                scriptVariables.putScalar(((KeyValuePair)object).getKey().toString(), SleepUtils.getScalar(((KeyValuePair)object).getValue()));
            }
            object = new IOObject();
            IOObject iOObject = new IOObject();
            try {
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                pipedInputStream.connect(pipedOutputStream);
                PipedInputStream pipedInputStream2 = new PipedInputStream();
                PipedOutputStream pipedOutputStream2 = new PipedOutputStream();
                pipedInputStream2.connect(pipedOutputStream2);
                ((IOObject)object).openRead(pipedInputStream2);
                ((IOObject)object).openWrite(pipedOutputStream);
                iOObject.openRead(pipedInputStream);
                iOObject.openWrite(pipedOutputStream2);
                scriptInstance2.getScriptVariables().putScalar("$source", SleepUtils.getScalar(iOObject));
                Thread thread = new Thread((Runnable)scriptInstance2, "fork of " + scriptInstance2.getRunnableBlock().getSourceLocation());
                ((IOObject)object).setThread(thread);
                iOObject.setThread(thread);
                scriptInstance2.setParent((IOObject)object);
                thread.start();
            }
            catch (Exception exception) {
                scriptInstance.getScriptEnvironment().flagError(exception);
            }
            return SleepUtils.getScalar(object);
        }
    }

    private static class sleep
    implements Function {
        private sleep() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            try {
                Thread.currentThread();
                Thread.sleep(BridgeUtilities.getLong(stack, 0L));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class exec
    implements Function {
        private exec() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Object object;
            Scalar scalar = stack.isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)stack.pop();
            String[] stringArray = scalar.getArray() != null ? SleepUtils.getListFromArray(scalar.getArray()).toArray(new String[0]) : scalar.toString().split("\\s");
            String[] stringArray2 = null;
            File file = null;
            if (!stack.isEmpty()) {
                if (SleepUtils.isEmptyScalar((Scalar)stack.peek())) {
                    stack.pop();
                } else {
                    object = BridgeUtilities.getHash(stack);
                    Iterator iterator = object.keys().scalarIterator();
                    stringArray2 = new String[object.keys().size()];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        Scalar scalar2 = (Scalar)iterator.next();
                        stringArray2[i] = scalar2.toString() + "=" + object.getAt(scalar2);
                    }
                }
            }
            if (!stack.isEmpty() && !SleepUtils.isEmptyScalar((Scalar)stack.peek())) {
                if (SleepUtils.isEmptyScalar((Scalar)stack.peek())) {
                    stack.pop();
                } else {
                    file = BridgeUtilities.getFile(stack, scriptInstance);
                }
            }
            object = new ProcessObject();
            ((ProcessObject)object).open(stringArray, stringArray2, file, scriptInstance.getScriptEnvironment());
            return SleepUtils.getScalar(object);
        }
    }

    private static class openf
    implements Function {
        private openf() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = ((Scalar)stack.pop()).toString();
            FileObject fileObject = new FileObject();
            fileObject.open(string2, scriptInstance.getScriptEnvironment());
            return SleepUtils.getScalar(fileObject);
        }
    }
}

