/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.KeyValuePair;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Variable;
import sleep.parser.Checkers;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class BridgeUtilities {
    private static final boolean doReplace = File.separatorChar != '/';
    static /* synthetic */ Class class$sleep$engine$types$ObjectValue;

    public static byte[] toByteArrayNoConversion(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static int getInt(Stack stack) {
        return BridgeUtilities.getInt(stack, 0);
    }

    public static int getInt(Stack stack, int n) {
        if (stack.isEmpty()) {
            return n;
        }
        return ((Scalar)stack.pop()).intValue();
    }

    public static Class getClass(Stack stack, Class clazz) {
        Object object = BridgeUtilities.getObject(stack);
        if (object == null) {
            return clazz;
        }
        return (Class)object;
    }

    public static long getLong(Stack stack) {
        return BridgeUtilities.getLong(stack, 0L);
    }

    public static long getLong(Stack stack, long l) {
        if (stack.isEmpty()) {
            return l;
        }
        return ((Scalar)stack.pop()).longValue();
    }

    public static double getDouble(Stack stack) {
        return BridgeUtilities.getDouble(stack, 0.0);
    }

    public static double getDouble(Stack stack, double d) {
        if (stack.isEmpty()) {
            return d;
        }
        return ((Scalar)stack.pop()).doubleValue();
    }

    public static Map extractNamedParameters(Stack stack) {
        HashMap<String, Scalar> hashMap = new HashMap<String, Scalar>();
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            Scalar scalar = (Scalar)iterator.next();
            if (scalar.objectValue() == null || scalar.objectValue().getClass() != (class$sleep$bridges$KeyValuePair == null ? BridgeUtilities.class$("sleep.bridges.KeyValuePair") : class$sleep$bridges$KeyValuePair)) continue;
            iterator.remove();
            KeyValuePair keyValuePair = (KeyValuePair)scalar.objectValue();
            hashMap.put(keyValuePair.getKey().toString(), keyValuePair.getValue());
        }
        return hashMap;
    }

    public static Iterator getIterator(Stack stack, ScriptInstance scriptInstance) {
        if (stack.isEmpty()) {
            return BridgeUtilities.getArray(stack).scalarIterator();
        }
        Scalar scalar = (Scalar)stack.pop();
        return SleepUtils.getIterator(scalar, scriptInstance);
    }

    public static ScalarArray getArray(Stack stack) {
        Scalar scalar = BridgeUtilities.getScalar(stack);
        if (scalar.getArray() == null) {
            return SleepUtils.getArrayScalar().getArray();
        }
        return scalar.getArray();
    }

    public static ScalarHash getHash(Stack stack) {
        if (stack.isEmpty()) {
            return SleepUtils.getHashScalar().getHash();
        }
        return ((Scalar)stack.pop()).getHash();
    }

    public static ScalarArray getWorkableArray(Stack stack) {
        if (stack.isEmpty()) {
            return SleepUtils.getArrayScalar().getArray();
        }
        Scalar scalar = (Scalar)stack.pop();
        if (scalar.getArray().getClass() == CollectionWrapper.class) {
            ScalarArray scalarArray = SleepUtils.getArrayScalar().getArray();
            Iterator iterator = scalar.getArray().scalarIterator();
            while (iterator.hasNext()) {
                scalarArray.push((Scalar)iterator.next());
            }
            return scalarArray;
        }
        return scalar.getArray();
    }

    public static Object getObject(Stack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return ((Scalar)stack.pop()).objectValue();
    }

    public static SleepClosure getFunction(Stack stack, ScriptInstance scriptInstance) {
        Scalar scalar = BridgeUtilities.getScalar(stack);
        SleepClosure sleepClosure = SleepUtils.getFunctionFromScalar(scalar, scriptInstance);
        if (sleepClosure == null) {
            throw new IllegalArgumentException("expected &closure--received: " + SleepUtils.describe(scalar));
        }
        return sleepClosure;
    }

    public static Scalar getScalar(Stack stack) {
        if (stack.isEmpty()) {
            return SleepUtils.getEmptyScalar();
        }
        return (Scalar)stack.pop();
    }

    public static String getString(Stack stack, String string) {
        if (stack.isEmpty()) {
            return string;
        }
        String string2 = stack.pop().toString();
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static File toSleepFile(String string, ScriptInstance scriptInstance) {
        File file;
        if (string == null) {
            return scriptInstance.cwd();
        }
        if (doReplace) {
            string = string.replace('/', File.separatorChar);
        }
        if (!(file = new File(string)).isAbsolute() && string.length() > 0) {
            return new File(scriptInstance.cwd(), string);
        }
        return file;
    }

    public static File getFile(Stack stack, ScriptInstance scriptInstance) {
        return BridgeUtilities.toSleepFile(stack.isEmpty() ? null : stack.pop().toString(), scriptInstance);
    }

    public static KeyValuePair getKeyValuePair(Stack stack) {
        String string;
        Scalar scalar = BridgeUtilities.getScalar(stack);
        if (scalar.objectValue() != null && scalar.objectValue().getClass() == KeyValuePair.class) {
            return (KeyValuePair)scalar.objectValue();
        }
        if (scalar.getActualValue() != null && (string = scalar.getActualValue().toString()).indexOf(61) > -1) {
            Scalar scalar2 = SleepUtils.getScalar(string.substring(0, string.indexOf(61)));
            Scalar scalar3 = SleepUtils.getScalar(string.substring(string.indexOf(61) + 1, string.length()));
            return new KeyValuePair(scalar2, scalar3);
        }
        throw new IllegalArgumentException("attempted to pass a malformed key value pair: " + scalar);
    }

    public static Scalar flattenArray(Scalar scalar, Scalar scalar2) {
        return BridgeUtilities.flattenIterator(scalar.getArray().scalarIterator(), scalar2);
    }

    public static Scalar flattenIterator(Iterator iterator, Scalar scalar) {
        if (scalar == null) {
            scalar = SleepUtils.getArrayScalar();
        }
        while (iterator.hasNext()) {
            Scalar scalar2 = (Scalar)iterator.next();
            if (scalar2.getArray() != null) {
                BridgeUtilities.flattenArray(scalar2, scalar);
                continue;
            }
            scalar.getArray().push(scalar2);
        }
        return scalar;
    }

    public static int initLocalScope(ScriptVariables scriptVariables, Variable variable, Stack stack) {
        int n = 1;
        Scalar scalar = SleepUtils.getArrayScalar();
        while (!stack.isEmpty()) {
            Scalar scalar2 = (Scalar)stack.pop();
            if (scalar2.getActualValue() != null && scalar2.getActualValue().getType() == (class$sleep$engine$types$ObjectValue == null ? BridgeUtilities.class$("sleep.engine.types.ObjectValue") : class$sleep$engine$types$ObjectValue) && scalar2.getActualValue().objectValue() != null && scalar2.getActualValue().objectValue().getClass() == (class$sleep$bridges$KeyValuePair == null ? BridgeUtilities.class$("sleep.bridges.KeyValuePair") : class$sleep$bridges$KeyValuePair)) {
                KeyValuePair keyValuePair = (KeyValuePair)scalar2.getActualValue().objectValue();
                if (!Checkers.isVariable(keyValuePair.getKey().toString())) {
                    throw new IllegalArgumentException("unreachable named parameter: " + keyValuePair.getKey());
                }
                scriptVariables.setScalarLevel(keyValuePair.getKey().toString(), keyValuePair.getValue(), variable);
                continue;
            }
            scalar.getArray().push(scalar2);
            scriptVariables.setScalarLevel("$" + n, scalar2, variable);
            ++n;
        }
        scriptVariables.setScalarLevel("@_", scalar, variable);
        return n;
    }

    public static final int normalize(int n, int n2) {
        return n < 0 ? n + n2 : n;
    }

    public static boolean expectArray(String string, Scalar scalar) {
        if (scalar.getArray() == null) {
            throw new IllegalArgumentException(string + ": expected array. received " + SleepUtils.describe(scalar));
        }
        return true;
    }
}

