/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.io.File;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import sleep.engine.Step;
import sleep.engine.atoms.Goto;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Block
implements Serializable {
    protected Step first;
    protected Step last;
    protected String source = "unknown";

    public Block(String string) {
        this.source = string;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Step step = this.first;
        while (step != null) {
            stringBuffer.append(step.toString(string));
            step = step.next;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String getSource() {
        return this.source;
    }

    public int getApproximateLineNumber() {
        if (this.first != null) {
            return this.first.getLineNumber();
        }
        return -1;
    }

    public int getHighLineNumber() {
        int n = 0;
        Step step = this.first;
        while (step != null) {
            int n2 = step.getHighLineNumber();
            if (n2 > n) {
                n = n2;
            }
            step = step.next;
        }
        return n;
    }

    public int getLowLineNumber() {
        int n = Integer.MAX_VALUE;
        Step step = this.first;
        while (step != null) {
            int n2 = step.getLowLineNumber();
            if (n2 < n) {
                n = n2;
            }
            step = step.next;
        }
        return n;
    }

    public String getApproximateLineRange() {
        int n;
        int n2 = this.getLowLineNumber();
        if (n2 == (n = this.getHighLineNumber())) {
            return n2 + "";
        }
        return n2 + "-" + n;
    }

    public String getSourceLocation() {
        return new File(this.source).getName() + ":" + this.getApproximateLineRange();
    }

    public void add(Step step) {
        if (this.first == null) {
            this.first = step;
        } else {
            this.last.next = step;
        }
        this.last = step;
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        return this.evaluate(scriptEnvironment, this.first);
    }

    private void handleException(ScriptEnvironment scriptEnvironment) {
        if (scriptEnvironment.isResponsible(this)) {
            Block block = scriptEnvironment.getExceptionHandler();
            block.evaluate(scriptEnvironment);
            scriptEnvironment.getScriptInstance().clearStackTrace();
        }
    }

    private void cleanupEnvironment(ScriptEnvironment scriptEnvironment) {
        scriptEnvironment.popSource();
        if (scriptEnvironment.isResponsible(this)) {
            scriptEnvironment.popExceptionContext();
        }
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment, Step step) {
        if (scriptEnvironment.isReturn()) {
            if (scriptEnvironment.isThrownValue()) {
                scriptEnvironment.pushSource(this.source);
                this.handleException(scriptEnvironment);
                this.cleanupEnvironment(scriptEnvironment);
            }
            return scriptEnvironment.getReturnValue();
        }
        scriptEnvironment.pushSource(this.source);
        Step step2 = step;
        while (step2 != null) {
            try {
                step2.evaluate(scriptEnvironment);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalArgumentException) {
                    scriptEnvironment.getScriptInstance().fireWarning(exception.getMessage(), step2.getLineNumber());
                } else if (exception instanceof IndexOutOfBoundsException) {
                    if (exception.getMessage() != null) {
                        scriptEnvironment.getScriptInstance().fireWarning("attempted an invalid index: " + exception.getMessage(), step2.getLineNumber());
                    } else {
                        scriptEnvironment.getScriptInstance().fireWarning("attempted an invalid index", step2.getLineNumber());
                    }
                } else if (exception instanceof ClassCastException) {
                    scriptEnvironment.getScriptInstance().fireWarning("attempted an invalid cast: " + exception.getMessage(), step2.getLineNumber());
                } else if (exception instanceof NullPointerException) {
                    scriptEnvironment.getScriptInstance().fireWarning("null value error", step2.getLineNumber());
                } else if (exception instanceof ConcurrentModificationException) {
                    if (exception.getMessage() != null) {
                        scriptEnvironment.getScriptInstance().fireWarning("unsafe data modification: " + exception.getMessage(), step2.getLineNumber());
                    } else {
                        scriptEnvironment.getScriptInstance().fireWarning("detected unsafe data modification", step2.getLineNumber());
                    }
                } else if (exception instanceof RuntimeException) {
                    if (exception.getMessage() == null) {
                        scriptEnvironment.getScriptInstance().fireWarning("internal error - " + exception.getClass(), step2.getLineNumber());
                    } else {
                        scriptEnvironment.getScriptInstance().fireWarning(exception.getMessage(), step2.getLineNumber());
                    }
                } else {
                    scriptEnvironment.getScriptInstance().fireWarning(exception.toString(), step2.getLineNumber());
                }
                this.cleanupEnvironment(scriptEnvironment);
                return SleepUtils.getEmptyScalar();
            }
            catch (Error error) {
                scriptEnvironment.getScriptInstance().fireWarning("critical internal error - " + error.toString(), step2.getLineNumber());
                this.cleanupEnvironment(scriptEnvironment);
                throw error;
            }
            while (scriptEnvironment.isReturn()) {
                if (scriptEnvironment.isYield()) {
                    if (step2 instanceof Goto) {
                        scriptEnvironment.addToContext(this, step2);
                    } else {
                        scriptEnvironment.addToContext(this, step2.next);
                    }
                }
                if (scriptEnvironment.isCallCC()) {
                    scriptEnvironment.getCurrentFrame().push(this.source);
                    scriptEnvironment.getCurrentFrame().push(new Integer(step2.getLineNumber()));
                }
                if (scriptEnvironment.isThrownValue()) {
                    if (!scriptEnvironment.isExceptionHandlerInstalled()) {
                        if (!SleepUtils.isEmptyScalar(scriptEnvironment.getReturnValue())) {
                            scriptEnvironment.getScriptInstance().fireWarning("Uncaught exception: " + scriptEnvironment.getExceptionMessage(), step2.getLineNumber());
                            scriptEnvironment.flagReturn(null, 16);
                        }
                    } else if (!SleepUtils.isEmptyScalar(scriptEnvironment.getReturnValue())) {
                        this.handleException(scriptEnvironment);
                    }
                    this.cleanupEnvironment(scriptEnvironment);
                    return scriptEnvironment.getReturnValue();
                }
                if (scriptEnvironment.isDebugInterrupt()) {
                    scriptEnvironment.getScriptInstance().fireWarning(scriptEnvironment.getDebugString(), step2.getLineNumber());
                    continue;
                }
                this.cleanupEnvironment(scriptEnvironment);
                return scriptEnvironment.getReturnValue();
            }
            step2 = step2.next;
        }
        this.cleanupEnvironment(scriptEnvironment);
        return SleepUtils.getEmptyScalar();
    }
}

