/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sleep.engine.CallRequest;
import sleep.engine.ObjectUtilities;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class ObjectNew
extends Step {
    protected Class name;

    public ObjectNew(Class clazz) {
        this.name = clazz;
    }

    public String toString() {
        return "[Object New]: " + this.name + "\n";
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        Constructor constructor = ObjectUtilities.findConstructor(this.name, scriptEnvironment.getCurrentFrame());
        if (constructor != null) {
            try {
                constructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConstructorCallRequest constructorCallRequest = new ConstructorCallRequest(scriptEnvironment, this.getLineNumber(), constructor, this.name);
            constructorCallRequest.CallFunction();
            return null;
        }
        scriptEnvironment.getScriptInstance().fireWarning("no constructor matching " + this.name.getName() + "(" + SleepUtils.describe(scriptEnvironment.getCurrentFrame()) + ")", this.getLineNumber());
        Scalar scalar = SleepUtils.getEmptyScalar();
        scriptEnvironment.FrameResult(scalar);
        return null;
    }

    private static class ConstructorCallRequest
    extends CallRequest {
        protected Constructor theConstructor;
        protected Class name;

        public ConstructorCallRequest(ScriptEnvironment scriptEnvironment, int n, Constructor constructor, Class clazz) {
            super(scriptEnvironment, n);
            this.theConstructor = constructor;
            this.name = clazz;
        }

        public String getFunctionName() {
            return this.name.toString();
        }

        public String getFrameDescription() {
            return this.name.toString();
        }

        public String formatCall(String string) {
            if (string != null && string.length() > 0) {
                string = ": " + string;
            }
            StringBuffer stringBuffer = new StringBuffer("[new " + this.name.getName() + string + "]");
            return stringBuffer.toString();
        }

        protected Scalar execute() {
            Object[] objectArray = ObjectUtilities.buildArgumentArray(this.theConstructor.getParameterTypes(), this.getScriptEnvironment().getCurrentFrame(), this.getScriptEnvironment().getScriptInstance());
            try {
                return ObjectUtilities.BuildScalar(false, this.theConstructor.newInstance(objectArray));
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null) {
                    this.getScriptEnvironment().flagError(invocationTargetException.getCause());
                }
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                this.getScriptEnvironment().getScriptInstance().fireWarning(ObjectUtilities.buildArgumentErrorMessage(this.name, this.name.getName(), this.theConstructor.getParameterTypes(), objectArray), this.getLineNumber());
            }
            catch (InstantiationException instantiationException) {
                this.getScriptEnvironment().getScriptInstance().fireWarning("unable to instantiate abstract class " + this.name.getName(), this.getLineNumber());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.getScriptEnvironment().getScriptInstance().fireWarning("cannot access constructor in " + this.name.getName() + ": " + illegalAccessException.getMessage(), this.getLineNumber());
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

