/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Stack;
import sleep.bridges.DefaultVariable;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;

public class ScriptVariables
implements Serializable {
    protected Variable global;
    protected LinkedList closure;
    protected LinkedList locals;
    protected Stack marks;

    public void beginToplevel(LinkedList linkedList) {
        this.marks.push(this.locals);
        this.locals = linkedList;
    }

    public LinkedList leaveToplevel() {
        LinkedList linkedList = this.locals;
        this.locals = (LinkedList)this.marks.pop();
        return linkedList;
    }

    public boolean haveMoreLocals() {
        return this.locals.size() > 1;
    }

    public ScriptVariables() {
        this(new DefaultVariable());
    }

    public ScriptVariables(Variable variable) {
        this.global = variable;
        this.closure = new LinkedList();
        this.locals = new LinkedList();
        this.marks = new Stack();
    }

    public void putScalar(String string, Scalar scalar) {
        this.global.putScalar(string, scalar);
    }

    public Scalar getScalar(String string) {
        return this.getScalar(string, null);
    }

    public Variable getScalarLevel(String string, ScriptInstance scriptInstance) {
        Variable variable = this.getLocalVariables();
        if (variable != null && variable.scalarExists(string)) {
            return variable;
        }
        variable = this.getClosureVariables();
        if (variable != null && variable.scalarExists(string)) {
            return variable;
        }
        variable = this.getGlobalVariables();
        if (variable.scalarExists(string)) {
            return variable;
        }
        return null;
    }

    public Scalar getScalar(String string, ScriptInstance scriptInstance) {
        Variable variable = this.getScalarLevel(string, scriptInstance);
        if (variable != null) {
            return variable.getScalar(string);
        }
        return null;
    }

    public void setScalarLevel(String string, Scalar scalar, Variable variable) {
        variable.putScalar(string, scalar);
    }

    public Variable getLocalVariables() {
        if (this.locals.size() == 0) {
            return null;
        }
        return (Variable)this.locals.getFirst();
    }

    public Variable getClosureVariables() {
        if (this.closure.size() == 0) {
            return null;
        }
        return (Variable)this.closure.getFirst();
    }

    public Variable getGlobalVariables() {
        return this.global;
    }

    public Variable getClosureVariables(SleepClosure sleepClosure) {
        return sleepClosure.getVariables();
    }

    public void setClosureVariables(SleepClosure sleepClosure, Variable variable) {
        sleepClosure.setVariables(variable);
    }

    public void pushClosureLevel(Variable variable) {
        this.closure.addFirst(variable);
    }

    public void popClosureLevel() {
        this.closure.removeFirst();
    }

    public void pushLocalLevel(Variable variable) {
        this.locals.addFirst(variable);
    }

    public void pushLocalLevel() {
        this.locals.addFirst(this.global.createLocalVariableContainer());
    }

    public void popLocalLevel() {
        this.locals.removeFirst();
    }
}

