/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class mxCellHandler {
    protected mxGraphComponent graphComponent;
    protected mxCellState state;
    protected Rectangle[] handles;
    protected boolean handlesVisible = true;
    protected transient Rectangle bounds;
    protected transient JComponent preview;
    protected transient Point first;
    protected transient int index;

    public mxCellHandler(mxGraphComponent mxGraphComponent2, mxCellState mxCellState2) {
        this.graphComponent = mxGraphComponent2;
        this.refresh(mxCellState2);
    }

    public boolean isActive() {
        return this.first != null;
    }

    public void refresh(mxCellState mxCellState2) {
        this.state = mxCellState2;
        this.handles = this.createHandles();
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxRectangle mxRectangle2 = mxGraph2.getBoundingBox(mxCellState2.getCell());
        if (mxRectangle2 != null) {
            this.bounds = mxRectangle2.getRectangle();
            if (this.handles != null) {
                for (int i = 0; i < this.handles.length; ++i) {
                    if (!this.isHandleVisible(i)) continue;
                    this.bounds.add(this.handles[i]);
                }
            }
        }
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public mxCellState getState() {
        return this.state;
    }

    public int getIndex() {
        return this.index;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isLabelMovable() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        String string = mxGraph2.getLabel(this.state.getCell());
        return mxGraph2.isLabelMovable(this.state.getCell()) && string != null && string.length() > 0;
    }

    public boolean isHandlesVisible() {
        return this.handlesVisible;
    }

    public void setHandlesVisible(boolean bl) {
        this.handlesVisible = bl;
    }

    public boolean isLabel(int n) {
        return n == this.getHandleCount() - 1;
    }

    protected Rectangle[] createHandles() {
        return null;
    }

    protected int getHandleCount() {
        return this.handles != null ? this.handles.length : 0;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public int getIndexAt(int n, int n2) {
        if (this.handles != null && this.isHandlesVisible()) {
            int n3 = this.graphComponent.getTolerance();
            Rectangle rectangle = new Rectangle(n - n3 / 2, n2 - n3 / 2, n3, n3);
            for (int i = this.handles.length - 1; i >= 0; --i) {
                if (!this.isHandleVisible(i) || !this.handles[i].intersects(rectangle)) continue;
                return i;
            }
        }
        return -1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            int n = this.getIndexAt(mouseEvent.getX(), mouseEvent.getY());
            if (!this.isIgnoredEvent(mouseEvent) && n >= 0 && this.isHandleEnabled(n)) {
                this.graphComponent.stopEditing(true);
                this.start(mouseEvent, n);
                mouseEvent.consume();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (!mouseEvent.isConsumed() && this.handles != null && (n = this.getIndexAt(mouseEvent.getX(), mouseEvent.getY())) >= 0 && this.isHandleEnabled(n)) {
            Cursor cursor = this.getCursor(mouseEvent, n);
            if (cursor != null) {
                this.graphComponent.getGraphControl().setCursor(cursor);
                mouseEvent.consume();
            } else {
                this.graphComponent.getGraphControl().setCursor(new Cursor(12));
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.reset();
    }

    public void start(MouseEvent mouseEvent, int n) {
        this.index = n;
        this.first = mouseEvent.getPoint();
        this.preview = this.createPreview();
        if (this.preview != null) {
            this.graphComponent.getGraphControl().add((Component)this.preview, 0);
        }
    }

    protected boolean isIgnoredEvent(MouseEvent mouseEvent) {
        return this.graphComponent.isEditEvent(mouseEvent);
    }

    protected JComponent createPreview() {
        return null;
    }

    public void reset() {
        if (this.preview != null) {
            this.preview.setVisible(false);
            this.preview.getParent().remove(this.preview);
            this.preview = null;
        }
        this.first = null;
    }

    protected Cursor getCursor(MouseEvent mouseEvent, int n) {
        return null;
    }

    public void paint(Graphics graphics) {
        if (this.handles != null && this.isHandlesVisible()) {
            for (int i = 0; i < this.handles.length; ++i) {
                if (!this.isHandleVisible(i) || !graphics.hitClip(this.handles[i].x, this.handles[i].y, this.handles[i].width, this.handles[i].height)) continue;
                graphics.setColor(this.getHandleFillColor(i));
                graphics.fillRect(this.handles[i].x, this.handles[i].y, this.handles[i].width, this.handles[i].height);
                graphics.setColor(this.getHandleBorderColor(i));
                graphics.drawRect(this.handles[i].x, this.handles[i].y, this.handles[i].width - 1, this.handles[i].height - 1);
            }
        }
    }

    protected boolean isHandleEnabled(int n) {
        return true;
    }

    protected boolean isHandleVisible(int n) {
        return !this.isLabel(n) || this.isLabelMovable();
    }

    protected Color getHandleFillColor(int n) {
        if (this.isLabel(n)) {
            return mxConstants.LABEL_HANDLE_FILLCOLOR;
        }
        return mxConstants.HANDLE_FILLCOLOR;
    }

    protected Color getHandleBorderColor(int n) {
        return mxConstants.HANDLE_BORDERCOLOR;
    }
}

