/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class mxInsertHandler
extends mxMouseAdapter {
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected String style;
    protected Point first;
    protected float lineWidth = 1.0f;
    protected Color lineColor = Color.black;
    protected boolean rounded = false;
    protected mxRectangle current;
    protected mxEventSource eventSource = new mxEventSource(this);

    public mxInsertHandler(mxGraphComponent mxGraphComponent2, String string) {
        this.graphComponent = mxGraphComponent2;
        this.style = string;
        mxGraphComponent2.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                mxInsertHandler.this.paint(graphics);
            }
        });
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isStartEvent(MouseEvent mouseEvent) {
        return true;
    }

    public void start(MouseEvent mouseEvent) {
        this.first = mouseEvent.getPoint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && this.isStartEvent(mouseEvent)) {
            this.start(mouseEvent);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && this.first != null) {
            mxRectangle mxRectangle2 = this.current;
            this.current = new mxRectangle(this.first.x, this.first.y, 0.0, 0.0);
            this.current.add(new mxRectangle(mouseEvent.getX(), mouseEvent.getY(), 0.0, 0.0));
            if (mxRectangle2 != null) {
                mxRectangle2.add(this.current);
            } else {
                mxRectangle2 = this.current;
            }
            Rectangle rectangle = mxRectangle2.getRectangle();
            int n = (int)Math.ceil(this.lineWidth);
            this.graphComponent.getGraphControl().repaint(rectangle.x - n, rectangle.y - n, rectangle.width + 2 * n, rectangle.height + 2 * n);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && this.current != null) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = mxGraph2.getView().getScale();
            mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
            this.current.setX(this.current.getX() / d - mxPoint2.getX());
            this.current.setY(this.current.getY() / d - mxPoint2.getY());
            this.current.setWidth(this.current.getWidth() / d);
            this.current.setHeight(this.current.getHeight() / d);
            Object object = this.insertCell(this.current);
            this.eventSource.fireEvent(new mxEventObject("insert", "cell", object));
            mouseEvent.consume();
        }
        this.reset();
    }

    public Object insertCell(mxRectangle mxRectangle2) {
        return this.graphComponent.getGraph().insertVertex(null, null, "", mxRectangle2.getX(), mxRectangle2.getY(), mxRectangle2.getWidth(), mxRectangle2.getHeight(), this.style);
    }

    public void reset() {
        Rectangle rectangle = null;
        if (this.current != null) {
            rectangle = this.current.getRectangle();
        }
        this.current = null;
        this.first = null;
        if (rectangle != null) {
            int n = (int)Math.ceil(this.lineWidth);
            this.graphComponent.getGraphControl().repaint(rectangle.x - n, rectangle.y - n, rectangle.width + 2 * n, rectangle.height + 2 * n);
        }
    }

    public void paint(Graphics graphics) {
        if (this.first != null && this.current != null) {
            ((Graphics2D)graphics).setStroke(new BasicStroke(this.lineWidth));
            graphics.setColor(this.lineColor);
            Rectangle rectangle = this.current.getRectangle();
            if (this.rounded) {
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 8, 8);
            } else {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void addListener(String string, mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.addListener(string, mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2) {
        this.removeListener(mxIEventListener2, null);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2, String string) {
        this.eventSource.removeListener(mxIEventListener2, string);
    }
}

