# Progress Linux: dokuwiki-templates-extra

# Copyright (C) 2024 Daniel Baumann <daniel.baumann@progress-linux.org>
#
# SPDX-License-Identifier: GPL-3.0+
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Build-Depends:
# none

SHELL := sh -e

TEMPLATE := ad-hominem

all:

test:

build:

install:
	mkdir -p $(DESTDIR)/usr/share/dokuwiki/templates-extra
	cp -a $(TEMPLATE) $(DESTDIR)/usr/share/dokuwiki/templates-extra

	# removing unused files
	rm -f $(DESTDIR)/usr/share/dokuwiki/templates-extra/$(TEMPLATE)/LICENSE*
	rm -f $(DESTDIR)/usr/share/dokuwiki/templates-extra/$(TEMPLATE)/README*
	rm -rf $(DESTDIR)/usr/share/dokuwiki/templates-extra/$(TEMPLATE)/.git*

	rm -f $(DESTDIR)/usr/share/dokuwiki/templates-extra/$(TEMPLATE)/composer.json

uninstall:
	rm -rf $(DESTDIR)/usr/share/dokuwiki/templates-extra/$(TEMPLATE)
	rmdir --ignore-fail-on-non-empty --parents $(DESTDIR) || true

clean:

distclean:

reinstall: uninstall install

upstream:
	rm -rf $(TEMPLATE)
	git clone https://github.com/saschaleib/dokuwiki-template-ad-hominem $(TEMPLATE)
	rm -rf $(TEMPLATE)/.git
