% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DonorAssignmentStandardAnalysis.R
\name{donorAssignmentQC}
\alias{donorAssignmentQC}
\title{Standard set of analysis for single cell donor assignment.}
\usage{
donorAssignmentQC(
  expName = "",
  likelihoodSummaryFile,
  doubletLikelihoodFile,
  dgeSummaryFile = NULL,
  dgeRawSummaryFile = NULL,
  readsPerCellFile = NULL,
  censusFile = NULL,
  expectedSamplesFile,
  outFileLikelyDonors = NULL,
  outDonorToCellMap = NULL,
  outPDF = NULL,
  outSummaryStatsFile = NULL,
  minimumFractionDonor = 0.002,
  alpha = 0.05,
  rescueDiffuseDoublets = F,
  minNumUMIs = 0,
  dgeFile = NULL,
  outMetaCellFile = NULL,
  selectedCellsForMetaCellFile = NULL,
  outCellBarcodesFile = NULL,
  anonymizeDonors = FALSE
)
}
\arguments{
\item{expName}{The experiment name.  This is used to label plots.}

\item{likelihoodSummaryFile}{The dropulation single donor likelihood file.}

\item{doubletLikelihoodFile}{The dropulation doublet likelihood file.}

\item{dgeSummaryFile}{The DGE summary file.  If cleanup steps have been run on the 
data, the most processed data should be used at this step to preserve that in the metacell summary.  
A DGE summary file is a tab separated file with the follow columns:
* CELL_BARCODE: the cell barcode sequence CELL_BARCODE that identifies a single cell uniquely
* NUM_TRANSCRIPTS: the total number of UMIs captured by a cell.  This is the sum of expression across all genes. 
(optional)}

\item{dgeRawSummaryFile}{The DGE summary file.  This file should contain the number of UMIs original observed in the 
data before any cleanup steps like cellbender. See dgeSummaryFile for file format.  (optional)}

\item{readsPerCellFile}{The reads per cell file. This file is tab delimited, has no header, and has two columns:
1. The number of reads for a cell barcode
2. The cell barcode identity.  
(optional)}

\item{censusFile}{The census results file. (optional)}

\item{expectedSamplesFile}{A file containing the expected list of donors in the experiment. The file has no header,
and a single donor ID on each line.}

\item{outFileLikelyDonors}{Output of which donors are in the experiment based on the Dropulation results.}

\item{outDonorToCellMap}{A map from each cell barcode to the best donor.  This is restricted to cells
that are not doublets and have passed FDR thresholds.  This represents subset of input cells that should
be used in downstream analysis that requires donor labels.}

\item{outPDF}{The output PDF file. (optional)}

\item{outSummaryStatsFile}{The output summary statistics file. (optional)}

\item{minimumFractionDonor}{To determine which donors are in the data, what fraction of cells must contain a donor for the 
donor to be included in the output.  This controls for a low level of miscalls of donor identity.}

\item{alpha}{The p-value threshold for doublets.}

\item{rescueDiffuseDoublets}{[EXPERIMENTAL] Should doublets where the 2nd donor of the pair isn't clear be rescued when possible?  These
cells usually have higher amounts of ambient RNA that makes many potential doublet pairs equally likely.  If set to true,
attempts to differentiate cells assigned to expected donors from noisy cells to recover a subset of barcodes with marginal scores
as singlets.   This method needs a pool where many donors that are evaluated are not expected in the pool (a set of null results).  
Without that null result, this option will erroneously rescue cells as singlets - use with caution!}

\item{minNumUMIs}{Filter cells with fewer than this number of UMIs. (optional)}

\item{dgeFile}{The input DGE file to generate meta cell output. If cleanup steps have been run on the 
data, the most processed data should be used at this step to preserve that in the metacell summary.  This is a tab delimited
flat file with each row containing a gene and each column containing a cell barcode.  The first column name is "GENE", followed by 
cell barcode identifiers.  (optional)}

\item{outMetaCellFile}{Sums the expression across cells of each donor to generate a new expression file for donors instead 
of cells. (optional)}

\item{selectedCellsForMetaCellFile}{Limits meta cell expression to a subset of donors.}

\item{outCellBarcodesFile}{cell barcodes for donors in the experiment (optional)}

\item{anonymizeDonors}{If set to true, donor IDs are changed to DONOR_1, DONOR_2, etc.  Purely for sharing 
visualizations of not-yet-public data.}
}
\description{
This generates a QC report with a number of useful plots, along with optional
outputs that are useful for downstream analysis.
}
