---
created: 2020-09-15T09:11:08.000+00:00
source_url: https://www.patreon.com/posts/version-1-1-41625391
---

# Version 1.1: Keyboard shortcut editor

In this series of posts about version 1.1, we'll introduce another feature by one of our GSoC candidates, Anjula. Anjula developed over the past few months a system to allow configuring the keymap shortcuts, and created a nice editor for it.  Here is what he has to say:

\* \* \*

Joplin desktop application supports keyboard shortcuts to a certain  degree. However, there wasn't an option for users to configure keyboard  shortcuts according to their preferences. My project was to implement a  keyboard shortcut editor along with the necessary integration.

Custom keyboard shortcuts would be a great addition for all Joplin  users including power users and those who are migrating to Joplin from  other note-taking applications. People also do not have the same  keyboard layout; not everyone has F6 necessarily. It would solve  conflicts between different preferences of workflows, and increase  discoverability for all keyboard shortcuts.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20200915-091108_0.png)

### Back-end service for handling keymapping-related functionality

KeymapService builds an in-memory keymap based on the default keymap  configuration. The default keymap configuration may vary from platform  to platform. Essentially, the in-memory keymap binds a keyboard shortcut  for some command of Joplin. Clients of KeymapService may obtain the  keyboard shortcuts for some commands, and/or alter the keymap via the  provided methods.

KeymapService also allows altering the keymap via a keymap file,  which is located in the profile directory. Contents of this keymap file  will take higher priority than the default keymap configuration, and  will replace the default keyboard shortcuts.

It is guaranteed that the keymap always stays pristine with proper validation.

### Keyboard shortcut editor with the necessary functionality to alter the keymap

Depending on the interfaces of KeymapService, the Keyboard shortcut editor allows the user to,

- View all the available commands and their respective keyboard shortcuts
- Change, or disable a keyboard shortcut for some command
- Restore a keyboard shortcut to its default value
- Export all changes to a keymap file (in JSON format)
- Import changes from an exported keymap file
- Perform a simple search to locate some shortcut

Changes performed to the keymap will be reflected immediately in the  application user-interface as well as in the keymap file located in the  profile directory. The editor will also perform continuous validation to  ensure that the keymap will not enter a dirty-state. For example, it  won't allow the user to use the same shortcut for two or more commands.

The complete report with details of code contributions can be found [here.](https://gist.github.com/rahulbansal3005/3d566668a94c882d9f56811e18a2b17f)