/*
 * Library encryption functions test program
 *
 * Copyright (C) 2008-2023, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <memory.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "pff_test_libcerror.h"
#include "pff_test_libpff.h"
#include "pff_test_macros.h"
#include "pff_test_unused.h"

#include "../libpff/libpff_encryption.h"
#include "../libpff/libpff_definitions.h"

uint8_t pff_test_encryption_compressible_encrypted_data1[ 2984 ] = {
	0x27, 0x04, 0x6a, 0xe2, 0x41, 0x41, 0xe8, 0x41, 0xda, 0x41, 0xe7, 0x19, 0x06, 0x4a, 0x21, 0x41,
	0x03, 0x36, 0xec, 0x3a, 0xe8, 0x55, 0xbb, 0x41, 0xb9, 0x13, 0xf2, 0x41, 0x41, 0x41, 0x7f, 0x41,
	0x4d, 0x41, 0xe2, 0xe2, 0x41, 0x41, 0xe8, 0x41, 0xd6, 0x41, 0x46, 0x0c, 0x24, 0xe8, 0xbb, 0x41,
	0x58, 0x13, 0x4b, 0x27, 0x41, 0x41, 0xcc, 0x41, 0x95, 0x41, 0x70, 0xe2, 0x41, 0x41, 0xe8, 0x41,
	0x1d, 0x41, 0x6e, 0x30, 0x41, 0x41, 0x47, 0x41, 0xc3, 0x36, 0x6d, 0x94, 0x7c, 0xb6, 0x21, 0x41,
	0x8d, 0x13, 0xc8, 0x6e, 0x4f, 0xd9, 0xbb, 0x41, 0x1d, 0x13, 0xf9, 0x08, 0x41, 0x41, 0xf4, 0x41,
	0x4f, 0x41, 0x76, 0xe2, 0x41, 0x41, 0xe8, 0x41, 0xf8, 0x41, 0xed, 0x48, 0x3d, 0xe9, 0x21, 0x41,
	0x98, 0x13, 0x22, 0xe7, 0xf8, 0x6a, 0x21, 0x41, 0x76, 0x13, 0xc9, 0x75, 0x8d, 0x19, 0xbb, 0x41,
	0x6a, 0x13, 0x6e, 0x41, 0x41, 0x41, 0x60, 0x41, 0xb1, 0x62, 0xa8, 0x41, 0x41, 0x41, 0x9c, 0x41,
	0x07, 0x62, 0x7f, 0x41, 0x41, 0x41, 0x7f, 0x41, 0x60, 0x41, 0x8f, 0x08, 0x41, 0x41, 0xf4, 0x41,
	0xad, 0x41, 0xa7, 0xde, 0x8f, 0xa8, 0xbb, 0x41, 0x27, 0x41, 0x59, 0xa1, 0xe1, 0x47, 0x21, 0x41,
	0x27, 0x13, 0x36, 0xbf, 0xbe, 0x9a, 0xbb, 0x41, 0xbd, 0x13, 0x2a, 0x41, 0x41, 0x41, 0x7f, 0x41,
	0x92, 0x41, 0xc1, 0xe9, 0xbc, 0x1f, 0x21, 0x41, 0x3f, 0x13, 0x95, 0x95, 0x9c, 0xad, 0x21, 0x41,
	0xce, 0x13, 0x2b, 0xa2, 0x61, 0x3c, 0xbb, 0x41, 0xf3, 0x13, 0xa8, 0x41, 0x41, 0x41, 0x7f, 0x41,
	0x25, 0x41, 0xc7, 0xe2, 0x41, 0x41, 0xe8, 0x41, 0x99, 0x41, 0xa2, 0x44, 0x1d, 0xd4, 0x21, 0x41,
	0x6d, 0x36, 0x8a, 0x6a, 0x31, 0xf3, 0x21, 0x41, 0xbf, 0x13, 0x4a, 0xcd, 0xd7, 0xad, 0x21, 0x41,
	0xd1, 0x13, 0x77, 0x4a, 0x8b, 0x50, 0xbb, 0x41, 0x54, 0x13, 0x73, 0x76, 0xb8, 0x36, 0xbb, 0x41,
	0xf0, 0x13, 0x72, 0x08, 0x41, 0x41, 0xf4, 0x41, 0x57, 0x41, 0x2a, 0xec, 0x00, 0xa2, 0xbb, 0x41,
	0x18, 0x13, 0xac, 0x12, 0x41, 0x41, 0x84, 0x41, 0x68, 0x13, 0xa8, 0x41, 0x41, 0x41, 0x38, 0x41,
	0xe8, 0x62, 0xcc, 0x41, 0x41, 0x41, 0x60, 0x41, 0x60, 0x62, 0xf4, 0x41, 0x41, 0x41, 0x9c, 0x41,
	0x85, 0x62, 0x5d, 0x68, 0x85, 0xf4, 0x21, 0x41, 0x97, 0x36, 0x58, 0x54, 0x90, 0x13, 0x21, 0x41,
	0xfa, 0x13, 0x90, 0xcd, 0xc0, 0x3f, 0xbb, 0x41, 0x1f, 0x13, 0x91, 0xaa, 0xb1, 0x6e, 0xbb, 0x41,
	0x19, 0x13, 0x21, 0x30, 0x41, 0x41, 0x47, 0x41, 0x72, 0x36, 0xd3, 0x48, 0xbc, 0xe0, 0x21, 0x41,
	0x60, 0x13, 0x7d, 0x5a, 0x49, 0xc1, 0x21, 0x41, 0x71, 0x13, 0x80, 0xd8, 0xeb, 0x50, 0xbb, 0x41,
	0x10, 0x13, 0xcb, 0x41, 0x41, 0x41, 0x7f, 0x41, 0x34, 0x41, 0xe9, 0xe2, 0x41, 0x41, 0xe8, 0x41,
	0x3e, 0x41, 0xb8, 0x73, 0x6c, 0xe0, 0x21, 0x41, 0x4d, 0x36, 0xd8, 0x3b, 0x52, 0x67, 0x21, 0x41,
	0x2f, 0x36, 0x2a, 0xb9, 0x89, 0x92, 0xbb, 0x41, 0xae, 0x13, 0x72, 0x62, 0x13, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0xf4, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0x13, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0x4d, 0x65, 0xd6, 0x3a, 0x04, 0x7c,
	0x9e, 0x1e, 0xe5, 0x65, 0x41, 0x8a, 0x41, 0xfb, 0x2a, 0x21, 0xa8, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0x62, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0xcc, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0x04, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0xe8, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0x2a, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0x74, 0x4c, 0x6e, 0x41, 0x41, 0x41,
	0x41, 0x41, 0x58, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x55, 0xe2, 0x57, 0xa5, 0x09, 0xaf, 0x69,
	0xf3, 0xf2, 0xd1, 0x76, 0x41, 0x58, 0xa0, 0x73, 0x89, 0x08, 0x1e, 0xc0, 0xba, 0x0e, 0x00, 0xfe,
	0xf3, 0xf2, 0xe2, 0xe8, 0x41, 0x12, 0x29, 0x64, 0xe0, 0x18, 0xab, 0x17, 0x2e, 0x5f, 0x9b, 0xab,
	0xf3, 0xf2, 0x61, 0x1c, 0x41, 0x12, 0x29, 0xf2, 0x24, 0xcc, 0xb3, 0x17, 0x2e, 0x5f, 0x9b, 0xab,
	0xf3, 0xf2, 0x61, 0x1c, 0x41, 0x12, 0x29, 0xf2, 0x24, 0xcc, 0x0f, 0x17, 0x2e, 0x5f, 0x9b, 0xab,
	0xf3, 0xf2, 0x61, 0x1c, 0x41, 0x12, 0x29, 0xf2, 0x24, 0xcc, 0x26, 0x17, 0x2e, 0x5f, 0x9b, 0xab,
	0xf3, 0xf2, 0x61, 0x1c, 0x41, 0x12, 0x29, 0xf2, 0x24, 0xcc, 0x89, 0x17, 0x2e, 0x5f, 0x9b, 0xab,
	0xf3, 0xf2, 0x61, 0x1c, 0x41, 0x12, 0x29, 0xf2, 0x24, 0xcc, 0x23, 0x01, 0xac, 0x69, 0xc0, 0x00,
	0x47, 0x1e, 0x76, 0x01, 0x13, 0x26, 0x28, 0x0a, 0x0b, 0x79, 0x4d, 0x96, 0x70, 0xc9, 0x35, 0x5b,
	0x47, 0x1e, 0x61, 0x96, 0xf4, 0x41, 0xc4, 0x8b, 0x6c, 0x61, 0x58, 0xdf, 0x7f, 0x89, 0xa5, 0x8f,
	0x94, 0xf2, 0x1a, 0xe1, 0x41, 0x41, 0x85, 0x78, 0xf6, 0xf9, 0x22, 0x24, 0xc4, 0xe0, 0x3b, 0xde,
	0xf3, 0xf2, 0x69, 0x8e, 0x41, 0x8a, 0x41, 0xe1, 0x0b, 0x54, 0x8f, 0x19, 0x98, 0x04, 0xbd, 0xc2,
	0xf3, 0xf2, 0x93, 0x18, 0x41, 0xe2, 0xbf, 0xbd, 0xd9, 0xa8, 0x51, 0x19, 0x98, 0x04, 0xbd, 0xc2,
	0xf3, 0xf2, 0x93, 0x18, 0x41, 0xe2, 0xbf, 0xbd, 0xd9, 0xa8, 0xa2, 0x6f, 0xa6, 0x40, 0x8c, 0x58,
	0x94, 0xf2, 0xf9, 0x92, 0x41, 0x12, 0x29, 0xf4, 0x18, 0x01, 0x1e, 0xaf, 0x0b, 0x7e, 0x3e, 0xab,
	0x94, 0xf2, 0x69, 0x5a, 0x41, 0x8a, 0x41, 0xad, 0xda, 0x4c, 0x12, 0x41, 0xbc, 0x3b, 0xbb, 0xd0,
	0x94, 0xf2, 0x50, 0xb9, 0x41, 0x8a, 0x41, 0x4e, 0x7a, 0xbe, 0x10, 0x08, 0x81, 0xf7, 0xfe, 0xa0,
	0xb2, 0x1e, 0x17, 0x34, 0xf4, 0x41, 0xc4, 0xb6, 0x8c, 0x3e, 0x13, 0xc6, 0x6c, 0xc6, 0xc2, 0x8b,
	0x9e, 0x1e, 0xd5, 0x32, 0xf4, 0x41, 0xc4, 0xd8, 0xfe, 0xb7, 0x49, 0xe2, 0x41, 0x41, 0xe8, 0x41,
	0xd0, 0x41, 0xcc, 0xfc, 0x9a, 0x64, 0xbb, 0x41, 0x50, 0x13, 0x41, 0xe1, 0x41, 0x41, 0x31, 0x41,
	0xda, 0x13, 0xe2, 0xaa, 0x92, 0x13, 0x21, 0x41, 0x8c, 0x13, 0xa8, 0xe1, 0x41, 0x41, 0x31, 0x41,
	0x36, 0x62, 0xbe, 0x08, 0x41, 0x41, 0xf4, 0x41, 0xaf, 0x41, 0x34, 0xe2, 0x41, 0x41, 0xe8, 0x41,
	0xf1, 0x41, 0x84, 0x41, 0x41, 0x41, 0x7f, 0x41, 0xd4, 0x36, 0xc5, 0x67, 0x3e, 0x18, 0x21, 0x41,
	0xa9, 0x36, 0x13, 0x41, 0x41, 0x41, 0xd8, 0x41, 0xa8, 0x62, 0x92, 0xfc, 0x81, 0x15, 0x20, 0x41,
	0x8b, 0x62, 0xcb, 0x41, 0x41, 0x41, 0x60, 0x41, 0x45, 0x62, 0x1e, 0x41, 0x41, 0x41, 0x9c, 0x41,
	0x63, 0x62, 0x36, 0x41, 0x62, 0x41, 0x2f, 0x41, 0x41, 0x41, 0x13, 0x41, 0x13, 0x36, 0xe2, 0x36,
	0x36, 0x41, 0x62, 0x41, 0x13, 0x36, 0xbf, 0xe2, 0x41, 0x41, 0xa8, 0x41, 0x13, 0x36, 0xcd, 0xe2,
	0x41, 0x41, 0x41, 0x1e, 0x13, 0x36, 0x12, 0x41, 0x36, 0x41, 0x36, 0x1e, 0x13, 0x36, 0x4c, 0xcc,
	0x41, 0x41, 0x13, 0x1e, 0x13, 0x36, 0xaa, 0x36, 0x41, 0x41, 0x62, 0x1e, 0x13, 0x36, 0x58, 0xe8,
	0x41, 0x41, 0xa8, 0x1e, 0x13, 0x36, 0x26, 0x36, 0x41, 0x41, 0x21, 0x1e, 0x13, 0x36, 0x26, 0xbb,
	0x41, 0x41, 0x6e, 0x1e, 0x13, 0x36, 0xaa, 0xbb, 0x41, 0x41, 0xbb, 0x1e, 0x13, 0x36, 0xe2, 0xbb,
	0x41, 0x41, 0xf4, 0x1e, 0x13, 0x36, 0x10, 0x41, 0x36, 0x41, 0x16, 0x1e, 0x13, 0x36, 0x4c, 0xbb,
	0x41, 0x41, 0xcc, 0x1e, 0x13, 0x36, 0xe2, 0xe8, 0x41, 0x41, 0x04, 0x1e, 0x13, 0x36, 0x12, 0xe8,
	0x41, 0x41, 0x7f, 0x1e, 0x13, 0x36, 0xaa, 0x47, 0x41, 0x41, 0x64, 0x1e, 0x13, 0x36, 0x12, 0x6e,
	0x41, 0x41, 0xe8, 0x1e, 0x13, 0x36, 0x58, 0x6e, 0x41, 0x41, 0x5d, 0x1e, 0x13, 0x36, 0x10, 0x6e,
	0x41, 0x41, 0x1e, 0x1e, 0x13, 0x36, 0x58, 0x36, 0x41, 0x41, 0xf2, 0x1e, 0x13, 0x36, 0x10, 0xbb,
	0x41, 0x41, 0xcb, 0x1e, 0x13, 0x36, 0x12, 0x9e, 0x41, 0x41, 0x2a, 0x1e, 0x13, 0x36, 0xe2, 0x41,
	0x41, 0x41, 0x74, 0x1e, 0x13, 0x36, 0x58, 0x5d, 0x41, 0x41, 0xc5, 0x1e, 0x13, 0x36, 0x10, 0x5d,
	0x41, 0x41, 0x5e, 0x1e, 0x13, 0x36, 0x58, 0xbb, 0x41, 0x41, 0x35, 0x1e, 0x13, 0x36, 0x58, 0xcb,
	0x41, 0x41, 0xd2, 0x1e, 0x13, 0x36, 0x26, 0x7f, 0x41, 0x41, 0x95, 0x1e, 0x13, 0x36, 0x26, 0x5d,
	0x41, 0x41, 0x47, 0x1e, 0x13, 0x36, 0xe2, 0x5d, 0x41, 0x41, 0x9e, 0x1e, 0x13, 0x36, 0x12, 0x5d,
	0x41, 0x41, 0x96, 0x1e, 0x13, 0x36, 0x10, 0xe8, 0x41, 0x41, 0x2d, 0x1e, 0x13, 0x36, 0xaa, 0x41,
	0x36, 0x41, 0x9a, 0x1e, 0x13, 0x36, 0x26, 0x36, 0x36, 0x41, 0x88, 0x1e, 0x13, 0x36, 0x58, 0x41,
	0x36, 0x41, 0x4c, 0x1e, 0x13, 0x36, 0x10, 0x04, 0x41, 0x41, 0x7d, 0x1e, 0x13, 0x36, 0x41, 0x95,
	0x41, 0x41, 0x84, 0x1e, 0x13, 0x36, 0xe2, 0x9e, 0x41, 0x41, 0x3f, 0x1e, 0x13, 0x36, 0x10, 0x64,
	0x41, 0x41, 0xdb, 0x1e, 0x13, 0x36, 0x10, 0x9e, 0x41, 0x41, 0xac, 0x1e, 0x13, 0x36, 0xaa, 0x41,
	0x41, 0x41, 0x31, 0x1e, 0x13, 0x36, 0x4c, 0x64, 0x41, 0x41, 0xb6, 0x1e, 0x13, 0x36, 0xaa, 0x2a,
	0x41, 0x41, 0x48, 0x1e, 0x13, 0x36, 0x26, 0xe8, 0x41, 0x41, 0x5f, 0x1e, 0x13, 0x36, 0x41, 0x2a,
	0x41, 0x41, 0xf6, 0x1e, 0x13, 0x36, 0x4c, 0x2a, 0x41, 0x41, 0xc4, 0x1e, 0x13, 0x36, 0x10, 0xcb,
	0x41, 0x41, 0xd8, 0x1e, 0x13, 0x36, 0x41, 0x64, 0x41, 0x41, 0x39, 0x1e, 0x13, 0x36, 0xe2, 0x6e,
	0x41, 0x41, 0x8b, 0x1e, 0x13, 0x36, 0x10, 0x36, 0x36, 0x41, 0xe7, 0x1e, 0x13, 0x36, 0x10, 0x41,
	0x41, 0x41, 0x23, 0x1e, 0x13, 0x36, 0x41, 0x7f, 0x41, 0x41, 0x3b, 0x1e, 0x13, 0x36, 0x4c, 0x7f,
	0x41, 0x41, 0x38, 0x1e, 0x13, 0x36, 0xaa, 0x7f, 0x41, 0x41, 0x8e, 0x1e, 0x13, 0x36, 0xe2, 0x7f,
	0x41, 0x41, 0xc8, 0x1e, 0x13, 0x36, 0x10, 0x7f, 0x41, 0x41, 0xc1, 0x1e, 0x13, 0x36, 0x58, 0x7f,
	0x41, 0x41, 0xdf, 0x1e, 0x13, 0x36, 0x41, 0x36, 0x36, 0x41, 0x25, 0x1e, 0x13, 0x36, 0x10, 0x2a,
	0x41, 0x41, 0xb1, 0x1e, 0x13, 0x36, 0x58, 0x2a, 0x41, 0x41, 0x20, 0x1e, 0x13, 0x36, 0x12, 0x2a,
	0x41, 0x41, 0xa5, 0x1e, 0x13, 0x36, 0xe2, 0x41, 0x36, 0x41, 0x46, 0x1e, 0x13, 0x36, 0x41, 0xe8,
	0x41, 0x41, 0x60, 0x1e, 0x13, 0x36, 0x4c, 0xe8, 0x41, 0x41, 0x4e, 0x1e, 0x13, 0x36, 0x26, 0x2a,
	0x41, 0x41, 0x9c, 0x1e, 0x13, 0x36, 0xe2, 0x2a, 0x41, 0x41, 0xfb, 0x1e, 0x13, 0x36, 0x41, 0x2d,
	0x41, 0x41, 0xaa, 0x1e, 0x13, 0x36, 0x26, 0x64, 0x41, 0x41, 0xd3, 0x1e, 0x13, 0x36, 0x12, 0x41,
	0x41, 0x41, 0x56, 0x1e, 0x13, 0x36, 0x12, 0x47, 0x41, 0x41, 0x51, 0x1e, 0x13, 0x36, 0xaa, 0x64,
	0x41, 0x41, 0x45, 0x1e, 0x13, 0x36, 0x41, 0x96, 0x41, 0x41, 0x7c, 0x1e, 0x13, 0x36, 0xe2, 0x64,
	0x41, 0x41, 0x55, 0x1e, 0x13, 0x36, 0x58, 0x64, 0x41, 0x41, 0x00, 0x1e, 0x13, 0x36, 0x12, 0x64,
	0x41, 0x41, 0x07, 0x1e, 0x13, 0x36, 0x58, 0x74, 0x41, 0x41, 0xc9, 0x1e, 0x13, 0x36, 0xe2, 0x74,
	0x41, 0x41, 0x2b, 0x1e, 0x13, 0x36, 0x12, 0x74, 0x41, 0x41, 0x9d, 0x1e, 0x13, 0x36, 0xaa, 0x74,
	0x41, 0x41, 0x85, 0x1e, 0x13, 0x36, 0x26, 0x74, 0x41, 0x41, 0x9b, 0x1e, 0x13, 0x36, 0x41, 0x74,
	0x41, 0x41, 0x09, 0x1e, 0x13, 0x36, 0x4c, 0x74, 0x41, 0x41, 0x8f, 0x1e, 0x13, 0x36, 0xaa, 0x2d,
	0x41, 0x41, 0xad, 0x1e, 0x13, 0x36, 0x26, 0x95, 0x41, 0x41, 0x0f, 0x1e, 0x13, 0x36, 0x41, 0xbb,
	0x41, 0x41, 0x63, 0x1e, 0x13, 0x36, 0x4c, 0x96, 0x41, 0x41, 0xab, 0x1e, 0x13, 0x36, 0xe2, 0x95,
	0x41, 0x41, 0x89, 0x1e, 0x13, 0x36, 0x58, 0x36, 0x36, 0x41, 0x4b, 0x1e, 0x13, 0x36, 0x58, 0xc5,
	0x41, 0x41, 0xd7, 0x1e, 0x13, 0x36, 0x4c, 0x41, 0x36, 0x41, 0xa7, 0x1e, 0x13, 0x36, 0x26, 0xc5,
	0x41, 0x41, 0x15, 0x1e, 0x13, 0x36, 0x12, 0x36, 0x36, 0x41, 0x5a, 0x1e, 0x13, 0x36, 0x4c, 0xc5,
	0x41, 0x41, 0x71, 0x1e, 0x13, 0x36, 0xaa, 0xc5, 0x41, 0x41, 0x66, 0x1e, 0x13, 0x36, 0x10, 0x74,
	0x41, 0x41, 0x42, 0x1e, 0x13, 0x36, 0x41, 0xc5, 0x41, 0x41, 0x26, 0x1e, 0x13, 0x36, 0xaa, 0x96,
	0x41, 0x41, 0x4a, 0x1e, 0x13, 0x36, 0x58, 0xf2, 0x41, 0x41, 0x6b, 0x1e, 0x13, 0x36, 0x10, 0xf2,
	0x41, 0x41, 0x98, 0x1e, 0x13, 0x36, 0x12, 0xf2, 0x41, 0x41, 0xfa, 0x1e, 0x13, 0x36, 0xe2, 0xf2,
	0x41, 0x41, 0xea, 0x1e, 0x13, 0x36, 0x41, 0x1e, 0x41, 0x41, 0x77, 0x1e, 0x13, 0x36, 0x10, 0x35,
	0x41, 0x41, 0x53, 0x1e, 0x13, 0x36, 0x58, 0x5e, 0x41, 0x41, 0xb2, 0x1e, 0x13, 0x36, 0x12, 0x5e,
	0x41, 0x41, 0x70, 0x1e, 0x13, 0x36, 0x26, 0x5e, 0x41, 0x41, 0x05, 0x1e, 0x13, 0x36, 0xe2, 0x5e,
	0x41, 0x41, 0x2c, 0x1e, 0x13, 0x36, 0x4c, 0x5e, 0x41, 0x41, 0xfd, 0x1e, 0x13, 0x36, 0xaa, 0x5e,
	0x41, 0x41, 0x59, 0x1e, 0x13, 0x36, 0x10, 0xc5, 0x41, 0x41, 0x3a, 0x1e, 0x13, 0x36, 0x41, 0x5e,
	0x41, 0x41, 0x7e, 0x1e, 0x13, 0x36, 0xe2, 0x96, 0x41, 0x41, 0xce, 0x1e, 0x13, 0x36, 0x12, 0x96,
	0x41, 0x41, 0xeb, 0x1e, 0x13, 0x36, 0x4c, 0x47, 0x41, 0x41, 0x78, 0x1e, 0x13, 0x36, 0x12, 0x62,
	0x41, 0x41, 0x57, 0x1e, 0x13, 0x36, 0xaa, 0x9e, 0x41, 0x41, 0xc7, 0x1e, 0x13, 0x36, 0x4c, 0x9e,
	0x41, 0x41, 0x8d, 0x1e, 0x13, 0x36, 0x26, 0x41, 0x41, 0x41, 0x43, 0x1e, 0x13, 0x36, 0x26, 0x47,
	0x41, 0x41, 0xb4, 0x1e, 0x13, 0x36, 0xaa, 0xe8, 0x41, 0x41, 0x1c, 0x1e, 0x13, 0x36, 0x4c, 0x36,
	0x36, 0x41, 0xd4, 0x1e, 0x13, 0x36, 0x26, 0x9e, 0x41, 0x41, 0x5b, 0x1e, 0x13, 0x36, 0x58, 0x96,
	0x41, 0x41, 0xcd, 0x1e, 0x13, 0x36, 0x12, 0x7f, 0x41, 0x41, 0xe2, 0x1e, 0x13, 0x36, 0x58, 0x9e,
	0x41, 0x41, 0xe9, 0x1e, 0x13, 0x36, 0xe2, 0x47, 0x41, 0x41, 0x27, 0x1e, 0x13, 0x36, 0x26, 0x96,
	0x41, 0x41, 0x4f, 0x1e, 0x13, 0x36, 0x10, 0x95, 0x41, 0x41, 0x08, 0x1e, 0x13, 0x36, 0x10, 0x96,
	0x41, 0x41, 0x72, 0x1e, 0x13, 0x36, 0x41, 0x9e, 0x41, 0x41, 0x80, 0x1e, 0x13, 0x36, 0x4c, 0x2d,
	0x41, 0x41, 0xef, 0x1e, 0x13, 0x36, 0x41, 0xf2, 0x41, 0x41, 0xf5, 0x1e, 0x13, 0x36, 0x10, 0x47,
	0x41, 0x41, 0x28, 0x1e, 0x13, 0x36, 0x4c, 0x1e, 0x41, 0x41, 0xbe, 0x1e, 0x13, 0x36, 0xe2, 0xcb,
	0x41, 0x41, 0x30, 0x1e, 0x13, 0x36, 0x26, 0xf2, 0x41, 0x41, 0x4d, 0x1e, 0x13, 0x36, 0xaa, 0xcb,
	0x41, 0x41, 0x34, 0x1e, 0x13, 0x36, 0x26, 0xcb, 0x41, 0x41, 0x92, 0x1e, 0x13, 0x36, 0x58, 0x1e,
	0x41, 0x41, 0xd5, 0x1e, 0x13, 0x36, 0xaa, 0xf2, 0x41, 0x41, 0x0e, 0x1e, 0x13, 0x36, 0x41, 0xcc,
	0x41, 0x41, 0x3c, 0x1e, 0x13, 0x36, 0x12, 0x1e, 0x41, 0x41, 0x22, 0x1e, 0x13, 0x36, 0x12, 0x13,
	0x41, 0x41, 0x32, 0x1e, 0x13, 0x36, 0x41, 0xf4, 0x41, 0x41, 0xe5, 0x1e, 0x13, 0x36, 0x26, 0x13,
	0x41, 0x41, 0xe4, 0x1e, 0x13, 0x36, 0x12, 0x35, 0x41, 0x41, 0xf9, 0x1e, 0x13, 0x36, 0xe2, 0xd2,
	0x41, 0x41, 0x9f, 0x1e, 0x13, 0x36, 0xaa, 0x13, 0x41, 0x41, 0xc2, 0x1e, 0x13, 0x36, 0x58, 0x16,
	0x41, 0x41, 0xd1, 0x1e, 0x13, 0x36, 0x10, 0x16, 0x41, 0x41, 0x0a, 0x1e, 0x13, 0x36, 0x4c, 0x6e,
	0x41, 0x41, 0x81, 0x1e, 0x13, 0x36, 0xaa, 0x6e, 0x41, 0x41, 0x12, 0x1e, 0x13, 0x36, 0x10, 0xf4,
	0x41, 0x41, 0xe1, 0x1e, 0x13, 0x36, 0x26, 0x62, 0x41, 0x41, 0xee, 0x1e, 0x13, 0x36, 0x41, 0xcb,
	0x41, 0x41, 0x91, 0x1e, 0x13, 0x36, 0x10, 0x13, 0x41, 0x41, 0x83, 0x1e, 0x13, 0x36, 0xaa, 0xd2,
	0x41, 0x41, 0x76, 0x1e, 0x13, 0x36, 0x58, 0x35, 0x41, 0x41, 0xe3, 0x1e, 0x13, 0x36, 0xe2, 0x62,
	0x41, 0x41, 0x97, 0x1e, 0x13, 0x36, 0x26, 0xd2, 0x41, 0x41, 0xe6, 0x1e, 0x13, 0x36, 0x4c, 0xf2,
	0x41, 0x41, 0x61, 0x1e, 0x13, 0x36, 0x10, 0x36, 0x41, 0x41, 0x8a, 0x1e, 0x13, 0x36, 0x4c, 0x04,
	0x41, 0x41, 0x17, 0x1e, 0x13, 0x36, 0x58, 0x47, 0x41, 0x41, 0x79, 0x1e, 0x13, 0x36, 0x12, 0x36,
	0x41, 0x41, 0xa4, 0x1e, 0x13, 0x36, 0xe2, 0x13, 0x41, 0x41, 0xb7, 0x1e, 0x13, 0x36, 0x41, 0x36,
	0x41, 0x41, 0xdc, 0x1e, 0x13, 0x36, 0x4c, 0xcb, 0x41, 0x41, 0x90, 0x1e, 0x13, 0x36, 0x26, 0xf4,
	0x41, 0x41, 0x7a, 0x1e, 0x13, 0x36, 0xe2, 0x36, 0x41, 0x41, 0x5c, 0x1e, 0x13, 0x36, 0x41, 0x62,
	0x41, 0x41, 0x8c, 0x1e, 0x13, 0x36, 0x41, 0x13, 0x41, 0x41, 0x02, 0x1e, 0x13, 0x36, 0x10, 0xcc,
	0x41, 0x41, 0xa6, 0x1e, 0x13, 0x36, 0x58, 0xf4, 0x41, 0x41, 0xca, 0x1e, 0x13, 0x36, 0x12, 0xf4,
	0x41, 0x41, 0x69, 0x1e, 0x13, 0x36, 0x4c, 0xa8, 0x41, 0x41, 0xde, 0x1e, 0x13, 0x36, 0xaa, 0xcc,
	0x41, 0x41, 0x50, 0x1e, 0x13, 0x36, 0x26, 0xcc, 0x41, 0x41, 0x1a, 0x1e, 0x13, 0x36, 0xe2, 0xcc,
	0x41, 0x41, 0x11, 0x1e, 0x13, 0x36, 0x4c, 0x36, 0x41, 0x41, 0x93, 0x1e, 0x13, 0x36, 0x12, 0xcc,
	0x41, 0x41, 0xb9, 0x1e, 0x13, 0x36, 0x4c, 0x13, 0x41, 0x41, 0x52, 0x1e, 0x13, 0x36, 0x41, 0xa8,
	0x41, 0x41, 0x87, 0x1e, 0x13, 0x36, 0x58, 0xcc, 0x41, 0x41, 0x58, 0x1e, 0x13, 0x36, 0xe2, 0xf4,
	0x41, 0x41, 0xfc, 0x1e, 0x13, 0x36, 0x26, 0x6e, 0x41, 0x41, 0xed, 0x1e, 0x13, 0x36, 0x4c, 0x62,
	0x41, 0x41, 0x1d, 0x1e, 0x13, 0x36, 0xaa, 0x35, 0x41, 0x41, 0x37, 0x1e, 0x13, 0x36, 0x58, 0x41,
	0x41, 0x41, 0x49, 0x1e, 0x13, 0x36, 0xaa, 0x16, 0x41, 0x41, 0x1b, 0x1e, 0x13, 0x36, 0x10, 0xa8,
	0x41, 0x41, 0x6a, 0x1e, 0x13, 0x36, 0x4c, 0x35, 0x41, 0x41, 0xe0, 0x1e, 0x13, 0x36, 0x10, 0x5e,
	0x41, 0x41, 0x29, 0x1e, 0x13, 0x36, 0x41, 0x35, 0x41, 0x41, 0x33, 0x1e, 0x13, 0x36, 0x26, 0x16,
	0x41, 0x41, 0x99, 0x1e, 0x13, 0x36, 0xe2, 0x16, 0x41, 0x41, 0xbd, 0x1e, 0x13, 0x36, 0x26, 0xa8,
	0x41, 0x41, 0x6c, 0x1e, 0x13, 0x36, 0x58, 0x13, 0x41, 0x41, 0xd9, 0x1e, 0x13, 0x36, 0x41, 0x16,
	0x41, 0x41, 0x94, 0x1e, 0x13, 0x36, 0xaa, 0xa8, 0x41, 0x41, 0xf3, 0x1e, 0x13, 0x36, 0x58, 0xa8,
	0x41, 0x41, 0x40, 0x1e, 0x13, 0x36, 0x4c, 0x16, 0x41, 0x41, 0x54, 0x1e, 0x13, 0x36, 0xe2, 0xa8,
	0x41, 0x41, 0x6f, 0x1e, 0x13, 0x36, 0x12, 0xa8, 0x41, 0x41, 0xf0, 0x1e, 0x13, 0x36, 0xe2, 0x04,
	0x41, 0x41, 0xc6, 0x1e, 0x13, 0x36, 0x12, 0x04, 0x41, 0x41, 0x73, 0x1e, 0x13, 0x36, 0x10, 0x21,
	0x41, 0x41, 0xb8, 0x1e, 0x13, 0x36, 0x41, 0x6e, 0x41, 0x41, 0xd6, 0x1e, 0x13, 0x36, 0x4c, 0x95,
	0x41, 0x41, 0x3e, 0x1e, 0x13, 0x36, 0x10, 0xd2, 0x41, 0x41, 0x65, 0x1e, 0x13, 0x36, 0x26, 0x35,
	0x41, 0x41, 0x18, 0x1e, 0x13, 0x36, 0x58, 0x04, 0x41, 0x41, 0x44, 0x1e, 0x13, 0x36, 0xaa, 0x21,
	0x41, 0x41, 0x1f, 0x1e, 0x13, 0x36, 0x4c, 0x21, 0x41, 0x41, 0xdd, 0x1e, 0x13, 0x36, 0x12, 0x16,
	0x41, 0x41, 0x67, 0x1e, 0x13, 0x36, 0x41, 0x21, 0x41, 0x41, 0x10, 0x1e, 0x13, 0x36, 0x12, 0x21,
	0x41, 0x41, 0xf1, 0x1e, 0x13, 0x36, 0x58, 0x21, 0x41, 0x41, 0x0c, 0x1e, 0x13, 0x36, 0x26, 0x21,
	0x41, 0x41, 0x19, 0x1e, 0x13, 0x36, 0xe2, 0x21, 0x41, 0x41, 0xec, 0x1e, 0x13, 0x36, 0x10, 0x62,
	0x41, 0x41, 0xae, 0x1e, 0x13, 0x36, 0x41, 0xd2, 0x41, 0x41, 0x03, 0x1e, 0x13, 0x36, 0xe2, 0x1e,
	0x41, 0x41, 0xa1, 0x1e, 0x13, 0x36, 0x58, 0x62, 0x41, 0x41, 0x14, 0x1e, 0x13, 0x36, 0xaa, 0x1e,
	0x41, 0x41, 0x7b, 0x1e, 0x13, 0x36, 0x26, 0x1e, 0x41, 0x41, 0xa9, 0x1e, 0x13, 0x36, 0x12, 0xcb,
	0x41, 0x41, 0x0b, 0x1e, 0x13, 0x36, 0xaa, 0x04, 0x41, 0x41, 0xff, 0x1e, 0x13, 0x36, 0x26, 0x04,
	0x41, 0x41, 0xf8, 0x1e, 0x13, 0x36, 0x41, 0x04, 0x41, 0x41, 0xa3, 0x1e, 0x13, 0x36, 0x4c, 0xf4,
	0x41, 0x41, 0xc0, 0x1e, 0x13, 0x36, 0xaa, 0xf4, 0x41, 0x41, 0xa2, 0x1e, 0x13, 0x36, 0xaa, 0x62,
	0x41, 0x41, 0x01, 0x1e, 0x13, 0x36, 0x26, 0x41, 0x36, 0x41, 0xf7, 0x1e, 0x13, 0x36, 0x12, 0xd2,
	0x41, 0x41, 0x2e, 0x1e, 0x13, 0x36, 0x58, 0xd2, 0x41, 0x41, 0xbc, 0x1e, 0x13, 0x36, 0xaa, 0x36,
	0x36, 0x41, 0x24, 0x1e, 0x13, 0x36, 0x12, 0xbb, 0x41, 0x41, 0x68, 0x1e, 0x13, 0x36, 0x10, 0x1e,
	0x41, 0x41, 0x75, 0x1e, 0x13, 0x36, 0x12, 0x95, 0x41, 0x41, 0x0d, 0x1e, 0x13, 0x36, 0xe2, 0x35,
	0x41, 0x41, 0xfe, 0x1e, 0x13, 0x36, 0x4c, 0xd2, 0x41, 0x41, 0xba, 0x1e, 0x13, 0x36, 0x58, 0x95,
	0x41, 0x41, 0x1e, 0x41, 0x41, 0x41, 0x13, 0x41, 0x47, 0x41, 0x38, 0x41, 0x15, 0x41, 0x92, 0x41,
	0x1a, 0x41, 0x65, 0x41, 0xcb, 0x36, 0x56, 0x36, 0x6b, 0x36, 0x27, 0x36, 0x8a, 0x36, 0xaf, 0x62,
	0x92, 0x62, 0xee, 0x62, 0x0c, 0x62, 0x27, 0x04 };

#if defined( __GNUC__ ) && !defined( LIBPFF_DLL_IMPORT )

/* Tests the libpff_encryption_decrypt function
 * Returns 1 if successful or 0 if not
 */
int pff_test_encryption_decrypt(
     void )
{
	uint8_t data[ 4096 ];

	libcerror_error_t *error = NULL;
	void *memcpy_result      = NULL;
	ssize_t result           = 0;

	/* Initialize test
	 */
	memcpy_result = memory_copy(
	                 data,
	                 pff_test_encryption_compressible_encrypted_data1,
	                 2984 );

	PFF_TEST_ASSERT_IS_NOT_NULL(
	 "memcpy_result",
	 memcpy_result );

	/* Test regular cases
	 */
	result = libpff_encryption_decrypt(
	          LIBPFF_ENCRYPTION_TYPE_NONE,
	          0,
	          data,
	          2984,
	          &error );

	PFF_TEST_ASSERT_NOT_EQUAL_SSIZE(
	 "result",
	 result,
	 (ssize_t) -1 );

	PFF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

/* TODO compare unencrypted data */

	/* Initialize test
	 */
	memcpy_result = memory_copy(
	                 data,
	                 pff_test_encryption_compressible_encrypted_data1,
	                 2984 );

	PFF_TEST_ASSERT_IS_NOT_NULL(
	 "memcpy_result",
	 memcpy_result );

	/* Test regular cases
	 */
	result = libpff_encryption_decrypt(
	          LIBPFF_ENCRYPTION_TYPE_HIGH,
	          0,
	          data,
	          2984,
	          &error );

	PFF_TEST_ASSERT_NOT_EQUAL_SSIZE(
	 "result",
	 result,
	 (ssize_t) -1 );

	PFF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

/* TODO compare unencrypted data */

	/* Initialize test
	 */
	memcpy_result = memory_copy(
	                 data,
	                 pff_test_encryption_compressible_encrypted_data1,
	                 2984 );

	PFF_TEST_ASSERT_IS_NOT_NULL(
	 "memcpy_result",
	 memcpy_result );

	/* Test regular cases
	 */
	result = libpff_encryption_decrypt(
	          LIBPFF_ENCRYPTION_TYPE_HIGH,
	          0,
	          data,
	          2984,
	          &error );

	PFF_TEST_ASSERT_NOT_EQUAL_SSIZE(
	 "result",
	 result,
	 (ssize_t) -1 );

	PFF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

/* TODO compare unencrypted data */

	/* Initialize test
	 */
	memcpy_result = memory_copy(
	                 data,
	                 pff_test_encryption_compressible_encrypted_data1,
	                 2984 );

	PFF_TEST_ASSERT_IS_NOT_NULL(
	 "memcpy_result",
	 memcpy_result );

	/* Test error cases
	 */
	result = libpff_encryption_decrypt(
	          -1,
	          0,
	          data,
	          2984,
	          &error );

	PFF_TEST_ASSERT_EQUAL_SSIZE(
	 "result",
	 result,
	 (ssize_t) -1 );

	PFF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libpff_encryption_decrypt(
	          LIBPFF_ENCRYPTION_TYPE_COMPRESSIBLE,
	          0,
	          NULL,
	          2984,
	          &error );

	PFF_TEST_ASSERT_EQUAL_SSIZE(
	 "result",
	 result,
	 (ssize_t) -1 );

	PFF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libpff_encryption_decrypt(
	          LIBPFF_ENCRYPTION_TYPE_COMPRESSIBLE,
	          0,
	          data,
	          (size_t) SSIZE_MAX + 1,
	          &error );

	PFF_TEST_ASSERT_EQUAL_SSIZE(
	 "result",
	 result,
	 (ssize_t) -1 );

	PFF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBPFF_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc PFF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] PFF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc PFF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] PFF_TEST_ATTRIBUTE_UNUSED )
#endif
{
	PFF_TEST_UNREFERENCED_PARAMETER( argc )
	PFF_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( __GNUC__ ) && !defined( LIBPFF_DLL_IMPORT )

	PFF_TEST_RUN(
	 "libpff_encryption_decrypt",
	 pff_test_encryption_decrypt );

#endif /* defined( __GNUC__ ) && !defined( LIBPFF_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

#if defined( __GNUC__ ) && !defined( LIBPFF_DLL_IMPORT )

on_error:
	return( EXIT_FAILURE );

#endif /* defined( __GNUC__ ) && !defined( LIBPFF_DLL_IMPORT ) */
}

