/*===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
*/

#ifndef _h_syslock_priv_
#define _h_syslock_priv_

#include <pthread.h>

#ifndef _h_klib_defs_
#include <klib/defs.h>
#endif

#ifndef _h_atomic32_
#include <atomic32.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------
 * KLock
 *  a POSIX-style mutual exclusion lock
 */
struct KLock
{
    pthread_mutex_t mutex;
    atomic32_t refcount;
};

/*--------------------------------------------------------------------------
 * KTimedLock
 *  a POSIX-style mutual exclusion lock
 *  with some facilities for timed operations
 */
struct KTimedLock
{
    pthread_mutex_t mutex;
    pthread_mutex_t cond_lock;
    pthread_cond_t cond;
    uint32_t waiters;
    atomic32_t refcount;
};

#ifdef __cplusplus
}
#endif

#endif /* _h_syslock_priv_ */
