
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeValue import AttributeValue


class AttributeList(ctypes.Structure):
    pass

def AttributeList_New():
    c_New = conf.lib.OTF2_AttributeList_New
    c_New.argtypes = []
    c_New.restype = ctypes.POINTER(AttributeList)
    # NOTE: Do not errcheck here. This function returns a value, not an error code
    return c_New()

def AttributeList_Delete(attributeList):
    c_Delete = conf.lib.OTF2_AttributeList_Delete
    c_Delete.argtypes = [ ctypes.POINTER(AttributeList) ]
    c_Delete.restype = ErrorCode
    c_Delete.errcheck = HandleErrorCode
    c_Delete(attributeList)

def AttributeList_AddAttribute(attributeList, attribute, type, attributeValue):
    c_AddAttribute = conf.lib.OTF2_AttributeList_AddAttribute
    c_AddAttribute.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, Type, AttributeValue._arg_type ]
    c_AddAttribute.restype = ErrorCode
    c_AddAttribute.errcheck = HandleErrorCode
    c_AddAttribute(attributeList, attribute, type, attributeValue._arg_value)

@otf2 for entry in Type.entries if entry.type:
def AttributeList_Add@@entry.type.otf2@@(attributeList, attribute, @@entry.type.lower@@Value):
    c_Add@@entry.type.otf2@@ = conf.lib.OTF2_AttributeList_Add@@entry.type.otf2@@
    c_Add@@entry.type.otf2@@.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, @@entry.type.py_argtype@@ ]
    c_Add@@entry.type.otf2@@.restype = ErrorCode
    c_Add@@entry.type.otf2@@.errcheck = HandleErrorCode
    c_Add@@entry.type.otf2@@(attributeList, attribute, @@entry.type.lower@@Value)

@otf2 endfor
def AttributeList_AddString(attributeList, attribute, stringRef):
    c_AddString = conf.lib.OTF2_AttributeList_AddString
    c_AddString.argtypes = [ctypes.POINTER(AttributeList), AttributeRef, StringRef]
    c_AddString.restype = ErrorCode
    c_AddString.errcheck = HandleErrorCode
    c_AddString(attributeList, attribute, stringRef)

@otf2 for entry in MappingType.entries:
@otf2  with def = entry.def
def AttributeList_Add@@entry.def.ref_name@@Ref(attributeList, attribute, @@def.ref_lname@@Ref):
    c_Add@@entry.def.ref_name@@Ref = conf.lib.OTF2_AttributeList_Add@@entry.def.ref_name@@Ref
    c_Add@@entry.def.ref_name@@Ref.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, @@def.self_attr.type.py_argtype@@ ]
    c_Add@@entry.def.ref_name@@Ref.restype = ErrorCode
    c_Add@@entry.def.ref_name@@Ref.errcheck = HandleErrorCode
    c_Add@@entry.def.ref_name@@Ref(attributeList, attribute, @@def.ref_lname@@Ref)

@otf2 endwith
@otf2 endfor
def AttributeList_RemoveAttribute(attributeList, attribute):
    c_RemoveAttribute = conf.lib.OTF2_AttributeList_RemoveAttribute
    c_RemoveAttribute.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef ]
    c_RemoveAttribute.restype = ErrorCode
    c_RemoveAttribute.errcheck = HandleErrorCode
    c_RemoveAttribute(attributeList, attribute)

def AttributeList_RemoveAllAttributes(attributeList):
    c_RemoveAllAttributes = conf.lib.OTF2_AttributeList_RemoveAllAttributes
    c_RemoveAllAttributes.argtypes = [ ctypes.POINTER(AttributeList) ]
    c_RemoveAllAttributes.restype = ErrorCode
    c_RemoveAllAttributes.errcheck = HandleErrorCode
    c_RemoveAllAttributes(attributeList)

def AttributeList_TestAttributeByID(attributeList, attribute):
    c_TestAttributeByID = conf.lib.OTF2_AttributeList_TestAttributeByID
    c_TestAttributeByID.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef ]
    c_TestAttributeByID.restype = ctypes.c_bool
    return c_TestAttributeByID(attributeList, attribute)

def AttributeList_GetAttributeByID(attributeList, attribute, attributeType = Type(), attributeValue = AttributeValue()):
    c_GetAttributeByID = conf.lib.OTF2_AttributeList_GetAttributeByID
    c_GetAttributeByID.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_GetAttributeByID.restype = ErrorCode
    c_GetAttributeByID.errcheck = HandleErrorCode
    c_GetAttributeByID(attributeList, attribute, ctypes.byref(attributeType), ctypes.byref(attributeValue))
    return (attributeType, attributeValue)

@otf2 for entry in Type.entries if entry.type:
def AttributeList_Get@@entry.type.otf2@@(attributeList, attribute):
    c_Get@@entry.type.otf2@@ = conf.lib.OTF2_AttributeList_Get@@entry.type.otf2@@
    c_Get@@entry.type.otf2@@.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(@@entry.type.py_argtype@@) ]
    c_Get@@entry.type.otf2@@.restype = ErrorCode
    c_Get@@entry.type.otf2@@.errcheck = HandleErrorCode
    @@entry.type.lower@@Value = @@entry.type.py_ctype@@()
    c_Get@@entry.type.otf2@@(attributeList, attribute, ctypes.byref(@@entry.type.lower@@Value))
    return @@entry.type.lower@@Value.value

@otf2 endfor
def AttributeList_GetString(attributeList, attribute):
    c_GetString = conf.lib.OTF2_AttributeList_GetString
    c_GetString.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(StringRef) ]
    c_GetString.restype = ErrorCode
    c_GetString.errcheck = HandleErrorCode
    stringRef = StringRef()
    c_GetString(attributeList, attribute, ctypes.byref(stringRef))
    return stringRef.value

@otf2 for entry in MappingType.entries:
@otf2  with def = entry.def
def AttributeList_Get@@def.ref_name@@Ref(attributeList, attribute):
    c_Get@@def.ref_name@@Ref = conf.lib.OTF2_AttributeList_Get@@def.ref_name@@Ref
    c_Get@@def.ref_name@@Ref.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(@@def.self_attr.type.py_argtype@@) ]
    c_Get@@def.ref_name@@Ref.restype = ErrorCode
    c_Get@@def.ref_name@@Ref.errcheck = HandleErrorCode
    @@def.ref_lname@@Ref = @@def.self_attr.type.py_ctype@@()
    c_Get@@def.ref_name@@Ref(attributeList, attribute, ctypes.byref(@@def.ref_lname@@Ref))
    return @@def.ref_lname@@Ref.value

@otf2  endwith
@otf2 endfor
def AttributeList_GetAttributeByIndex(attributeList, index, attribute = AttributeRef(),
                                      attributeType = Type(),attributeValue = AttributeValue()):
    c_GetAttributeByIndex = conf.lib.OTF2_AttributeList_GetAttributeByIndex
    c_GetAttributeByIndex.argtypes = [ ctypes.POINTER(AttributeList), ctypes.c_uint32, ctypes.POINTER(AttributeRef), ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_GetAttributeByIndex.restype = ErrorCode
    c_GetAttributeByIndex.errcheck = HandleErrorCode
    c_GetAttributeByIndex(attributeList, index, ctypes.byref(attribute), ctypes.byref(attributeType), ctypes.byref(attributeValue))
    return (attribute.value, attributeType, attributeValue)

def AttributeList_PopAttribute(attributeList, attribute = AttributeRef(),
                               attributeType = Type(), attributeValue = AttributeValue()):
    c_PopAttribute = conf.lib.OTF2_AttributeList_PopAttribute
    c_PopAttribute.argtypes = [ ctypes.POINTER(AttributeList), ctypes.POINTER(AttributeRef), ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_PopAttribute.restype = ErrorCode
    c_PopAttribute.errcheck = HandleErrorCode
    c_PopAttribute(attributeList, ctypes.byref(attribute), ctypes.byref(attributeType), ctypes.byref(attributeValue))
    return (attribute.value, attributeType, attributeValue)

def AttributeList_GetNumberOfElements(attributeList):
    c_GetNumberOfElements = conf.lib.OTF2_AttributeList_GetNumberOfElements
    c_GetNumberOfElements.argtype = [ ctypes.POINTER(AttributeList) ]
    c_GetNumberOfElements.restype = ctypes.c_uint32
    return c_GetNumberOfElements(attributeList)

__all__ = [
    'AttributeList',
    'AttributeList_New',
    'AttributeList_Delete',
    'AttributeList_AddAttribute',
    'AttributeList_AddString',
    @otf2 for entry in Type.entries if entry.type:
    'AttributeList_Add@@entry.type.otf2@@',
    'AttributeList_Get@@entry.type.otf2@@',
    @otf2 endfor
    'AttributeList_RemoveAttribute',
    'AttributeList_RemoveAllAttributes',
    'AttributeList_TestAttributeByID',
    'AttributeList_GetAttributeByID',
    @otf2 for entry in MappingType.entries:
    @otf2 with def = entry.def
    'AttributeList_Add@@entry.def.ref_name@@Ref',
    'AttributeList_Get@@def.ref_name@@Ref',
    @otf2 endwith
    @otf2 endfor
    'AttributeList_GetString',
    'AttributeList_GetAttributeByIndex',
    'AttributeList_PopAttribute',
    'AttributeList_GetNumberOfElements'
]
