# == Class: vmms::deps
#
#  vmms anchors and dependency management
#
class vmms::deps {
  # Setup anchors for install, config and service phases of the module.  These
  # anchors allow external modules to hook the begin and end of any of these
  # phases.  Package or service management can also be replaced by ensuring the
  # package is absent or turning off service management and having the
  # replacement depend on the appropriate anchors.  When applicable, end tags
  # should be notified so that subscribers can determine if installation,
  # config or service state changed and act on that if needed.
  anchor { 'vmms::install::begin': }
  -> Package<| tag == 'vmms-package'|>
  ~> anchor { 'vmms::install::end': }
  -> anchor { 'vmms::config::begin': }
  -> Vmms_config<||>
  ~> anchor { 'vmms::config::end': }
  -> anchor { 'vmms::db::begin': }
  -> anchor { 'vmms::db::end': }
  ~> anchor { 'vmms::dbsync::begin': }
  -> anchor { 'vmms::dbsync::end': }
  ~> anchor { 'vmms::service::begin': }
  ~> Service<| tag == 'vmms-service' |>
  ~> anchor { 'vmms::service::end': }

  Anchor['vmms::config::begin']
  -> Vmms_api_uwsgi_config<||>
  -> Anchor['vmms::config::end']

  # We need openstackclient before marking service end so that vmms
  # will have clients available to create resources. This tag handles the
  # openstackclient but indirectly since the client is not available in
  # all catalogs that don't need the client class (like many spec tests)
  Package<| tag == 'openstackclient'|>
  -> Anchor['vmms::service::end']

  # Installation or config changes will always restart services.
  Anchor['vmms::install::end'] ~> Anchor['vmms::service::begin']
  Anchor['vmms::config::end']  ~> Anchor['vmms::service::begin']
}
