% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completeUpload.R
\name{completeUpload}
\alias{completeUpload}
\title{Complete an upload}
\usage{
completeUpload(init, url = restUrl())
}
\arguments{
\item{init}{List containing \code{complete_url} and \code{session_token}.
This is typically the return value from \code{\link{startUpload}}.}

\item{url}{String containing the URL of the gypsum REST API.}
}
\value{
\code{NULL} is invisibly returned on successful completion.
}
\description{
Complete an upload session after all files have been uploaded.
}
\examples{
tmp <- tempfile()
dir.create(tmp)
write(file=file.path(tmp, "blah.txt"), LETTERS)
dir.create(file.path(tmp, "foo"))
write(file=file.path(tmp, "foo", "bar.txt"), 1:10)

if (interactive()) {
    init <- startUpload(
        project="test-R", 
        asset="upload-complete-check", 
        version="v1", 
        files=list.files(tmp, recursive=TRUE),
        probation=TRUE,
        directory=tmp
    )
    uploadFiles(init, directory=tmp)

    # Finishing the upload.
    completeUpload(init) 
}

}
\seealso{
\code{\link{startUpload}}, to create \code{init}.
}
\author{
Aaron Lun
}
