/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.CompassPoint;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixUnprojector;
import cds.healpix.SettableHashParts;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.HackersDelight;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

final class HealpixNestedVerticesAndPathComputer
implements VerticesAndPathComputer {
    private final HealpixNested h;
    private final HealpixUnprojector unprojector = new HealpixUnprojector();
    private final int nsideMinus1;
    private int baseCellHash;
    private int iInBaseCell;
    private int jInBaseCell;
    private int baseCellOffsetX;
    private int baseCellOffsetY;
    private int xInt;
    private int yInt;
    private double x;
    private double y;
    private final SettableHashParts hashPartsProxy = new SettableHashParts(){

        @Override
        public int baseCellHash() {
            return HealpixNestedVerticesAndPathComputer.this.baseCellHash;
        }

        @Override
        public int iInBaseCell() {
            return HealpixNestedVerticesAndPathComputer.this.iInBaseCell;
        }

        @Override
        public int jInBaseCell() {
            return HealpixNestedVerticesAndPathComputer.this.jInBaseCell;
        }

        @Override
        public void setBaseCellHash(int baseCelHash) {
            HealpixNestedVerticesAndPathComputer.this.baseCellHash = baseCelHash;
        }

        @Override
        public void setIInBaseCell(int iInBaseCel) {
            HealpixNestedVerticesAndPathComputer.this.iInBaseCell = iInBaseCel;
        }

        @Override
        public void setJInBaseCell(int jInBaseCel) {
            HealpixNestedVerticesAndPathComputer.this.jInBaseCell = jInBaseCel;
        }
    };

    HealpixNestedVerticesAndPathComputer(HealpixNested healpixNested) {
        this.h = healpixNested;
        this.nsideMinus1 = this.h.nsideRemainderMask;
    }

    @Override
    public int depth() {
        return this.h.depth;
    }

    @Override
    public double[] center(long hash) {
        double[] resultLonLat = new double[2];
        this.center(hash, resultLonLat);
        return resultLonLat;
    }

    @Override
    public void center(long hash, double[] resultLonLat) {
        this.centerOfPojectedCell(hash, resultLonLat);
        this.unprojector.unproject(resultLonLat[0], resultLonLat[1], resultLonLat);
    }

    @Override
    public double[] vertex(long hash, CompassPoint.Cardinal cardinalPoint) {
        double[] resultLonLat = new double[2];
        this.vertex(hash, cardinalPoint, resultLonLat);
        return resultLonLat;
    }

    @Override
    public void vertex(long hash, CompassPoint.Cardinal cardinalPoint, double[] resultLonLat) {
        this.centerOfPojectedCell(hash, resultLonLat);
        this.vertexLonLat(resultLonLat, cardinalPoint, resultLonLat);
    }

    @Override
    public EnumMap<CompassPoint.Cardinal, double[]> vertices(long hash, EnumSet<CompassPoint.Cardinal> cardinalPoints) {
        EnumMap<CompassPoint.Cardinal, double[]> verticesMap = new EnumMap<CompassPoint.Cardinal, double[]>(CompassPoint.Cardinal.class);
        double[] centerXY = this.centerOfPojectedCell(hash);
        for (CompassPoint.Cardinal c : cardinalPoints) {
            double[] resultLonLat = new double[2];
            this.vertexLonLat(centerXY, c, resultLonLat);
            verticesMap.put(c, resultLonLat);
        }
        return verticesMap;
    }

    @Override
    public void vertices(long hash, EnumMap<CompassPoint.Cardinal, double[]> cardinalPoints) {
        double[] centerXY = this.centerOfPojectedCell(hash);
        for (Map.Entry<CompassPoint.Cardinal, double[]> e : cardinalPoints.entrySet()) {
            this.vertexLonLat(centerXY, e.getKey(), e.getValue());
        }
    }

    @Override
    public double[][] pathAlongCellSide(long hash, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments) {
        int resultSize = isToVertexIncluded ? nSegments + 1 : nSegments;
        double[][] pathPoints = new double[resultSize][];
        this.pathAlongCellSide(hash, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints);
        return pathPoints;
    }

    @Override
    public void pathAlongCellSide(long hash, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments, double[][] pathPoints) {
        double[] centerXY = this.centerOfPojectedCell(hash);
        this.pathAlongCellSide(centerXY, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints, 0);
    }

    @Override
    public double[][] pathAlongCellEdge(long hash, CompassPoint.Cardinal startingVertex, boolean clockwiseDirection, int nSegmentsBySide) {
        double[][] pathPoints = new double[nSegmentsBySide << 2][];
        this.pathAlongCellEdge(hash, startingVertex, clockwiseDirection, nSegmentsBySide, pathPoints);
        return pathPoints;
    }

    @Override
    public void pathAlongCellEdge(long hash, CompassPoint.Cardinal startingVertex, boolean clockwiseDirection, int nSegmentsBySide, double[][] pathPoints) {
        CompassPoint.Cardinal vertex4;
        CompassPoint.Cardinal vertex3;
        CompassPoint.Cardinal vertex2;
        double[] centerXY = this.centerOfPojectedCell(hash);
        CompassPoint.Cardinal vertex1 = startingVertex;
        if (clockwiseDirection) {
            vertex2 = startingVertex.nextClockwise();
            vertex3 = vertex2.nextClockwise();
            vertex4 = vertex3.nextClockwise();
        } else {
            vertex2 = startingVertex.nextCounterClockwise();
            vertex3 = vertex2.nextCounterClockwise();
            vertex4 = vertex3.nextCounterClockwise();
        }
        this.pathAlongCellSide(centerXY, vertex1, vertex2, false, nSegmentsBySide, pathPoints, 0);
        this.pathAlongCellSide(centerXY, vertex2, vertex3, false, nSegmentsBySide, pathPoints, nSegmentsBySide);
        this.pathAlongCellSide(centerXY, vertex3, vertex4, false, nSegmentsBySide, pathPoints, nSegmentsBySide << 1);
        this.pathAlongCellSide(centerXY, vertex4, vertex1, false, nSegmentsBySide, pathPoints, (nSegmentsBySide << 2) - nSegmentsBySide);
    }

    private void pathAlongCellSide(double[] centerXY, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments, double[][] pathPoints, int fromPathPointsIndex) {
        int resultSize = isToVertexIncluded ? nSegments + 1 : nSegments;
        double fromOffsetX = fromVertex.timeXOffset(this.h.oneOverNside);
        double fromOffsetY = fromVertex.timeYOffset(this.h.oneOverNside);
        double stepX = (toVertex.timeXOffset(this.h.oneOverNside) - fromOffsetX) / (double)nSegments;
        double stepY = (toVertex.timeYOffset(this.h.oneOverNside) - fromOffsetY) / (double)nSegments;
        for (int i = 0; i < resultSize; ++i) {
            double[] pathPoint = new double[2];
            double x = centerXY[0] + fromOffsetX + (double)i * stepX;
            double y = centerXY[1] + fromOffsetY + (double)i * stepY;
            this.unprojector.unproject(x < 0.0 ? x + 8.0 : x, y, pathPoint);
            pathPoints[i + fromPathPointsIndex] = pathPoint;
        }
    }

    private void vertexLonLat(double[] centerXY, CompassPoint.Cardinal vertexDirection, double[] resultVertexLonLat) {
        double x = centerXY[0] + vertexDirection.timeXOffset(this.h.oneOverNside);
        double y = centerXY[1] + vertexDirection.timeYOffset(this.h.oneOverNside);
        this.unprojector.unproject(x < 0.0 ? x + 8.0 : x, y, resultVertexLonLat);
    }

    private double[] centerOfPojectedCell(long hash) {
        double[] resultXY = new double[2];
        this.centerOfPojectedCell(hash, resultXY);
        return resultXY;
    }

    private void centerOfPojectedCell(long hash, double[] resultXY) {
        this.checkRegularHash(hash);
        this.decodeRegularHash(hash);
        this.rotate45andScale2();
        this.shiftFromSmallCellCenterToBaseCellCenter();
        this.scaleToProjectionDividingByNside();
        this.computeBaseCellCenterOffsetsIn8x3Grid();
        this.applyBaseCellCenterOffsets();
        this.setResultIn(resultXY);
    }

    private void checkRegularHash(long hash) {
        if (hash < 0L || this.h.nHash < hash) {
            throw new IllegalArgumentException("Wrong hash value. Expected value in [0, " + this.h.nHash + "[; Actual value: " + hash);
        }
    }

    private void decodeRegularHash(long hash) {
        this.h.decodeRegularHash(hash, this.hashPartsProxy);
        assert (0 <= this.baseCellHash && this.baseCellHash < 12);
        assert (0 <= this.iInBaseCell && this.iInBaseCell < this.h.nside);
        assert (0 <= this.jInBaseCell && this.jInBaseCell < this.h.nside);
    }

    private void rotate45andScale2() {
        this.xInt = this.iInBaseCell - this.jInBaseCell;
        assert (-this.h.nside < this.xInt && this.xInt < this.h.nside);
        this.yInt = this.iInBaseCell + this.jInBaseCell;
        assert (0 <= this.yInt && this.yInt <= 2 * (this.h.nside - 1));
    }

    private void shiftFromSmallCellCenterToBaseCellCenter() {
        this.yInt -= this.nsideMinus1;
        assert (-this.h.nside < this.yInt && this.yInt < this.h.nside);
    }

    private void scaleToProjectionDividingByNside() {
        this.x = (double)this.xInt * this.h.oneOverNside;
        this.y = (double)this.yInt * this.h.oneOverNside;
    }

    private void computeBaseCellCenterOffsetsIn8x3Grid() {
        this.baseCellOffsetY = HealpixNestedVerticesAndPathComputer.divBy4Quotient(this.baseCellHash);
        assert (0 <= this.baseCellOffsetY && this.baseCellOffsetY <= 2);
        this.baseCellOffsetY = 1 - this.baseCellOffsetY;
        assert (-1 <= this.baseCellOffsetY && this.baseCellOffsetY <= 1);
        this.baseCellOffsetX = HealpixNestedVerticesAndPathComputer.divBy4Reminder(this.baseCellHash);
        assert (0 <= this.baseCellOffsetX && this.baseCellOffsetX <= 3);
        this.baseCellOffsetX <<= 1;
        assert (this.baseCellOffsetX == 0 || this.baseCellOffsetX == 2 || this.baseCellOffsetX == 4 || this.baseCellOffsetX == 6);
        this.baseCellOffsetX |= this.baseCellOffsetY & 1;
        assert (0 <= this.baseCellOffsetX && this.baseCellOffsetX <= 7);
    }

    private static int divBy4Quotient(int val) {
        return val >> 2;
    }

    private static int divBy4Reminder(int val) {
        return val & 3;
    }

    private void applyBaseCellCenterOffsets() {
        this.x += (double)this.baseCellOffsetX;
        this.y += (double)this.baseCellOffsetY;
        this.x += (double)((HackersDelight.toBits(this.x) & Long.MIN_VALUE) >>> 60);
    }

    private void setResultIn(double[] resultXY) {
        resultXY[0] = this.x;
        resultXY[1] = this.y;
    }
}

