// Code generated by Wire. DO NOT EDIT.

//go:generate go run -mod=mod github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package artifact

import (
	"context"
	"github.com/aquasecurity/trivy-db/pkg/db"
	"github.com/aquasecurity/trivy/pkg/cache"
	"github.com/aquasecurity/trivy/pkg/fanal/applier"
	"github.com/aquasecurity/trivy/pkg/fanal/artifact"
	image2 "github.com/aquasecurity/trivy/pkg/fanal/artifact/image"
	local2 "github.com/aquasecurity/trivy/pkg/fanal/artifact/local"
	"github.com/aquasecurity/trivy/pkg/fanal/artifact/repo"
	"github.com/aquasecurity/trivy/pkg/fanal/artifact/sbom"
	"github.com/aquasecurity/trivy/pkg/fanal/artifact/vm"
	"github.com/aquasecurity/trivy/pkg/fanal/image"
	"github.com/aquasecurity/trivy/pkg/fanal/types"
	"github.com/aquasecurity/trivy/pkg/fanal/walker"
	"github.com/aquasecurity/trivy/pkg/rpc/client"
	"github.com/aquasecurity/trivy/pkg/scan"
	"github.com/aquasecurity/trivy/pkg/scan/langpkg"
	"github.com/aquasecurity/trivy/pkg/scan/local"
	"github.com/aquasecurity/trivy/pkg/scan/ospkg"
	"github.com/aquasecurity/trivy/pkg/vulnerability"
)

// Injectors from inject.go:

// initializeImageScanService is for container image scanning in standalone mode
// e.g. dockerd, container registry, podman, etc.
func initializeImageScanService(ctx context.Context, imageName string, imageOpt types.ImageOptions, cacheOptions cache.Options, artifactOption artifact.Option) (scan.Service, func(), error) {
	cacheCache, cleanup, err := cache.New(cacheOptions)
	if err != nil {
		return scan.Service{}, nil, err
	}
	applierApplier := applier.NewApplier(cacheCache)
	scanner := ospkg.NewScanner()
	langpkgScanner := langpkg.NewScanner()
	config := db.Config{}
	client := vulnerability.NewClient(config)
	service := local.NewService(applierApplier, scanner, langpkgScanner, client)
	typesImage, cleanup2, err := image.NewContainerImage(ctx, imageName, imageOpt)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	artifactArtifact, err := image2.NewArtifact(typesImage, cacheCache, artifactOption)
	if err != nil {
		cleanup2()
		cleanup()
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup2()
		cleanup()
	}, nil
}

// initializeArchiveScanService is for container image archive scanning in standalone mode
// e.g. docker save -o alpine.tar alpine:3.15
func initializeArchiveScanService(ctx context.Context, filePath string, cacheOptions cache.Options, artifactOption artifact.Option) (scan.Service, func(), error) {
	cacheCache, cleanup, err := cache.New(cacheOptions)
	if err != nil {
		return scan.Service{}, nil, err
	}
	applierApplier := applier.NewApplier(cacheCache)
	scanner := ospkg.NewScanner()
	langpkgScanner := langpkg.NewScanner()
	config := db.Config{}
	client := vulnerability.NewClient(config)
	service := local.NewService(applierApplier, scanner, langpkgScanner, client)
	typesImage, err := image.NewArchiveImage(filePath)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	artifactArtifact, err := image2.NewArtifact(typesImage, cacheCache, artifactOption)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup()
	}, nil
}

// initializeFilesystemScanService is for filesystem scanning in standalone mode
func initializeFilesystemScanService(ctx context.Context, path string, cacheOptions cache.Options, artifactOption artifact.Option) (scan.Service, func(), error) {
	cacheCache, cleanup, err := cache.New(cacheOptions)
	if err != nil {
		return scan.Service{}, nil, err
	}
	applierApplier := applier.NewApplier(cacheCache)
	scanner := ospkg.NewScanner()
	langpkgScanner := langpkg.NewScanner()
	config := db.Config{}
	client := vulnerability.NewClient(config)
	service := local.NewService(applierApplier, scanner, langpkgScanner, client)
	fs := walker.NewFS()
	artifactArtifact, err := local2.NewArtifact(path, cacheCache, fs, artifactOption)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup()
	}, nil
}

// initializeRepositoryScanService is for repository scanning in standalone mode
func initializeRepositoryScanService(ctx context.Context, url string, cacheOptions cache.Options, artifactOption artifact.Option) (scan.Service, func(), error) {
	cacheCache, cleanup, err := cache.New(cacheOptions)
	if err != nil {
		return scan.Service{}, nil, err
	}
	applierApplier := applier.NewApplier(cacheCache)
	scanner := ospkg.NewScanner()
	langpkgScanner := langpkg.NewScanner()
	config := db.Config{}
	client := vulnerability.NewClient(config)
	service := local.NewService(applierApplier, scanner, langpkgScanner, client)
	fs := walker.NewFS()
	artifactArtifact, cleanup2, err := repo.NewArtifact(url, cacheCache, fs, artifactOption)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup2()
		cleanup()
	}, nil
}

// initializeSBOMScanService is for sbom scanning in standalone mode
func initializeSBOMScanService(ctx context.Context, filePath string, cacheOptions cache.Options, artifactOption artifact.Option) (scan.Service, func(), error) {
	cacheCache, cleanup, err := cache.New(cacheOptions)
	if err != nil {
		return scan.Service{}, nil, err
	}
	applierApplier := applier.NewApplier(cacheCache)
	scanner := ospkg.NewScanner()
	langpkgScanner := langpkg.NewScanner()
	config := db.Config{}
	client := vulnerability.NewClient(config)
	service := local.NewService(applierApplier, scanner, langpkgScanner, client)
	artifactArtifact, err := sbom.NewArtifact(filePath, cacheCache, artifactOption)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup()
	}, nil
}

// initializeVMScanService is for vm scanning in standalone mode
func initializeVMScanService(ctx context.Context, filePath string, cacheOptions cache.Options, artifactOption artifact.Option) (scan.Service, func(), error) {
	cacheCache, cleanup, err := cache.New(cacheOptions)
	if err != nil {
		return scan.Service{}, nil, err
	}
	applierApplier := applier.NewApplier(cacheCache)
	scanner := ospkg.NewScanner()
	langpkgScanner := langpkg.NewScanner()
	config := db.Config{}
	client := vulnerability.NewClient(config)
	service := local.NewService(applierApplier, scanner, langpkgScanner, client)
	walkerVM := walker.NewVM()
	artifactArtifact, err := vm.NewArtifact(filePath, cacheCache, walkerVM, artifactOption)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup()
	}, nil
}

// initializeRemoteImageScanService is for container image scanning in client/server mode
// e.g. dockerd, container registry, podman, etc.
func initializeRemoteImageScanService(ctx context.Context, imageName string, remoteCacheOptions cache.RemoteOptions, remoteScanOptions client.ServiceOption, imageOpt types.ImageOptions, artifactOption artifact.Option) (scan.Service, func(), error) {
	v := _wireValue
	service := client.NewService(remoteScanOptions, v...)
	typesImage, cleanup, err := image.NewContainerImage(ctx, imageName, imageOpt)
	if err != nil {
		return scan.Service{}, nil, err
	}
	remoteCache := cache.NewRemoteCache(ctx, remoteCacheOptions)
	artifactArtifact, err := image2.NewArtifact(typesImage, remoteCache, artifactOption)
	if err != nil {
		cleanup()
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup()
	}, nil
}

var (
	_wireValue = []client.Option(nil)
)

// initializeRemoteArchiveScanService is for container image archive scanning in client/server mode
// e.g. docker save -o alpine.tar alpine:3.15
func initializeRemoteArchiveScanService(ctx context.Context, filePath string, remoteCacheOptions cache.RemoteOptions, remoteScanOptions client.ServiceOption, artifactOption artifact.Option) (scan.Service, func(), error) {
	v := _wireValue
	service := client.NewService(remoteScanOptions, v...)
	typesImage, err := image.NewArchiveImage(filePath)
	if err != nil {
		return scan.Service{}, nil, err
	}
	remoteCache := cache.NewRemoteCache(ctx, remoteCacheOptions)
	artifactArtifact, err := image2.NewArtifact(typesImage, remoteCache, artifactOption)
	if err != nil {
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
	}, nil
}

// initializeRemoteFilesystemScanService is for filesystem scanning in client/server mode
func initializeRemoteFilesystemScanService(ctx context.Context, path string, remoteCacheOptions cache.RemoteOptions, remoteScanOptions client.ServiceOption, artifactOption artifact.Option) (scan.Service, func(), error) {
	v := _wireValue
	service := client.NewService(remoteScanOptions, v...)
	remoteCache := cache.NewRemoteCache(ctx, remoteCacheOptions)
	fs := walker.NewFS()
	artifactArtifact, err := local2.NewArtifact(path, remoteCache, fs, artifactOption)
	if err != nil {
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
	}, nil
}

// initializeRemoteRepositoryScanService is for repository scanning in client/server mode
func initializeRemoteRepositoryScanService(ctx context.Context, url string, remoteCacheOptions cache.RemoteOptions, remoteScanOptions client.ServiceOption, artifactOption artifact.Option) (scan.Service, func(), error) {
	v := _wireValue
	service := client.NewService(remoteScanOptions, v...)
	remoteCache := cache.NewRemoteCache(ctx, remoteCacheOptions)
	fs := walker.NewFS()
	artifactArtifact, cleanup, err := repo.NewArtifact(url, remoteCache, fs, artifactOption)
	if err != nil {
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
		cleanup()
	}, nil
}

// initializeRemoteSBOMScanService is for sbom scanning in client/server mode
func initializeRemoteSBOMScanService(ctx context.Context, path string, remoteCacheOptions cache.RemoteOptions, remoteScanOptions client.ServiceOption, artifactOption artifact.Option) (scan.Service, func(), error) {
	v := _wireValue
	service := client.NewService(remoteScanOptions, v...)
	remoteCache := cache.NewRemoteCache(ctx, remoteCacheOptions)
	artifactArtifact, err := sbom.NewArtifact(path, remoteCache, artifactOption)
	if err != nil {
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
	}, nil
}

// initializeRemoteVMScanService is for vm scanning in client/server mode
func initializeRemoteVMScanService(ctx context.Context, path string, remoteCacheOptions cache.RemoteOptions, remoteScanOptions client.ServiceOption, artifactOption artifact.Option) (scan.Service, func(), error) {
	v := _wireValue
	service := client.NewService(remoteScanOptions, v...)
	remoteCache := cache.NewRemoteCache(ctx, remoteCacheOptions)
	walkerVM := walker.NewVM()
	artifactArtifact, err := vm.NewArtifact(path, remoteCache, walkerVM, artifactOption)
	if err != nil {
		return scan.Service{}, nil, err
	}
	scanService := scan.NewService(service, artifactArtifact)
	return scanService, func() {
	}, nil
}
