package sam

import (
	"github.com/aquasecurity/trivy/pkg/iac/providers/aws/iam"
	iacTypes "github.com/aquasecurity/trivy/pkg/iac/types"
)

type StateMachine struct {
	Metadata             iacTypes.Metadata
	Name                 iacTypes.StringValue
	LoggingConfiguration LoggingConfiguration
	ManagedPolicies      []iacTypes.StringValue
	Policies             []iam.Policy
	Tracing              TracingConfiguration
}

type LoggingConfiguration struct {
	Metadata       iacTypes.Metadata
	LoggingEnabled iacTypes.BoolValue
}

type TracingConfiguration struct {
	Metadata iacTypes.Metadata
	Enabled  iacTypes.BoolValue
}
