/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected byte[] randomData;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsClientContext tlsClientContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n) {
        this.context = tlsClientContext;
        this.randomData = new byte[256];
        tlsClientContext.getSecureRandom().nextBytes(this.randomData);
        this.encryptCipher = blockCipher;
        this.decryptCipher = blockCipher2;
        int n2 = 2 * n + digest.getDigestSize() + digest2.getDigestSize() + blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsClientContext, n2);
        int n3 = 0;
        this.writeMac = new TlsMac(tlsClientContext, digest, byArray, n3, digest.getDigestSize());
        this.readMac = new TlsMac(tlsClientContext, digest2, byArray, n3 += digest.getDigestSize(), digest2.getDigestSize());
        this.initCipher(true, blockCipher, byArray, n, n3 += digest2.getDigestSize(), n3 + n * 2);
        this.initCipher(false, blockCipher2, byArray, n, n3 += n, n3 + n + blockCipher.getBlockSize());
    }

    protected void initCipher(boolean bl, BlockCipher blockCipher, byte[] byArray, int n, int n2, int n3) {
        KeyParameter keyParameter = new KeyParameter(byArray, n2, n);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray, n3, blockCipher.getBlockSize());
        blockCipher.init(bl, parametersWithIV);
    }

    public byte[] encodePlaintext(short s, byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        boolean bl;
        int n5 = this.encryptCipher.getBlockSize();
        int n6 = n5 - 1 - (n2 + this.writeMac.getSize()) % n5;
        boolean bl2 = bl = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (bl) {
            n4 = (255 - n6) / n5;
            int n7 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n4);
            n6 += n7 * n5;
        }
        n4 = n2 + this.writeMac.getSize() + n6 + 1;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = this.writeMac.calculateMac(s, byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        int n8 = n2 + byArray3.length;
        for (n3 = 0; n3 <= n6; ++n3) {
            byArray2[n3 + n8] = (byte)n6;
        }
        for (n3 = 0; n3 < n4; n3 += n5) {
            this.encryptCipher.processBlock(byArray2, n3, byArray2, n3);
        }
        return byArray2;
    }

    public byte[] decodeCiphertext(short s, byte[] byArray, int n, int n2) throws IOException {
        boolean bl;
        int n3;
        int n4;
        int n5 = this.decryptCipher.getBlockSize();
        int n6 = Math.max(n5, (n4 = this.readMac.getSize()) + 1);
        if (n2 < n6) {
            throw new TlsFatalAlert(50);
        }
        if (n2 % n5 != 0) {
            throw new TlsFatalAlert(21);
        }
        for (n3 = 0; n3 < n2; n3 += n5) {
            this.decryptCipher.processBlock(byArray, n + n3, byArray, n + n3);
        }
        n3 = n2;
        int n7 = this.checkPaddingConstantTime(byArray, n, n3, n5, n4);
        int n8 = n3 - n7 - n4;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n + n8, n + n8 + n4);
        byte[] byArray3 = this.readMac.calculateMacConstantTime(s, byArray, n, n8, n3 - n4, this.randomData);
        boolean bl2 = bl = !Arrays.constantTimeAreEqual(byArray3, byArray2);
        if (bl || n7 == 0) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray, n, n + n8);
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = n + n2;
        byte by = byArray[n5 - 1];
        int n6 = by & 0xFF;
        int n7 = n6 + 1;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = bl = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (!bl && n7 > n3 || n4 + n7 > n2) {
            n7 = 0;
        } else {
            int n10 = n5 - n7;
            do {
                n9 = (byte)(n9 | byArray[n10++] ^ by);
            } while (n10 < n5);
            n8 = n7;
            if (n9 != 0) {
                n7 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n8 < 256) {
            n9 = (byte)(n9 | byArray2[n8++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n9);
        return n7;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n) {
        int n2 = secureRandom.nextInt();
        int n3 = this.lowestBitSet(n2);
        return Math.min(n3, n);
    }

    protected int lowestBitSet(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 0;
        while ((n & 1) == 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }
}

