/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.Permission;
import java.security.spec.ECParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jcajce.provider.asymmetric.ec.EC5Util;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "DhDefaultParams");
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile org.bouncycastle.jce.spec.ECParameterSpec ecImplicitCaParams;
    private volatile Object dhDefaultParams;

    BouncyCastleProviderConfiguration() {
    }

    void setParameter(String string, Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (string.equals("threadLocalEcImplicitlyCa")) {
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec;
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if ((eCParameterSpec = object instanceof org.bouncycastle.jce.spec.ECParameterSpec || object == null ? (org.bouncycastle.jce.spec.ECParameterSpec)object : EC5Util.convertSpec((ECParameterSpec)object, false)) == null) {
                this.ecThreadSpec.remove();
            } else {
                this.ecThreadSpec.set(eCParameterSpec);
            }
        } else if (string.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            this.ecImplicitCaParams = object instanceof org.bouncycastle.jce.spec.ECParameterSpec || object == null ? (org.bouncycastle.jce.spec.ECParameterSpec)object : EC5Util.convertSpec((ECParameterSpec)object, false);
        } else if (string.equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && !(object instanceof DHParameterSpec[]) && object != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            Object object2 = object;
            if (object2 == null) {
                this.dhThreadSpec.remove();
            } else {
                this.dhThreadSpec.set(object2);
            }
        } else if (string.equals("DhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (object instanceof DHParameterSpec || object instanceof DHParameterSpec[] || object == null) {
                this.dhDefaultParams = object;
            } else {
                throw new IllegalArgumentException("not a valid DHParameterSpec or DHParameterSpec[]");
            }
        }
    }

    public org.bouncycastle.jce.spec.ECParameterSpec getEcImplicitlyCa() {
        org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (org.bouncycastle.jce.spec.ECParameterSpec)this.ecThreadSpec.get();
        if (eCParameterSpec != null) {
            return eCParameterSpec;
        }
        return this.ecImplicitCaParams;
    }

    public DHParameterSpec getDHDefaultParameters(int n) {
        Object object = this.dhThreadSpec.get();
        if (object == null) {
            object = this.dhDefaultParams;
        }
        if (object instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)object;
            if (dHParameterSpec.getP().bitLength() == n) {
                return dHParameterSpec;
            }
        } else if (object instanceof DHParameterSpec[]) {
            DHParameterSpec[] dHParameterSpecArray = (DHParameterSpec[])object;
            for (int i = 0; i != dHParameterSpecArray.length; ++i) {
                if (dHParameterSpecArray[i].getP().bitLength() != n) continue;
                return dHParameterSpecArray[i];
            }
        }
        return null;
    }
}

